/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.terminalemulator;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleText;
import javax.swing.JComponent;
import javax.swing.text.AttributeSet;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.netbeans.lib.terminalemulator.BCoord;
import org.netbeans.lib.terminalemulator.BExtent;
import org.netbeans.lib.terminalemulator.Coord;
import org.netbeans.lib.terminalemulator.Extent;
import org.netbeans.lib.terminalemulator.Line;
import org.netbeans.lib.terminalemulator.Term;

class Screen
extends JComponent
implements Accessible {
    private Term term;
    private static final boolean debug = false;
    private AccessibleContext accessible_context;
    private AccessibleScreenText accessible_screen_text;
    private int oldPos;

    public Screen(Term term, int n, int n2) {
        this.term = term;
        Dimension dimension = new Dimension(n, n2);
        this.setSize(dimension);
        this.setPreferredSize(dimension);
    }

    public boolean isManagingFocus() {
        return true;
    }

    public void paint(Graphics graphics) {
        this.term.do_paint(graphics);
    }

    public Dimension getMaximumSize() {
        return new Dimension(1000, 1000);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessible_context == null) {
            this.accessible_context = new AccessibleScreen();
        }
        return this.accessible_context;
    }

    void possiblyUpdateCaretText() {
        if (this.accessible_screen_text == null) {
            return;
        }
        int n = this.term.CoordToPosition(this.term.getCursorCoord());
        this.accessible_context.firePropertyChange("AccessibleText", null, new Integer(n));
        this.accessible_context.firePropertyChange("AccessibleCaret", new Integer(n), new Integer(this.oldPos));
        this.oldPos = n;
    }

    protected class AccessibleScreen
    extends JComponent.AccessibleJComponent {
        protected AccessibleScreen() {
            super(Screen.this);
        }

        public String getAccessibleDescription() {
            return "Terminal emulator";
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TEXT;
        }

        public AccessibleText getAccessibleText() {
            if (Screen.this.accessible_screen_text == null) {
                Screen.this.accessible_screen_text = new AccessibleScreenText();
            }
            return Screen.this.accessible_screen_text;
        }
    }

    protected class AccessibleScreenText
    implements AccessibleText {
        private int last_attr;
        private MutableAttributeSet last_as;

        AccessibleScreenText() {
        }

        public int getCaretPosition() {
            return Screen.this.term.CoordToPosition(Screen.this.term.getCursorCoord());
        }

        public AttributeSet getCharacterAttribute(int n) {
            Object object;
            Coord coord = Screen.this.term.PositionToCoord(n);
            if (coord == null) {
                return null;
            }
            BCoord bCoord = coord.toBCoord(((Screen)Screen.this).term.firsta);
            int n2 = 0;
            try {
                object = ((Screen)Screen.this).term.buf.lineAt(bCoord.row);
                int[] nArray = ((Line)object).attrArray();
                n2 = nArray[bCoord.col];
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (n2 == this.last_attr) {
                return this.last_as;
            }
            object = new SimpleAttributeSet();
            if ((n2 & 0x2000) == 8192) {
                object.addAttribute(StyleConstants.Underline, Boolean.TRUE);
            }
            if ((n2 & 0x4000) == 16384) {
                object.addAttribute(StyleConstants.Bold, Boolean.TRUE);
            }
            boolean bl = (n2 & 0x800) == 2048;
            Color color = Screen.this.term.foregroundColor(bl, n2);
            if (color != Color.black) {
                object.addAttribute(StyleConstants.Foreground, color);
            }
            if ((color = Screen.this.term.backgroundColor(bl, n2)) != null) {
                object.addAttribute(StyleConstants.Background, color);
            }
            this.last_attr = n2;
            this.last_as = object;
            return object;
        }

        public Rectangle getCharacterBounds(int n) {
            return Screen.this.term.getCharacterBounds(Screen.this.term.PositionToCoord(n));
        }

        public int getCharCount() {
            return Screen.this.term.getCharCount();
        }

        public int getSelectionStart() {
            Extent extent = Screen.this.term.getSelectionExtent();
            if (extent == null) {
                return this.getCaretPosition();
            }
            return Screen.this.term.CoordToPosition(extent.begin);
        }

        public int getSelectionEnd() {
            Extent extent = Screen.this.term.getSelectionExtent();
            if (extent == null) {
                return this.getCaretPosition();
            }
            return Screen.this.term.CoordToPosition(extent.end);
        }

        public String getSelectedText() {
            return Screen.this.term.getSelectedText();
        }

        private String getHelper(int n, BCoord bCoord) {
            if (bCoord == null) {
                return null;
            }
            Line line = ((Screen)Screen.this).term.buf.lineAt(bCoord.row);
            switch (n) {
                case 1: {
                    return new String(line.charArray(), bCoord.col, 1);
                }
                case 2: {
                    BExtent bExtent = ((Screen)Screen.this).term.buf.find_word(((Screen)Screen.this).term.word_delineator, bCoord);
                    Extent extent = bExtent.toExtent(((Screen)Screen.this).term.firsta);
                    return Screen.this.term.textWithin(extent.begin, extent.end);
                }
                case 3: {
                    return new String(line.charArray());
                }
            }
            return null;
        }

        public String getAfterIndex(int n, int n2) {
            Coord coord = Screen.this.term.PositionToCoord(n2);
            if (coord == null) {
                return null;
            }
            BCoord bCoord = coord.toBCoord(((Screen)Screen.this).term.firsta);
            bCoord = ((Screen)Screen.this).term.buf.advance(bCoord);
            return this.getHelper(n, bCoord);
        }

        public String getAtIndex(int n, int n2) {
            Coord coord = Screen.this.term.PositionToCoord(n2);
            if (coord == null) {
                return null;
            }
            BCoord bCoord = coord.toBCoord(((Screen)Screen.this).term.firsta);
            return this.getHelper(n, bCoord);
        }

        public String getBeforeIndex(int n, int n2) {
            Coord coord = Screen.this.term.PositionToCoord(n2);
            if (coord == null) {
                return null;
            }
            BCoord bCoord = coord.toBCoord(((Screen)Screen.this).term.firsta);
            bCoord = ((Screen)Screen.this).term.buf.backup(bCoord);
            return this.getHelper(n, bCoord);
        }

        public int getIndexAtPoint(Point point) {
            BCoord bCoord = Screen.this.term.toViewCoord(point);
            BCoord bCoord2 = Screen.this.term.toBufCoords(bCoord);
            return Screen.this.term.CoordToPosition(new Coord(bCoord2, ((Screen)Screen.this).term.firsta));
        }
    }
}

