/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.terminalemulator;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.swing.SwingUtilities;
import org.netbeans.lib.terminalemulator.Term;
import org.netbeans.lib.terminalemulator.TermInputListener;

public class StreamTerm
extends Term {
    private OutputStreamWriter writer;

    public OutputStreamWriter getOutputStreamWriter() {
        return this.writer;
    }

    public StreamTerm() {
        this.addInputListener(new TermInputListener(){

            public void sendChars(char[] cArray, int n, int n2) {
                if (StreamTerm.this.writer == null) {
                    return;
                }
                try {
                    StreamTerm.this.writer.write(cArray, n, n2);
                    StreamTerm.this.writer.flush();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }

            public void sendChar(char c) {
                if (StreamTerm.this.writer == null) {
                    return;
                }
                try {
                    StreamTerm.this.writer.write(c);
                    StreamTerm.this.writer.flush();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
    }

    public void connect(OutputStream outputStream, InputStream inputStream, InputStream inputStream2) {
        this.updateTtySize();
        if (outputStream != null) {
            this.writer = new OutputStreamWriter(outputStream);
        }
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        OutputMonitor outputMonitor = new OutputMonitor(inputStreamReader, this);
        outputMonitor.start();
        if (inputStream2 != null) {
            InputStreamReader inputStreamReader2 = new InputStreamReader(inputStream2);
            OutputMonitor outputMonitor2 = new OutputMonitor(inputStreamReader2, this);
            outputMonitor2.start();
        }
    }

    private class OutputMonitor
    extends Thread {
        private static final int BUFSZ = 1024;
        private char[] buf = new char[1024];
        private Term term;
        private InputStreamReader reader;

        OutputMonitor(InputStreamReader inputStreamReader, Term term) {
            super("StreamTerm.OutputMonitor");
            this.reader = inputStreamReader;
            this.term = term;
        }

        private void db_echo_receipt(char[] cArray, int n, int n2) {
            System.out.println("Received:");
            int n3 = 0;
            while (n3 < n2) {
                int n4 = n3;
                System.out.print(Fmt.pad(n3, 4) + ": ");
                int n5 = 0;
                while (n5 < 20 && n3 < n2) {
                    String string = Integer.toHexString(cArray[n + n3]);
                    System.out.print(Fmt.pad0(string, 2) + " ");
                    ++n3;
                    ++n5;
                }
                System.out.println();
                n3 = n4;
                System.out.print("      ");
                int n6 = 0;
                while (n6 < 20 && n3 < n2) {
                    int n7 = cArray[n + n3];
                    if (Character.isISOControl((char)n7)) {
                        n7 = 32;
                    }
                    System.out.print(Fmt.pad((byte)n7, 2) + " ");
                    ++n3;
                    ++n6;
                }
                System.out.println();
            }
        }

        public void run() {
            Trampoline trampoline = new Trampoline();
            try {
                int n;
                while ((n = this.reader.read(this.buf, 0, 1024)) != -1) {
                    if (StreamTerm.this.debugInput()) {
                        this.db_echo_receipt(this.buf, 0, n);
                    }
                    trampoline.nread = n;
                    SwingUtilities.invokeAndWait(trampoline);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        private final class Trampoline
        implements Runnable {
            public int nread;

            private Trampoline() {
            }

            public void run() {
                OutputMonitor.this.term.putChars(OutputMonitor.this.buf, 0, this.nread);
            }
        }
    }

    static class Fmt {
        Fmt() {
        }

        public static String pad(int n, int n2) {
            return Fmt.pad(new String() + n, n2);
        }

        public static String pad(byte by, int n) {
            return Fmt.pad(new String() + (char)by, n);
        }

        public static String pad0(String string, int n) {
            return Fmt.padwith(string, n, '0');
        }

        public static String pad(String string, int n) {
            return Fmt.padwith(string, n, ' ');
        }

        /*
         * Unable to fully structure code
         */
        private static String padwith(String var0, int var1_1, char var2_2) {
            block3: {
                var3_3 = false;
                if (var1_1 < 0) {
                    var3_3 = true;
                    var1_1 = -var1_1;
                }
                var4_4 = var0.length() > var1_1 ? var0.substring(0, var1_1) : var0;
                var5_5 = var1_1 - var4_4.length();
                var6_6 = new StringBuffer(var4_4);
                if (!var3_3) ** GOTO lbl16
                while (var5_5-- > 0) {
                    var6_6.append(var2_2);
                }
                break block3;
lbl-1000:
                // 1 sources

                {
                    var6_6.insert(0, var2_2);
lbl16:
                    // 2 sources

                    ** while (var5_5-- > 0)
                }
            }
            return new String(var6_6);
        }
    }
}

