/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.tomcat4;

import java.util.Vector;
import org.apache.catalina.Connector;
import org.apache.catalina.Container;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Logger;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.Service;
import org.apache.catalina.net.DefaultServerSocketFactory;
import org.apache.catalina.net.ServerSocketFactory;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;
import org.apache.coyote.Adapter;
import org.apache.coyote.ProtocolHandler;
import org.apache.coyote.tomcat4.CoyoteAdapter;
import org.apache.coyote.tomcat4.CoyoteRequest;
import org.apache.coyote.tomcat4.CoyoteResponse;
import org.apache.coyote.tomcat4.CoyoteServerSocketFactory;
import org.apache.tomcat.util.IntrospectionUtils;

public final class CoyoteConnector
implements Connector,
Lifecycle {
    private Service service = null;
    private int acceptCount = 10;
    private String address = null;
    private int bufferSize = 2048;
    protected Container container = null;
    private Vector created = new Vector();
    private int curProcessors = 0;
    private int debug = 0;
    private boolean enableLookups = false;
    private ServerSocketFactory factory = null;
    private static final String info = "org.apache.coyote.tomcat4.CoyoteConnector2/1.0";
    protected LifecycleSupport lifecycle = new LifecycleSupport((Lifecycle)this);
    protected int minProcessors = 5;
    private int maxProcessors = 20;
    private int connectionTimeout = 60000;
    private int port = 8080;
    private String proxyName = null;
    private int proxyPort = 0;
    private int redirectPort = 443;
    private String scheme = "http";
    private boolean secure = false;
    private StringManager sm = StringManager.getManager((String)"org.apache.coyote.tomcat4");
    private boolean initialized = false;
    private boolean started = false;
    private boolean stopped = false;
    private Thread thread = null;
    private boolean tcpNoDelay = true;
    private String protocolHandlerClassName = "org.apache.coyote.http11.Http11Protocol";
    private boolean useURIValidationHack = true;
    private ProtocolHandler protocolHandler = null;
    private Adapter adapter = null;

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public Request createRequest() {
        CoyoteRequest request = new CoyoteRequest();
        request.setConnector(this);
        return request;
    }

    public Response createResponse() {
        CoyoteResponse response = new CoyoteResponse();
        response.setConnector(this);
        return response;
    }

    public LifecycleListener[] findLifecycleListeners() {
        return null;
    }

    public int getAcceptCount() {
        return this.acceptCount;
    }

    public String getAddress() {
        return this.address;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public Container getContainer() {
        return this.container;
    }

    public int getCurProcessors() {
        return this.curProcessors;
    }

    public int getDebug() {
        return this.debug;
    }

    public boolean getEnableLookups() {
        return this.enableLookups;
    }

    public ServerSocketFactory getFactory() {
        if (this.factory == null) {
            CoyoteConnector coyoteConnector = this;
            synchronized (coyoteConnector) {
                this.factory = new DefaultServerSocketFactory();
            }
        }
        return this.factory;
    }

    public String getInfo() {
        return info;
    }

    public int getMaxProcessors() {
        return this.maxProcessors;
    }

    public int getMinProcessors() {
        return this.minProcessors;
    }

    public int getPort() {
        return this.port;
    }

    public String getProtocolHandlerClassName() {
        return this.protocolHandlerClassName;
    }

    public String getProxyName() {
        return this.proxyName;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public int getRedirectPort() {
        return this.redirectPort;
    }

    public String getScheme() {
        return this.scheme;
    }

    public boolean getSecure() {
        return this.secure;
    }

    public Service getService() {
        return this.service;
    }

    public boolean getTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public boolean getUseURIValidationHack() {
        return this.useURIValidationHack;
    }

    public void initialize() throws LifecycleException {
        if (this.initialized) {
            throw new LifecycleException(this.sm.getString("coyoteConnector.alreadyInitialized"));
        }
        this.initialized = true;
        this.adapter = new CoyoteAdapter(this);
        try {
            Class<?> clazz = Class.forName(this.protocolHandlerClassName);
            this.protocolHandler = (ProtocolHandler)clazz.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new LifecycleException(this.sm.getString("coyoteConnector.protocolHandlerInstantiationFailed", (Object)e));
        }
        this.protocolHandler.setAdapter(this.adapter);
        IntrospectionUtils.setProperty((Object)this.protocolHandler, (String)"jkHome", (String)System.getProperty("catalina.base"));
        IntrospectionUtils.setProperty((Object)this.protocolHandler, (String)"port", (String)String.valueOf(this.port));
        IntrospectionUtils.setProperty((Object)this.protocolHandler, (String)"maxThreads", (String)String.valueOf(this.maxProcessors));
        IntrospectionUtils.setProperty((Object)this.protocolHandler, (String)"backlog", (String)String.valueOf(this.acceptCount));
        IntrospectionUtils.setProperty((Object)this.protocolHandler, (String)"tcpNoDelay", (String)String.valueOf(this.tcpNoDelay));
        IntrospectionUtils.setProperty((Object)this.protocolHandler, (String)"soTimeout", (String)String.valueOf(this.connectionTimeout));
        IntrospectionUtils.setProperty((Object)this.protocolHandler, (String)"timeout", (String)String.valueOf(this.connectionTimeout));
        if (this.address != null) {
            IntrospectionUtils.setProperty((Object)this.protocolHandler, (String)"address", (String)this.address);
        }
        if (this.factory instanceof CoyoteServerSocketFactory) {
            IntrospectionUtils.setProperty((Object)this.protocolHandler, (String)"secure", (String)"true");
            CoyoteServerSocketFactory ssf = (CoyoteServerSocketFactory)this.factory;
            IntrospectionUtils.setProperty((Object)this.protocolHandler, (String)"algorithm", (String)ssf.getAlgorithm());
            if (ssf.getClientAuth()) {
                IntrospectionUtils.setProperty((Object)this.protocolHandler, (String)"clientauth", (String)String.valueOf(ssf.getClientAuth()));
            }
            IntrospectionUtils.setProperty((Object)this.protocolHandler, (String)"keystore", (String)ssf.getKeystoreFile());
            IntrospectionUtils.setProperty((Object)this.protocolHandler, (String)"randomfile", (String)ssf.getRandomFile());
            IntrospectionUtils.setProperty((Object)this.protocolHandler, (String)"rootfile", (String)ssf.getRootFile());
            IntrospectionUtils.setProperty((Object)this.protocolHandler, (String)"keypass", (String)ssf.getKeystorePass());
            IntrospectionUtils.setProperty((Object)this.protocolHandler, (String)"keytype", (String)ssf.getKeystoreType());
            IntrospectionUtils.setProperty((Object)this.protocolHandler, (String)"protocol", (String)ssf.getProtocol());
            IntrospectionUtils.setProperty((Object)this.protocolHandler, (String)"sSLImplementation", (String)ssf.getSSLImplementation());
        } else {
            IntrospectionUtils.setProperty((Object)this.protocolHandler, (String)"secure", (String)"false");
        }
        try {
            this.protocolHandler.init();
        }
        catch (Exception e) {
            throw new LifecycleException(this.sm.getString("coyoteConnector.protocolHandlerInitializationFailed", (Object)e));
        }
    }

    public boolean isAvailable() {
        return this.started;
    }

    private void log(String message) {
        Logger logger = this.container.getLogger();
        String localName = "CoyoteConnector";
        if (logger != null) {
            logger.log(String.valueOf(localName) + " " + message);
        } else {
            System.out.println(String.valueOf(localName) + " " + message);
        }
    }

    private void log(String message, Throwable throwable) {
        Logger logger = this.container.getLogger();
        String localName = "CoyoteConnector";
        if (logger != null) {
            logger.log(String.valueOf(localName) + " " + message, throwable);
        } else {
            System.out.println(String.valueOf(localName) + " " + message);
            throwable.printStackTrace(System.out);
        }
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public void setAcceptCount(int count) {
        this.acceptCount = count;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setContainer(Container container) {
        this.container = container;
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    public void setEnableLookups(boolean enableLookups) {
        this.enableLookups = enableLookups;
    }

    public void setFactory(ServerSocketFactory factory) {
        this.factory = factory;
    }

    public void setMaxProcessors(int maxProcessors) {
        this.maxProcessors = maxProcessors;
    }

    public void setMinProcessors(int minProcessors) {
        this.minProcessors = minProcessors;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setProtocolHandlerClassName(String protocolHandlerClassName) {
        this.protocolHandlerClassName = protocolHandlerClassName;
    }

    public void setProxyName(String proxyName) {
        this.proxyName = proxyName;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public void setRedirectPort(int redirectPort) {
        this.redirectPort = redirectPort;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public void setService(Service service) {
        this.service = service;
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    public void setUseURIValidationHack(boolean useURIValidationHack) {
        this.useURIValidationHack = useURIValidationHack;
    }

    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(this.sm.getString("coyoteConnector.alreadyStarted"));
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        try {
            this.protocolHandler.start();
        }
        catch (Exception e) {
            throw new LifecycleException(this.sm.getString("coyoteConnector.protocolHandlerStartFailed", (Object)e));
        }
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(this.sm.getString("coyoteConnector.notStarted"));
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        try {
            this.protocolHandler.destroy();
        }
        catch (Exception e) {
            throw new LifecycleException(this.sm.getString("coyoteConnector.protocolHandlerDestroyFailed", (Object)e));
        }
    }
}

