/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.classfile;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import koala.dynamicjava.classfile.AttributeInfo;
import koala.dynamicjava.classfile.AttributeOwnerComponent;
import koala.dynamicjava.classfile.ClassIdentifier;
import koala.dynamicjava.classfile.ConstantPool;
import koala.dynamicjava.classfile.FieldInfo;
import koala.dynamicjava.classfile.InnerClassesAttribute;
import koala.dynamicjava.classfile.JVMUtilities;
import koala.dynamicjava.classfile.MethodInfo;

public class ClassFile
extends AttributeOwnerComponent {
    private static final int MAGIC = -889275714;
    private static final short MAJOR_VERSION = 45;
    private static final short MINOR_VERSION = 3;
    private short superClass;
    private List interfaces;
    private List fields;
    private List methods;

    public ClassFile(String string, String string2) {
        this.constantPool = new ConstantPool();
        String string3 = JVMUtilities.getName(string);
        this.nameIndex = this.constantPool.put(new ClassIdentifier(string3));
        string3 = JVMUtilities.getName(string2);
        this.superClass = this.constantPool.put(new ClassIdentifier(string3));
        this.interfaces = new LinkedList();
        this.fields = new LinkedList();
        this.methods = new LinkedList();
    }

    public ConstantPool getConstantPool() {
        return this.constantPool;
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(-889275714);
        dataOutputStream.writeShort(3);
        dataOutputStream.writeShort(45);
        this.constantPool.write(dataOutputStream);
        dataOutputStream.writeShort(this.accessFlags);
        dataOutputStream.writeShort(this.nameIndex);
        dataOutputStream.writeShort(this.superClass);
        dataOutputStream.writeShort(this.interfaces.size());
        Iterator iterator = this.interfaces.iterator();
        while (iterator.hasNext()) {
            dataOutputStream.writeShort(((Short)iterator.next()).shortValue());
        }
        dataOutputStream.writeShort(this.fields.size());
        iterator = this.fields.iterator();
        while (iterator.hasNext()) {
            ((FieldInfo)iterator.next()).write(dataOutputStream);
        }
        dataOutputStream.writeShort(this.methods.size());
        iterator = this.methods.iterator();
        while (iterator.hasNext()) {
            ((MethodInfo)iterator.next()).write(dataOutputStream);
        }
        dataOutputStream.writeShort(this.attributes.size());
        iterator = this.attributes.iterator();
        while (iterator.hasNext()) {
            ((AttributeInfo)iterator.next()).write(dataOutputStream);
        }
    }

    public void setPublic() {
        this.accessFlags = (short)(this.accessFlags | 1);
    }

    public void setFinal() {
        this.accessFlags = (short)(this.accessFlags | 0x10);
    }

    public void setSuper() {
        this.accessFlags = (short)(this.accessFlags | 0x20);
    }

    public void setInterface() {
        this.accessFlags = (short)(this.accessFlags | 0x200);
    }

    public void setAbstract() {
        this.accessFlags = (short)(this.accessFlags | 0x400);
    }

    public void addInterface(String string) {
        String string2 = JVMUtilities.getName(string);
        this.interfaces.add(new Short(this.constantPool.put(new ClassIdentifier(string2))));
    }

    public FieldInfo createField(String string, String string2) {
        FieldInfo fieldInfo = new FieldInfo(this.constantPool, string, string2);
        this.fields.add(fieldInfo);
        return fieldInfo;
    }

    public MethodInfo createMethod(String string, String string2, String[] stringArray) {
        MethodInfo methodInfo = new MethodInfo(this.constantPool, string, string2, stringArray);
        this.methods.add(methodInfo);
        return methodInfo;
    }

    public void setInnerClassesAttribute(InnerClassesAttribute innerClassesAttribute) {
        this.attributes.add(innerClassesAttribute);
    }
}

