/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.classfile;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import koala.dynamicjava.classfile.AttributeInfo;
import koala.dynamicjava.classfile.ClassIdentifier;
import koala.dynamicjava.classfile.ConstantPool;
import koala.dynamicjava.classfile.JVMUtilities;

public class CodeAttribute
extends AttributeInfo {
    private short maxStack;
    private short maxLocals;
    private byte[] code;
    private List exceptionTable;
    private List attributes;

    public CodeAttribute(ConstantPool constantPool) {
        super(constantPool, "Code");
        this.length = 12;
        this.exceptionTable = new LinkedList();
        this.attributes = new LinkedList();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.nameIndex);
        dataOutputStream.writeInt(this.length);
        dataOutputStream.writeShort(this.maxStack);
        dataOutputStream.writeShort(this.maxLocals);
        dataOutputStream.writeInt(this.code.length);
        dataOutputStream.write(this.code);
        dataOutputStream.writeShort(this.exceptionTable.size());
        Iterator iterator = this.exceptionTable.iterator();
        while (iterator.hasNext()) {
            ((ExceptionTableEntry)iterator.next()).write(dataOutputStream);
        }
        dataOutputStream.writeShort(this.attributes.size());
        iterator = this.attributes.iterator();
        while (iterator.hasNext()) {
            ((AttributeInfo)iterator.next()).write(dataOutputStream);
        }
    }

    public void setCode(byte[] byArray, short s, short s2) {
        this.maxLocals = s;
        this.maxStack = s2;
        this.code = byArray;
        this.length += byArray.length;
    }

    public void addExceptionTableEntry(short s, short s2, short s3, String string) {
        String string2 = JVMUtilities.getName(string);
        short s4 = this.constantPool.put(new ClassIdentifier(string2));
        ExceptionTableEntry exceptionTableEntry = new ExceptionTableEntry(s, s2, s3, s4);
        this.exceptionTable.add(exceptionTableEntry);
        this.length += exceptionTableEntry.getLength();
    }

    class ExceptionTableEntry {
        private short startPc;
        private short endPc;
        private short handlerPc;
        private short catchType;

        public ExceptionTableEntry(short s, short s2, short s3, short s4) {
            this.startPc = s;
            this.endPc = s2;
            this.handlerPc = s3;
            this.catchType = s4;
        }

        public short getLength() {
            return 8;
        }

        public void write(OutputStream outputStream) throws IOException {
            this.write(new DataOutputStream(outputStream));
        }

        public void write(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeShort(this.startPc);
            dataOutputStream.writeShort(this.endPc);
            dataOutputStream.writeShort(this.handlerPc);
            dataOutputStream.writeShort(this.catchType);
        }
    }
}

