/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.gui;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import koala.dynamicjava.gui.MessageHandler;
import koala.dynamicjava.gui.resource.ActionMap;
import koala.dynamicjava.gui.resource.JComponentModifier;
import koala.dynamicjava.gui.resource.MissingListenerException;

public class Editor
extends JTextArea
implements ActionMap {
    protected File currentFile;
    protected Document document;
    protected static char[] buffer = new char[4096];
    protected UndoableEditListener undoHandler;
    protected UndoManager undo;
    protected UndoAction undoAction;
    protected RedoAction redoAction;
    protected boolean documentModified;
    protected MessageHandler messageHandler;
    protected Map actions = new HashMap();

    public Editor(MessageHandler messageHandler) {
        this.setFont(new Font("monospaced", 0, 12));
        this.undoHandler = new UndoHandler();
        this.undo = new UndoManager();
        this.actions.put("OpenAction", new OpenAction());
        this.actions.put("SaveAction", new SaveAction());
        this.actions.put("SaveAsAction", new SaveAsAction());
        this.undoAction = new UndoAction();
        this.actions.put("UndoAction", this.undoAction);
        this.redoAction = new RedoAction();
        this.actions.put("RedoAction", this.redoAction);
        this.document = this.getDocument();
        this.document.addDocumentListener(new DocumentAdapter());
        this.document.addUndoableEditListener(this.undoHandler);
        this.messageHandler = messageHandler;
        this.messageHandler.setMainMessage("Status.init");
    }

    public void openFile(String string) {
        this.currentFile = new File(string);
        this.document = new PlainDocument();
        if (this.currentFile.exists()) {
            try {
                int n;
                FileReader fileReader = new FileReader(this.currentFile);
                while ((n = ((Reader)fileReader).read(buffer, 0, buffer.length)) != -1) {
                    this.document.insertString(this.document.getLength(), new String(buffer, 0, n), null);
                }
            }
            catch (Exception exception) {
                System.err.println(exception.toString());
            }
        }
        this.document.addDocumentListener(new DocumentAdapter());
        this.document.addUndoableEditListener(this.undoHandler);
        this.undo = new UndoManager();
        this.undoAction.update();
        this.redoAction.update();
        this.setDocument(this.document);
    }

    protected void saveDocument() {
        Object object;
        if (this.currentFile == null) {
            object = new JFileChooser();
            ((JFileChooser)object).setFileHidingEnabled(false);
            int n = ((JFileChooser)object).showSaveDialog(this);
            if (n == 0) {
                this.currentFile = ((JFileChooser)object).getSelectedFile();
            }
        }
        if (this.currentFile != null) {
            try {
                object = new FileWriter(this.currentFile);
                ((Writer)object).write(this.document.getText(0, this.document.getLength()));
                ((Writer)object).flush();
            }
            catch (Exception exception) {
                System.err.println(exception.toString());
            }
        }
    }

    public void closeProcedure() {
        if (this.documentModified && JOptionPane.showConfirmDialog(this, "Save the current buffer?", "Unsaved Buffer", 0) == 0) {
            this.saveDocument();
        }
    }

    public Action getAction(String string) throws MissingListenerException {
        Action[] actionArray = this.getActions();
        int n = 0;
        while (n < actionArray.length) {
            if (actionArray[n].getValue("Name").equals(string)) {
                return actionArray[n];
            }
            ++n;
        }
        return (Action)this.actions.get(string);
    }

    class SaveAsAction
    extends AbstractAction {
        SaveAsAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileHidingEnabled(false);
            int n = jFileChooser.showSaveDialog(Editor.this);
            if (n == 0) {
                Editor.this.currentFile = jFileChooser.getSelectedFile();
                try {
                    FileWriter fileWriter = new FileWriter(Editor.this.currentFile);
                    fileWriter.write(Editor.this.document.getText(0, Editor.this.document.getLength()));
                    ((Writer)fileWriter).flush();
                    Editor.this.messageHandler.setMainMessage("Status.current", Editor.this.currentFile.getCanonicalPath());
                }
                catch (Exception exception) {
                    System.err.println(exception.toString());
                }
            }
        }
    }

    class SaveAction
    extends AbstractAction {
        SaveAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (Editor.this.documentModified) {
                Editor.this.saveDocument();
                Editor.this.documentModified = false;
                try {
                    Editor.this.messageHandler.setMessage("Status.wrote", Editor.this.currentFile.getCanonicalPath());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    class OpenAction
    extends AbstractAction {
        OpenAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (Editor.this.documentModified) {
                Editor.this.document.removeUndoableEditListener(Editor.this.undoHandler);
                Editor.this.closeProcedure();
                Editor.this.documentModified = false;
            }
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileHidingEnabled(false);
            int n = jFileChooser.showOpenDialog(Editor.this);
            if (n == 0) {
                Editor.this.currentFile = jFileChooser.getSelectedFile();
                Editor.this.document = new PlainDocument();
                if (Editor.this.currentFile.exists()) {
                    try {
                        int n2;
                        FileReader fileReader = new FileReader(Editor.this.currentFile);
                        while ((n2 = ((Reader)fileReader).read(buffer, 0, buffer.length)) != -1) {
                            Editor.this.document.insertString(Editor.this.document.getLength(), new String(buffer, 0, n2), null);
                        }
                        Editor.this.messageHandler.setMainMessage("Status.current", Editor.this.currentFile.getCanonicalPath());
                    }
                    catch (Exception exception) {
                        System.err.println(exception.toString());
                    }
                }
                Editor.this.document.addDocumentListener(new DocumentAdapter());
                Editor.this.document.addUndoableEditListener(Editor.this.undoHandler);
                Editor.this.undo = new UndoManager();
                Editor.this.undoAction.update();
                Editor.this.redoAction.update();
                Editor.this.setDocument(Editor.this.document);
            }
        }
    }

    class DocumentAdapter
    implements DocumentListener {
        DocumentAdapter() {
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            Editor.this.documentModified = true;
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            Editor.this.documentModified = true;
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            Editor.this.documentModified = true;
        }
    }

    class RedoAction
    extends AbstractAction
    implements JComponentModifier {
        List components = new LinkedList();

        RedoAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                Editor.this.undo.redo();
            }
            catch (CannotRedoException cannotRedoException) {
                System.out.println(cannotRedoException);
            }
            this.update();
            Editor.this.undoAction.update();
        }

        public void addJComponent(JComponent jComponent) {
            this.components.add(jComponent);
            jComponent.setEnabled(false);
        }

        protected void update() {
            Iterator iterator = this.components.iterator();
            while (iterator.hasNext()) {
                ((JComponent)iterator.next()).setEnabled(Editor.this.undo.canRedo());
            }
        }
    }

    class UndoAction
    extends AbstractAction
    implements JComponentModifier {
        List components = new LinkedList();

        UndoAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                Editor.this.undo.undo();
            }
            catch (CannotUndoException cannotUndoException) {
                System.out.println(cannotUndoException);
            }
            this.update();
            Editor.this.redoAction.update();
        }

        public void addJComponent(JComponent jComponent) {
            this.components.add(jComponent);
            jComponent.setEnabled(false);
        }

        protected void update() {
            Editor.this.documentModified = Editor.this.undo.canUndo();
            Iterator iterator = this.components.iterator();
            while (iterator.hasNext()) {
                ((JComponent)iterator.next()).setEnabled(Editor.this.documentModified);
            }
        }
    }

    class UndoHandler
    implements UndoableEditListener {
        UndoHandler() {
        }

        public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
            Editor.this.undo.addEdit(undoableEditEvent.getEdit());
            Editor.this.undoAction.update();
            Editor.this.redoAction.update();
        }
    }
}

