/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.gui;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import koala.dynamicjava.gui.resource.ActionMap;
import koala.dynamicjava.gui.resource.ButtonFactory;
import koala.dynamicjava.gui.resource.MissingListenerException;
import koala.dynamicjava.gui.resource.ResourceManager;

public class URLChooser
extends JDialog
implements ActionMap {
    protected static final String RESOURCE = "koala.dynamicjava.gui.resources.urlchooser";
    protected static ResourceBundle bundle = ResourceBundle.getBundle("koala.dynamicjava.gui.resources.urlchooser", Locale.getDefault());
    protected static ResourceManager resources = new ResourceManager(bundle);
    protected ButtonFactory buttonFactory;
    protected JTextField textField;
    protected JButton okButton;
    protected JButton clearButton;
    protected Action okAction;
    protected Map listeners = new HashMap();

    public URLChooser(JDialog jDialog, Action action) {
        super(jDialog);
        this.initialize(action);
    }

    public URLChooser(JFrame jFrame, Action action) {
        super(jFrame);
        this.initialize(action);
    }

    public String getText() {
        return this.textField.getText();
    }

    protected void initialize(Action action) {
        this.okAction = action;
        this.setModal(true);
        this.listeners.put("BrowseButtonAction", new BrowseButtonAction());
        this.listeners.put("OKButtonAction", new OKButtonAction());
        this.listeners.put("CancelButtonAction", new CancelButtonAction());
        this.listeners.put("ClearButtonAction", new ClearButtonAction());
        this.setTitle(resources.getString("URLChooser.title"));
        this.buttonFactory = new ButtonFactory(bundle, this);
        this.getContentPane().add("North", this.createURLSelectionPanel());
        this.getContentPane().add("South", this.createButtonsPanel());
    }

    protected JPanel createURLSelectionPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        URLChooser.setConstraintsCoords(gridBagConstraints, 0, 0, 2, 1);
        jPanel.add((Component)new JLabel(resources.getString("URLChooser.label")), gridBagConstraints);
        this.textField = new JTextField(30);
        this.textField.getDocument().addDocumentListener(new DocumentAdapter());
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        URLChooser.setConstraintsCoords(gridBagConstraints, 0, 1, 1, 1);
        jPanel.add((Component)this.textField, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        URLChooser.setConstraintsCoords(gridBagConstraints, 1, 1, 1, 1);
        jPanel.add((Component)this.buttonFactory.createJButton("BrowseButton"), gridBagConstraints);
        return jPanel;
    }

    protected JPanel createButtonsPanel() {
        JPanel jPanel = new JPanel(new FlowLayout());
        this.okButton = this.buttonFactory.createJButton("OKButton");
        jPanel.add(this.okButton);
        jPanel.add(this.buttonFactory.createJButton("CancelButton"));
        this.clearButton = this.buttonFactory.createJButton("ClearButton");
        jPanel.add(this.clearButton);
        this.okButton.setEnabled(false);
        this.clearButton.setEnabled(false);
        return jPanel;
    }

    protected static void setConstraintsCoords(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
    }

    protected void updateOKButtonAction() {
        this.okButton.setEnabled(!this.textField.getText().equals(""));
    }

    protected void updateClearButtonAction() {
        this.clearButton.setEnabled(!this.textField.getText().equals(""));
    }

    public Action getAction(String string) throws MissingListenerException {
        return (Action)this.listeners.get(string);
    }

    protected class ClearButtonAction
    extends AbstractAction {
        protected ClearButtonAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            URLChooser.this.textField.setText("");
        }
    }

    protected class CancelButtonAction
    extends AbstractAction {
        protected CancelButtonAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            URLChooser.this.dispose();
            URLChooser.this.textField.setText("");
        }
    }

    protected class OKButtonAction
    extends AbstractAction {
        protected OKButtonAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            URLChooser.this.okAction.actionPerformed(actionEvent);
            URLChooser.this.dispose();
            URLChooser.this.textField.setText("");
        }
    }

    protected class BrowseButtonAction
    extends AbstractAction {
        protected BrowseButtonAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileHidingEnabled(false);
            jFileChooser.setFileSelectionMode(2);
            int n = jFileChooser.showOpenDialog(URLChooser.this);
            if (n == 0) {
                File file = jFileChooser.getSelectedFile();
                try {
                    URLChooser.this.textField.setText(file.getCanonicalPath());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    protected class DocumentAdapter
    implements DocumentListener {
        protected DocumentAdapter() {
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            URLChooser.this.updateOKButtonAction();
            URLChooser.this.updateClearButtonAction();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            URLChooser.this.updateOKButtonAction();
            URLChooser.this.updateClearButtonAction();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            URLChooser.this.updateOKButtonAction();
            URLChooser.this.updateClearButtonAction();
        }
    }
}

