/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.interpreter;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import koala.dynamicjava.interpreter.context.Context;
import koala.dynamicjava.interpreter.error.CatchedExceptionError;
import koala.dynamicjava.interpreter.error.ExecutionError;
import koala.dynamicjava.tree.AddAssignExpression;
import koala.dynamicjava.tree.AddExpression;
import koala.dynamicjava.tree.AndExpression;
import koala.dynamicjava.tree.ArrayAccess;
import koala.dynamicjava.tree.ArrayAllocation;
import koala.dynamicjava.tree.ArrayInitializer;
import koala.dynamicjava.tree.BinaryExpression;
import koala.dynamicjava.tree.BitAndAssignExpression;
import koala.dynamicjava.tree.BitAndExpression;
import koala.dynamicjava.tree.BitOrAssignExpression;
import koala.dynamicjava.tree.BitOrExpression;
import koala.dynamicjava.tree.BlockStatement;
import koala.dynamicjava.tree.CastExpression;
import koala.dynamicjava.tree.CatchStatement;
import koala.dynamicjava.tree.ClassAllocation;
import koala.dynamicjava.tree.ClassDeclaration;
import koala.dynamicjava.tree.ComplementExpression;
import koala.dynamicjava.tree.ConditionalExpression;
import koala.dynamicjava.tree.DivideAssignExpression;
import koala.dynamicjava.tree.DivideExpression;
import koala.dynamicjava.tree.DoStatement;
import koala.dynamicjava.tree.EqualExpression;
import koala.dynamicjava.tree.ExclusiveOrAssignExpression;
import koala.dynamicjava.tree.ExclusiveOrExpression;
import koala.dynamicjava.tree.Expression;
import koala.dynamicjava.tree.ExpressionContainer;
import koala.dynamicjava.tree.FieldAccess;
import koala.dynamicjava.tree.ForStatement;
import koala.dynamicjava.tree.FormalParameter;
import koala.dynamicjava.tree.FunctionCall;
import koala.dynamicjava.tree.GreaterExpression;
import koala.dynamicjava.tree.GreaterOrEqualExpression;
import koala.dynamicjava.tree.IdentifierToken;
import koala.dynamicjava.tree.IfThenElseStatement;
import koala.dynamicjava.tree.IfThenStatement;
import koala.dynamicjava.tree.ImportDeclaration;
import koala.dynamicjava.tree.InnerAllocation;
import koala.dynamicjava.tree.InnerClassAllocation;
import koala.dynamicjava.tree.InstanceOfExpression;
import koala.dynamicjava.tree.InterfaceDeclaration;
import koala.dynamicjava.tree.LabeledStatement;
import koala.dynamicjava.tree.LessExpression;
import koala.dynamicjava.tree.LessOrEqualExpression;
import koala.dynamicjava.tree.MinusExpression;
import koala.dynamicjava.tree.MultiplyAssignExpression;
import koala.dynamicjava.tree.MultiplyExpression;
import koala.dynamicjava.tree.Node;
import koala.dynamicjava.tree.NotEqualExpression;
import koala.dynamicjava.tree.NotExpression;
import koala.dynamicjava.tree.ObjectFieldAccess;
import koala.dynamicjava.tree.ObjectMethodCall;
import koala.dynamicjava.tree.OrExpression;
import koala.dynamicjava.tree.PackageDeclaration;
import koala.dynamicjava.tree.PlusExpression;
import koala.dynamicjava.tree.PostDecrement;
import koala.dynamicjava.tree.PostIncrement;
import koala.dynamicjava.tree.PreDecrement;
import koala.dynamicjava.tree.PreIncrement;
import koala.dynamicjava.tree.QualifiedName;
import koala.dynamicjava.tree.ReferenceType;
import koala.dynamicjava.tree.RemainderAssignExpression;
import koala.dynamicjava.tree.RemainderExpression;
import koala.dynamicjava.tree.ReturnStatement;
import koala.dynamicjava.tree.ShiftLeftAssignExpression;
import koala.dynamicjava.tree.ShiftLeftExpression;
import koala.dynamicjava.tree.ShiftRightAssignExpression;
import koala.dynamicjava.tree.ShiftRightExpression;
import koala.dynamicjava.tree.SimpleAllocation;
import koala.dynamicjava.tree.SimpleAssignExpression;
import koala.dynamicjava.tree.StaticFieldAccess;
import koala.dynamicjava.tree.StaticMethodCall;
import koala.dynamicjava.tree.SubtractAssignExpression;
import koala.dynamicjava.tree.SubtractExpression;
import koala.dynamicjava.tree.SuperMethodCall;
import koala.dynamicjava.tree.SwitchBlock;
import koala.dynamicjava.tree.SwitchStatement;
import koala.dynamicjava.tree.SynchronizedStatement;
import koala.dynamicjava.tree.ThisExpression;
import koala.dynamicjava.tree.ThrowStatement;
import koala.dynamicjava.tree.TreeUtilities;
import koala.dynamicjava.tree.TryStatement;
import koala.dynamicjava.tree.UnsignedShiftRightAssignExpression;
import koala.dynamicjava.tree.UnsignedShiftRightExpression;
import koala.dynamicjava.tree.VariableDeclaration;
import koala.dynamicjava.tree.WhileStatement;
import koala.dynamicjava.tree.visitor.VisitorObject;

public class NameVisitor
extends VisitorObject {
    private Context context;

    public NameVisitor(Context context) {
        this.context = context;
    }

    public Object visit(PackageDeclaration packageDeclaration) {
        this.context.setCurrentPackage(packageDeclaration.getName());
        return null;
    }

    public Object visit(ImportDeclaration importDeclaration) {
        if (importDeclaration.isPackage()) {
            this.context.declarePackageImport(importDeclaration.getName());
        } else {
            try {
                this.context.declareClassImport(importDeclaration.getName());
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new CatchedExceptionError(classNotFoundException, (Node)importDeclaration);
            }
        }
        return null;
    }

    public Object visit(WhileStatement whileStatement) {
        Node node = whileStatement.getCondition();
        Object object = node.acceptVisitor(this);
        if (object != null) {
            if (object instanceof ReferenceType) {
                throw new ExecutionError("malformed.expression", node);
            }
            whileStatement.setCondition((Expression)object);
        }
        if ((object = (node = whileStatement.getBody()).acceptVisitor(this)) != null) {
            if (object instanceof ReferenceType) {
                throw new ExecutionError("malformed.expression", node);
            }
            whileStatement.setBody((Node)object);
        }
        return null;
    }

    public Object visit(ForStatement forStatement) {
        Object object;
        Node node;
        this.context.enterScope();
        List list = forStatement.getInitialization();
        if (list != null) {
            this.visitList(list);
        }
        if ((node = forStatement.getCondition()) != null && (object = node.acceptVisitor(this)) != null) {
            if (object instanceof ReferenceType) {
                throw new ExecutionError("malformed.expression", node);
            }
            forStatement.setCondition((Expression)object);
        }
        if ((list = forStatement.getUpdate()) != null) {
            this.visitList(list);
        }
        if ((object = (node = forStatement.getBody()).acceptVisitor(this)) != null) {
            if (object instanceof ReferenceType) {
                throw new ExecutionError("malformed.expression", node);
            }
            forStatement.setBody((Node)object);
        }
        this.context.leaveScope();
        return null;
    }

    public Object visit(DoStatement doStatement) {
        Node node = doStatement.getCondition();
        Object object = node.acceptVisitor(this);
        if (object != null) {
            if (object instanceof ReferenceType) {
                throw new ExecutionError("malformed.expression", node);
            }
            doStatement.setCondition((Expression)object);
        }
        if ((object = (node = doStatement.getBody()).acceptVisitor(this)) != null) {
            if (object instanceof ReferenceType) {
                throw new ExecutionError("malformed.expression", node);
            }
            doStatement.setBody((Node)object);
        }
        return null;
    }

    public Object visit(SwitchStatement switchStatement) {
        Expression expression = switchStatement.getSelector();
        Object object = expression.acceptVisitor(this);
        if (object != null) {
            if (object instanceof ReferenceType) {
                throw new ExecutionError("malformed.expression", expression);
            }
            switchStatement.setSelector((Expression)object);
        }
        Iterator iterator = switchStatement.getBindings().iterator();
        while (iterator.hasNext()) {
            ((Node)iterator.next()).acceptVisitor(this);
        }
        return null;
    }

    public Object visit(SwitchBlock switchBlock) {
        List list;
        Expression expression = switchBlock.getExpression();
        if (expression != null) {
            this.visitExpressionContainer(switchBlock);
        }
        if ((list = switchBlock.getStatements()) != null) {
            this.visitList(list);
        }
        return null;
    }

    public Object visit(LabeledStatement labeledStatement) {
        Node node = labeledStatement.getStatement();
        Object object = node.acceptVisitor(this);
        if (object != null) {
            if (object instanceof ReferenceType) {
                throw new ExecutionError("malformed.expression", node);
            }
            labeledStatement.setStatement((Expression)object);
        }
        return null;
    }

    public Object visit(ThrowStatement throwStatement) {
        this.visitExpressionContainer(throwStatement);
        return null;
    }

    public Object visit(SynchronizedStatement synchronizedStatement) {
        Node node = synchronizedStatement.getLock();
        Object object = node.acceptVisitor(this);
        if (object != null) {
            if (object instanceof ReferenceType) {
                throw new ExecutionError("malformed.expression", node);
            }
            synchronizedStatement.setLock((Expression)object);
        }
        if ((object = (node = synchronizedStatement.getBody()).acceptVisitor(this)) != null) {
            if (object instanceof ReferenceType) {
                throw new ExecutionError("malformed.expression", node);
            }
            synchronizedStatement.setBody((Node)object);
        }
        return null;
    }

    public Object visit(TryStatement tryStatement) {
        tryStatement.getTryBlock().acceptVisitor(this);
        Iterator iterator = tryStatement.getCatchStatements().iterator();
        while (iterator.hasNext()) {
            ((Node)iterator.next()).acceptVisitor(this);
        }
        Node node = tryStatement.getFinallyBlock();
        if (node != null) {
            node.acceptVisitor(this);
        }
        return null;
    }

    public Object visit(CatchStatement catchStatement) {
        this.context.enterScope();
        catchStatement.getException().acceptVisitor(this);
        catchStatement.getBlock().acceptVisitor(this);
        this.context.leaveScope();
        return null;
    }

    public Object visit(ReturnStatement returnStatement) {
        Expression expression = returnStatement.getExpression();
        if (expression != null) {
            this.visitExpressionContainer(returnStatement);
        }
        return null;
    }

    public Object visit(IfThenStatement ifThenStatement) {
        Node node = ifThenStatement.getCondition();
        Object object = node.acceptVisitor(this);
        if (object != null) {
            if (object instanceof ReferenceType) {
                throw new ExecutionError("malformed.expression", node);
            }
            ifThenStatement.setCondition((Expression)object);
        }
        if ((object = (node = ifThenStatement.getThenStatement()).acceptVisitor(this)) != null) {
            if (object instanceof ReferenceType) {
                throw new ExecutionError("malformed.expression", node);
            }
            ifThenStatement.setThenStatement((Node)object);
        }
        return null;
    }

    public Object visit(IfThenElseStatement ifThenElseStatement) {
        Node node = ifThenElseStatement.getCondition();
        Object object = node.acceptVisitor(this);
        if (object != null) {
            if (object instanceof ReferenceType) {
                throw new ExecutionError("malformed.expression", node);
            }
            ifThenElseStatement.setCondition((Expression)object);
        }
        if ((object = (node = ifThenElseStatement.getThenStatement()).acceptVisitor(this)) != null) {
            if (object instanceof ReferenceType) {
                throw new ExecutionError("malformed.expression", node);
            }
            ifThenElseStatement.setThenStatement((Node)object);
        }
        if ((object = (node = ifThenElseStatement.getElseStatement()).acceptVisitor(this)) != null) {
            if (object instanceof ReferenceType) {
                throw new ExecutionError("malformed.expression", node);
            }
            ifThenElseStatement.setElseStatement((Node)object);
        }
        return null;
    }

    public Object visit(VariableDeclaration variableDeclaration) {
        Object object;
        String string = variableDeclaration.getName();
        if (this.context.isDefinedVariable(string)) {
            variableDeclaration.setProperty("errorStrings", new String[]{string});
            throw new ExecutionError("variable.redefinition", variableDeclaration);
        }
        if (variableDeclaration.isFinal()) {
            this.context.defineConstant(string, null);
        } else {
            this.context.define(string, null);
        }
        Expression expression = variableDeclaration.getInitializer();
        if (expression != null && (object = expression.acceptVisitor(this)) != null) {
            if (object instanceof ReferenceType) {
                throw new ExecutionError("malformed.expression", expression);
            }
            variableDeclaration.setInitializer((Expression)object);
        }
        return null;
    }

    public Object visit(SimpleAssignExpression simpleAssignExpression) {
        Expression expression;
        Expression expression2 = simpleAssignExpression.getRightExpression();
        Object object = expression2.acceptVisitor(this);
        if (object != null) {
            if (object instanceof ReferenceType) {
                throw new ExecutionError("right.expression", expression2);
            }
            simpleAssignExpression.setRightExpression((Expression)object);
        }
        if ((expression = simpleAssignExpression.getLeftExpression()) instanceof QualifiedName) {
            List list = ((QualifiedName)expression).getIdentifiers();
            String string = ((IdentifierToken)list.get(0)).image();
            if (list.size() == 1 && !this.context.exists(string)) {
                this.context.define(string, null);
            }
        }
        if ((object = expression.acceptVisitor(this)) != null) {
            if (object instanceof ReferenceType) {
                throw new ExecutionError("left.expression", simpleAssignExpression);
            }
            simpleAssignExpression.setLeftExpression((Expression)object);
        }
        return null;
    }

    public Object visit(BlockStatement blockStatement) {
        this.context.enterScope();
        this.visitList(blockStatement.getStatements());
        this.context.leaveScope();
        return null;
    }

    public Object visit(ObjectFieldAccess objectFieldAccess) {
        Object object = objectFieldAccess.getExpression().acceptVisitor(this);
        if (object != null) {
            if (object instanceof ReferenceType) {
                return new StaticFieldAccess((ReferenceType)object, objectFieldAccess.getFieldName(), objectFieldAccess.getFilename(), objectFieldAccess.getBeginLine(), objectFieldAccess.getBeginColumn(), objectFieldAccess.getEndLine(), objectFieldAccess.getEndColumn());
            }
            objectFieldAccess.setExpression((Expression)object);
        }
        return null;
    }

    public Object visit(ObjectMethodCall objectMethodCall) {
        Object object;
        Expression expression;
        List list = objectMethodCall.getArguments();
        if (list != null) {
            this.visitList(list);
        }
        if ((expression = objectMethodCall.getExpression()) == null) {
            object = this.context.getDefaultQualifier(objectMethodCall);
        } else {
            object = expression.acceptVisitor(this);
            if (object == null) {
                return null;
            }
        }
        if (object == null) {
            return new FunctionCall(objectMethodCall.getMethodName(), objectMethodCall.getArguments(), objectMethodCall.getFilename(), objectMethodCall.getBeginLine(), objectMethodCall.getBeginColumn(), objectMethodCall.getEndLine(), objectMethodCall.getEndColumn());
        }
        if (object instanceof ReferenceType) {
            return new StaticMethodCall((ReferenceType)object, objectMethodCall.getMethodName(), objectMethodCall.getArguments(), objectMethodCall.getFilename(), objectMethodCall.getBeginLine(), objectMethodCall.getBeginColumn(), objectMethodCall.getEndLine(), objectMethodCall.getEndColumn());
        }
        objectMethodCall.setExpression((Expression)object);
        return null;
    }

    public Object visit(SuperMethodCall superMethodCall) {
        List list = superMethodCall.getArguments();
        if (list != null) {
            this.visitList(list);
        }
        return null;
    }

    public Object visit(ThisExpression thisExpression) {
        return this.context.getDefaultQualifier(thisExpression, thisExpression.getClassName());
    }

    public Object visit(QualifiedName qualifiedName) {
        Object object;
        List list = qualifiedName.getIdentifiers();
        IdentifierToken identifierToken = (IdentifierToken)list.get(0);
        if (this.context.isDefined(identifierToken.image())) {
            Expression expression = this.context.createName(qualifiedName, identifierToken);
            Iterator iterator = list.iterator();
            iterator.next();
            while (iterator.hasNext()) {
                IdentifierToken identifierToken2 = (IdentifierToken)iterator.next();
                expression = new ObjectFieldAccess(expression, identifierToken2.image(), qualifiedName.getFilename(), identifierToken.beginLine(), identifierToken.beginColumn(), identifierToken2.endLine(), identifierToken2.endColumn());
            }
            return expression;
        }
        List list2 = (List)((LinkedList)list).clone();
        boolean bl = false;
        while (list2.size() > 0) {
            object = TreeUtilities.listToName(list2);
            bl = this.context.classExists((String)object);
            if (bl) break;
            list2.remove(list2.size() - 1);
        }
        if (!bl) {
            qualifiedName.setProperty("errorStrings", new String[]{identifierToken.image()});
            throw new ExecutionError("undefined.class", qualifiedName);
        }
        object = (IdentifierToken)list2.get(list2.size() - 1);
        ReferenceType referenceType = new ReferenceType(list2, qualifiedName.getFilename(), identifierToken.beginLine(), identifierToken.beginColumn(), object.endLine(), object.endColumn());
        if (list2.size() != list.size()) {
            ListIterator listIterator = list.listIterator(list2.size());
            object = (IdentifierToken)listIterator.next();
            FieldAccess fieldAccess = new StaticFieldAccess(referenceType, object.image(), qualifiedName.getFilename(), identifierToken.beginLine(), identifierToken.beginColumn(), object.endLine(), object.endColumn());
            while (listIterator.hasNext()) {
                object = (IdentifierToken)listIterator.next();
                fieldAccess = new ObjectFieldAccess(fieldAccess, object.image(), qualifiedName.getFilename(), identifierToken.beginLine(), identifierToken.beginColumn(), object.endLine(), object.endColumn());
            }
            return fieldAccess;
        }
        return referenceType;
    }

    public Object visit(SimpleAllocation simpleAllocation) {
        List list = simpleAllocation.getArguments();
        if (list != null) {
            this.visitList(list);
        }
        return null;
    }

    public Object visit(ArrayAllocation arrayAllocation) {
        this.visitList(arrayAllocation.getSizes());
        if (arrayAllocation.getInitialization() != null) {
            arrayAllocation.getInitialization().acceptVisitor(this);
        }
        return null;
    }

    public Object visit(InnerAllocation innerAllocation) {
        this.visitExpressionContainer(innerAllocation);
        List list = innerAllocation.getArguments();
        if (list != null) {
            this.visitList(list);
        }
        return null;
    }

    public Object visit(ArrayInitializer arrayInitializer) {
        this.visitList(arrayInitializer.getCells());
        return null;
    }

    public Object visit(ArrayAccess arrayAccess) {
        this.visitExpressionContainer(arrayAccess);
        Expression expression = arrayAccess.getCellNumber();
        Object object = expression.acceptVisitor(this);
        if (object != null) {
            if (object instanceof ReferenceType) {
                throw new ExecutionError("malformed.expression", expression);
            }
            arrayAccess.setCellNumber((Expression)object);
        }
        return null;
    }

    public Object visit(NotExpression notExpression) {
        this.visitExpressionContainer(notExpression);
        return null;
    }

    public Object visit(ComplementExpression complementExpression) {
        this.visitExpressionContainer(complementExpression);
        return null;
    }

    public Object visit(PlusExpression plusExpression) {
        this.visitExpressionContainer(plusExpression);
        return null;
    }

    public Object visit(MinusExpression minusExpression) {
        this.visitExpressionContainer(minusExpression);
        return null;
    }

    public Object visit(AddExpression addExpression) {
        this.visitBinaryExpression(addExpression);
        return null;
    }

    public Object visit(AddAssignExpression addAssignExpression) {
        this.visitBinaryExpression(addAssignExpression);
        return null;
    }

    public Object visit(SubtractExpression subtractExpression) {
        this.visitBinaryExpression(subtractExpression);
        return null;
    }

    public Object visit(SubtractAssignExpression subtractAssignExpression) {
        this.visitBinaryExpression(subtractAssignExpression);
        return null;
    }

    public Object visit(MultiplyExpression multiplyExpression) {
        this.visitBinaryExpression(multiplyExpression);
        return null;
    }

    public Object visit(MultiplyAssignExpression multiplyAssignExpression) {
        this.visitBinaryExpression(multiplyAssignExpression);
        return null;
    }

    public Object visit(DivideExpression divideExpression) {
        this.visitBinaryExpression(divideExpression);
        return null;
    }

    public Object visit(DivideAssignExpression divideAssignExpression) {
        this.visitBinaryExpression(divideAssignExpression);
        return null;
    }

    public Object visit(RemainderExpression remainderExpression) {
        this.visitBinaryExpression(remainderExpression);
        return null;
    }

    public Object visit(RemainderAssignExpression remainderAssignExpression) {
        this.visitBinaryExpression(remainderAssignExpression);
        return null;
    }

    public Object visit(EqualExpression equalExpression) {
        this.visitBinaryExpression(equalExpression);
        return null;
    }

    public Object visit(NotEqualExpression notEqualExpression) {
        this.visitBinaryExpression(notEqualExpression);
        return null;
    }

    public Object visit(LessExpression lessExpression) {
        this.visitBinaryExpression(lessExpression);
        return null;
    }

    public Object visit(LessOrEqualExpression lessOrEqualExpression) {
        this.visitBinaryExpression(lessOrEqualExpression);
        return null;
    }

    public Object visit(GreaterExpression greaterExpression) {
        this.visitBinaryExpression(greaterExpression);
        return null;
    }

    public Object visit(GreaterOrEqualExpression greaterOrEqualExpression) {
        this.visitBinaryExpression(greaterOrEqualExpression);
        return null;
    }

    public Object visit(BitAndExpression bitAndExpression) {
        this.visitBinaryExpression(bitAndExpression);
        return null;
    }

    public Object visit(BitAndAssignExpression bitAndAssignExpression) {
        this.visitBinaryExpression(bitAndAssignExpression);
        return null;
    }

    public Object visit(ExclusiveOrExpression exclusiveOrExpression) {
        this.visitBinaryExpression(exclusiveOrExpression);
        return null;
    }

    public Object visit(ExclusiveOrAssignExpression exclusiveOrAssignExpression) {
        this.visitBinaryExpression(exclusiveOrAssignExpression);
        return null;
    }

    public Object visit(BitOrExpression bitOrExpression) {
        this.visitBinaryExpression(bitOrExpression);
        return null;
    }

    public Object visit(BitOrAssignExpression bitOrAssignExpression) {
        this.visitBinaryExpression(bitOrAssignExpression);
        return null;
    }

    public Object visit(ShiftLeftExpression shiftLeftExpression) {
        this.visitBinaryExpression(shiftLeftExpression);
        return null;
    }

    public Object visit(ShiftLeftAssignExpression shiftLeftAssignExpression) {
        this.visitBinaryExpression(shiftLeftAssignExpression);
        return null;
    }

    public Object visit(ShiftRightExpression shiftRightExpression) {
        this.visitBinaryExpression(shiftRightExpression);
        return null;
    }

    public Object visit(ShiftRightAssignExpression shiftRightAssignExpression) {
        this.visitBinaryExpression(shiftRightAssignExpression);
        return null;
    }

    public Object visit(UnsignedShiftRightExpression unsignedShiftRightExpression) {
        this.visitBinaryExpression(unsignedShiftRightExpression);
        return null;
    }

    public Object visit(UnsignedShiftRightAssignExpression unsignedShiftRightAssignExpression) {
        this.visitBinaryExpression(unsignedShiftRightAssignExpression);
        return null;
    }

    public Object visit(AndExpression andExpression) {
        this.visitBinaryExpression(andExpression);
        return null;
    }

    public Object visit(OrExpression orExpression) {
        this.visitBinaryExpression(orExpression);
        return null;
    }

    public Object visit(InstanceOfExpression instanceOfExpression) {
        this.visitExpressionContainer(instanceOfExpression);
        return null;
    }

    public Object visit(ConditionalExpression conditionalExpression) {
        Expression expression = conditionalExpression.getConditionExpression();
        Object object = expression.acceptVisitor(this);
        if (object != null) {
            if (object instanceof ReferenceType) {
                throw new ExecutionError("malformed.expression", expression);
            }
            conditionalExpression.setConditionExpression((Expression)object);
        }
        if ((object = (expression = conditionalExpression.getIfTrueExpression()).acceptVisitor(this)) != null) {
            if (object instanceof ReferenceType) {
                throw new ExecutionError("malformed.second.operand", expression);
            }
            conditionalExpression.setIfTrueExpression((Expression)object);
        }
        if ((object = (expression = conditionalExpression.getIfFalseExpression()).acceptVisitor(this)) != null) {
            if (object instanceof ReferenceType) {
                throw new ExecutionError("malformed.third.operand", expression);
            }
            conditionalExpression.setIfFalseExpression((Expression)object);
        }
        return null;
    }

    public Object visit(PostIncrement postIncrement) {
        this.visitExpressionContainer(postIncrement);
        return null;
    }

    public Object visit(PreIncrement preIncrement) {
        this.visitExpressionContainer(preIncrement);
        return null;
    }

    public Object visit(PostDecrement postDecrement) {
        this.visitExpressionContainer(postDecrement);
        return null;
    }

    public Object visit(PreDecrement preDecrement) {
        this.visitExpressionContainer(preDecrement);
        return null;
    }

    public Object visit(CastExpression castExpression) {
        this.visitExpressionContainer(castExpression);
        return null;
    }

    public Object visit(ClassAllocation classAllocation) {
        List list = classAllocation.getArguments();
        if (list != null) {
            this.visitList(list);
        }
        return null;
    }

    public Object visit(InnerClassAllocation innerClassAllocation) {
        this.visitExpressionContainer(innerClassAllocation);
        List list = innerClassAllocation.getArguments();
        if (list != null) {
            this.visitList(list);
        }
        return null;
    }

    public Object visit(FormalParameter formalParameter) {
        if (formalParameter.isFinal()) {
            this.context.defineConstant(formalParameter.getName(), null);
        } else {
            this.context.define(formalParameter.getName(), null);
        }
        return null;
    }

    public Object visit(ClassDeclaration classDeclaration) {
        this.context.defineClass(classDeclaration);
        return null;
    }

    public Object visit(InterfaceDeclaration interfaceDeclaration) {
        this.context.defineClass(interfaceDeclaration);
        return null;
    }

    private void visitExpressionContainer(ExpressionContainer expressionContainer) {
        Expression expression = expressionContainer.getExpression();
        Object object = expression.acceptVisitor(this);
        if (object != null) {
            if (object instanceof ReferenceType) {
                throw new ExecutionError("malformed.expression", expression);
            }
            expressionContainer.setExpression((Expression)object);
        }
    }

    private void visitBinaryExpression(BinaryExpression binaryExpression) {
        Object object = binaryExpression.getLeftExpression().acceptVisitor(this);
        if (object != null) {
            if (object instanceof Expression) {
                binaryExpression.setLeftExpression((Expression)object);
            } else {
                throw new ExecutionError("left.operand", binaryExpression);
            }
        }
        if ((object = binaryExpression.getRightExpression().acceptVisitor(this)) != null) {
            if (object instanceof Expression) {
                binaryExpression.setRightExpression((Expression)object);
            } else {
                throw new ExecutionError("right.operand", binaryExpression);
            }
        }
    }

    private void visitList(List list) {
        ListIterator<Object> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            Node node = (Node)listIterator.next();
            Object object = node.acceptVisitor(this);
            if (object == null) continue;
            if (object instanceof ReferenceType) {
                throw new ExecutionError("malformed.expression", node);
            }
            listIterator.set(object);
        }
    }
}

