/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.interpreter.context;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import koala.dynamicjava.interpreter.context.SimpleContext;

public class VariableContext
implements SimpleContext {
    protected Link scopes;
    protected Scope scope;
    protected Scope cscope;

    public VariableContext() {
        this.enterScope();
    }

    public VariableContext(Set set) {
        this();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            ((AbstractVariable)iterator.next()).set(this, null);
        }
    }

    public void enterScope() {
        this.scopes = LinkFactory.createLink(this.scopes);
        this.scope = this.scopes.scope;
        this.cscope = this.scopes.cscope;
    }

    public void enterScope(Set set) {
        this.enterScope();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            ((AbstractVariable)iterator.next()).set(this, null);
        }
    }

    public void defineVariables(Set set) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            AbstractVariable abstractVariable = (AbstractVariable)iterator.next();
            if (abstractVariable.get(this) != Scope.NO_SUCH_KEY) continue;
            abstractVariable.set(this, null);
        }
    }

    public Set leaveScope() {
        HashSet<AbstractVariable> hashSet = new HashSet<AbstractVariable>(11);
        Iterator iterator = this.scope.keySet().iterator();
        while (iterator.hasNext()) {
            hashSet.add(new Variable((String)iterator.next()));
        }
        iterator = this.cscope.keySet().iterator();
        while (iterator.hasNext()) {
            hashSet.add(new Constant((String)iterator.next()));
        }
        this.scopes = this.scopes.next;
        this.scope = this.scopes.scope;
        this.cscope = this.scopes.cscope;
        return hashSet;
    }

    public Set getCurrentScopeVariables() {
        HashSet<AbstractVariable> hashSet = new HashSet<AbstractVariable>(11);
        Iterator iterator = this.scope.keySet().iterator();
        while (iterator.hasNext()) {
            hashSet.add(new Variable((String)iterator.next()));
        }
        iterator = this.cscope.keySet().iterator();
        while (iterator.hasNext()) {
            hashSet.add(new Constant((String)iterator.next()));
        }
        return hashSet;
    }

    public Set getCurrentScopeVariableNames() {
        HashSet hashSet = new HashSet(11);
        Iterator iterator = this.scope.keySet().iterator();
        while (iterator.hasNext()) {
            hashSet.add(iterator.next());
        }
        iterator = this.cscope.keySet().iterator();
        while (iterator.hasNext()) {
            hashSet.add(iterator.next());
        }
        return hashSet;
    }

    public boolean isDefinedVariable(String string) {
        Link link = this.scopes;
        while (link != null) {
            if (link.scope.get(string) != Scope.NO_SUCH_KEY) {
                return true;
            }
            if (link.cscope.get(string) != Scope.NO_SUCH_KEY) {
                return true;
            }
            link = link.next;
        }
        return false;
    }

    public boolean isFinal(String string) {
        Link link = this.scopes;
        while (link != null) {
            if (link.cscope.get(string) != Scope.NO_SUCH_KEY) {
                return true;
            }
            link = link.next;
        }
        return false;
    }

    public void define(String string, Object object) {
        if (this.scope.put(string, object) != Scope.NO_SUCH_KEY) {
            throw new IllegalStateException(string);
        }
    }

    public void defineConstant(String string, Object object) {
        if (this.cscope.put(string, object) != Scope.NO_SUCH_KEY || this.scope.get(string) != Scope.NO_SUCH_KEY) {
            throw new IllegalStateException(string);
        }
    }

    public Object get(String string) {
        Link link = this.scopes;
        while (link != null) {
            Object object = link.scope.get(string);
            if (object != Scope.NO_SUCH_KEY || (object = link.cscope.get(string)) != Scope.NO_SUCH_KEY) {
                return object;
            }
            link = link.next;
        }
        throw new IllegalStateException(string);
    }

    public void set(String string, Object object) {
        Link link = this.scopes;
        while (link != null) {
            Object object2 = link.scope.get(string);
            if (object2 != Scope.NO_SUCH_KEY) {
                link.scope.put(string, object);
                return;
            }
            link = link.next;
        }
        throw new IllegalStateException(string);
    }

    public void setConstant(String string, Object object) {
        this.cscope.put(string, object);
    }

    public void setVariable(String string, Object object) {
        this.scope.put(string, object);
    }

    public Map getConstants() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(11);
        Link link = this.scopes;
        while (link != null) {
            Iterator iterator = link.cscope.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                hashMap.put(string, link.cscope.get(string));
            }
            link = link.next;
        }
        return hashMap;
    }

    protected static class Scope {
        protected static final float LOAD_FACTOR = 0.75f;
        protected static final int INITIAL_CAPACITY = 11;
        protected static final Object NO_SUCH_KEY = new Object();
        protected Entry[] table = new Entry[11];
        protected int count;
        protected int threshold = 8;

        public Object get(String string) {
            int n = string.hashCode() & Integer.MAX_VALUE;
            int n2 = n % this.table.length;
            Entry entry = this.table[n2];
            while (entry != null) {
                if (entry.hash == n && entry.key.equals(string)) {
                    return entry.value;
                }
                entry = entry.next;
            }
            return NO_SUCH_KEY;
        }

        public Object put(String string, Object object) {
            Entry entry;
            int n = string.hashCode() & Integer.MAX_VALUE;
            int n2 = n % this.table.length;
            Entry entry2 = this.table[n2];
            while (entry2 != null) {
                if (entry2.hash == n && entry2.key.equals(string)) {
                    Object object2 = entry2.value;
                    entry2.value = object;
                    return object2;
                }
                entry2 = entry2.next;
            }
            if (this.count++ >= this.threshold) {
                this.rehash();
                n2 = n % this.table.length;
            }
            this.table[n2] = entry = EntryFactory.createEntry(n, string, object, this.table[n2]);
            return NO_SUCH_KEY;
        }

        public Set keySet() {
            HashSet<String> hashSet = new HashSet<String>(11);
            int n = this.table.length - 1;
            while (n >= 0) {
                Entry entry = this.table[n];
                while (entry != null) {
                    hashSet.add(entry.key);
                    entry = entry.next;
                }
                --n;
            }
            return hashSet;
        }

        public void clear() {
            this.count = 0;
            int n = this.table.length - 1;
            while (n >= 0) {
                this.table[n] = null;
                --n;
            }
        }

        protected void rehash() {
            Entry[] entryArray = this.table;
            this.table = new Entry[entryArray.length * 2 + 1];
            this.threshold = (int)((float)this.table.length * 0.75f);
            int n = entryArray.length - 1;
            while (n >= 0) {
                Entry entry = entryArray[n];
                while (entry != null) {
                    Entry entry2 = entry;
                    entry = entry.next;
                    int n2 = entry2.hash % this.table.length;
                    entry2.next = this.table[n2];
                    this.table[n2] = entry2;
                }
                --n;
            }
        }

        protected static class EntryFactory {
            protected EntryFactory() {
            }

            public static Entry createEntry(int n, String string, Object object, Entry entry) {
                return new Entry(n, string, object, entry);
            }
        }

        protected static class Entry {
            public int hash;
            public String key;
            public Object value;
            public Entry next;

            public Entry(int n, String string, Object object, Entry entry) {
                this.hash = n;
                this.key = string;
                this.value = object;
                this.next = entry;
            }
        }
    }

    protected static class LinkFactory {
        protected static final int SIZE = 10;
        protected static final WeakReference[] links = new WeakReference[10];

        protected LinkFactory() {
        }

        public static Link createLink(Link link) {
            return new Link(link);
        }

        public static void recycle(Link link) {
        }
    }

    protected static class Link {
        public Scope scope = new Scope();
        public Scope cscope = new Scope();
        public Link next;

        public Link(Link link) {
            this.next = link;
        }
    }

    protected class Constant
    extends AbstractVariable {
        public Constant(String string) {
            this.name = string;
        }

        public void set(VariableContext variableContext, Object object) {
            variableContext.cscope.put(this.name, object);
        }

        public Object get(VariableContext variableContext) {
            return variableContext.cscope.get(this.name);
        }
    }

    protected static class Variable
    extends AbstractVariable {
        public Variable(String string) {
            this.name = string;
        }

        public void set(VariableContext variableContext, Object object) {
            variableContext.scope.put(this.name, object);
        }

        public Object get(VariableContext variableContext) {
            return variableContext.scope.get(this.name);
        }
    }

    protected static abstract class AbstractVariable {
        public String name;

        protected AbstractVariable() {
        }

        public abstract void set(VariableContext var1, Object var2);

        public abstract Object get(VariableContext var1);

        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

