/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.tree;

import koala.dynamicjava.tree.Literal;

public class IntegerLiteral
extends Literal {
    public IntegerLiteral(String string) {
        this(string, null, 0, 0, 0, 0);
    }

    public IntegerLiteral(String string, String string2, int n, int n2, int n3, int n4) {
        super(string, IntegerLiteral.parse(string), Integer.TYPE, string2, n, n2, n3, n4);
    }

    private static Integer parse(String string) {
        if (string.startsWith("0x")) {
            return IntegerLiteral.parseHexadecimal(string.substring(2, string.length()));
        }
        if (string.startsWith("0")) {
            return IntegerLiteral.parseOctal(string);
        }
        return Integer.valueOf(string);
    }

    private static Integer parseHexadecimal(String string) {
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            char c = Character.toLowerCase(string.charAt(n2));
            if (n >>> 28 != 0) {
                throw new NumberFormatException(string);
            }
            n = (n << 4) + c + (c >= 'a' && c <= 'f' ? -87 : -48);
            ++n2;
        }
        return new Integer(n);
    }

    private static Integer parseOctal(String string) {
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            if (n >>> 29 != 0) {
                throw new NumberFormatException(string);
            }
            n = (n << 3) + c - 48;
            ++n2;
        }
        return new Integer(n);
    }
}

