/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.tree;

import koala.dynamicjava.tree.Literal;

public class LongLiteral
extends Literal {
    public LongLiteral(String string) {
        this(string, null, 0, 0, 0, 0);
    }

    public LongLiteral(String string, String string2, int n, int n2, int n3, int n4) {
        super(string, LongLiteral.parse(string.substring(0, string.length() - 1)), Long.TYPE, string2, n, n2, n3, n4);
    }

    private static Long parse(String string) {
        if (string.startsWith("0x")) {
            return LongLiteral.parseHexadecimal(string.substring(2, string.length()));
        }
        if (string.startsWith("0")) {
            return LongLiteral.parseOctal(string);
        }
        return Long.valueOf(string);
    }

    private static Long parseHexadecimal(String string) {
        long l = 0L;
        int n = 0;
        while (n < string.length()) {
            char c = Character.toLowerCase(string.charAt(n));
            if (l >>> 60 != 0L) {
                throw new NumberFormatException(string);
            }
            l = (l << 4) + (long)c + (c >= 'a' && c <= 'f' ? -87L : -48L);
            ++n;
        }
        return new Long(l);
    }

    private static Long parseOctal(String string) {
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            if (n >>> 61 != 0) {
                throw new NumberFormatException(string);
            }
            n = (n << 3) + c - 48;
            ++n2;
        }
        return new Long(n);
    }
}

