/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.util;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import koala.dynamicjava.tree.AddAssignExpression;
import koala.dynamicjava.tree.AddExpression;
import koala.dynamicjava.tree.AndExpression;
import koala.dynamicjava.tree.ArrayAccess;
import koala.dynamicjava.tree.ArrayAllocation;
import koala.dynamicjava.tree.ArrayInitializer;
import koala.dynamicjava.tree.ArrayType;
import koala.dynamicjava.tree.BinaryExpression;
import koala.dynamicjava.tree.BitAndAssignExpression;
import koala.dynamicjava.tree.BitAndExpression;
import koala.dynamicjava.tree.BitOrAssignExpression;
import koala.dynamicjava.tree.BitOrExpression;
import koala.dynamicjava.tree.BlockStatement;
import koala.dynamicjava.tree.BreakStatement;
import koala.dynamicjava.tree.CastExpression;
import koala.dynamicjava.tree.CatchStatement;
import koala.dynamicjava.tree.ClassAllocation;
import koala.dynamicjava.tree.ClassDeclaration;
import koala.dynamicjava.tree.ClassInitializer;
import koala.dynamicjava.tree.ComplementExpression;
import koala.dynamicjava.tree.ConditionalExpression;
import koala.dynamicjava.tree.ConstructorDeclaration;
import koala.dynamicjava.tree.ConstructorInvocation;
import koala.dynamicjava.tree.ContinueStatement;
import koala.dynamicjava.tree.DivideAssignExpression;
import koala.dynamicjava.tree.DivideExpression;
import koala.dynamicjava.tree.DoStatement;
import koala.dynamicjava.tree.EmptyStatement;
import koala.dynamicjava.tree.EqualExpression;
import koala.dynamicjava.tree.ExclusiveOrAssignExpression;
import koala.dynamicjava.tree.ExclusiveOrExpression;
import koala.dynamicjava.tree.Expression;
import koala.dynamicjava.tree.FieldDeclaration;
import koala.dynamicjava.tree.ForStatement;
import koala.dynamicjava.tree.FormalParameter;
import koala.dynamicjava.tree.FunctionCall;
import koala.dynamicjava.tree.GreaterExpression;
import koala.dynamicjava.tree.GreaterOrEqualExpression;
import koala.dynamicjava.tree.IfThenElseStatement;
import koala.dynamicjava.tree.IfThenStatement;
import koala.dynamicjava.tree.ImportDeclaration;
import koala.dynamicjava.tree.InnerAllocation;
import koala.dynamicjava.tree.InnerClassAllocation;
import koala.dynamicjava.tree.InstanceInitializer;
import koala.dynamicjava.tree.InstanceOfExpression;
import koala.dynamicjava.tree.InterfaceDeclaration;
import koala.dynamicjava.tree.LabeledStatement;
import koala.dynamicjava.tree.LessExpression;
import koala.dynamicjava.tree.LessOrEqualExpression;
import koala.dynamicjava.tree.Literal;
import koala.dynamicjava.tree.MethodDeclaration;
import koala.dynamicjava.tree.MinusExpression;
import koala.dynamicjava.tree.MultiplyAssignExpression;
import koala.dynamicjava.tree.MultiplyExpression;
import koala.dynamicjava.tree.Node;
import koala.dynamicjava.tree.NotEqualExpression;
import koala.dynamicjava.tree.NotExpression;
import koala.dynamicjava.tree.ObjectFieldAccess;
import koala.dynamicjava.tree.ObjectMethodCall;
import koala.dynamicjava.tree.OrExpression;
import koala.dynamicjava.tree.PackageDeclaration;
import koala.dynamicjava.tree.PlusExpression;
import koala.dynamicjava.tree.PostDecrement;
import koala.dynamicjava.tree.PostIncrement;
import koala.dynamicjava.tree.PreDecrement;
import koala.dynamicjava.tree.PreIncrement;
import koala.dynamicjava.tree.PrimitiveType;
import koala.dynamicjava.tree.QualifiedName;
import koala.dynamicjava.tree.ReferenceType;
import koala.dynamicjava.tree.RemainderAssignExpression;
import koala.dynamicjava.tree.RemainderExpression;
import koala.dynamicjava.tree.ReturnStatement;
import koala.dynamicjava.tree.ShiftLeftAssignExpression;
import koala.dynamicjava.tree.ShiftLeftExpression;
import koala.dynamicjava.tree.ShiftRightAssignExpression;
import koala.dynamicjava.tree.ShiftRightExpression;
import koala.dynamicjava.tree.SimpleAllocation;
import koala.dynamicjava.tree.SimpleAssignExpression;
import koala.dynamicjava.tree.StaticFieldAccess;
import koala.dynamicjava.tree.StaticMethodCall;
import koala.dynamicjava.tree.SubtractAssignExpression;
import koala.dynamicjava.tree.SubtractExpression;
import koala.dynamicjava.tree.SuperFieldAccess;
import koala.dynamicjava.tree.SuperMethodCall;
import koala.dynamicjava.tree.SwitchBlock;
import koala.dynamicjava.tree.SwitchStatement;
import koala.dynamicjava.tree.SynchronizedStatement;
import koala.dynamicjava.tree.ThisExpression;
import koala.dynamicjava.tree.ThrowStatement;
import koala.dynamicjava.tree.TryStatement;
import koala.dynamicjava.tree.TypeExpression;
import koala.dynamicjava.tree.UnaryExpression;
import koala.dynamicjava.tree.UnsignedShiftRightAssignExpression;
import koala.dynamicjava.tree.UnsignedShiftRightExpression;
import koala.dynamicjava.tree.VariableDeclaration;
import koala.dynamicjava.tree.WhileStatement;
import koala.dynamicjava.tree.visitor.VisitorObject;

public class DisplayVisitor
extends VisitorObject {
    private PrintStream out;
    private String indentation;

    public DisplayVisitor(OutputStream outputStream) {
        this.out = new PrintStream(outputStream);
        this.indentation = "";
    }

    public Object visit(PackageDeclaration packageDeclaration) {
        this.print("l." + packageDeclaration.getBeginLine() + " PackageDeclaration " + packageDeclaration.getName() + " {");
        this.displayProperties(packageDeclaration);
        this.print("}");
        return null;
    }

    public Object visit(ImportDeclaration importDeclaration) {
        this.print("l." + importDeclaration.getBeginLine() + " ImportDeclaration " + importDeclaration.getName() + (importDeclaration.isPackage() ? ".*" : "") + " {");
        this.displayProperties(importDeclaration);
        this.print("}");
        return null;
    }

    public Object visit(EmptyStatement emptyStatement) {
        this.print("l." + emptyStatement.getBeginLine() + " EmptyStatement {");
        this.displayProperties(emptyStatement);
        this.print("}");
        return null;
    }

    public Object visit(WhileStatement whileStatement) {
        this.print("l." + whileStatement.getBeginLine() + " WhileStatement {");
        this.print("condition:");
        this.indent();
        whileStatement.getCondition().acceptVisitor(this);
        this.unindent();
        this.print("body:");
        this.indent();
        whileStatement.getBody().acceptVisitor(this);
        this.unindent();
        this.displayProperties(whileStatement);
        this.print("}");
        return null;
    }

    public Object visit(ForStatement forStatement) {
        Iterator iterator;
        this.print("l." + forStatement.getBeginLine() + " ForStatement {");
        this.print("initialization:");
        if (forStatement.getInitialization() != null) {
            this.indent();
            iterator = forStatement.getInitialization().iterator();
            while (iterator.hasNext()) {
                ((Node)iterator.next()).acceptVisitor(this);
            }
            this.unindent();
        }
        this.print("condition:");
        if (forStatement.getCondition() != null) {
            this.indent();
            forStatement.getCondition().acceptVisitor(this);
            this.unindent();
        }
        this.print("update:");
        if (forStatement.getUpdate() != null) {
            this.indent();
            iterator = forStatement.getUpdate().iterator();
            while (iterator.hasNext()) {
                ((Node)iterator.next()).acceptVisitor(this);
            }
            this.unindent();
        }
        this.print("body:");
        this.indent();
        forStatement.getBody().acceptVisitor(this);
        this.unindent();
        this.displayProperties(forStatement);
        this.print("}");
        return null;
    }

    public Object visit(DoStatement doStatement) {
        this.print("l." + doStatement.getBeginLine() + " DoStatement {");
        this.print("condition:");
        this.indent();
        doStatement.getCondition().acceptVisitor(this);
        this.unindent();
        this.print("body:");
        this.indent();
        doStatement.getBody().acceptVisitor(this);
        this.unindent();
        this.displayProperties(doStatement);
        this.print("}");
        return null;
    }

    public Object visit(SwitchStatement switchStatement) {
        this.print("l." + switchStatement.getBeginLine() + " SwitchStatement {");
        this.print("selector:");
        this.indent();
        switchStatement.getSelector().acceptVisitor(this);
        this.unindent();
        this.print("bindings:");
        this.indent();
        Iterator iterator = switchStatement.getBindings().iterator();
        while (iterator.hasNext()) {
            ((Node)iterator.next()).acceptVisitor(this);
        }
        this.unindent();
        this.displayProperties(switchStatement);
        this.print("}");
        return null;
    }

    public Object visit(SwitchBlock switchBlock) {
        this.print("l." + switchBlock.getBeginLine() + " SwitchBlock {");
        this.print("expression:");
        this.indent();
        if (switchBlock.getExpression() != null) {
            switchBlock.getExpression().acceptVisitor(this);
        } else {
            this.print("default");
        }
        this.unindent();
        this.print("statements:");
        this.indent();
        if (switchBlock.getStatements() != null) {
            Iterator iterator = switchBlock.getStatements().iterator();
            while (iterator.hasNext()) {
                ((Node)iterator.next()).acceptVisitor(this);
            }
        }
        this.unindent();
        this.displayProperties(switchBlock);
        this.print("}");
        return null;
    }

    public Object visit(LabeledStatement labeledStatement) {
        this.print("l." + labeledStatement.getBeginLine() + " LabeledStatement {");
        this.print("label:");
        this.indent();
        this.print(labeledStatement.getLabel());
        this.unindent();
        this.print("statement:");
        this.indent();
        labeledStatement.getStatement().acceptVisitor(this);
        this.unindent();
        this.displayProperties(labeledStatement);
        this.print("}");
        return null;
    }

    public Object visit(BreakStatement breakStatement) {
        this.print("l." + breakStatement.getBeginLine() + " BreakStatement {");
        this.print("label:");
        this.indent();
        this.print(breakStatement.getLabel());
        this.unindent();
        this.displayProperties(breakStatement);
        this.print("}");
        return null;
    }

    public Object visit(TryStatement tryStatement) {
        this.print("l." + tryStatement.getBeginLine() + " TryStatement {");
        this.print("tryBlock:");
        this.indent();
        tryStatement.getTryBlock().acceptVisitor(this);
        this.unindent();
        this.print("catchStatements:");
        this.indent();
        Iterator iterator = tryStatement.getCatchStatements().iterator();
        while (iterator.hasNext()) {
            ((Node)iterator.next()).acceptVisitor(this);
        }
        this.unindent();
        this.print("finallyBlock:");
        this.indent();
        if (tryStatement.getFinallyBlock() != null) {
            tryStatement.getFinallyBlock().acceptVisitor(this);
        }
        this.unindent();
        this.displayProperties(tryStatement);
        this.print("}");
        return null;
    }

    public Object visit(CatchStatement catchStatement) {
        this.print("l." + catchStatement.getBeginLine() + " CatchStatement {");
        this.print("exception:");
        this.indent();
        catchStatement.getException().acceptVisitor(this);
        this.unindent();
        this.print("block:");
        this.indent();
        catchStatement.getBlock().acceptVisitor(this);
        this.unindent();
        this.displayProperties(catchStatement);
        this.print("}");
        return null;
    }

    public Object visit(ThrowStatement throwStatement) {
        this.print("l." + throwStatement.getBeginLine() + " ThrowStatement {");
        this.print("expression:");
        this.indent();
        throwStatement.getExpression().acceptVisitor(this);
        this.unindent();
        this.displayProperties(throwStatement);
        this.print("}");
        return null;
    }

    public Object visit(ReturnStatement returnStatement) {
        this.print("l." + returnStatement.getBeginLine() + " ReturnStatement {");
        this.print("expression:");
        this.indent();
        returnStatement.getExpression().acceptVisitor(this);
        this.unindent();
        this.displayProperties(returnStatement);
        this.print("}");
        return null;
    }

    public Object visit(SynchronizedStatement synchronizedStatement) {
        this.print("l." + synchronizedStatement.getBeginLine() + " SynchronizedStatement {");
        this.print("lock:");
        this.indent();
        synchronizedStatement.getLock().acceptVisitor(this);
        this.unindent();
        this.print("body:");
        this.indent();
        synchronizedStatement.getBody().acceptVisitor(this);
        this.unindent();
        this.displayProperties(synchronizedStatement);
        this.print("}");
        return null;
    }

    public Object visit(ContinueStatement continueStatement) {
        this.print("l." + continueStatement.getBeginLine() + " ContinueStatement {");
        this.print("label:");
        this.indent();
        this.print(continueStatement.getLabel());
        this.unindent();
        this.displayProperties(continueStatement);
        this.print("}");
        return null;
    }

    public Object visit(IfThenStatement ifThenStatement) {
        this.print("l." + ifThenStatement.getBeginLine() + " IfThenStatement {");
        this.print("condition:");
        this.indent();
        ifThenStatement.getCondition().acceptVisitor(this);
        this.unindent();
        this.print("thenStatement:");
        this.indent();
        ifThenStatement.getThenStatement().acceptVisitor(this);
        this.unindent();
        this.displayProperties(ifThenStatement);
        this.print("}");
        return null;
    }

    public Object visit(IfThenElseStatement ifThenElseStatement) {
        this.print("l." + ifThenElseStatement.getBeginLine() + " IfThenElseStatement {");
        this.print("condition:");
        this.indent();
        ifThenElseStatement.getCondition().acceptVisitor(this);
        this.unindent();
        this.print("thenStatement:");
        this.indent();
        ifThenElseStatement.getThenStatement().acceptVisitor(this);
        this.unindent();
        this.print("elseStatement:");
        this.indent();
        ifThenElseStatement.getElseStatement().acceptVisitor(this);
        this.unindent();
        this.displayProperties(ifThenElseStatement);
        this.print("}");
        return null;
    }

    public Object visit(Literal literal) {
        this.print("l." + literal.getBeginLine() + " Literal (" + literal.getType() + ") <" + literal.getValue() + "> {");
        this.displayProperties(literal);
        this.print("}");
        return null;
    }

    public Object visit(ThisExpression thisExpression) {
        this.print("l." + thisExpression.getBeginLine() + " ThisExpression {");
        this.print("className:");
        this.indent();
        this.print(thisExpression.getClassName());
        this.unindent();
        this.displayProperties(thisExpression);
        this.print("}");
        return null;
    }

    public Object visit(QualifiedName qualifiedName) {
        this.print("l." + qualifiedName.getBeginLine() + " QualifiedName {");
        this.print("representation:");
        this.indent();
        this.print(qualifiedName.getRepresentation());
        this.unindent();
        this.displayProperties(qualifiedName);
        this.print("}");
        return null;
    }

    public Object visit(ObjectFieldAccess objectFieldAccess) {
        this.print("l." + objectFieldAccess.getBeginLine() + " ObjectFieldAccess {");
        this.print("expression:");
        this.indent();
        objectFieldAccess.getExpression().acceptVisitor(this);
        this.unindent();
        this.print("fieldName:");
        this.indent();
        this.print(objectFieldAccess.getFieldName());
        this.unindent();
        this.displayProperties(objectFieldAccess);
        this.print("}");
        return null;
    }

    public Object visit(StaticFieldAccess staticFieldAccess) {
        this.print("l." + staticFieldAccess.getBeginLine() + " StaticFieldAccess {");
        this.print("fieldType:");
        this.indent();
        staticFieldAccess.getFieldType().acceptVisitor(this);
        this.unindent();
        this.print("fieldName:");
        this.indent();
        this.print(staticFieldAccess.getFieldName());
        this.unindent();
        this.displayProperties(staticFieldAccess);
        this.print("}");
        return null;
    }

    public Object visit(ArrayAccess arrayAccess) {
        this.print("l." + arrayAccess.getBeginLine() + " ArrayAccess {");
        this.print("expression:");
        this.indent();
        arrayAccess.getExpression().acceptVisitor(this);
        this.unindent();
        this.print("cellNumber:");
        this.indent();
        arrayAccess.getCellNumber().acceptVisitor(this);
        this.unindent();
        this.displayProperties(arrayAccess);
        this.print("}");
        return null;
    }

    public Object visit(SuperFieldAccess superFieldAccess) {
        this.print(this.indentation + "l." + superFieldAccess.getBeginLine() + " SuperFieldAccess {");
        this.print("fieldName:");
        this.indent();
        this.print(superFieldAccess.getFieldName());
        this.unindent();
        this.displayProperties(superFieldAccess);
        this.print("}");
        return null;
    }

    public Object visit(ObjectMethodCall objectMethodCall) {
        this.print("l." + objectMethodCall.getBeginLine() + " ObjectMethodCall {");
        this.print("expression:");
        this.indent();
        if (objectMethodCall.getExpression() != null) {
            objectMethodCall.getExpression().acceptVisitor(this);
        } else {
            this.print("null");
        }
        this.unindent();
        this.print("methodName:");
        this.indent();
        this.print(objectMethodCall.getMethodName());
        this.unindent();
        this.print("arguments:");
        this.indent();
        if (objectMethodCall.getArguments() != null) {
            Iterator iterator = objectMethodCall.getArguments().iterator();
            while (iterator.hasNext()) {
                ((Expression)iterator.next()).acceptVisitor(this);
            }
        }
        this.unindent();
        this.displayProperties(objectMethodCall);
        this.print("}");
        return null;
    }

    public Object visit(FunctionCall functionCall) {
        this.print("l." + functionCall.getBeginLine() + " FunctionCall {");
        this.print("methodName:");
        this.indent();
        this.print(functionCall.getMethodName());
        this.unindent();
        this.print("arguments:");
        this.indent();
        if (functionCall.getArguments() != null) {
            Iterator iterator = functionCall.getArguments().iterator();
            while (iterator.hasNext()) {
                ((Expression)iterator.next()).acceptVisitor(this);
            }
        }
        this.unindent();
        this.displayProperties(functionCall);
        this.print("}");
        return null;
    }

    public Object visit(StaticMethodCall staticMethodCall) {
        this.print("l." + staticMethodCall.getBeginLine() + " StaticMethodCall {");
        this.print("methodType:");
        this.indent();
        staticMethodCall.getMethodType().acceptVisitor(this);
        this.unindent();
        this.print("methodName:");
        this.indent();
        this.print(staticMethodCall.getMethodName());
        this.unindent();
        this.print("arguments:");
        this.indent();
        if (staticMethodCall.getArguments() != null) {
            Iterator iterator = staticMethodCall.getArguments().iterator();
            while (iterator.hasNext()) {
                ((Expression)iterator.next()).acceptVisitor(this);
            }
        }
        this.unindent();
        this.displayProperties(staticMethodCall);
        this.print("}");
        return null;
    }

    public Object visit(ConstructorInvocation constructorInvocation) {
        this.print("l." + constructorInvocation.getBeginLine() + " ConstructorInvocation {");
        this.print("expression:");
        this.indent();
        if (constructorInvocation.getExpression() != null) {
            constructorInvocation.getExpression().acceptVisitor(this);
        }
        this.unindent();
        this.print("arguments:");
        this.indent();
        if (constructorInvocation.getArguments() != null) {
            Iterator iterator = constructorInvocation.getArguments().iterator();
            while (iterator.hasNext()) {
                ((Expression)iterator.next()).acceptVisitor(this);
            }
        }
        this.unindent();
        this.print("isSuper:");
        this.indent();
        this.print(constructorInvocation.isSuper() ? "true" : "false");
        this.unindent();
        this.displayProperties(constructorInvocation);
        this.print("}");
        return null;
    }

    public Object visit(SuperMethodCall superMethodCall) {
        this.print("l." + superMethodCall.getBeginLine() + " SuperMethodCall {");
        this.print("methodName:");
        this.indent();
        this.print(superMethodCall.getMethodName());
        this.unindent();
        this.print("arguments:");
        this.indent();
        if (superMethodCall.getArguments() != null) {
            Iterator iterator = superMethodCall.getArguments().iterator();
            while (iterator.hasNext()) {
                ((Expression)iterator.next()).acceptVisitor(this);
            }
        }
        this.unindent();
        this.displayProperties(superMethodCall);
        this.print("}");
        return null;
    }

    public Object visit(PrimitiveType primitiveType) {
        this.print("l." + primitiveType.getBeginLine() + " PrimitiveType <" + primitiveType.getValue() + ">");
        this.displayProperties(primitiveType);
        return null;
    }

    public Object visit(ReferenceType referenceType) {
        this.print("l." + referenceType.getBeginLine() + " ReferenceType {");
        this.print("representation:");
        this.indent();
        this.print(referenceType.getRepresentation());
        this.unindent();
        this.displayProperties(referenceType);
        this.print("}");
        return null;
    }

    public Object visit(ArrayType arrayType) {
        this.print("l." + arrayType.getBeginLine() + " ArrayType {");
        if (arrayType.getElementType() != null) {
            this.print("elementType:");
            arrayType.getElementType().acceptVisitor(this);
        }
        this.displayProperties(arrayType);
        this.print("}");
        return null;
    }

    public Object visit(TypeExpression typeExpression) {
        this.print("l." + typeExpression.getBeginLine() + " TypeExpression {");
        this.print("type:");
        this.indent();
        typeExpression.getType().acceptVisitor(this);
        this.unindent();
        this.displayProperties(typeExpression);
        this.print("}");
        return null;
    }

    public Object visit(PostIncrement postIncrement) {
        this.displayUnary(postIncrement);
        return null;
    }

    public Object visit(PostDecrement postDecrement) {
        this.displayUnary(postDecrement);
        return null;
    }

    public Object visit(PreIncrement preIncrement) {
        this.displayUnary(preIncrement);
        return null;
    }

    public Object visit(PreDecrement preDecrement) {
        this.displayUnary(preDecrement);
        return null;
    }

    public Object visit(ArrayInitializer arrayInitializer) {
        this.print("l." + arrayInitializer.getBeginLine() + " ArrayInitializer {");
        this.print("cells:");
        this.indent();
        Iterator iterator = arrayInitializer.getCells().iterator();
        while (iterator.hasNext()) {
            ((Expression)iterator.next()).acceptVisitor(this);
        }
        this.unindent();
        this.print("elementType:");
        this.indent();
        arrayInitializer.getElementType().acceptVisitor(this);
        this.unindent();
        this.displayProperties(arrayInitializer);
        this.print("}");
        return null;
    }

    public Object visit(ArrayAllocation arrayAllocation) {
        this.print("l." + arrayAllocation.getBeginLine() + " ArrayAllocation {");
        this.print("creationType:");
        this.indent();
        arrayAllocation.getCreationType().acceptVisitor(this);
        this.unindent();
        this.print("dimension:");
        this.indent();
        this.print("" + arrayAllocation.getDimension());
        this.unindent();
        this.print("sizes:");
        this.indent();
        Iterator iterator = arrayAllocation.getSizes().iterator();
        while (iterator.hasNext()) {
            ((Expression)iterator.next()).acceptVisitor(this);
        }
        this.unindent();
        this.print("initialization:");
        this.indent();
        if (arrayAllocation.getInitialization() != null) {
            arrayAllocation.getInitialization().acceptVisitor(this);
        }
        this.unindent();
        this.displayProperties(arrayAllocation);
        this.print("}");
        return null;
    }

    public Object visit(SimpleAllocation simpleAllocation) {
        this.print("l." + simpleAllocation.getBeginLine() + " SimpleAllocation {");
        this.print("creationType:");
        this.indent();
        simpleAllocation.getCreationType().acceptVisitor(this);
        this.unindent();
        this.print("arguments:");
        this.indent();
        if (simpleAllocation.getArguments() != null) {
            Iterator iterator = simpleAllocation.getArguments().iterator();
            while (iterator.hasNext()) {
                ((Expression)iterator.next()).acceptVisitor(this);
            }
        }
        this.unindent();
        this.displayProperties(simpleAllocation);
        this.print("}");
        return null;
    }

    public Object visit(ClassAllocation classAllocation) {
        Iterator iterator;
        this.print("l." + classAllocation.getBeginLine() + " ClassAllocation {");
        this.print("creationType:");
        this.indent();
        classAllocation.getCreationType().acceptVisitor(this);
        this.unindent();
        this.print("arguments:");
        this.indent();
        if (classAllocation.getArguments() != null) {
            iterator = classAllocation.getArguments().iterator();
            while (iterator.hasNext()) {
                ((Expression)iterator.next()).acceptVisitor(this);
            }
        }
        this.unindent();
        this.print("members:");
        this.indent();
        iterator = classAllocation.getMembers().iterator();
        while (iterator.hasNext()) {
            ((Node)iterator.next()).acceptVisitor(this);
        }
        this.unindent();
        this.displayProperties(classAllocation);
        this.print("}");
        return null;
    }

    public Object visit(InnerAllocation innerAllocation) {
        this.print("l." + innerAllocation.getBeginLine() + " InnerAllocation {");
        this.print("expression:");
        this.indent();
        innerAllocation.getExpression().acceptVisitor(this);
        this.unindent();
        this.print("creationType:");
        this.indent();
        innerAllocation.getCreationType().acceptVisitor(this);
        this.unindent();
        this.print("arguments:");
        this.indent();
        if (innerAllocation.getArguments() != null) {
            Iterator iterator = innerAllocation.getArguments().iterator();
            while (iterator.hasNext()) {
                ((Expression)iterator.next()).acceptVisitor(this);
            }
        }
        this.unindent();
        this.displayProperties(innerAllocation);
        this.print("}");
        return null;
    }

    public Object visit(InnerClassAllocation innerClassAllocation) {
        Iterator iterator;
        this.print("l." + innerClassAllocation.getBeginLine() + " InnerClassAllocation {");
        this.print("expression:");
        this.indent();
        innerClassAllocation.getExpression().acceptVisitor(this);
        this.unindent();
        this.print("creationType:");
        this.indent();
        innerClassAllocation.getCreationType().acceptVisitor(this);
        this.unindent();
        this.print("arguments:");
        this.indent();
        if (innerClassAllocation.getArguments() != null) {
            iterator = innerClassAllocation.getArguments().iterator();
            while (iterator.hasNext()) {
                ((Expression)iterator.next()).acceptVisitor(this);
            }
        }
        this.unindent();
        this.print("members:");
        this.indent();
        iterator = innerClassAllocation.getMembers().iterator();
        while (iterator.hasNext()) {
            ((Node)iterator.next()).acceptVisitor(this);
        }
        this.unindent();
        this.displayProperties(innerClassAllocation);
        this.print("}");
        return null;
    }

    public Object visit(CastExpression castExpression) {
        this.print("l." + castExpression.getBeginLine() + " CastExpression {");
        this.print("targetType:");
        this.indent();
        castExpression.getTargetType().acceptVisitor(this);
        this.unindent();
        this.print("expression:");
        this.indent();
        castExpression.getExpression().acceptVisitor(this);
        this.unindent();
        this.displayProperties(castExpression);
        this.print("}");
        return null;
    }

    public Object visit(NotExpression notExpression) {
        this.displayUnary(notExpression);
        return null;
    }

    public Object visit(ComplementExpression complementExpression) {
        this.displayUnary(complementExpression);
        return null;
    }

    public Object visit(PlusExpression plusExpression) {
        this.displayUnary(plusExpression);
        return null;
    }

    public Object visit(MinusExpression minusExpression) {
        this.displayUnary(minusExpression);
        return null;
    }

    public Object visit(MultiplyExpression multiplyExpression) {
        this.displayBinary(multiplyExpression);
        return null;
    }

    public Object visit(DivideExpression divideExpression) {
        this.displayBinary(divideExpression);
        return null;
    }

    public Object visit(RemainderExpression remainderExpression) {
        this.displayBinary(remainderExpression);
        return null;
    }

    public Object visit(AddExpression addExpression) {
        this.displayBinary(addExpression);
        return null;
    }

    public Object visit(SubtractExpression subtractExpression) {
        this.displayBinary(subtractExpression);
        return null;
    }

    public Object visit(ShiftLeftExpression shiftLeftExpression) {
        this.displayBinary(shiftLeftExpression);
        return null;
    }

    public Object visit(ShiftRightExpression shiftRightExpression) {
        this.displayBinary(shiftRightExpression);
        return null;
    }

    public Object visit(UnsignedShiftRightExpression unsignedShiftRightExpression) {
        this.displayBinary(unsignedShiftRightExpression);
        return null;
    }

    public Object visit(LessExpression lessExpression) {
        this.displayBinary(lessExpression);
        return null;
    }

    public Object visit(GreaterExpression greaterExpression) {
        this.displayBinary(greaterExpression);
        return null;
    }

    public Object visit(LessOrEqualExpression lessOrEqualExpression) {
        this.displayBinary(lessOrEqualExpression);
        return null;
    }

    public Object visit(GreaterOrEqualExpression greaterOrEqualExpression) {
        this.displayBinary(greaterOrEqualExpression);
        return null;
    }

    public Object visit(InstanceOfExpression instanceOfExpression) {
        this.print("l." + instanceOfExpression.getBeginLine() + " InstanceOfExpression {");
        this.print("expression:");
        this.indent();
        instanceOfExpression.getExpression().acceptVisitor(this);
        this.unindent();
        this.print("referenceType:");
        this.indent();
        instanceOfExpression.getReferenceType().acceptVisitor(this);
        this.unindent();
        this.displayProperties(instanceOfExpression);
        this.print("}");
        return null;
    }

    public Object visit(EqualExpression equalExpression) {
        this.displayBinary(equalExpression);
        return null;
    }

    public Object visit(NotEqualExpression notEqualExpression) {
        this.displayBinary(notEqualExpression);
        return null;
    }

    public Object visit(BitAndExpression bitAndExpression) {
        this.displayBinary(bitAndExpression);
        return null;
    }

    public Object visit(ExclusiveOrExpression exclusiveOrExpression) {
        this.displayBinary(exclusiveOrExpression);
        return null;
    }

    public Object visit(BitOrExpression bitOrExpression) {
        this.displayBinary(bitOrExpression);
        return null;
    }

    public Object visit(AndExpression andExpression) {
        this.displayBinary(andExpression);
        return null;
    }

    public Object visit(OrExpression orExpression) {
        this.displayBinary(orExpression);
        return null;
    }

    public Object visit(ConditionalExpression conditionalExpression) {
        this.print("l." + conditionalExpression.getBeginLine() + " ConditionalExpression {");
        this.print("conditionExpression:");
        this.indent();
        conditionalExpression.getConditionExpression().acceptVisitor(this);
        this.unindent();
        this.print("ifTrueExpression:");
        this.indent();
        conditionalExpression.getIfTrueExpression().acceptVisitor(this);
        this.unindent();
        this.print("ifFalseExpression:");
        this.indent();
        conditionalExpression.getIfFalseExpression().acceptVisitor(this);
        this.unindent();
        this.displayProperties(conditionalExpression);
        this.print("}");
        return null;
    }

    public Object visit(SimpleAssignExpression simpleAssignExpression) {
        this.displayBinary(simpleAssignExpression);
        return null;
    }

    public Object visit(MultiplyAssignExpression multiplyAssignExpression) {
        this.displayBinary(multiplyAssignExpression);
        return null;
    }

    public Object visit(DivideAssignExpression divideAssignExpression) {
        this.displayBinary(divideAssignExpression);
        return null;
    }

    public Object visit(RemainderAssignExpression remainderAssignExpression) {
        this.displayBinary(remainderAssignExpression);
        return null;
    }

    public Object visit(AddAssignExpression addAssignExpression) {
        this.displayBinary(addAssignExpression);
        return null;
    }

    public Object visit(SubtractAssignExpression subtractAssignExpression) {
        this.displayBinary(subtractAssignExpression);
        return null;
    }

    public Object visit(ShiftLeftAssignExpression shiftLeftAssignExpression) {
        this.displayBinary(shiftLeftAssignExpression);
        return null;
    }

    public Object visit(ShiftRightAssignExpression shiftRightAssignExpression) {
        this.displayBinary(shiftRightAssignExpression);
        return null;
    }

    public Object visit(UnsignedShiftRightAssignExpression unsignedShiftRightAssignExpression) {
        this.displayBinary(unsignedShiftRightAssignExpression);
        return null;
    }

    public Object visit(BitAndAssignExpression bitAndAssignExpression) {
        this.displayBinary(bitAndAssignExpression);
        return null;
    }

    public Object visit(ExclusiveOrAssignExpression exclusiveOrAssignExpression) {
        this.displayBinary(exclusiveOrAssignExpression);
        return null;
    }

    public Object visit(BitOrAssignExpression bitOrAssignExpression) {
        this.displayBinary(bitOrAssignExpression);
        return null;
    }

    public Object visit(BlockStatement blockStatement) {
        this.print("l." + blockStatement.getBeginLine() + " BlockStatement {");
        this.print("statements:");
        this.indent();
        Iterator iterator = blockStatement.getStatements().iterator();
        while (iterator.hasNext()) {
            ((Node)iterator.next()).acceptVisitor(this);
        }
        this.unindent();
        this.displayProperties(blockStatement);
        this.print("}");
        return null;
    }

    public Object visit(ClassDeclaration classDeclaration) {
        Iterator iterator;
        this.print("l." + classDeclaration.getBeginLine() + " ClassDeclaration {");
        this.print("name:");
        this.indent();
        this.print(classDeclaration.getName());
        this.unindent();
        this.print("superclass:");
        this.indent();
        this.print(classDeclaration.getSuperclass());
        this.unindent();
        this.print("interfaces:");
        this.indent();
        if (classDeclaration.getInterfaces() != null) {
            iterator = classDeclaration.getInterfaces().iterator();
            while (iterator.hasNext()) {
                this.print((String)iterator.next());
            }
        }
        this.unindent();
        this.print("members:");
        this.indent();
        iterator = classDeclaration.getMembers().iterator();
        while (iterator.hasNext()) {
            ((Node)iterator.next()).acceptVisitor(this);
        }
        this.unindent();
        this.displayProperties(classDeclaration);
        this.print("}");
        return null;
    }

    public Object visit(InterfaceDeclaration interfaceDeclaration) {
        Iterator iterator;
        this.print("l." + interfaceDeclaration.getBeginLine() + " InterfaceDeclaration {");
        this.print("name:");
        this.indent();
        this.print(interfaceDeclaration.getName());
        this.unindent();
        this.print("interfaces:");
        this.indent();
        if (interfaceDeclaration.getInterfaces() != null) {
            iterator = interfaceDeclaration.getInterfaces().iterator();
            while (iterator.hasNext()) {
                this.print((String)iterator.next());
            }
        }
        this.unindent();
        this.print("members:");
        this.indent();
        iterator = interfaceDeclaration.getMembers().iterator();
        while (iterator.hasNext()) {
            ((Node)iterator.next()).acceptVisitor(this);
        }
        this.unindent();
        this.displayProperties(interfaceDeclaration);
        this.print("}");
        return null;
    }

    public Object visit(ConstructorDeclaration constructorDeclaration) {
        this.print("l." + constructorDeclaration.getBeginLine() + " ConstructorDeclaration {");
        this.print("accessFlags:");
        this.indent();
        this.print("" + constructorDeclaration.getAccessFlags());
        this.unindent();
        this.print("name:");
        this.indent();
        this.print(constructorDeclaration.getName());
        this.unindent();
        this.print("parameters:");
        this.indent();
        Iterator iterator = constructorDeclaration.getParameters().iterator();
        while (iterator.hasNext()) {
            ((Node)iterator.next()).acceptVisitor(this);
        }
        this.unindent();
        this.print("exceptions:");
        this.indent();
        iterator = constructorDeclaration.getExceptions().iterator();
        while (iterator.hasNext()) {
            this.print((String)iterator.next());
        }
        this.unindent();
        this.print("constructorInvocation:");
        this.indent();
        if (constructorDeclaration.getConstructorInvocation() != null) {
            constructorDeclaration.getConstructorInvocation().acceptVisitor(this);
        }
        this.unindent();
        this.print("statements:");
        this.indent();
        iterator = constructorDeclaration.getStatements().iterator();
        while (iterator.hasNext()) {
            ((Node)iterator.next()).acceptVisitor(this);
        }
        this.unindent();
        this.displayProperties(constructorDeclaration);
        this.print("}");
        return null;
    }

    public Object visit(MethodDeclaration methodDeclaration) {
        this.print("l." + methodDeclaration.getBeginLine() + " MethodDeclaration {");
        this.print("accessFlags:");
        this.indent();
        this.print("" + methodDeclaration.getAccessFlags());
        this.unindent();
        this.print("returnType:");
        this.indent();
        methodDeclaration.getReturnType().acceptVisitor(this);
        this.unindent();
        this.print("name:");
        this.indent();
        this.print(methodDeclaration.getName());
        this.unindent();
        this.print("parameters:");
        this.indent();
        Iterator iterator = methodDeclaration.getParameters().iterator();
        while (iterator.hasNext()) {
            ((Node)iterator.next()).acceptVisitor(this);
        }
        this.unindent();
        this.print("exceptions:");
        this.indent();
        iterator = methodDeclaration.getExceptions().iterator();
        while (iterator.hasNext()) {
            this.print((String)iterator.next());
        }
        this.unindent();
        this.print("body:");
        this.indent();
        if (methodDeclaration.getBody() != null) {
            methodDeclaration.getBody().acceptVisitor(this);
        }
        this.unindent();
        this.displayProperties(methodDeclaration);
        this.print("}");
        return null;
    }

    public Object visit(FormalParameter formalParameter) {
        this.print("l." + formalParameter.getBeginLine() + " FormalParameter {");
        if (formalParameter.isFinal()) {
            this.print("final");
        }
        this.print("type:");
        this.indent();
        formalParameter.getType().acceptVisitor(this);
        this.unindent();
        this.print("name:");
        this.indent();
        this.print(formalParameter.getName());
        this.unindent();
        this.displayProperties(formalParameter);
        this.print("}");
        return null;
    }

    public Object visit(FieldDeclaration fieldDeclaration) {
        this.print("l." + fieldDeclaration.getBeginLine() + " FieldDeclaration {");
        this.print("accessFlags:");
        this.indent();
        this.print("" + fieldDeclaration.getAccessFlags());
        this.unindent();
        this.print("type:");
        this.indent();
        fieldDeclaration.getType().acceptVisitor(this);
        this.unindent();
        this.print("name:");
        this.indent();
        this.print(fieldDeclaration.getName());
        this.unindent();
        this.print("initializer:");
        this.indent();
        if (fieldDeclaration.getInitializer() != null) {
            fieldDeclaration.getInitializer().acceptVisitor(this);
        }
        this.unindent();
        this.displayProperties(fieldDeclaration);
        this.print("}");
        return null;
    }

    public Object visit(VariableDeclaration variableDeclaration) {
        this.print("l." + variableDeclaration.getBeginLine() + " VariableDeclaration {");
        this.print("isFinal:");
        this.indent();
        this.print("" + variableDeclaration.isFinal());
        this.unindent();
        this.print("type:");
        this.indent();
        variableDeclaration.getType().acceptVisitor(this);
        this.unindent();
        this.print("name:");
        this.indent();
        this.print(variableDeclaration.getName());
        this.unindent();
        this.print("initializer:");
        this.indent();
        if (variableDeclaration.getInitializer() != null) {
            variableDeclaration.getInitializer().acceptVisitor(this);
        }
        this.unindent();
        this.displayProperties(variableDeclaration);
        this.print("}");
        return null;
    }

    public Object visit(ClassInitializer classInitializer) {
        this.print("l." + classInitializer.getBeginLine() + " ClassInitializer {");
        this.print("block:");
        this.indent();
        classInitializer.getBlock().acceptVisitor(this);
        this.unindent();
        this.displayProperties(classInitializer);
        this.print("}");
        return null;
    }

    public Object visit(InstanceInitializer instanceInitializer) {
        this.print("l." + instanceInitializer.getBeginLine() + " InstanceInitializer {");
        this.print("block:");
        this.indent();
        instanceInitializer.getBlock().acceptVisitor(this);
        this.unindent();
        this.displayProperties(instanceInitializer);
        this.print("}");
        return null;
    }

    private void displayUnary(UnaryExpression unaryExpression) {
        this.print("l." + unaryExpression.getBeginLine() + " " + unaryExpression.getClass().getName() + " {");
        this.print("expression:");
        this.indent();
        unaryExpression.getExpression().acceptVisitor(this);
        this.unindent();
        this.displayProperties(unaryExpression);
        this.print("}");
    }

    private void displayBinary(BinaryExpression binaryExpression) {
        this.print("l." + binaryExpression.getBeginLine() + " " + binaryExpression.getClass().getName() + " {");
        this.print("leftExpression:");
        this.indent();
        binaryExpression.getLeftExpression().acceptVisitor(this);
        this.unindent();
        this.print("rightExpression:");
        this.indent();
        binaryExpression.getRightExpression().acceptVisitor(this);
        this.unindent();
        this.displayProperties(binaryExpression);
        this.print("}");
    }

    private void displayProperties(Node node) {
        Iterator iterator = node.getProperties().iterator();
        if (iterator.hasNext()) {
            this.print("properties:");
        }
        while (iterator.hasNext()) {
            this.indent();
            String string = (String)iterator.next();
            this.print(string + ": " + node.getProperty(string));
            this.unindent();
        }
    }

    private void indent() {
        this.indentation = this.indentation + "  ";
    }

    private void unindent() {
        this.indentation = this.indentation.substring(0, this.indentation.length() - 2);
    }

    private void print(String string) {
        this.out.println(this.indentation + string);
    }
}

