/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor;

import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtEditorUI;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.NbToolbarSupport;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.CloneableEditor;
import org.openide.util.actions.ActionPerformer;
import org.openide.util.actions.CallbackSystemAction;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;

public class NbEditorUI
extends ExtEditorUI {
    private FocusListener focusL;
    private SystemActionUpdater findActionUpdater = this.createSystemActionUpdater("find", true, false);
    private SystemActionUpdater replaceActionUpdater = this.createSystemActionUpdater("replace", true, false);
    private SystemActionUpdater gotoActionUpdater = this.createSystemActionUpdater("goto", true, false);
    private SystemActionUpdater removeSelectionActionUpdater = this.createSystemActionUpdater("remove-selection", true, true);

    protected SystemActionUpdater createSystemActionUpdater(String string, boolean bl, boolean bl2) {
        return new SystemActionUpdater(string, bl, bl2);
    }

    public NbEditorUI() {
        this.focusL = new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                FileObject fileObject;
                DataObject dataObject;
                BaseDocument baseDocument = NbEditorUI.this.getDocument();
                if (baseDocument != null && (dataObject = NbEditorUtilities.getDataObject(baseDocument)) != null && (fileObject = dataObject.getPrimaryFile()) != null) {
                    fileObject.refresh();
                }
            }
        };
    }

    protected void installUI(JTextComponent jTextComponent) {
        super.installUI(jTextComponent);
        jTextComponent.addFocusListener(this.focusL);
    }

    protected void uninstallUI(JTextComponent jTextComponent) {
        super.uninstallUI(jTextComponent);
        jTextComponent.removeFocusListener(this.focusL);
    }

    protected JComponent createExtComponent() {
        JComponent jComponent = super.createExtComponent();
        NbToolbarSupport.checkToolbar(jComponent, (JEditorPane)this.getComponent());
        return jComponent;
    }

    static class EnabledPropertySyncListener
    implements PropertyChangeListener {
        Action action;

        EnabledPropertySyncListener(Action action) {
            this.action = action;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("enabled".equals(propertyChangeEvent.getPropertyName())) {
                this.action.setEnabled((Boolean)propertyChangeEvent.getNewValue());
            }
        }
    }

    public final class SystemActionUpdater
    implements PropertyChangeListener,
    ActionPerformer {
        private String editorActionName;
        private boolean updatePerformer;
        private boolean syncEnabling;
        private Action editorAction;
        private Action systemAction;
        private PropertyChangeListener enabledPropertySyncL;

        SystemActionUpdater(String string, boolean bl, boolean bl2) {
            this.editorActionName = string;
            this.updatePerformer = bl;
            this.syncEnabling = bl2;
            Object object = NbEditorUI.this.getComponentLock();
            synchronized (object) {
                JTextComponent jTextComponent = NbEditorUI.this.getComponent();
                if (jTextComponent != null) {
                    this.propertyChange(new PropertyChangeEvent(NbEditorUI.this, "component", null, jTextComponent));
                }
                NbEditorUI.this.addPropertyChangeListener(this);
            }
        }

        public void editorActivated() {
            Action action = this.getEditorAction();
            Action action2 = this.getSystemAction();
            if (action != null && action2 != null) {
                if (this.updatePerformer && action.isEnabled() && action2 instanceof CallbackSystemAction) {
                    ((CallbackSystemAction)action2).setActionPerformer((ActionPerformer)this);
                }
                if (this.syncEnabling) {
                    if (this.enabledPropertySyncL == null) {
                        this.enabledPropertySyncL = new EnabledPropertySyncListener(action2);
                    }
                    action.addPropertyChangeListener(this.enabledPropertySyncL);
                }
            }
        }

        public void editorDeactivated() {
            Action action = this.getEditorAction();
            Action action2 = this.getSystemAction();
            if (action != null && action2 != null && this.syncEnabling && this.enabledPropertySyncL != null) {
                action.removePropertyChangeListener(this.enabledPropertySyncL);
            }
        }

        private void reset() {
            if (this.enabledPropertySyncL != null) {
                this.editorAction.removePropertyChangeListener(this.enabledPropertySyncL);
            }
            this.editorAction = null;
            this.systemAction = null;
            this.enabledPropertySyncL = null;
        }

        public void performAction(SystemAction systemAction) {
            JTextComponent jTextComponent = NbEditorUI.this.getComponent();
            Action action = this.getEditorAction();
            if (jTextComponent != null && action != null) {
                action.actionPerformed(new ActionEvent(jTextComponent, 0, ""));
            }
        }

        public synchronized void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("activated".equals(string)) {
                TopComponent topComponent = (TopComponent)propertyChangeEvent.getNewValue();
                if (topComponent instanceof CloneableEditor) {
                    this.editorActivated();
                } else {
                    this.editorDeactivated();
                }
            } else if ("component".equals(string)) {
                JTextComponent jTextComponent = (JTextComponent)propertyChangeEvent.getNewValue();
                TopComponent.Registry registry = TopComponent.getRegistry();
                if (jTextComponent != null) {
                    jTextComponent.addPropertyChangeListener(this);
                    registry.addPropertyChangeListener((PropertyChangeListener)this);
                } else {
                    jTextComponent = (JTextComponent)propertyChangeEvent.getOldValue();
                    jTextComponent.removePropertyChangeListener(this);
                    registry.removePropertyChangeListener((PropertyChangeListener)this);
                }
                this.reset();
            } else if ("editorKit".equals(string)) {
                this.reset();
            }
        }

        private synchronized Action getEditorAction() {
            BaseKit baseKit;
            if (this.editorAction == null && (baseKit = Utilities.getKit(NbEditorUI.this.getComponent())) != null) {
                this.editorAction = baseKit.getActionByName(this.editorActionName);
            }
            return this.editorAction;
        }

        private Action getSystemAction() {
            String string;
            Action action;
            if (this.systemAction == null && (action = this.getEditorAction()) != null && (string = (String)action.getValue("systemActionClassName")) != null) {
                Class<?> clazz;
                try {
                    clazz = Class.forName(string);
                }
                catch (Throwable throwable) {
                    clazz = null;
                }
                if (clazz != null && NbEditorUtilities.getTopManager() != null) {
                    this.systemAction = SystemAction.get(clazz);
                }
            }
            return this.systemAction;
        }

        protected void finalize() throws Throwable {
            this.reset();
        }
    }
}

