/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.MissingResourceException;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.JumpList;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtSyntaxSupport;
import org.openide.ErrorManager;
import org.openide.TopManager;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.loaders.DataObject;
import org.openide.text.Line;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class NbEditorUtilities {
    static /* synthetic */ Class class$org$openide$cookies$LineCookie;
    static /* synthetic */ Class class$org$openide$windows$TopComponent;
    static /* synthetic */ Class class$org$openide$cookies$EditorCookie;
    static /* synthetic */ Class class$org$openide$ErrorManager;
    static /* synthetic */ Class class$org$netbeans$modules$editor$FormatterIndentEngine;

    public static DataObject getDataObject(Document document) {
        Object object = document.getProperty("stream");
        if (object instanceof DataObject) {
            return (DataObject)object;
        }
        return null;
    }

    public static int[] getIdentifierAndMethodBlock(BaseDocument baseDocument, int n) throws BadLocationException {
        int[] nArray;
        int[] nArray2 = Utilities.getIdentifierBlock(baseDocument, n);
        if (nArray2 != null && (nArray = ((ExtSyntaxSupport)baseDocument.getSyntaxSupport()).getFunctionBlock(nArray2)) != null) {
            return new int[]{nArray2[0], nArray2[1], nArray[1]};
        }
        return nArray2;
    }

    public static Line getLine(BaseDocument baseDocument, int n, boolean bl) {
        Line.Set set;
        LineCookie lineCookie;
        DataObject dataObject = NbEditorUtilities.getDataObject(baseDocument);
        if (dataObject != null && (lineCookie = (LineCookie)dataObject.getCookie(class$org$openide$cookies$LineCookie == null ? (class$org$openide$cookies$LineCookie = NbEditorUtilities.class$("org.openide.cookies.LineCookie")) : class$org$openide$cookies$LineCookie)) != null && (set = lineCookie.getLineSet()) != null) {
            try {
                int n2 = Utilities.getLineOffset(baseDocument, n);
                return bl ? set.getOriginal(n2) : set.getCurrent(n2);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return null;
    }

    public static Line getLine(JTextComponent jTextComponent, boolean bl) {
        return NbEditorUtilities.getLine((BaseDocument)jTextComponent.getDocument(), jTextComponent.getCaret().getDot(), bl);
    }

    public static TopComponent getTopComponent(JTextComponent jTextComponent) {
        return (TopComponent)SwingUtilities.getAncestorOfClass(class$org$openide$windows$TopComponent == null ? (class$org$openide$windows$TopComponent = NbEditorUtilities.class$("org.openide.windows.TopComponent")) : class$org$openide$windows$TopComponent, jTextComponent);
    }

    public static void addJumpListEntry(DataObject dataObject) {
        final EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(class$org$openide$cookies$EditorCookie == null ? (class$org$openide$cookies$EditorCookie = NbEditorUtilities.class$("org.openide.cookies.EditorCookie")) : class$org$openide$cookies$EditorCookie);
        if (editorCookie != null) {
            final Timer timer = new Timer(500, null);
            timer.addActionListener(new ActionListener(){
                private int countDown = 10;

                public void actionPerformed(ActionEvent actionEvent) {
                    SwingUtilities.invokeLater(new Runnable(this){
                        private final /* synthetic */ 1 this$0;
                        {
                            this.this$0 = var1_1;
                        }

                        public void run() {
                            if (1.access$006(this.this$0) >= 0) {
                                JEditorPane[] jEditorPaneArray = 1.access$100(this.this$0).getOpenedPanes();
                                if (jEditorPaneArray != null && jEditorPaneArray.length > 0) {
                                    JumpList.checkAddEntry(jEditorPaneArray[0]);
                                    1.access$200(this.this$0).stop();
                                }
                            } else {
                                1.access$200(this.this$0).stop();
                            }
                        }
                    });
                }

                static /* synthetic */ int access$006(1 var0) {
                    return --var0.countDown;
                }

                static /* synthetic */ EditorCookie access$100(1 var0) {
                    return var0.editorCookie;
                }

                static /* synthetic */ Timer access$200(1 var0) {
                    return var0.timer;
                }
            });
            timer.start();
        }
    }

    public static TopManager getTopManager() {
        TopManager topManager;
        try {
            topManager = TopManager.getDefault();
        }
        catch (Throwable throwable) {
            topManager = null;
        }
        return topManager;
    }

    public static String[] mergeStringArrays(String[] stringArray, String[] stringArray2) {
        String[] stringArray3 = new String[stringArray.length + stringArray2.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray3[n] = stringArray[n];
            ++n;
        }
        int n2 = 0;
        while (n2 < stringArray2.length) {
            stringArray3[stringArray.length + n2] = stringArray2[n2];
            ++n2;
        }
        return stringArray3;
    }

    public static String getMimeType(Document document) {
        return (String)document.getProperty("mimeType");
    }

    public static void invalidArgument(String string) {
        IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Invalid argument");
        Toolkit.getDefaultToolkit().beep();
        ErrorManager errorManager = (ErrorManager)Lookup.getDefault().lookup(class$org$openide$ErrorManager == null ? (class$org$openide$ErrorManager = NbEditorUtilities.class$("org.openide.ErrorManager")) : class$org$openide$ErrorManager);
        if (errorManager != null) {
            errorManager.annotate((Throwable)illegalArgumentException, 256, illegalArgumentException.getMessage(), NbEditorUtilities.getString(string), null, null);
        }
        throw illegalArgumentException;
    }

    private static String getString(String string) {
        try {
            return NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$FormatterIndentEngine == null ? (class$org$netbeans$modules$editor$FormatterIndentEngine = NbEditorUtilities.class$("org.netbeans.modules.editor.FormatterIndentEngine")) : class$org$netbeans$modules$editor$FormatterIndentEngine)).getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                missingResourceException.printStackTrace();
            }
            return string;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

