/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor;

import java.awt.Component;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import org.netbeans.core.windows.frames.TopComponentContainer;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.LocaleSupport;
import org.netbeans.editor.MultiKeyBinding;
import org.netbeans.editor.Registry;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.options.AllOptionsFolder;
import org.netbeans.modules.editor.options.BaseOptions;
import org.openide.ErrorManager;
import org.openide.TopManager;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.actions.Presenter;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

final class NbToolbarSupport {
    private static final boolean debug = Boolean.getBoolean("netbeans.debug.editor.toolbar");
    private static final boolean debugSort = Boolean.getBoolean("netbeans.debug.editor.toolbar.sort");
    private static final String TOOLBARS_FOLDER_NAME = "Toolbars";
    private static final String DEFAULT_TOOLBAR_NAME = "Default";
    static final String BASE_MIME_TYPE = "text/base";
    private static final int TIMER_DELAY = 5000;
    private static final WeakHashMap kit2kitSup = new WeakHashMap();
    private static boolean lastToolbarsVisible;
    private static final Timer checkToolbarsTimer;
    private static int instanceCount;
    private static final Runnable returnFocusRunnable;
    private static final ActionListener sharedActionListener;
    private static final MouseListener sharedMouseListener;
    private static final SettingsChangeListener settingsListener;
    private static final PropertyChangeListener sharedPropertyChangeListener;
    private EditorKit kit;
    private JToolBar toolbarComponent;
    static /* synthetic */ Class class$org$openide$loaders$DataFolder;
    static /* synthetic */ Class class$javax$swing$text$JTextComponent;
    static /* synthetic */ Class class$org$openide$windows$TopComponent;
    static /* synthetic */ Class class$org$netbeans$core$windows$frames$TopComponentContainer;
    static /* synthetic */ Class class$org$netbeans$modules$editor$NbToolbarSupport;
    static /* synthetic */ Class class$org$openide$cookies$InstanceCookie;
    static /* synthetic */ Class class$javax$swing$JSeparator;

    static void checkToolbar(JComponent jComponent, JEditorPane jEditorPane) {
        jEditorPane.removePropertyChangeListener(sharedPropertyChangeListener);
        jEditorPane.addPropertyChangeListener(sharedPropertyChangeListener);
        NbToolbarSupport.refreshToolbar(jComponent, jEditorPane, NbToolbarSupport.isToolbarsVisible(), false);
    }

    private static void processAllToolbars(boolean bl, boolean bl2) {
        JEditorPane jEditorPane = NbToolbarSupport.getEditorPane(NbToolbarSupport.getExtComponent(TopComponent.getRegistry().getActivated()));
        Iterator iterator = Registry.getComponentIterator();
        while (iterator.hasNext()) {
            Component component = (Component)iterator.next();
            if (debug) {
                System.out.println("iteratorComponent=" + System.identityHashCode(component) + ", isShowing()=" + component.isShowing() + ", isActivatedPane=" + (component == jEditorPane) + ", hasSelectedTopComponent=" + NbToolbarSupport.hasSelectedTopComponent(component));
            }
            if (!(component instanceof JEditorPane)) continue;
            boolean bl3 = true;
            String string = "";
            if (!bl2 && !bl) {
                bl3 = !component.isShowing() && component != jEditorPane && !NbToolbarSupport.hasSelectedTopComponent(component);
                string = "RECLAIM";
            } else if (!bl2 && bl) {
                bl3 = component.isShowing() || NbToolbarSupport.hasSelectedTopComponent(component);
                string = "SHOW";
            } else {
                bl3 = true;
                String string2 = string = bl ? "SHOW" : "HIDE";
            }
            if (!bl3) continue;
            if (debug) {
                System.out.println("Attempt to " + string + " toolbar of c=" + System.identityHashCode(component));
            }
            NbToolbarSupport.refreshPaneToolbar((JEditorPane)component, bl, bl2);
        }
    }

    static DataFolder getToolbarFolder(String string, boolean bl) {
        String string2 = "Editors/" + string + "/" + TOOLBARS_FOLDER_NAME + "/" + DEFAULT_TOOLBAR_NAME;
        DataFolder dataFolder = null;
        FileObject fileObject = TopManager.getDefault().getRepository().getDefaultFileSystem().findResource(string2);
        if (fileObject != null) {
            try {
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                dataFolder = (DataFolder)dataObject.getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = NbToolbarSupport.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {}
        } else if (bl) {
            try {
                FileUtil.createFolder((FileObject)TopManager.getDefault().getRepository().getDefaultFileSystem().getRoot(), (String)string2);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(4096, (Throwable)iOException);
            }
        }
        return dataFolder;
    }

    private static JComponent getExtComponent(TopComponent topComponent) {
        Component component;
        if (topComponent != null && topComponent.getComponentCount() > 0 && (component = topComponent.getComponent(0)) instanceof JComponent) {
            JComponent jComponent = (JComponent)component;
            return NbToolbarSupport.getEditorPane(jComponent) != null ? jComponent : null;
        }
        return null;
    }

    private static JEditorPane getEditorPane(JComponent jComponent) {
        return jComponent != null ? (JEditorPane)jComponent.getClientProperty(class$javax$swing$text$JTextComponent == null ? (class$javax$swing$text$JTextComponent = NbToolbarSupport.class$("javax.swing.text.JTextComponent")) : class$javax$swing$text$JTextComponent) : null;
    }

    private static boolean hasSelectedTopComponent(Component component) {
        TopComponent topComponent = (TopComponent)SwingUtilities.getAncestorOfClass(class$org$openide$windows$TopComponent == null ? (class$org$openide$windows$TopComponent = NbToolbarSupport.class$("org.openide.windows.TopComponent")) : class$org$openide$windows$TopComponent, component);
        if (topComponent == null) {
            return true;
        }
        TopComponentContainer topComponentContainer = (TopComponentContainer)SwingUtilities.getAncestorOfClass(class$org$netbeans$core$windows$frames$TopComponentContainer == null ? (class$org$netbeans$core$windows$frames$TopComponentContainer = NbToolbarSupport.class$("org.netbeans.core.windows.frames.TopComponentContainer")) : class$org$netbeans$core$windows$frames$TopComponentContainer, (Component)topComponent);
        if (topComponentContainer == null) {
            return true;
        }
        List list = topComponentContainer.getAreas();
        int n = list.size() - 1;
        while (n >= 0) {
            TopComponentContainer.Area area = (TopComponentContainer.Area)list.get(n);
            if (area.getSelectedTopComponent() == topComponent) {
                return true;
            }
            --n;
        }
        return false;
    }

    private static void refreshPaneToolbar(JEditorPane jEditorPane, boolean bl, boolean bl2) {
        EditorUI editorUI = Utilities.getEditorUI(jEditorPane);
        if (editorUI != null && editorUI.hasExtComponent()) {
            NbToolbarSupport.refreshToolbar(editorUI.getExtComponent(), jEditorPane, bl, bl2);
        }
    }

    private static void refreshToolbar(JComponent jComponent, JEditorPane jEditorPane, boolean bl, boolean bl2) {
        EditorKit editorKit = jEditorPane.getEditorKit();
        if (editorKit != null) {
            NbToolbarSupport nbToolbarSupport = (NbToolbarSupport)jEditorPane.getClientProperty(class$org$netbeans$modules$editor$NbToolbarSupport == null ? (class$org$netbeans$modules$editor$NbToolbarSupport = NbToolbarSupport.class$("org.netbeans.modules.editor.NbToolbarSupport")) : class$org$netbeans$modules$editor$NbToolbarSupport);
            DataFolder dataFolder = null;
            DataFolder dataFolder2 = null;
            if (bl) {
                dataFolder = NbToolbarSupport.getToolbarFolder(BASE_MIME_TYPE, false);
                dataFolder2 = NbToolbarSupport.getToolbarFolder(NbToolbarSupport.getKitMimeType(editorKit), false);
                bl &= dataFolder != null || dataFolder2 != null;
            }
            if (bl) {
                if (nbToolbarSupport == null) {
                    KitSupport kitSupport = NbToolbarSupport.getKitSupport(editorKit);
                    nbToolbarSupport = kitSupport.obtainUnused();
                    if (nbToolbarSupport == null) {
                        nbToolbarSupport = new NbToolbarSupport(editorKit);
                        nbToolbarSupport.refreshToolbarComponent(dataFolder, dataFolder2);
                    }
                    nbToolbarSupport.attachToolbarComponent(jComponent, jEditorPane);
                }
                if (bl2) {
                    nbToolbarSupport.detachToolbarComponent(jComponent, jEditorPane);
                    nbToolbarSupport.refreshToolbarComponent(dataFolder, dataFolder2);
                    nbToolbarSupport.attachToolbarComponent(jComponent, jEditorPane);
                }
            } else if (nbToolbarSupport != null) {
                nbToolbarSupport.detachToolbarComponent(jComponent, jEditorPane);
                NbToolbarSupport.getKitSupport(nbToolbarSupport.kit).release(nbToolbarSupport);
            }
        }
    }

    private static boolean isToolbarsVisible() {
        return AllOptionsFolder.getDefault().isToolbarVisible();
    }

    private static KitSupport getKitSupport(EditorKit editorKit) {
        WeakHashMap weakHashMap = kit2kitSup;
        synchronized (weakHashMap) {
            KitSupport kitSupport = (KitSupport)kit2kitSup.get(editorKit);
            if (kitSupport == null) {
                kitSupport = new KitSupport();
                kit2kitSup.put(editorKit, kitSupport);
            }
            KitSupport kitSupport2 = kitSupport;
            return kitSupport2;
        }
    }

    private static int releaseExtraUnusedKitSupports() {
        WeakHashMap weakHashMap = kit2kitSup;
        synchronized (weakHashMap) {
            int n = 0;
            Iterator iterator = ((AbstractMap)kit2kitSup).values().iterator();
            while (iterator.hasNext()) {
                n += ((KitSupport)iterator.next()).releaseExtraUnused();
            }
            int n2 = n;
            return n2;
        }
    }

    private static String getKitMimeType(EditorKit editorKit) {
        String string = editorKit.getContentType();
        if (string == null) {
            throw new NullPointerException();
        }
        return string;
    }

    private static String getMnemonic(MultiKeyBinding multiKeyBinding) {
        StringBuffer stringBuffer = new StringBuffer();
        if (multiKeyBinding.keys != null) {
            int n = 0;
            while (n < multiKeyBinding.keys.length) {
                if (n > 0) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append(NbToolbarSupport.getKeyMnemonic(multiKeyBinding.keys[n]));
                ++n;
            }
        } else {
            stringBuffer.append(NbToolbarSupport.getKeyMnemonic(multiKeyBinding.key));
        }
        return stringBuffer.toString();
    }

    private static String getKeyMnemonic(KeyStroke keyStroke) {
        int n;
        String string = org.openide.util.Utilities.keyToString((KeyStroke)keyStroke);
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = keyStroke.getModifiers();
        if ((n2 & 2) != 0) {
            stringBuffer.append("Ctrl+");
        }
        if ((n2 & 8) != 0) {
            stringBuffer.append("Alt+");
        }
        if ((n2 & 1) != 0) {
            stringBuffer.append("Shift+");
        }
        if ((n2 & 4) != 0) {
            stringBuffer.append("Meta+");
        }
        if ((n = string.indexOf(45)) != -1) {
            string = string.substring(n + 1);
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    NbToolbarSupport(EditorKit editorKit) {
        this.kit = editorKit;
        ++instanceCount;
    }

    private void refreshToolbarComponent(DataFolder dataFolder, DataFolder dataFolder2) {
        this.toolbarComponent = new JToolBar();
        this.toolbarComponent.setFloatable(false);
        this.toolbarComponent.setBorder(null);
        this.toolbarComponent.addMouseListener(sharedMouseListener);
        this.addPresenters(dataFolder, dataFolder2, this.toolbarComponent);
    }

    private void addPresenters(DataFolder dataFolder, DataFolder dataFolder2, JToolBar jToolBar) {
        Object object;
        ArrayList arrayList = new ArrayList();
        AllOptionsFolder allOptionsFolder = AllOptionsFolder.getDefault();
        if (allOptionsFolder != null && (object = allOptionsFolder.getKeyBindingList()) != null) {
            arrayList.addAll(object);
        }
        if (this.kit instanceof BaseKit) {
            Object object2;
            object = (BaseKit)this.kit;
            BaseOptions baseOptions = BaseOptions.getOptions(this.kit.getClass());
            if (baseOptions != null && (object2 = baseOptions.getKeyBindingList()) != null) {
                arrayList.addAll(object2);
            }
            object2 = NbToolbarSupport.getToolbarObjects(dataFolder, dataFolder2).iterator();
            while (object2.hasNext()) {
                Object object3;
                Object object4;
                Object object5;
                Object object6;
                Object object7;
                DataObject dataObject = (DataObject)object2.next();
                InstanceCookie instanceCookie = (InstanceCookie)dataObject.getCookie(class$org$openide$cookies$InstanceCookie == null ? NbToolbarSupport.class$("org.openide.cookies.InstanceCookie") : class$org$openide$cookies$InstanceCookie);
                if (instanceCookie != null) {
                    try {
                        if ((class$javax$swing$JSeparator == null ? NbToolbarSupport.class$("javax.swing.JSeparator") : class$javax$swing$JSeparator).isAssignableFrom(instanceCookie.instanceClass())) {
                            jToolBar.addSeparator();
                            continue;
                        }
                        object7 = instanceCookie.instanceCreate();
                        if (object7 instanceof Presenter.Toolbar) {
                            object6 = ((Presenter.Toolbar)object7).getToolbarPresenter();
                            jToolBar.add((Component)object6);
                            if (!(object6 instanceof JButton)) continue;
                            object5 = (JButton)object6;
                            ((AbstractButton)object5).setBorderPainted(false);
                            ((Component)object5).addMouseListener(sharedMouseListener);
                            continue;
                        }
                        if (!(object7 instanceof Component)) continue;
                        jToolBar.add((Component)object7);
                        if (!(object7 instanceof JButton)) continue;
                        object6 = (JButton)object7;
                        ((AbstractButton)object6).setBorderPainted(false);
                        ((Component)object6).addMouseListener(sharedMouseListener);
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify(1, (Throwable)iOException);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        ErrorManager.getDefault().notify(1, (Throwable)classNotFoundException);
                    }
                    continue;
                }
                object7 = dataObject.getName();
                object6 = ((BaseKit)object).getActionByName((String)object7);
                if (object6 == null) continue;
                object5 = object6.getValue("SmallIcon");
                if (object5 == null) {
                    object4 = (String)object6.getValue("IconResource");
                    if (object4 == null) {
                        object4 = "org/netbeans/modules/editor/resources/default";
                    }
                    if ((object3 = org.openide.util.Utilities.loadImage((String)((String)object4 + ".gif"))) != null) {
                        object6.putValue("SmallIcon", new ImageIcon((Image)object3));
                    }
                }
                object4 = jToolBar.add((Action)object6);
                object3 = arrayList.iterator();
                while (object3.hasNext()) {
                    Object e = object3.next();
                    if (!(e instanceof MultiKeyBinding)) continue;
                    MultiKeyBinding multiKeyBinding = (MultiKeyBinding)e;
                    if (!((String)object7).equals(multiKeyBinding.actionName)) continue;
                    ((JComponent)object4).setToolTipText(((JComponent)object4).getToolTipText() + " (" + NbToolbarSupport.getMnemonic(multiKeyBinding) + ")");
                    break;
                }
                ((AbstractButton)object4).setBorderPainted(false);
                ((AbstractButton)object4).addActionListener(sharedActionListener);
                ((Component)object4).addMouseListener(sharedMouseListener);
                ((AbstractButton)object4).setMargin(new Insets(2, 1, 0, 1));
            }
        }
    }

    static List getToolbarObjects(DataFolder dataFolder, DataFolder dataFolder2) {
        Object object;
        Object object2;
        HashMap hashMap = new HashMap();
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        if (dataFolder2 != null) {
            NbToolbarSupport.addDataObjects(hashMap, arrayList, dataFolder2.getChildren());
        }
        if (dataFolder != null) {
            NbToolbarSupport.addDataObjects(hashMap, arrayList, dataFolder.getChildren());
        }
        if (dataFolder2 != null) {
            NbToolbarSupport.addSortPairs(dataFolder2, arrayList2);
        }
        if (dataFolder != null) {
            NbToolbarSupport.addSortPairs(dataFolder, arrayList2);
        }
        SortSupport sortSupport = new SortSupport();
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            object2 = iterator.next();
            object = iterator.next();
            if (hashMap.containsKey(object2) && hashMap.containsKey(object)) {
                sortSupport.addEdge(object2, object);
                continue;
            }
            if (!debugSort) continue;
            System.out.println("Edge not added: " + object2 + " -> " + hashMap.containsKey(object2) + ", " + object + " -> " + hashMap.containsKey(object));
        }
        if (debugSort) {
            System.out.println("Names: " + arrayList + "\nsortSupport:" + sortSupport);
        }
        object2 = sortSupport.eliminateMultipleStarts(arrayList, true);
        if (debugSort) {
            System.out.println("Eliminated multiple starts: " + sortSupport + "\nStandalones: " + object2);
        }
        object = sortSupport.createSortedList();
        if (debugSort) {
            System.out.println("Sorted Name List: " + object);
        }
        object.addAll(object2);
        int n = object.size();
        ArrayList arrayList3 = new ArrayList(n);
        int n2 = 0;
        while (n2 < n) {
            arrayList3.add(hashMap.get(object.get(n2)));
            ++n2;
        }
        if (arrayList3.indexOf(null) != -1) {
            throw new IllegalStateException();
        }
        return arrayList3;
    }

    private static void addDataObjects(Map map, List list, DataObject[] dataObjectArray) {
        int n = dataObjectArray.length;
        ArrayList<String> arrayList = new ArrayList<String>(n);
        int n2 = 0;
        while (n2 < n) {
            DataObject dataObject = dataObjectArray[n2];
            String string = dataObject.getPrimaryFile().getNameExt();
            if (list.indexOf(string) == -1 && arrayList.indexOf(string) == -1) {
                map.put(string, dataObject);
                arrayList.add(string);
            }
            ++n2;
        }
        list.addAll(0, arrayList);
    }

    private static void addSortPairs(DataFolder dataFolder, List list) {
        FileObject fileObject = dataFolder.getPrimaryFile();
        Enumeration enumeration = fileObject.getAttributes();
        while (enumeration.hasMoreElements()) {
            Object object;
            String string = (String)enumeration.nextElement();
            int n = string.indexOf("/");
            if (n == -1 || !((object = fileObject.getAttribute(string)) instanceof Boolean) || !((Boolean)object).booleanValue()) continue;
            list.add(string.substring(0, n));
            list.add(string.substring(n + 1));
        }
    }

    private void attachToolbarComponent(JComponent jComponent, JEditorPane jEditorPane) {
        if (jEditorPane.getClientProperty(class$org$netbeans$modules$editor$NbToolbarSupport == null ? (class$org$netbeans$modules$editor$NbToolbarSupport = NbToolbarSupport.class$("org.netbeans.modules.editor.NbToolbarSupport")) : class$org$netbeans$modules$editor$NbToolbarSupport) != null) {
            throw new IllegalStateException();
        }
        jEditorPane.putClientProperty(class$org$netbeans$modules$editor$NbToolbarSupport == null ? (class$org$netbeans$modules$editor$NbToolbarSupport = NbToolbarSupport.class$("org.netbeans.modules.editor.NbToolbarSupport")) : class$org$netbeans$modules$editor$NbToolbarSupport, this);
        jComponent.add((Component)this.toolbarComponent, "North");
    }

    private void detachToolbarComponent(JComponent jComponent, JEditorPane jEditorPane) {
        if (jEditorPane.getClientProperty(class$org$netbeans$modules$editor$NbToolbarSupport == null ? (class$org$netbeans$modules$editor$NbToolbarSupport = NbToolbarSupport.class$("org.netbeans.modules.editor.NbToolbarSupport")) : class$org$netbeans$modules$editor$NbToolbarSupport) == null) {
            throw new IllegalStateException();
        }
        jEditorPane.putClientProperty(class$org$netbeans$modules$editor$NbToolbarSupport == null ? (class$org$netbeans$modules$editor$NbToolbarSupport = NbToolbarSupport.class$("org.netbeans.modules.editor.NbToolbarSupport")) : class$org$netbeans$modules$editor$NbToolbarSupport, null);
        jComponent.remove(this.toolbarComponent);
    }

    static /* synthetic */ boolean access$800() {
        return lastToolbarsVisible;
    }

    static /* synthetic */ boolean access$802(boolean bl) {
        lastToolbarsVisible = bl;
        return lastToolbarsVisible;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        checkToolbarsTimer = new Timer(5000, null);
        returnFocusRunnable = new Runnable(){

            public void run() {
                JTextComponent jTextComponent = BaseTextUI.getFocusedComponent();
                if (jTextComponent != null) {
                    ((Component)jTextComponent).requestFocus();
                }
            }
        };
        sharedActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                if (object instanceof Timer) {
                    boolean bl;
                    if (debug) {
                        System.out.println("TIMER fired");
                    }
                    if (bl = NbToolbarSupport.isToolbarsVisible()) {
                        NbToolbarSupport.processAllToolbars(false, false);
                        int n = NbToolbarSupport.releaseExtraUnusedKitSupports();
                        if (debug) {
                            System.out.println("Unused toolbar supports remaining=" + n + ", instanceCount=" + instanceCount + "\nkitSupportRegistry: " + kit2kitSup);
                        }
                        if (n > 0 && !checkToolbarsTimer.isRunning()) {
                            checkToolbarsTimer.restart();
                        }
                    }
                } else {
                    SwingUtilities.invokeLater(returnFocusRunnable);
                }
            }
        };
        sharedMouseListener = new MouseAdapter(){

            public void mouseEntered(MouseEvent mouseEvent) {
                JButton jButton;
                if (mouseEvent.getSource() instanceof JButton && (jButton = (JButton)mouseEvent.getSource()).isEnabled()) {
                    jButton.setBorderPainted(true);
                }
            }

            public void mouseExited(MouseEvent mouseEvent) {
                if (mouseEvent.getSource() instanceof JButton) {
                    ((JButton)mouseEvent.getSource()).setBorderPainted(false);
                }
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent) && mouseEvent.getClickCount() == 1) {
                    JPopupMenu jPopupMenu = new JPopupMenu();
                    JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(LocaleSupport.getString("PROP_base_toolbarVisible"), NbToolbarSupport.isToolbarsVisible());
                    jCheckBoxMenuItem.addActionListener(new ActionListener(this){
                        private final /* synthetic */ 3 this$0;
                        {
                            this.this$0 = var1_1;
                        }

                        public void actionPerformed(ActionEvent actionEvent) {
                            AllOptionsFolder.getDefault().setToolbarVisible(((JCheckBoxMenuItem)actionEvent.getSource()).isSelected());
                        }
                    });
                    jPopupMenu.add(jCheckBoxMenuItem);
                    jPopupMenu.show((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        };
        settingsListener = new SettingsChangeListener(){

            public void settingsChange(SettingsChangeEvent settingsChangeEvent) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 5 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public void run() {
                        boolean bl = NbToolbarSupport.access$100();
                        if (NbToolbarSupport.access$800() != bl) {
                            NbToolbarSupport.access$802(bl);
                            NbToolbarSupport.access$200(NbToolbarSupport.access$800(), true);
                            if (!NbToolbarSupport.access$800()) {
                                NbToolbarSupport.access$500().clear();
                            }
                        }
                    }
                });
            }
        };
        sharedPropertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if ("editorKit".equals(string)) {
                    Object object = propertyChangeEvent.getSource();
                    if (object instanceof JEditorPane) {
                        JEditorPane jEditorPane = (JEditorPane)object;
                        NbToolbarSupport.refreshPaneToolbar(jEditorPane, false, false);
                        NbToolbarSupport.refreshPaneToolbar(jEditorPane, true, false);
                    }
                } else if ("activated".equals(string)) {
                    JComponent jComponent;
                    TopComponent topComponent = (TopComponent)propertyChangeEvent.getNewValue();
                    if (topComponent == null) {
                        TopComponent.getRegistry().getActivated();
                    }
                    if ((jComponent = NbToolbarSupport.getExtComponent(topComponent)) != null) {
                        if (debug) {
                            System.out.println("Attempt to SHOW toolbar for c=" + System.identityHashCode(NbToolbarSupport.getEditorPane(jComponent)));
                        }
                        NbToolbarSupport.refreshToolbar(jComponent, NbToolbarSupport.getEditorPane(jComponent), NbToolbarSupport.isToolbarsVisible(), false);
                        checkToolbarsTimer.restart();
                    }
                } else if ("currentWorkspace".equals(string)) {
                    if (debug) {
                        System.out.println("WORKSPACE changed");
                    }
                    if (NbToolbarSupport.isToolbarsVisible()) {
                        NbToolbarSupport.processAllToolbars(true, false);
                    }
                }
            }
        };
        Settings.addSettingsChangeListener(settingsListener);
        settingsListener.settingsChange(null);
        TopComponent.getRegistry().addPropertyChangeListener(sharedPropertyChangeListener);
        WindowManager.getDefault().addPropertyChangeListener(sharedPropertyChangeListener);
        checkToolbarsTimer.addActionListener(sharedActionListener);
        checkToolbarsTimer.setRepeats(false);
    }

    private static final class SortSupport {
        private Map vert2edges = new HashMap();
        private Set edgesEnds = new HashSet();
        private Set mdfsVisited = new HashSet();
        private List mdfsFinished = new ArrayList();

        SortSupport() {
        }

        void addEdge(Object object, Object object2) {
            if (object == null || object2 == null) {
                throw new IllegalStateException();
            }
            if (object.equals(object2)) {
                return;
            }
            this.edgesEnds.add(object2);
            ArrayList<Object> arrayList = (ArrayList<Object>)this.vert2edges.get(object);
            boolean bl = false;
            if (arrayList == null) {
                arrayList = new ArrayList<Object>(2);
                this.vert2edges.put(object, arrayList);
                bl = true;
            }
            if (arrayList.indexOf(object2) == -1) {
                arrayList.add(object2);
                if (debugSort) {
                    System.out.println("added edge " + object + " -> " + object2);
                }
                if (this.mdfs(object)) {
                    arrayList.remove(arrayList.size() - 1);
                    if (bl) {
                        this.vert2edges.remove(object);
                    }
                    if (debugSort) {
                        System.out.println("REMOVED edge " + object + " -> " + object2);
                    }
                }
            }
        }

        List eliminateMultipleStarts(List list, boolean bl) {
            Object var3_3 = null;
            Object var4_4 = null;
            ArrayList arrayList = bl ? new ArrayList() : null;
            int n = list.size();
            int n2 = 0;
            while (n2 < n) {
                Object e = list.get(n2);
                if (!this.edgesEnds.contains(e)) {
                    if (bl && !this.vert2edges.containsKey(e)) {
                        arrayList.add(e);
                    } else if (var3_3 == null) {
                        var3_3 = e;
                        var4_4 = e;
                    } else {
                        this.addEdge(var4_4, e);
                    }
                }
                ++n2;
            }
            return arrayList;
        }

        List createSortedList() {
            HashSet hashSet = new HashSet(this.vert2edges.keySet());
            hashSet.removeAll(this.edgesEnds);
            Iterator iterator = hashSet.iterator();
            if (!iterator.hasNext()) {
                throw new IllegalStateException("No first item");
            }
            Object e = iterator.next();
            if (iterator.hasNext()) {
                throw new IllegalStateException("More than one start item");
            }
            this.mdfs(e);
            Collections.reverse(this.mdfsFinished);
            return this.mdfsFinished;
        }

        private boolean mdfs(Object object) {
            this.mdfsVisited.clear();
            this.mdfsFinished.clear();
            return this.mdfsRec(object);
        }

        private boolean mdfsRec(Object object) {
            if (this.mdfsVisited.contains(object)) {
                return true;
            }
            this.mdfsVisited.add(object);
            List list = (List)this.vert2edges.get(object);
            if (list != null) {
                int n = list.size();
                int n2 = 0;
                while (n2 < n) {
                    if (this.mdfsRec(list.get(n2))) {
                        return true;
                    }
                    ++n2;
                }
            }
            this.mdfsFinished.add(object);
            return false;
        }

        public String toString() {
            return "edgesEnds=" + this.edgesEnds + "\n\n vert2edges=" + this.vert2edges;
        }
    }

    private static class KitSupport {
        private List unused = new ArrayList();

        KitSupport() {
        }

        synchronized NbToolbarSupport obtainUnused() {
            int n = this.unused.size() - 1;
            if (n >= 0) {
                NbToolbarSupport nbToolbarSupport = (NbToolbarSupport)this.unused.get(n);
                this.unused.remove(n);
                if (debug) {
                    System.out.println("KITSUPPORT: valid unused " + System.identityHashCode(nbToolbarSupport));
                }
                return nbToolbarSupport;
            }
            return null;
        }

        synchronized void release(NbToolbarSupport nbToolbarSupport) {
            if (debug) {
                System.out.println("KITSUPPORT: release " + System.identityHashCode(nbToolbarSupport));
            }
            this.unused.add(nbToolbarSupport);
            if (!checkToolbarsTimer.isRunning()) {
                checkToolbarsTimer.restart();
            }
        }

        synchronized int releaseExtraUnused() {
            int n = this.unused.size();
            if (n <= 1) {
                return 0;
            }
            int n2 = n / 2;
            while (n > n2) {
                this.unused.remove(--n);
            }
            return n2;
        }

        public String toString() {
            return "unused=" + this.unused;
        }
    }
}

