/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.Formatter;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.Completion;
import org.netbeans.editor.ext.CompletionJavaDoc;
import org.netbeans.editor.ext.CompletionQuery;
import org.netbeans.editor.ext.ExtEditorUI;
import org.netbeans.editor.ext.ExtKit;
import org.netbeans.editor.ext.ExtUtilities;
import org.netbeans.editor.ext.java.JCClass;
import org.netbeans.editor.ext.java.JCConstructor;
import org.netbeans.editor.ext.java.JCField;
import org.netbeans.editor.ext.java.JCMethod;
import org.netbeans.editor.ext.java.JCPackage;
import org.netbeans.editor.ext.java.JavaCompletion;
import org.netbeans.editor.ext.java.JavaDrawLayerFactory;
import org.netbeans.editor.ext.java.JavaFormatter;
import org.netbeans.editor.ext.java.JavaSyntax;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.editor.NbEditorKit;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.java.JCStorage;
import org.netbeans.modules.editor.java.JCUpdater;
import org.netbeans.modules.editor.java.NbCompletionJavaDoc;
import org.netbeans.modules.editor.java.NbJavaCompletion;
import org.netbeans.modules.editor.java.NbJavaFastImport;
import org.netbeans.modules.editor.java.NbJavaSyntaxSupport;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SourceCookie;
import org.openide.debugger.Breakpoint;
import org.openide.debugger.Debugger;
import org.openide.debugger.Watch;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.src.ClassElement;
import org.openide.src.SourceElement;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.WeakListener;
import org.openide.windows.TopComponent;

public class JavaKit
extends NbEditorKit {
    public static final String JAVA_MIME_TYPE = "text/x-java";
    private static final String[] getSetIsPrefixes = new String[]{"get", "set", "is"};
    public static final String makeGetterAction = "make-getter";
    public static final String makeSetterAction = "make-setter";
    public static final String makeIsAction = "make-is";
    public static final String addWatchAction = "add-watch";
    public static final String toggleBreakpointAction = "toggle-breakpoint";
    public static final String abbrevDebugLineAction = "abbrev-debug-line";
    public static final String fastImportAction = "fast-import";
    public static final String javaDocShowAction = "javadoc-show-action";
    static final long serialVersionUID = -5445829962533684922L;
    private static DORegistryListener rl;
    static /* synthetic */ Class class$org$openide$windows$TopComponent;

    public JavaKit() {
        this.prepareJCCInit();
        if (rl == null) {
            rl = new DORegistryListener();
            DataObject.getRegistry().addChangeListener(WeakListener.change((ChangeListener)rl, (Object)DataObject.getRegistry()));
        }
    }

    private void prepareJCCInit() {
        CompletionInitializer completionInitializer = new CompletionInitializer();
        JavaCompletion.setFinderInitializer(completionInitializer);
        TopComponent.getRegistry().addPropertyChangeListener((PropertyChangeListener)completionInitializer);
    }

    public String getContentType() {
        return JAVA_MIME_TYPE;
    }

    public Document createDefaultDocument() {
        NbEditorDocument nbEditorDocument = new NbEditorDocument(this.getClass());
        nbEditorDocument.putProperty("write-line-separator", "\n");
        return nbEditorDocument;
    }

    public Syntax createSyntax(Document document) {
        return new JavaSyntax();
    }

    public SyntaxSupport createSyntaxSupport(BaseDocument baseDocument) {
        return new NbJavaSyntaxSupport(baseDocument);
    }

    public Completion createCompletion(ExtEditorUI extEditorUI) {
        return new NbJavaCompletion(extEditorUI);
    }

    public CompletionJavaDoc createCompletionJavaDoc(ExtEditorUI extEditorUI) {
        return new NbCompletionJavaDoc(extEditorUI);
    }

    public Formatter createFormatter() {
        return new JavaFormatter(this.getClass());
    }

    protected void initDocument(BaseDocument baseDocument) {
        baseDocument.addLayer(new JavaDrawLayerFactory.JavaLayer(), 1010);
        baseDocument.addDocumentListener(new JavaDrawLayerFactory.LParenWatcher());
    }

    public Class getFocusableComponentClass(JTextComponent jTextComponent) {
        return class$org$openide$windows$TopComponent == null ? (class$org$openide$windows$TopComponent = JavaKit.class$("org.openide.windows.TopComponent")) : class$org$openide$windows$TopComponent;
    }

    protected Action[] createActions() {
        Action[] actionArray = new Action[]{new JavaDefaultKeyTypedAction(), new JavaGotoHelpAction(), new JavaGotoSourceAction(), new JavaGotoDeclarationAction(), new ExtKit.PrefixMakerAction(makeGetterAction, "get", getSetIsPrefixes), new ExtKit.PrefixMakerAction(makeSetterAction, "set", getSetIsPrefixes), new ExtKit.PrefixMakerAction(makeIsAction, "is", getSetIsPrefixes), new AbbrevDebugLineAction(), new ExtKit.CommentAction("//"), new ExtKit.UncommentAction("//"), new FastImportAction(), new JavaDocShowAction()};
        return TextAction.augmentList(super.createActions(), actionArray);
    }

    static JCClass findResultInnerClass(JCClass jCClass, String string) {
        if (jCClass == null || string == null) {
            return null;
        }
        ClassElement classElement = ClassElement.forName((String)jCClass.getFullName());
        if (classElement == null) {
            return null;
        }
        ClassElement[] classElementArray = classElement.getClasses();
        if (string != null) {
            int n = 0;
            while (n < classElementArray.length) {
                JCClass jCClass2;
                if (string.equals(classElementArray[n].getName().getName()) && (jCClass2 = JavaCompletion.getFinder().getExactClass(classElementArray[n].getName().getFullName())) != null) {
                    return jCClass2;
                }
                ++n;
            }
        }
        return null;
    }

    private static Object findImportedItem(NbJavaSyntaxSupport nbJavaSyntaxSupport, CompletionQuery.Result result) {
        nbJavaSyntaxSupport.refreshJavaImport();
        String string = nbJavaSyntaxSupport.getPackage();
        int n = 0;
        while (n < result.getData().size()) {
            Object e = result.getData().get(n);
            if (e instanceof JCClass) {
                JCClass jCClass = (JCClass)e;
                String string2 = jCClass.getPackageName();
                if (nbJavaSyntaxSupport.isImported(jCClass) || string.equals(string2)) {
                    return result.getData().get(n);
                }
            }
            ++n;
        }
        return null;
    }

    private static Object findResultInnerItem(NbJavaSyntaxSupport nbJavaSyntaxSupport, CompletionQuery.Result result) {
        ClassElement classElement;
        JCClass jCClass = nbJavaSyntaxSupport.getTopClass();
        if (jCClass != null && (classElement = ClassElement.forName((String)jCClass.getFullName())) != null) {
            ClassElement[] classElementArray = classElement.getClasses();
            Object var5_5 = null;
            int n = 0;
            while (n < result.getData().size()) {
                int n2;
                Comparable[] comparableArray;
                JCClass jCClass2;
                JCClass jCClass3;
                Comparable comparable;
                if (result.getData().get(n) instanceof JCClass) {
                    return JavaKit.findResultInnerClass(jCClass, ((JCClass)result.getData().get(n)).getName());
                }
                if (result.getData().get(n) instanceof JCMethod) {
                    comparable = (JCMethod)result.getData().get(n);
                    jCClass3 = comparable.getClazz();
                    if (jCClass3 != null && (jCClass2 = JavaKit.findResultInnerClass(jCClass, jCClass3.getName())) != null) {
                        comparableArray = jCClass2.getMethods();
                        n2 = 0;
                        while (n2 < comparableArray.length) {
                            if (comparableArray[n2].equals(comparable)) {
                                return comparableArray[n2];
                            }
                            ++n2;
                        }
                    }
                } else if (result.getData().get(n) instanceof JCConstructor) {
                    comparable = (JCConstructor)result.getData().get(n);
                    jCClass3 = comparable.getClazz();
                    if (jCClass3 != null && (jCClass2 = JavaKit.findResultInnerClass(jCClass, jCClass3.getName())) != null) {
                        comparableArray = jCClass2.getConstructors();
                        n2 = 0;
                        while (n2 < comparableArray.length) {
                            if (comparableArray[n2].equals(comparable)) {
                                return comparableArray[n2];
                            }
                            ++n2;
                        }
                    }
                } else if (result.getData().get(n) instanceof JCField && (jCClass3 = (comparable = (JCField)result.getData().get(n)).getClazz()) != null && (jCClass2 = JavaKit.findResultInnerClass(jCClass, jCClass3.getName())) != null) {
                    comparableArray = jCClass2.getFields();
                    n2 = 0;
                    while (n2 < comparableArray.length) {
                        if (comparableArray[n2].equals(comparable)) {
                            return comparableArray[n2];
                        }
                        ++n2;
                    }
                }
                ++n;
            }
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class DORegistryListener
    implements ChangeListener {
        private Vector unsavedSources = new Vector(5);
        static /* synthetic */ Class class$org$openide$cookies$SourceCookie;

        public void stateChanged(ChangeEvent changeEvent) {
            DataObject[] dataObjectArray = DataObject.getRegistry().getModified();
            Vector<DataObject> vector = new Vector<DataObject>(5);
            int n = 0;
            while (n < dataObjectArray.length) {
                SourceCookie sourceCookie = (SourceCookie)dataObjectArray[n].getCookie(class$org$openide$cookies$SourceCookie == null ? DORegistryListener.class$("org.openide.cookies.SourceCookie") : class$org$openide$cookies$SourceCookie);
                if (sourceCookie != null) {
                    if (!this.unsavedSources.contains(dataObjectArray[n])) {
                        this.unsavedSources.add(dataObjectArray[n]);
                    }
                    vector.add(dataObjectArray[n]);
                }
                ++n;
            }
            this.addSavedSourcesToParserDB(this.getSavedSources(vector));
        }

        private void addSavedSourcesToParserDB(final DataObject[] dataObjectArray) {
            if (dataObjectArray.length <= 0) {
                return;
            }
            final JCUpdater jCUpdater = new JCUpdater();
            RequestProcessor.postRequest((Runnable)new Runnable(){
                static /* synthetic */ Class class$org$openide$cookies$SourceCookie;

                private void updateParserDB(SourceElement sourceElement, DataObject dataObject) {
                    Node node;
                    if (sourceElement.getStatus() != 3) {
                        return;
                    }
                    if (dataObject.isValid() && (node = dataObject.getNodeDelegate()) != null) {
                        jCUpdater.processNode(node, null);
                    }
                }

                public void run() {
                    int n = 0;
                    while (n < dataObjectArray.length) {
                        if (dataObjectArray[n].isValid()) {
                            SourceCookie sourceCookie = (SourceCookie)dataObjectArray[n].getCookie(class$org$openide$cookies$SourceCookie == null ? 1.class$("org.openide.cookies.SourceCookie") : class$org$openide$cookies$SourceCookie);
                            SourceElement sourceElement = sourceCookie.getSource();
                            DataObject dataObject = dataObjectArray[n];
                            Task task = sourceElement.prepare();
                            if (task.isFinished()) {
                                this.updateParserDB(sourceElement, dataObject);
                            } else {
                                task.addTaskListener(new TaskListener(this, sourceElement, dataObject){
                                    private final /* synthetic */ SourceElement val$se;
                                    private final /* synthetic */ DataObject val$savedSource;
                                    private final /* synthetic */ 1 this$2;
                                    {
                                        this.this$2 = var1_1;
                                        this.val$se = sourceElement;
                                        this.val$savedSource = dataObject;
                                    }

                                    public void taskFinished(Task task) {
                                        task.removeTaskListener((TaskListener)this);
                                        1.access$300(this.this$2, this.val$se, this.val$savedSource);
                                    }
                                });
                            }
                        }
                        ++n;
                    }
                }

                static /* synthetic */ Class class$(String string) {
                    try {
                        return Class.forName(string);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }

                static /* synthetic */ void access$300(1 var0, SourceElement sourceElement, DataObject dataObject) {
                    var0.updateParserDB(sourceElement, dataObject);
                }
            }, (int)0, (int)1);
        }

        private DataObject[] getSavedSources(Vector vector) {
            Vector vector2 = new Vector(5);
            int n = 0;
            while (n < this.unsavedSources.size()) {
                if (!vector.contains(this.unsavedSources.get(n))) {
                    vector2.add(this.unsavedSources.get(n));
                }
                ++n;
            }
            int n2 = 0;
            while (n2 < vector2.size()) {
                this.unsavedSources.remove(vector2.get(n2));
                ++n2;
            }
            DataObject[] dataObjectArray = new DataObject[vector2.size()];
            vector2.toArray(dataObjectArray);
            return dataObjectArray;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    public static class FastImportAction
    extends BaseAction {
        public FastImportAction() {
            super(JavaKit.fastImportAction);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                new NbJavaFastImport(jTextComponent).setDialogVisible(true);
            }
        }
    }

    public static class AbbrevDebugLineAction
    extends BaseAction {
        public AbbrevDebugLineAction() {
            super(JavaKit.abbrevDebugLineAction);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
                BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                StringBuffer stringBuffer = new StringBuffer("System.out.println(\"");
                String string = (String)baseDocument.getProperty("title");
                if (string != null) {
                    stringBuffer.append(string);
                    stringBuffer.append(':');
                }
                try {
                    stringBuffer.append(Utilities.getLineOffset(baseDocument, jTextComponent.getCaret().getDot()) + 1);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                stringBuffer.append(' ');
                BaseKit baseKit = Utilities.getKit(jTextComponent);
                Action action = baseKit.getActionByName("insert-content");
                if (action != null) {
                    Utilities.performAction(action, new ActionEvent(jTextComponent, 1001, stringBuffer.toString()), jTextComponent);
                }
            }
        }
    }

    public static class JavaGotoHelpAction
    extends BaseAction {
        static /* synthetic */ Class class$org$netbeans$modules$editor$java$JavaKit$JavaGotoHelpAction;
        static /* synthetic */ Class class$org$netbeans$modules$editor$java$JavaKit;
        static /* synthetic */ Class class$org$netbeans$modules$editor$java$NbJavaSyntaxSupport;

        public JavaGotoHelpAction() {
            super("goto-help", 128);
            this.putValue("helpID", (class$org$netbeans$modules$editor$java$JavaKit$JavaGotoHelpAction == null ? (class$org$netbeans$modules$editor$java$JavaKit$JavaGotoHelpAction = JavaGotoHelpAction.class$("org.netbeans.modules.editor.java.JavaKit$JavaGotoHelpAction")) : class$org$netbeans$modules$editor$java$JavaKit$JavaGotoHelpAction).getName());
            this.putValue("ShortDescription", NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$java$JavaKit == null ? (class$org$netbeans$modules$editor$java$JavaKit = JavaGotoHelpAction.class$("org.netbeans.modules.editor.java.JavaKit")) : class$org$netbeans$modules$editor$java$JavaKit)).getString("java-desc-goto-help"));
        }

        public URL[] getJavaDocURLs(JTextComponent jTextComponent) {
            Completion completion = ExtUtilities.getCompletion(jTextComponent);
            SyntaxSupport syntaxSupport = Utilities.getSyntaxSupport(jTextComponent);
            NbJavaSyntaxSupport nbJavaSyntaxSupport = (NbJavaSyntaxSupport)syntaxSupport.get(class$org$netbeans$modules$editor$java$NbJavaSyntaxSupport == null ? (class$org$netbeans$modules$editor$java$NbJavaSyntaxSupport = JavaGotoHelpAction.class$("org.netbeans.modules.editor.java.NbJavaSyntaxSupport")) : class$org$netbeans$modules$editor$java$NbJavaSyntaxSupport);
            if (completion != null) {
                if (completion.isPaneVisible()) {
                    Object object = completion.getSelectedValue();
                    if (object != null) {
                        return nbJavaSyntaxSupport.getJavaDocURLs(object);
                    }
                } else {
                    int n = jTextComponent.getCaret().getDot();
                    BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                    try {
                        int[] nArray = NbEditorUtilities.getIdentifierAndMethodBlock(baseDocument, n);
                        if (nArray == null) {
                            nArray = new int[]{n, n};
                        }
                        int n2 = nArray.length - 1;
                        while (n2 >= 1) {
                            CompletionQuery.Result result = completion.getQuery().query(jTextComponent, nArray[n2], nbJavaSyntaxSupport);
                            if (result != null && result.getData().size() > 0) {
                                if (result.getData().size() > 1) {
                                    Object object = JavaKit.findResultInnerItem(nbJavaSyntaxSupport, result);
                                    if (object != null) {
                                        return nbJavaSyntaxSupport.getJavaDocURLs(object);
                                    }
                                    Object object2 = JavaKit.findImportedItem(nbJavaSyntaxSupport, result);
                                    if (object2 != null) {
                                        return nbJavaSyntaxSupport.getJavaDocURLs(object2);
                                    }
                                }
                                return nbJavaSyntaxSupport.getJavaDocURLs(result.getData().get(0));
                            }
                            --n2;
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }
            return null;
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                URL[] uRLArray = this.getJavaDocURLs(jTextComponent);
                if (uRLArray != null && uRLArray.length > 0) {
                    TopManager topManager = NbEditorUtilities.getTopManager();
                    if (topManager != null) {
                        topManager.showUrl(uRLArray[0]);
                    }
                } else {
                    Utilities.setStatusText(jTextComponent, NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$java$JavaKit == null ? (class$org$netbeans$modules$editor$java$JavaKit = JavaGotoHelpAction.class$("org.netbeans.modules.editor.java.JavaKit")) : class$org$netbeans$modules$editor$java$JavaKit)).getString("cannot_find_javadoc"));
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        }

        public String getPopupMenuText(JTextComponent jTextComponent) {
            return NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$java$JavaKit == null ? (class$org$netbeans$modules$editor$java$JavaKit = JavaGotoHelpAction.class$("org.netbeans.modules.editor.java.JavaKit")) : class$org$netbeans$modules$editor$java$JavaKit)).getString("show_javadoc");
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    public static class JavaDocShowAction
    extends BaseAction {
        static /* synthetic */ Class class$org$netbeans$modules$editor$java$JavaKit$JavaDocShowAction;
        static /* synthetic */ Class class$org$netbeans$modules$editor$java$NbJavaSyntaxSupport;

        public JavaDocShowAction() {
            super(JavaKit.javaDocShowAction);
            this.putValue("helpID", (class$org$netbeans$modules$editor$java$JavaKit$JavaDocShowAction == null ? (class$org$netbeans$modules$editor$java$JavaKit$JavaDocShowAction = JavaDocShowAction.class$("org.netbeans.modules.editor.java.JavaKit$JavaDocShowAction")) : class$org$netbeans$modules$editor$java$JavaKit$JavaDocShowAction).getName());
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                Object object = this.getMember(jTextComponent);
                CompletionJavaDoc completionJavaDoc = ExtUtilities.getCompletionJavaDoc(jTextComponent);
                if (completionJavaDoc != null) {
                    completionJavaDoc.setContent(object);
                    completionJavaDoc.addToHistory(object);
                }
            }
        }

        private int findEndOfMethod(JTextComponent jTextComponent, int n) {
            try {
                int n2 = 0;
                BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                int n3 = n;
                while (n3 < jTextComponent.getDocument().getLength()) {
                    char c = baseDocument.getChars(n3, 1)[0];
                    if (c == ';') {
                        return -1;
                    }
                    if (c == '(') {
                        ++n2;
                    }
                    if (c == ')') {
                        if (n2 == 0) {
                            return n3 + 1;
                        }
                        --n2;
                    }
                    ++n3;
                }
                return -1;
            }
            catch (BadLocationException badLocationException) {
                return -1;
            }
        }

        public Object getMember(JTextComponent jTextComponent) {
            Object object = null;
            Completion completion = ExtUtilities.getCompletion(jTextComponent);
            SyntaxSupport syntaxSupport = Utilities.getSyntaxSupport(jTextComponent);
            NbJavaSyntaxSupport nbJavaSyntaxSupport = (NbJavaSyntaxSupport)syntaxSupport.get(class$org$netbeans$modules$editor$java$NbJavaSyntaxSupport == null ? (class$org$netbeans$modules$editor$java$NbJavaSyntaxSupport = JavaDocShowAction.class$("org.netbeans.modules.editor.java.NbJavaSyntaxSupport")) : class$org$netbeans$modules$editor$java$NbJavaSyntaxSupport);
            if (completion != null) {
                if (completion.isPaneVisible()) {
                    object = completion.getSelectedValue();
                    if (object != null) {
                        return object;
                    }
                } else {
                    try {
                        int n = jTextComponent.getCaret().getDot();
                        BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                        int[] nArray = NbEditorUtilities.getIdentifierAndMethodBlock(baseDocument, n);
                        if (nArray == null || n > 0 && baseDocument.getChars(n - 1, 1)[0] == '(' && n == nArray[0]) {
                            nArray = new int[]{n, n};
                        }
                        int n2 = nArray.length - 1;
                        while (n2 >= 1) {
                            CompletionQuery.Result result = completion.getQuery().query(jTextComponent, nArray[n2], syntaxSupport);
                            if (result != null && result.getData().size() > 0) {
                                Object object2;
                                int n3;
                                Object e = result.getData().get(0);
                                if ((e instanceof JCConstructor || e instanceof JCMethod) && result.getData().size() > 1 && (n3 = this.findEndOfMethod(jTextComponent, nArray[n2])) > -1 && (object2 = completion.getQuery().query(jTextComponent, n3, syntaxSupport)) != null && object2.getData().size() > 0) {
                                    return object2.getData().get(0);
                                }
                                Object object3 = JavaKit.findResultInnerItem(nbJavaSyntaxSupport, result);
                                if (object3 != null) {
                                    return object3;
                                }
                                object2 = JavaKit.findImportedItem(nbJavaSyntaxSupport, result);
                                return object2 != null ? object2 : result.getData().get(0);
                            }
                            --n2;
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }
            return null;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    public static class JavaGotoSourceAction
    extends BaseAction {
        static /* synthetic */ Class class$org$netbeans$modules$editor$java$JavaKit$JavaGotoSourceAction;
        static /* synthetic */ Class class$org$netbeans$modules$editor$java$NbJavaSyntaxSupport;
        static /* synthetic */ Class class$org$netbeans$modules$editor$java$JavaKit;

        public JavaGotoSourceAction() {
            super("goto-source", 128);
            this.putValue("helpID", (class$org$netbeans$modules$editor$java$JavaKit$JavaGotoSourceAction == null ? (class$org$netbeans$modules$editor$java$JavaKit$JavaGotoSourceAction = JavaGotoSourceAction.class$("org.netbeans.modules.editor.java.JavaKit$JavaGotoSourceAction")) : class$org$netbeans$modules$editor$java$JavaKit$JavaGotoSourceAction).getName());
            this.putValue("IconResource", "org/netbeans/modules/editor/resources/gotosource");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            TopManager topManager;
            String string;
            if (jTextComponent != null && (string = this.openSource(jTextComponent, false)) != null && (topManager = NbEditorUtilities.getTopManager()) != null) {
                topManager.notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string));
            }
        }

        private int findEndOfMethod(JTextComponent jTextComponent, int n) {
            try {
                int n2 = 0;
                BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                int n3 = n;
                while (n3 < jTextComponent.getDocument().getLength()) {
                    char c = baseDocument.getChars(n3, 1)[0];
                    if (c == ';') {
                        return -1;
                    }
                    if (c == '(') {
                        ++n2;
                    }
                    if (c == ')') {
                        if (n2 == 0) {
                            return n3 + 1;
                        }
                        --n2;
                    }
                    ++n3;
                }
                return -1;
            }
            catch (BadLocationException badLocationException) {
                return -1;
            }
        }

        public String openSource(JTextComponent jTextComponent, boolean bl) {
            Object object = null;
            String string = null;
            Completion completion = ExtUtilities.getCompletion(jTextComponent);
            SyntaxSupport syntaxSupport = Utilities.getSyntaxSupport(jTextComponent);
            NbJavaSyntaxSupport nbJavaSyntaxSupport = (NbJavaSyntaxSupport)syntaxSupport.get(class$org$netbeans$modules$editor$java$NbJavaSyntaxSupport == null ? (class$org$netbeans$modules$editor$java$NbJavaSyntaxSupport = JavaGotoSourceAction.class$("org.netbeans.modules.editor.java.NbJavaSyntaxSupport")) : class$org$netbeans$modules$editor$java$NbJavaSyntaxSupport);
            if (completion != null) {
                if (completion.isPaneVisible()) {
                    object = completion.getSelectedValue();
                    if (object != null) {
                        string = nbJavaSyntaxSupport.openSource(object, false, bl);
                    }
                } else {
                    try {
                        int n = jTextComponent.getCaret().getDot();
                        BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                        int[] nArray = NbEditorUtilities.getIdentifierAndMethodBlock(baseDocument, n);
                        if (nArray == null || n > 0 && baseDocument.getChars(n - 1, 1)[0] == '(' && n == nArray[0]) {
                            nArray = new int[]{n, n};
                        }
                        int n2 = nArray.length - 1;
                        while (n2 >= 1) {
                            CompletionQuery.Result result = completion.getQuery().query(jTextComponent, nArray[n2], nbJavaSyntaxSupport);
                            if (result != null && result.getData().size() > 0) {
                                Object object2;
                                int n3;
                                Object e = result.getData().get(0);
                                if ((e instanceof JCConstructor || e instanceof JCMethod) && result.getData().size() > 1 && (n3 = this.findEndOfMethod(jTextComponent, nArray[n2])) > -1 && (object2 = completion.getQuery().query(jTextComponent, n3, nbJavaSyntaxSupport)) != null && object2.getData().size() > 0) {
                                    string = nbJavaSyntaxSupport.openSource(object2.getData().get(0), false, bl);
                                    break;
                                }
                                nbJavaSyntaxSupport.refreshJavaImport();
                                Object object3 = JavaKit.findResultInnerItem(nbJavaSyntaxSupport, result);
                                if (object3 != null) {
                                    string = nbJavaSyntaxSupport.openSource(object3, false, bl);
                                    break;
                                }
                                object2 = JavaKit.findImportedItem(nbJavaSyntaxSupport, result);
                                string = object2 != null ? nbJavaSyntaxSupport.openSource(object2, false, bl) : nbJavaSyntaxSupport.openSource(result.getData().get(0), false, bl);
                            }
                            --n2;
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }
            String string2 = null;
            if (string != null) {
                boolean bl2 = object instanceof JCPackage;
                string2 = NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$java$JavaKit == null ? (class$org$netbeans$modules$editor$java$JavaKit = JavaGotoSourceAction.class$("org.netbeans.modules.editor.java.JavaKit")) : class$org$netbeans$modules$editor$java$JavaKit)).getString(bl ? (bl2 ? "goto_source_explore_package" : "goto_source_open_source") : (bl2 ? "goto_source_package_not_found" : "goto_source_source_not_found"));
                string2 = MessageFormat.format(string2, string);
            }
            return string2;
        }

        public String getPopupMenuText(JTextComponent jTextComponent) {
            return this.openSource(jTextComponent, true);
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    public static class JavaGotoDeclarationAction
    extends ExtKit.GotoDeclarationAction {
        static /* synthetic */ Class class$org$netbeans$modules$editor$java$JavaKit$JavaGotoDeclarationAction;
        static /* synthetic */ Class class$org$netbeans$modules$editor$java$NbJavaSyntaxSupport;

        public JavaGotoDeclarationAction() {
            this.putValue("helpID", (class$org$netbeans$modules$editor$java$JavaKit$JavaGotoDeclarationAction == null ? (class$org$netbeans$modules$editor$java$JavaKit$JavaGotoDeclarationAction = JavaGotoDeclarationAction.class$("org.netbeans.modules.editor.java.JavaKit$JavaGotoDeclarationAction")) : class$org$netbeans$modules$editor$java$JavaKit$JavaGotoDeclarationAction).getName());
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            block13: {
                if (jTextComponent != null) {
                    Completion completion = ExtUtilities.getCompletion(jTextComponent);
                    SyntaxSupport syntaxSupport = Utilities.getSyntaxSupport(jTextComponent);
                    NbJavaSyntaxSupport nbJavaSyntaxSupport = (NbJavaSyntaxSupport)syntaxSupport.get(class$org$netbeans$modules$editor$java$NbJavaSyntaxSupport == null ? (class$org$netbeans$modules$editor$java$NbJavaSyntaxSupport = JavaGotoDeclarationAction.class$("org.netbeans.modules.editor.java.NbJavaSyntaxSupport")) : class$org$netbeans$modules$editor$java$NbJavaSyntaxSupport);
                    if (completion != null) {
                        if (completion.isPaneVisible()) {
                            Object object = completion.getSelectedValue();
                            if (object != null) {
                                nbJavaSyntaxSupport.openSource(object, true, false);
                            }
                        } else {
                            boolean bl = false;
                            int n = jTextComponent.getCaret().getDot();
                            BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                            try {
                                int n2;
                                int[] nArray = NbEditorUtilities.getIdentifierAndMethodBlock(baseDocument, n);
                                if (nArray != null && nArray.length == 2 && ((n2 = Utilities.getFirstNonWhiteBwd(baseDocument, nArray[0])) < 0 || baseDocument.getChars(n2, 1)[0] != '.')) {
                                    bl = this.gotoDeclaration(jTextComponent);
                                }
                                if (bl) break block13;
                                if (nArray == null) {
                                    nArray = new int[]{n, n};
                                }
                                n2 = nArray.length - 1;
                                while (n2 >= 1) {
                                    CompletionQuery.Result result = completion.getQuery().query(jTextComponent, nArray[n2], nbJavaSyntaxSupport);
                                    if (result != null && result.getData().size() > 0) {
                                        Object object = JavaKit.findResultInnerItem(nbJavaSyntaxSupport, result);
                                        if (object != null) {
                                            nbJavaSyntaxSupport.openSource(object, true, false);
                                        } else {
                                            nbJavaSyntaxSupport.openSource(result.getData().get(0), true, false);
                                        }
                                        break;
                                    }
                                    --n2;
                                }
                            }
                            catch (BadLocationException badLocationException) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    public static class ToggleBreakpointAction
    extends BaseAction {
        static /* synthetic */ Class class$org$netbeans$modules$editor$java$JavaKit$ToggleBreakpointAction;

        public ToggleBreakpointAction() {
            super(JavaKit.toggleBreakpointAction);
            this.putValue("helpID", (class$org$netbeans$modules$editor$java$JavaKit$ToggleBreakpointAction == null ? (class$org$netbeans$modules$editor$java$JavaKit$ToggleBreakpointAction = ToggleBreakpointAction.class$("org.netbeans.modules.editor.java.JavaKit$ToggleBreakpointAction")) : class$org$netbeans$modules$editor$java$JavaKit$ToggleBreakpointAction).getName());
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                int n;
                NbJavaSyntaxSupport nbJavaSyntaxSupport = (NbJavaSyntaxSupport)Utilities.getSyntaxSupport(jTextComponent);
                Breakpoint breakpoint = nbJavaSyntaxSupport.getBreakpoint(n = jTextComponent.getCaret().getDot());
                if (breakpoint == null) {
                    nbJavaSyntaxSupport.createBreakpoint(n);
                } else {
                    breakpoint.remove();
                }
            }
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    public static class JavaBuildToolTipAction
    extends ExtKit.BuildToolTipAction {
        static final long serialVersionUID = -2009277037915948909L;

        protected String buildText(JTextComponent jTextComponent) {
            Watch watch;
            String string;
            int n;
            String string2 = null;
            NbJavaSyntaxSupport nbJavaSyntaxSupport = (NbJavaSyntaxSupport)Utilities.getSyntaxSupport(jTextComponent);
            Debugger debugger = nbJavaSyntaxSupport.getDebugger();
            if (debugger != null && ((n = debugger.getState()) == 3 || n == 4) && (string = ExtUtilities.getExtEditorUI(jTextComponent).getToolTipSupport().getIdentifierUnderCursor()) != null && (watch = debugger.createWatch(string, true)) != null) {
                String string3 = watch.getAsText();
                if (string3 != null && !string3.trim().equals(string.trim())) {
                    string2 = string + '=' + string3;
                }
                watch.remove();
            }
            return string2;
        }
    }

    public static class JavaDefaultKeyTypedAction
    extends ExtKit.ExtDefaultKeyTypedAction {
    }

    private static class CompletionInitializer
    implements JavaCompletion.JCFinderInitializer,
    PropertyChangeListener,
    Runnable {
        static /* synthetic */ Class class$org$openide$cookies$EditorCookie;

        private CompletionInitializer() {
        }

        public void initJCFinder() {
            JCStorage.getStorage();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("activatedNodes".equals(propertyChangeEvent.getPropertyName())) {
                Node[] nodeArray = TopComponent.getRegistry().getActivatedNodes();
                if (nodeArray == null || nodeArray.length == 0) {
                    return;
                }
                EditorCookie editorCookie = (EditorCookie)nodeArray[0].getCookie(class$org$openide$cookies$EditorCookie == null ? (class$org$openide$cookies$EditorCookie = CompletionInitializer.class$("org.openide.cookies.EditorCookie")) : class$org$openide$cookies$EditorCookie);
                if (editorCookie == null) {
                    return;
                }
                JEditorPane[] jEditorPaneArray = editorCookie.getOpenedPanes();
                if (jEditorPaneArray == null || jEditorPaneArray.length == 0 || !jEditorPaneArray[0].hasFocus()) {
                    return;
                }
                EditorKit editorKit = jEditorPaneArray[0].getEditorKit();
                if (!(editorKit instanceof JavaKit)) {
                    return;
                }
                TopComponent.getRegistry().removePropertyChangeListener((PropertyChangeListener)this);
                RequestProcessor.postRequest((Runnable)this);
            }
        }

        public void run() {
            JCStorage.getStorage();
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

