/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.DocumentEvent;
import javax.swing.text.Element;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.ext.java.JCClass;
import org.netbeans.editor.ext.java.JCConstructor;
import org.netbeans.editor.ext.java.JCField;
import org.netbeans.editor.ext.java.JCFinder;
import org.netbeans.editor.ext.java.JCMethod;
import org.netbeans.editor.ext.java.JCPackage;
import org.netbeans.editor.ext.java.JCParameter;
import org.netbeans.editor.ext.java.JCType;
import org.netbeans.editor.ext.java.JavaCompletion;
import org.netbeans.editor.ext.java.JavaSyntaxSupport;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.java.JCExtension;
import org.netbeans.modules.editor.java.JavaKit;
import org.openide.TopManager;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.SourceCookie;
import org.openide.debugger.Breakpoint;
import org.openide.debugger.Debugger;
import org.openide.debugger.DebuggerNotFoundException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileSystemCapability;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.src.ClassElement;
import org.openide.src.FieldElement;
import org.openide.src.Identifier;
import org.openide.src.InitializerElement;
import org.openide.src.MemberElement;
import org.openide.src.MethodElement;
import org.openide.src.SourceElement;
import org.openide.text.Line;
import org.openide.util.Task;
import org.openide.util.TaskListener;

public class NbJavaSyntaxSupport
extends JavaSyntaxSupport {
    private static final String PACKAGE_SUMMARY = "package-summary";
    private HashMap jcLookupCache = new HashMap(307);
    protected boolean jcValid;
    static /* synthetic */ Class class$org$openide$cookies$SourceCookie$Editor;
    static /* synthetic */ Class class$org$openide$cookies$SourceCookie;
    static /* synthetic */ Class class$org$openide$loaders$DataFolder;

    public NbJavaSyntaxSupport(BaseDocument baseDocument) {
        super(baseDocument);
    }

    protected void documentModified(DocumentEvent documentEvent) {
        super.documentModified(documentEvent);
        this.jcValid = false;
    }

    protected int getMethodStartPosition(int n) {
        DataObject dataObject = NbEditorUtilities.getDataObject(this.getDocument());
        if (dataObject != null) {
            try {
                Element element;
                org.openide.src.Element element2;
                SourceCookie.Editor editor = (SourceCookie.Editor)dataObject.getCookie(class$org$openide$cookies$SourceCookie$Editor == null ? (class$org$openide$cookies$SourceCookie$Editor = NbJavaSyntaxSupport.class$("org.openide.cookies.SourceCookie$Editor")) : class$org$openide$cookies$SourceCookie$Editor);
                if (editor != null && (element2 = editor.findElement(n)) != null && (element = editor.sourceToText(element2)) != null) {
                    return element.getStartOffset();
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return 0;
    }

    private boolean isMounted(String string, String string2) {
        Enumeration enumeration = TopManager.getDefault().getRepository().getFileSystems();
        while (enumeration.hasMoreElements()) {
            FileSystem fileSystem = (FileSystem)enumeration.nextElement();
            FileObject fileObject = fileSystem.find(string, string2, "class");
            if (fileObject == null) {
                fileObject = fileSystem.find(string, string2, "java");
            }
            if (fileObject == null) continue;
            return true;
        }
        return false;
    }

    protected boolean isUnknownImport(String string) {
        boolean bl = super.isUnknownImport(string);
        if (bl) {
            return bl;
        }
        List list = this.getUnknownImports();
        int n = 0;
        while (n < list.size()) {
            String string2 = (String)list.get(n);
            if (string2.endsWith("*") && string2.length() > 2) {
                string2 = string2.substring(0, string2.length() - 2);
                JCClass jCClass = JavaCompletion.getFinder().getExactClass(string2 + "." + string);
                if (this.isMounted(string2, string) && jCClass == null) {
                    return true;
                }
            }
            ++n;
        }
        return bl;
    }

    public int findGlobalDeclarationPosition(String string, int n) {
        org.openide.src.Element element = this.getElementAtPos(n);
        if (element instanceof MemberElement) {
            MemberElement memberElement = (MemberElement)element;
            while (memberElement != null) {
                ClassElement classElement;
                FieldElement[] fieldElementArray;
                if (memberElement instanceof ClassElement && (fieldElementArray = (classElement = (ClassElement)memberElement).getFields()) != null) {
                    int n2 = 0;
                    while (n2 < fieldElementArray.length) {
                        Element element2;
                        SourceCookie.Editor editor;
                        DataObject dataObject;
                        if (fieldElementArray[n2].getName().getFullName().equals(string) && (dataObject = NbEditorUtilities.getDataObject(this.getDocument())) != null && (editor = (SourceCookie.Editor)dataObject.getCookie(class$org$openide$cookies$SourceCookie$Editor == null ? NbJavaSyntaxSupport.class$("org.openide.cookies.SourceCookie$Editor") : class$org$openide$cookies$SourceCookie$Editor)) != null && (element2 = editor.sourceToText((org.openide.src.Element)fieldElementArray[n2])) != null) {
                            return element2.getStartOffset();
                        }
                        ++n2;
                    }
                }
                memberElement = memberElement.getDeclaringClass();
            }
        }
        return -1;
    }

    private org.openide.src.Element getElementAtPos(int n) {
        SourceCookie.Editor editor;
        DataObject dataObject = NbEditorUtilities.getDataObject(this.getDocument());
        if (dataObject != null && (editor = (SourceCookie.Editor)dataObject.getCookie(class$org$openide$cookies$SourceCookie$Editor == null ? (class$org$openide$cookies$SourceCookie$Editor = NbJavaSyntaxSupport.class$("org.openide.cookies.SourceCookie$Editor")) : class$org$openide$cookies$SourceCookie$Editor)) != null) {
            return editor.findElement(n);
        }
        return null;
    }

    private ClassElement getClassElement(int n) {
        ClassElement classElement = null;
        org.openide.src.Element element = this.getElementAtPos(n);
        if (element instanceof ClassElement) {
            classElement = (ClassElement)element;
        } else if (element instanceof MemberElement) {
            classElement = ((MemberElement)element).getDeclaringClass();
        } else if (element instanceof InitializerElement) {
            classElement = ((InitializerElement)element).getDeclaringClass();
        }
        return classElement;
    }

    public JCClass getTopClass() {
        DataObject dataObject = NbEditorUtilities.getDataObject(this.getDocument());
        if (dataObject != null) {
            String string = dataObject.getPrimaryFile().getPackageName('.');
            return JavaCompletion.getFinder().getExactClass(string);
        }
        return null;
    }

    public JCClass getClassFromName(String string, boolean bl) {
        JCClass jCClass = JavaKit.findResultInnerClass(this.getTopClass(), string);
        return jCClass != null ? jCClass : super.getClassFromName(string, bl);
    }

    public String getPackage() {
        Identifier identifier;
        SourceElement sourceElement;
        SourceCookie sourceCookie;
        DataObject dataObject = NbEditorUtilities.getDataObject(this.getDocument());
        if (dataObject != null && (sourceCookie = (SourceCookie)dataObject.getCookie(class$org$openide$cookies$SourceCookie == null ? (class$org$openide$cookies$SourceCookie = NbJavaSyntaxSupport.class$("org.openide.cookies.SourceCookie")) : class$org$openide$cookies$SourceCookie)) != null && (sourceElement = sourceCookie.getSource()) != null && (identifier = sourceElement.getPackage()) != null) {
            return identifier.getFullName();
        }
        return "";
    }

    public JCClass getClass(int n) {
        ClassElement classElement = this.getClassElement(n);
        if (classElement != null) {
            return JavaCompletion.getFinder().getExactClass(classElement.getName().getFullName());
        }
        return null;
    }

    public boolean isStaticBlock(int n) {
        org.openide.src.Element element = this.getElementAtPos(n);
        if (element instanceof MethodElement) {
            return (((MethodElement)element).getModifiers() & 8) != 0;
        }
        if (element instanceof FieldElement) {
            return (((FieldElement)element).getModifiers() & 8) != 0;
        }
        return element instanceof InitializerElement;
    }

    private ClassElement[] getAllClassElements() {
        SourceElement sourceElement;
        SourceCookie sourceCookie;
        DataObject dataObject = NbEditorUtilities.getDataObject(this.getDocument());
        if (dataObject != null && (sourceCookie = (SourceCookie)dataObject.getCookie(class$org$openide$cookies$SourceCookie == null ? (class$org$openide$cookies$SourceCookie = NbJavaSyntaxSupport.class$("org.openide.cookies.SourceCookie")) : class$org$openide$cookies$SourceCookie)) != null && (sourceElement = sourceCookie.getSource()) != null) {
            return sourceElement.getAllClasses();
        }
        return null;
    }

    public boolean isPrepared() {
        SourceElement sourceElement;
        SourceCookie sourceCookie;
        DataObject dataObject = NbEditorUtilities.getDataObject(this.getDocument());
        return dataObject == null || (sourceCookie = (SourceCookie)dataObject.getCookie(class$org$openide$cookies$SourceCookie == null ? (class$org$openide$cookies$SourceCookie = NbJavaSyntaxSupport.class$("org.openide.cookies.SourceCookie")) : class$org$openide$cookies$SourceCookie)) == null || (sourceElement = sourceCookie.getSource()) == null || sourceElement.getStatus() != 0 && sourceElement.getStatus() != 1;
    }

    private void performRefresh() {
        JCFinder jCFinder = JavaCompletion.getFinder();
        ClassElement[] classElementArray = this.getAllClassElements();
        if (classElementArray != null) {
            int n = 0;
            while (n < classElementArray.length) {
                JCClass jCClass = JCExtension.parseClassElement(classElementArray[n], 0, 0, 0, this.jcLookupCache, true);
                if (jCClass != null) {
                    jCFinder.append(new JavaCompletion.SingleProvider(jCClass));
                    this.refreshParents(jCClass);
                }
                ++n;
            }
        }
        this.jcValid = true;
    }

    public void refreshClassInfo() {
        if (!this.jcValid) {
            DataObject dataObject = NbEditorUtilities.getDataObject(this.getDocument());
            if (dataObject == null) {
                return;
            }
            SourceCookie sourceCookie = (SourceCookie)dataObject.getCookie(class$org$openide$cookies$SourceCookie == null ? (class$org$openide$cookies$SourceCookie = NbJavaSyntaxSupport.class$("org.openide.cookies.SourceCookie")) : class$org$openide$cookies$SourceCookie);
            if (sourceCookie == null) {
                return;
            }
            SourceElement sourceElement = sourceCookie.getSource();
            Task task = sourceElement.prepare();
            if (task.isFinished()) {
                this.performRefresh();
            } else {
                task.addTaskListener(new TaskListener(){

                    public void taskFinished(Task task) {
                        task.removeTaskListener((TaskListener)this);
                        NbJavaSyntaxSupport.this.performRefresh();
                    }
                });
            }
        }
    }

    private void refreshParents(JCClass jCClass) {
        JCFinder jCFinder = JavaCompletion.getFinder();
        ArrayList<JCClass> arrayList = new ArrayList<JCClass>();
        arrayList.add(jCClass);
        while ((jCClass = jCClass.getSuperclass()) != null && !jCClass.equals(JavaCompletion.INVALID_CLASS) && arrayList.indexOf(jCClass) < 0) {
            JCClass jCClass2 = jCFinder.getExactClass(jCClass.getFullName());
            if (jCClass2 == null) {
                ClassElement classElement = ClassElement.forName((String)jCClass.getFullName());
                if (classElement != null) {
                    jCClass2 = JCExtension.parseClassElement(classElement, 0, 0, 0, this.jcLookupCache, true);
                }
                if (jCClass2 == null) break;
                jCFinder.append(new JavaCompletion.SingleProvider(jCClass2));
            }
            jCClass = jCClass2;
            arrayList.add(jCClass);
        }
    }

    protected Map buildGlobalVariableMap(int n) {
        this.refreshClassInfo();
        JCFinder jCFinder = JavaCompletion.getFinder();
        JCClass jCClass = this.getClass(n);
        if (jCClass != null) {
            HashMap<String, JCType> hashMap = new HashMap<String, JCType>();
            List list = jCFinder.findFields(jCClass, "", false, false, true);
            int n2 = list.size() - 1;
            while (n2 >= 0) {
                JCField jCField = (JCField)list.get(n2);
                hashMap.put(jCField.getName(), jCField.getType());
                --n2;
            }
            return hashMap;
        }
        return null;
    }

    private ClassElement recurseClasses(ClassElement[] classElementArray, String string) {
        int n = 0;
        while (n < classElementArray.length) {
            ClassElement classElement = classElementArray[n];
            if (classElement.getName().getFullName().replace('$', '.').equals(string)) {
                return classElement;
            }
            ClassElement classElement2 = this.recurseClasses(classElement.getClasses(), string);
            if (classElement2 != null) {
                return classElement2;
            }
            ++n;
        }
        return null;
    }

    private DataObject getDataObject(FileObject fileObject) {
        DataObject dataObject = null;
        if (fileObject != null) {
            try {
                dataObject = DataObject.find((FileObject)fileObject);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        return dataObject;
    }

    private DataObject getDataObject(Repository repository, JCClass jCClass) {
        FileObject fileObject;
        DataObject dataObject = null;
        String string = jCClass.getName();
        int n = string.indexOf(46, 0);
        if (n >= 0) {
            string = string.substring(0, n);
        }
        if ((fileObject = repository.find(jCClass.getPackageName(), string, "java")) != null) {
            dataObject = this.getDataObject(fileObject);
        }
        return dataObject;
    }

    private SourceElement getSourceElement(DataObject dataObject) {
        SourceCookie sourceCookie;
        SourceElement sourceElement = null;
        if (dataObject != null && (sourceCookie = (SourceCookie)dataObject.getCookie(class$org$openide$cookies$SourceCookie == null ? (class$org$openide$cookies$SourceCookie = NbJavaSyntaxSupport.class$("org.openide.cookies.SourceCookie")) : class$org$openide$cookies$SourceCookie)) != null) {
            sourceElement = sourceCookie.getSource();
        }
        return sourceElement;
    }

    private ClassElement getClassElement(DataObject dataObject, JCClass jCClass) {
        SourceElement sourceElement = this.getSourceElement(dataObject);
        ClassElement classElement = null;
        if (sourceElement != null) {
            classElement = this.recurseClasses(sourceElement.getClasses(), jCClass.getFullName());
        }
        return classElement;
    }

    private void openAtElement(final DataObject dataObject, final org.openide.src.Element element) {
        new Thread(){
            static /* synthetic */ Class class$org$openide$cookies$OpenCookie;

            public void run() {
                OpenCookie openCookie;
                OpenCookie openCookie2 = element != null ? (OpenCookie)element.getCookie(class$org$openide$cookies$OpenCookie == null ? (class$org$openide$cookies$OpenCookie = 2.class$("org.openide.cookies.OpenCookie")) : class$org$openide$cookies$OpenCookie) : (openCookie = (OpenCookie)dataObject.getCookie(class$org$openide$cookies$OpenCookie == null ? (class$org$openide$cookies$OpenCookie = 2.class$("org.openide.cookies.OpenCookie")) : class$org$openide$cookies$OpenCookie));
                if (openCookie != null) {
                    openCookie.open();
                    return;
                }
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        }.start();
    }

    private String getSourceName(JCClass jCClass, boolean bl) {
        String string = jCClass.getName();
        int n = string.indexOf(46);
        if (n >= 0) {
            string = string.substring(0, n);
        }
        return bl ? string : jCClass.getPackageName() + '.' + string;
    }

    public String openSource(Object object, boolean bl, boolean bl2) {
        JCConstructor jCConstructor;
        JCClass jCClass;
        TopManager topManager = NbEditorUtilities.getTopManager();
        if (topManager == null) {
            return null;
        }
        Repository repository = topManager.getRepository();
        DataObject dataObject = null;
        ClassElement classElement = null;
        String string = null;
        boolean bl3 = false;
        if (object instanceof JCPackage) {
            if (!bl) {
                String string2 = ((JCPackage)object).getName();
                if (string2 == null || string2.length() <= 0) {
                    return null;
                }
                FileObject fileObject = repository.find(string2, null, null);
                if (fileObject != null && (dataObject = this.getDataObject(fileObject)) != null) {
                    Node node = dataObject.getNodeDelegate();
                    if (node != null) {
                        bl3 = true;
                        if (!bl2) {
                            topManager.getNodeOperation().explore(node);
                        }
                    }
                    dataObject = null;
                }
                if (bl2 || !bl3) {
                    string = string2;
                }
            }
        } else if (object instanceof JCClass) {
            JCClass jCClass2 = (JCClass)object;
            if (!JavaCompletion.isPrimitiveClass(jCClass2)) {
                dataObject = this.getDataObject(repository, jCClass2);
                if (dataObject == null) {
                    dataObject = this.openViaClass(jCClass2);
                }
                if (dataObject != null) {
                    bl3 = true;
                    classElement = this.getClassElement(dataObject, jCClass2);
                }
                if (bl2 || !bl3) {
                    string = this.getSourceName(jCClass2, bl2);
                }
            }
        } else if (object instanceof JCField) {
            JCClass jCClass3;
            JCField jCField = (JCField)object;
            JCClass jCClass4 = jCClass3 = bl ? jCField.getClazz() : jCField.getType().getClazz();
            if (!JavaCompletion.isPrimitiveClass(jCClass3)) {
                dataObject = this.getDataObject(repository, jCClass3);
                if (dataObject == null) {
                    dataObject = this.openViaClass(jCClass3);
                }
                if (dataObject != null) {
                    bl3 = true;
                    ClassElement classElement2 = this.getClassElement(dataObject, jCClass3);
                    if (classElement2 != null) {
                        classElement = JCExtension.findFieldElement(jCField, classElement2);
                    }
                }
                if (bl2 || !bl3) {
                    string = this.getSourceName(jCClass3, bl2);
                }
            }
        } else if (object instanceof JCMethod) {
            JCMethod jCMethod = (JCMethod)object;
            JCClass jCClass5 = jCMethod.getClazz();
            if (!JavaCompletion.isPrimitiveClass(jCClass5)) {
                dataObject = this.getDataObject(repository, jCClass5);
                if (dataObject == null) {
                    dataObject = this.openViaClass(jCClass5);
                }
                if (dataObject != null) {
                    bl3 = true;
                    ClassElement classElement3 = this.getClassElement(dataObject, jCClass5);
                    if (classElement3 != null) {
                        classElement = JCExtension.findMethodElement(jCMethod, classElement3);
                    }
                }
                if (bl2 || !bl3) {
                    string = this.getSourceName(jCClass5, bl2);
                }
            }
        } else if (object instanceof JCConstructor && !JavaCompletion.isPrimitiveClass(jCClass = (jCConstructor = (JCConstructor)object).getClazz())) {
            dataObject = this.getDataObject(repository, jCClass);
            if (dataObject == null) {
                dataObject = this.openViaClass(jCClass);
            }
            if (dataObject != null) {
                bl3 = true;
                ClassElement classElement4 = this.getClassElement(dataObject, jCClass);
                if (classElement4 != null) {
                    classElement = JCExtension.findConstructorElement(jCConstructor, classElement4);
                }
            }
            if (bl2 || !bl3) {
                string = this.getSourceName(jCClass, bl2);
            }
        }
        if (dataObject != null && !bl2) {
            this.openAtElement(dataObject, (org.openide.src.Element)classElement);
            NbEditorUtilities.addJumpListEntry(dataObject);
        }
        return string;
    }

    private DataObject openViaClass(JCClass jCClass) {
        DataObject dataObject;
        FileObject fileObject = TopManager.getDefault().getRepository().find(jCClass.getPackageName(), jCClass.getName(), "class");
        if (fileObject == null) {
            return null;
        }
        try {
            dataObject = DataObject.find((FileObject)fileObject.getParent());
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            return null;
        }
        if (dataObject == null) {
            return null;
        }
        DataFolder dataFolder = (DataFolder)dataObject.getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = NbJavaSyntaxSupport.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder);
        if (dataFolder == null) {
            return null;
        }
        DataObject[] dataObjectArray = dataFolder.getChildren();
        int n = 0;
        while (n < dataObjectArray.length) {
            SourceCookie sourceCookie;
            DataObject dataObject2 = dataObjectArray[n];
            if (!(dataObject2 instanceof DataFolder) && (sourceCookie = (SourceCookie)dataObject2.getCookie(class$org$openide$cookies$SourceCookie == null ? NbJavaSyntaxSupport.class$("org.openide.cookies.SourceCookie") : class$org$openide$cookies$SourceCookie)) != null) {
                SourceElement sourceElement = sourceCookie.getSource();
                ClassElement[] classElementArray = sourceElement.getClasses();
                String string = dataObject2.getPrimaryFile().getPackageName('.');
                int n2 = 0;
                while (n2 < classElementArray.length) {
                    FileObject fileObject2;
                    String string2 = classElementArray[n2].getName().getFullName();
                    if (!string.equals(string2) && string2.equals(fileObject.getPackageName('.')) && (fileObject2 = TopManager.getDefault().getRepository().findResource(string.replace('.', '/') + ".java")) != null) {
                        try {
                            return DataObject.find((FileObject)fileObject2);
                        }
                        catch (DataObjectNotFoundException dataObjectNotFoundException) {
                            // empty catch block
                        }
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return null;
    }

    private FileSystem[] getDocFileSystems() {
        FileSystem[] fileSystemArray;
        ArrayList<FileSystem> arrayList = new ArrayList<FileSystem>();
        TopManager topManager = NbEditorUtilities.getTopManager();
        if (topManager != null) {
            fileSystemArray = topManager.getRepository().getFileSystems();
            while (fileSystemArray.hasMoreElements()) {
                FileSystem fileSystem = (FileSystem)fileSystemArray.nextElement();
                if (!fileSystem.getCapability().capableOf(FileSystemCapability.DOC)) continue;
                arrayList.add(fileSystem);
            }
        }
        fileSystemArray = new FileSystem[arrayList.size()];
        arrayList.toArray(fileSystemArray);
        return fileSystemArray;
    }

    private FileObject[] getDocFileObjects(String string, String string2) {
        FileObject fileObject;
        FileSystem[] fileSystemArray = this.getDocFileSystems();
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        String string3 = "api." + string;
        int n = 0;
        while (n < fileSystemArray.length) {
            fileObject = fileSystemArray[n].find(string, string2, "html");
            if (fileObject == null) {
                fileObject = fileSystemArray[n].find(string3, string2, "html");
            }
            if (fileObject != null) {
                arrayList.add(fileObject);
            }
            ++n;
        }
        fileObject = new FileObject[arrayList.size()];
        arrayList.toArray((T[])fileObject);
        return fileObject;
    }

    public URL[] getJavaDocURLs(Object object) {
        Comparable comparable;
        ArrayList<URL> arrayList = new ArrayList<URL>();
        if (object instanceof JCPackage) {
            comparable = (JCPackage)object;
            FileObject[] fileObjectArray = this.getDocFileObjects(comparable.getName(), PACKAGE_SUMMARY);
            int n = 0;
            while (n < fileObjectArray.length) {
                try {
                    arrayList.add(fileObjectArray[n].getURL());
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    // empty catch block
                }
                ++n;
            }
        } else if (object instanceof JCClass) {
            comparable = (JCClass)object;
            FileObject[] fileObjectArray = this.getDocFileObjects(comparable.getPackageName(), comparable.getName());
            int n = 0;
            while (n < fileObjectArray.length) {
                try {
                    arrayList.add(fileObjectArray[n].getURL());
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    // empty catch block
                }
                ++n;
            }
        } else if (object instanceof JCConstructor) {
            comparable = (JCConstructor)object;
            JCClass jCClass = comparable.getClazz();
            FileObject[] fileObjectArray = this.getDocFileObjects(jCClass.getPackageName(), jCClass.getName());
            int n = 0;
            while (n < fileObjectArray.length) {
                try {
                    URL uRL = fileObjectArray[n].getURL();
                    StringBuffer stringBuffer = new StringBuffer("#");
                    stringBuffer.append(object instanceof JCMethod ? ((JCMethod)comparable).getName() : jCClass.getName());
                    stringBuffer.append('(');
                    JCParameter[] jCParameterArray = comparable.getParameters();
                    int n2 = jCParameterArray.length - 1;
                    int n3 = 0;
                    while (n3 <= n2) {
                        stringBuffer.append(jCParameterArray[n3].getType().format(true));
                        if (n3 < n2) {
                            stringBuffer.append(", ");
                        }
                        ++n3;
                    }
                    stringBuffer.append(')');
                    try {
                        arrayList.add(new URL(uRL.toString() + stringBuffer));
                    }
                    catch (MalformedURLException malformedURLException) {}
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    // empty catch block
                }
                ++n;
            }
        } else if (object instanceof JCField) {
            comparable = (JCField)object;
            JCClass jCClass = comparable.getClazz();
            FileObject[] fileObjectArray = this.getDocFileObjects(jCClass.getPackageName(), jCClass.getName());
            int n = 0;
            while (n < fileObjectArray.length) {
                try {
                    URL uRL = fileObjectArray[n].getURL();
                    try {
                        arrayList.add(new URL(uRL.toString() + '#' + comparable.getName()));
                    }
                    catch (MalformedURLException malformedURLException) {}
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    // empty catch block
                }
                ++n;
            }
        }
        comparable = new URL[arrayList.size()];
        arrayList.toArray((T[])comparable);
        return comparable;
    }

    public Debugger getDebugger() {
        try {
            TopManager topManager = NbEditorUtilities.getTopManager();
            if (topManager != null) {
                return topManager.getDebugger();
            }
        }
        catch (DebuggerNotFoundException debuggerNotFoundException) {
            // empty catch block
        }
        return null;
    }

    public Breakpoint getBreakpoint(int n) {
        Debugger debugger = this.getDebugger();
        Line line = NbEditorUtilities.getLine(this.getDocument(), n, false);
        if (debugger != null && line != null) {
            return debugger.findBreakpoint(line);
        }
        return null;
    }

    public Breakpoint createBreakpoint(int n) {
        Debugger debugger = this.getDebugger();
        Line line = NbEditorUtilities.getLine(this.getDocument(), n, false);
        if (debugger != null && line != null) {
            return debugger.createBreakpoint(line);
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

