/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import java.awt.Dialog;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import org.netbeans.modules.editor.java.JCStorage;
import org.netbeans.modules.editor.java.JCStorageElement;
import org.netbeans.modules.editor.java.JCUpdater;
import org.netbeans.modules.editor.java.PDCustomizerDialog;
import org.openide.DialogDescriptor;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.JarFileSystem;
import org.openide.filesystems.LocalFileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public class PDCustomizer {
    PDCustomizerDialog pdDialog;
    private static ResourceBundle bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$editor$java$PDCustomizer == null ? (class$org$netbeans$modules$editor$java$PDCustomizer = PDCustomizer.class$("org.netbeans.modules.editor.java.PDCustomizer")) : class$org$netbeans$modules$editor$java$PDCustomizer));
    private static PDCustomizer customizer;
    public static JButton CLOSE_OPTION;
    private String[] columnNames = new String[]{bundle.getString("PDCD_PREFIX"), bundle.getString("PDCD_FILESYSTEM"), bundle.getString("PDCD_AUTOUPDATE")};
    private static final String HELP_ID = "editing.completion.manager";
    private CustomizerTableModel model = new CustomizerTableModel();
    private JCStorageElement[] elements;
    private PropertyChangeListener storageListener;
    private Dialog dialog;
    static /* synthetic */ Class class$org$netbeans$modules$editor$java$PDCustomizer;

    private PDCustomizer() {
        this.pdDialog = new PDCustomizerDialog((Frame)new JFrame(), true);
        this.pdDialog.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                if (!listSelectionModel.isSelectionEmpty()) {
                    PDCustomizer.this.pdDialog.enableDeleteButton(true);
                    int n = listSelectionModel.getMinSelectionIndex();
                    Object object = PDCustomizer.this.model.getValueAt(n, 1);
                    boolean bl = object != null && object instanceof String && PDCustomizer.this.getMountedFS((String)object) != null;
                    PDCustomizer.this.pdDialog.enableUpdateButton(bl);
                }
            }
        });
        this.pdDialog.getTable().setModel(this.model);
        this.storageListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                PDCustomizer.this.refresh();
            }
        };
    }

    Dialog getCustomizer() {
        if (this.dialog == null) {
            this.attachListener();
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this.pdDialog.getContentPane(), bundle.getString("PDCD_PDCUSTOMIZER"), false, new Object[]{CLOSE_OPTION}, (Object)CLOSE_OPTION, 0, new HelpCtx(HELP_ID), null);
            this.dialog = TopManager.getDefault().createDialog(dialogDescriptor);
        }
        this.refresh();
        return this.dialog;
    }

    FileSystem getMountedFS(String string) {
        if (string == null) {
            return null;
        }
        Enumeration enumeration = TopManager.getDefault().getRepository().getFileSystems();
        while (enumeration.hasMoreElements()) {
            FileSystem fileSystem;
            Object e = enumeration.nextElement();
            if (!(e instanceof FileSystem) || !string.equals((fileSystem = (FileSystem)e).getSystemName())) continue;
            return fileSystem;
        }
        return null;
    }

    public void refresh() {
        this.setData(this.getData());
    }

    public Object[][] getData() {
        this.elements = JCStorage.getStorage().getElements();
        Object[][] objectArray = new Object[this.elements.length][3];
        int n = 0;
        while (n < this.elements.length) {
            objectArray[n] = new Object[]{this.elements[n].getName(), this.elements[n].getFileSystemName(), new Boolean(this.elements[n].getAutoUpdate() && this.getMountedFS(this.elements[n].getFileSystemName()) != null)};
            ++n;
        }
        return objectArray;
    }

    public void setData(Object[][] objectArray) {
        this.model.setDataVector(objectArray, this.columnNames);
        this.pdDialog.getTable().getColumnModel().getColumn(0).setPreferredWidth(130);
        this.pdDialog.getTable().getColumnModel().getColumn(1).setPreferredWidth(130);
        this.pdDialog.getTable().getColumnModel().getColumn(2).setPreferredWidth(25);
        this.pdDialog.enableUpdateButton(false);
        this.pdDialog.enableDeleteButton(false);
    }

    public static synchronized PDCustomizer getDefault() {
        if (customizer == null) {
            customizer = new PDCustomizer();
        }
        return customizer;
    }

    private DataObject getSelectedFSDO() {
        DataObject dataObject = null;
        int n = this.pdDialog.getTable().getSelectedRow();
        Object object = this.model.getValueAt(n, 1);
        if (object != null && object instanceof String) {
            String string = (String)object;
            FileSystem fileSystem = this.getMountedFS(string);
            if (fileSystem == null) {
                return null;
            }
            FileObject fileObject = fileSystem.getRoot();
            if (fileObject != null) {
                try {
                    DataObject dataObject2 = DataObject.find((FileObject)fileObject);
                    if (dataObject2 != null && dataObject2.isValid()) {
                        return dataObject2;
                    }
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    // empty catch block
                }
            }
        }
        return dataObject;
    }

    public void delete(String string, boolean bl) {
        if (string == null) {
            return;
        }
        JCStorageElement jCStorageElement = JCStorage.getStorage().getElement(string);
        if (bl && jCStorageElement != null) {
            NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)MessageFormat.format(bundle.getString("PDC_DeleteQuestion"), jCStorageElement.getName()), bundle.getString("PDC_DeleteDialogTitle"), 0, 3, null, NotifyDescriptor.YES_OPTION);
            TopManager.getDefault().notify(notifyDescriptor);
            if (notifyDescriptor.getValue() != NotifyDescriptor.YES_OPTION) {
                return;
            }
        }
        JCStorage.getStorage().deleteFile(jCStorageElement);
    }

    protected void delete() {
        int n = this.pdDialog.getTable().getSelectedRow();
        Object object = this.model.getValueAt(n, 0);
        if (object != null && object instanceof String) {
            this.delete((String)object, true);
        }
    }

    protected void add() {
        block14: {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileSelectionMode(2);
            jFileChooser.setFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().endsWith(".jar") || file.getName().endsWith(".zip");
                }

                public String getDescription() {
                    return bundle.getString("PDC_JarArchivesMask");
                }
            });
            jFileChooser.setDialogTitle(bundle.getString("PDC_ChooserTitle"));
            jFileChooser.setMultiSelectionEnabled(false);
            if (jFileChooser.showDialog(WindowManager.getDefault().getMainWindow(), bundle.getString("PDC_SelectButton")) == 0) {
                File file = jFileChooser.getSelectedFile();
                try {
                    boolean bl;
                    LocalFileSystem localFileSystem = null;
                    if (file.isDirectory()) {
                        localFileSystem = new LocalFileSystem();
                        localFileSystem.setRootDirectory(file);
                    } else if (file.getName().endsWith(".jar") || file.getName().endsWith(".zip")) {
                        localFileSystem = new JarFileSystem();
                        ((JarFileSystem)localFileSystem).setJarFile(file);
                    }
                    if (localFileSystem == null) {
                        return;
                    }
                    localFileSystem.setHidden(true);
                    if (Repository.getDefault().findFileSystem(localFileSystem.getSystemName()) == null) {
                        Repository.getDefault().addFileSystem((FileSystem)localFileSystem);
                        bl = false;
                    } else {
                        bl = true;
                    }
                    LocalFileSystem localFileSystem2 = localFileSystem;
                    FileObject fileObject = localFileSystem.getRoot();
                    if (fileObject == null) break block14;
                    try {
                        DataObject dataObject = DataObject.find((FileObject)fileObject);
                        if (dataObject != null && dataObject.isValid() && dataObject != null) {
                            JCUpdater jCUpdater = new JCUpdater(new Node[]{dataObject.getNodeDelegate()}, true);
                            if (!bl) {
                                jCUpdater.addPropertyChangeListener(new PropertyChangeListener((FileSystem)localFileSystem2, jCUpdater){
                                    private final /* synthetic */ FileSystem val$fileSystem;
                                    private final /* synthetic */ JCUpdater val$update;
                                    {
                                        this.val$fileSystem = fileSystem;
                                        this.val$update = jCUpdater;
                                    }

                                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                                        if (propertyChangeEvent == null) {
                                            return;
                                        }
                                        if ("mount_fs".equals(propertyChangeEvent.getPropertyName())) {
                                            boolean bl;
                                            boolean bl2 = bl = propertyChangeEvent.getNewValue() != null && propertyChangeEvent.getNewValue() instanceof Boolean ? (Boolean)propertyChangeEvent.getNewValue() : false;
                                            if (!bl) {
                                                Repository.getDefault().removeFileSystem(this.val$fileSystem);
                                                JCStorageElement jCStorageElement = JCStorage.getStorage().findFileSystemElement(this.val$fileSystem.getSystemName());
                                                if (jCStorageElement != null) {
                                                    jCStorageElement.setAutoUpdate(false);
                                                    PDCustomizer.this.refresh();
                                                }
                                            } else {
                                                this.val$fileSystem.setHidden(false);
                                            }
                                            if (this.val$update != null) {
                                                this.val$update.removePropertyChangeListener(this);
                                            }
                                        }
                                    }
                                });
                            }
                            jCUpdater.start();
                        }
                    }
                    catch (DataObjectNotFoundException dataObjectNotFoundException) {}
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                catch (PropertyVetoException propertyVetoException) {
                    propertyVetoException.printStackTrace();
                }
            }
        }
    }

    protected void update() {
        DataObject dataObject = this.getSelectedFSDO();
        if (dataObject != null) {
            JCUpdater jCUpdater = new JCUpdater(new Node[]{dataObject.getNodeDelegate()});
            jCUpdater.start();
        }
    }

    public void openDialog() {
        if (this.dialog == null) {
            this.attachListener();
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this.pdDialog.getContentPane(), bundle.getString("PDCD_PDCUSTOMIZER"), false, new Object[]{CLOSE_OPTION}, (Object)CLOSE_OPTION, 0, new HelpCtx(HELP_ID), null);
            this.dialog = TopManager.getDefault().createDialog(dialogDescriptor);
        }
        this.refresh();
        this.dialog.show();
    }

    void attachListener() {
        JCStorage.getStorage().addPropertyChangeListener(this.storageListener);
    }

    void detachListener() {
        JCStorage.getStorage().addPropertyChangeListener(this.storageListener);
    }

    public CustomizerTableModel getCustomizerTableModel() {
        return this.model;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        CLOSE_OPTION = new JButton(bundle.getString("PDCD_CLOSE"));
        CLOSE_OPTION.setMnemonic(bundle.getString("PDCD_CLOSE").charAt(0));
        CLOSE_OPTION.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_PDCD_CLOSE"));
    }

    private class CustomizerTableModel
    extends DefaultTableModel
    implements TableModelListener {
        boolean[] canEdit = new boolean[]{false, false, true};
        static /* synthetic */ Class class$java$lang$Boolean;

        public CustomizerTableModel() {
            this.addTableModelListener(this);
        }

        public boolean isCellEditable(int n, int n2) {
            Object object = PDCustomizer.this.model.getValueAt(n, 1);
            boolean bl = object != null && object instanceof String && PDCustomizer.this.getMountedFS((String)object) != null;
            return this.canEdit[n2] && bl;
        }

        public Class getColumnClass(int n) {
            if (n == 2) {
                return class$java$lang$Boolean == null ? (class$java$lang$Boolean = CustomizerTableModel.class$("java.lang.Boolean")) : class$java$lang$Boolean;
            }
            return super.getColumnClass(n);
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            int n = tableModelEvent.getFirstRow();
            int n2 = tableModelEvent.getColumn();
            if (n2 != 2) {
                return;
            }
            Object object = PDCustomizer.this.model.getValueAt(n, n2);
            if (object instanceof Boolean) {
                PDCustomizer.this.elements[n].setAutoUpdate((Boolean)object);
                JCStorage.getStorage().saveElements();
            }
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

