/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.options;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Toolkit;
import java.beans.IntrospectionException;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OptionalDataException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.MultiKeyBinding;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsDefaults;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.modules.editor.FormatterIndentEngine;
import org.netbeans.modules.editor.IndentEngineFormatter;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.options.AllOptionsFolder;
import org.netbeans.modules.editor.options.MIMEOptionFile;
import org.netbeans.modules.editor.options.MIMEOptionFolder;
import org.netbeans.modules.editor.options.MIMEOptionNode;
import org.netbeans.modules.editor.options.MultiPropertyFolder;
import org.netbeans.modules.editor.options.OptionSupport;
import org.netbeans.modules.editor.options.OptionUtilities;
import org.netbeans.modules.editor.options.UpgradeOptions;
import org.openide.ServiceType;
import org.openide.TopManager;
import org.openide.execution.NbClassPath;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.IndentEngine;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public class BaseOptions
extends OptionSupport {
    protected static final int LATEST_OPTIONS_VERSION = 21;
    protected static final String OPTIONS_VERSION_PROP = "optionsVersion";
    public static final String ABBREV_MAP_PROP = "abbrevMap";
    public static final String BASE = "base";
    public static final String CARET_BLINK_RATE_PROP = "caretBlinkRate";
    public static final String CARET_COLOR_INSERT_MODE_PROP = "caretColorInsertMode";
    public static final String CARET_COLOR_OVERWRITE_MODE_PROP = "caretColorOverwriteMode";
    public static final String CARET_ITALIC_INSERT_MODE_PROP = "caretItalicInsertMode";
    public static final String CARET_ITALIC_OVERWRITE_MODE_PROP = "caretItalicOverwriteMode";
    public static final String CARET_TYPE_INSERT_MODE_PROP = "caretTypeInsertMode";
    public static final String CARET_TYPE_OVERWRITE_MODE_PROP = "caretTypeOverwriteMode";
    public static final String COLORING_MAP_PROP = "coloringMap";
    public static final String EXPAND_TABS_PROP = "expandTabs";
    public static final String FIND_HIGHLIGHT_SEARCH_PROP = "findHighlightSearch";
    public static final String FIND_HISTORY_PROP = "findHistory";
    public static final String FIND_HISTORY_SIZE_PROP = "findHistorySize";
    public static final String FIND_INC_SEARCH_DELAY_PROP = "findIncSearchDelay";
    public static final String FIND_INC_SEARCH_PROP = "findIncSearch";
    public static final String FIND_MATCH_CASE_PROP = "findMatchCase";
    public static final String FIND_REG_EXP_PROP = "findRegExp";
    public static final String FIND_SMART_CASE_PROP = "findSmartCase";
    public static final String FIND_WHOLE_WORDS_PROP = "findWholeWords";
    public static final String FIND_WRAP_SEARCH_PROP = "findWrapSearch";
    public static final String FONT_SIZE_PROP = "fontSize";
    public static final String HIGHLIGHT_CARET_ROW_PROP = "highlightCaretRow";
    public static final String HIGHLIGHT_MATCHING_BRACKET_PROP = "highlightMatchingBracket";
    public static final String INDENT_ENGINE_PROP = "indentEngine";
    public static final String KEY_BINDING_LIST_PROP = "keyBindingList";
    public static final String LINE_HEIGHT_CORRECTION_PROP = "lineHeightCorrection";
    public static final String LINE_NUMBER_MARGIN_PROP = "lineNumberMargin";
    public static final String LINE_NUMBER_MARGIN_PROP_2 = "lineNumberMargin2";
    public static final String LINE_NUMBER_VISIBLE_PROP = "lineNumberVisible";
    public static final String MACRO_MAP_PROP = "macroMap";
    public static final String MARGIN_PROP = "margin";
    public static final String SCROLL_FIND_INSETS_PROP = "scrollFindInsets";
    public static final String SCROLL_JUMP_INSETS_PROP = "scrollJumpInsets";
    public static final String SPACES_PER_TAB_PROP = "spacesPerTab";
    public static final String STATUS_BAR_CARET_DELAY_PROP = "statusBarCaretDelay";
    public static final String STATUS_BAR_VISIBLE_PROP = "statusBarVisible";
    public static final String TAB_SIZE_PROP = "tabSize";
    public static final String TEXT_LIMIT_LINE_COLOR_PROP = "textLimitLineColor";
    public static final String TEXT_LIMIT_LINE_VISIBLE_PROP = "textLimitLineVisible";
    public static final String TEXT_LIMIT_WIDTH_PROP = "textLimitWidth";
    public static final String TOOLBAR_VISIBLE_PROP = "toolbarVisible";
    static final String[] BASE_PROP_NAMES = new String[]{"abbrevMap", "caretBlinkRate", "caretColorInsertMode", "caretColorOverwriteMode", "caretItalicInsertMode", "caretItalicOverwriteMode", "caretTypeInsertMode", "caretTypeOverwriteMode", "coloringMap", "expandTabs", "fontSize", "highlightCaretRow", "highlightMatchingBracket", "indentEngine", "keyBindingList", "lineHeightCorrection", "lineNumberMargin2", "lineNumberVisible", "macroMap", "margin", "scrollFindInsets", "scrollJumpInsets", "spacesPerTab", "statusBarCaretDelay", "statusBarVisible", "tabSize", "textLimitLineColor", "textLimitLineVisible", "textLimitWidth", "optionsVersion"};
    static final long serialVersionUID = -5469192431366914841L;
    private static final String HELP_ID = "editing.global";
    private static final String NO_INDENT_ENGINE = "NO_INDENT_ENGINE";
    private static final boolean debugFormat = Boolean.getBoolean("netbeans.debug.editor.format");
    private transient Settings.Initializer coloringMapInitializer;
    private transient int optionsVersion;
    private transient IndentEngine readExternalIndentEngine;
    private transient boolean inReadExternal;
    private transient MIMEOptionNode mimeNode;
    private transient Map defaultAbbrevsMap;
    private transient Map defaultMacrosMap;
    private transient Map defaultKeyBindingsMap;
    private transient MIMEOptionFolder settingsFolder;
    private static final HashMap kitClass2Options = new HashMap();
    static /* synthetic */ Class class$org$netbeans$editor$BaseKit;
    static /* synthetic */ Class class$org$openide$loaders$DataFolder;
    static /* synthetic */ Class class$org$netbeans$modules$editor$options$AbbrevsMIMEProcessor;
    static /* synthetic */ Class class$org$netbeans$modules$editor$options$FontsColorsMIMEProcessor;
    static /* synthetic */ Class class$org$netbeans$modules$editor$options$KeyBindingsMIMEProcessor;
    static /* synthetic */ Class class$org$netbeans$modules$editor$options$MacrosMIMEProcessor;
    static /* synthetic */ Class class$org$netbeans$modules$editor$options$PropertiesMIMEProcessor;
    static /* synthetic */ Class class$org$netbeans$modules$editor$SimpleIndentEngine;

    public BaseOptions() {
        this(class$org$netbeans$editor$BaseKit == null ? (class$org$netbeans$editor$BaseKit = BaseOptions.class$("org.netbeans.editor.BaseKit")) : class$org$netbeans$editor$BaseKit, BASE);
        this.optionsVersion = 21;
    }

    public BaseOptions(Class clazz, String string) {
        super(clazz, string);
        kitClass2Options.put(clazz, this);
    }

    public static BaseOptions getOptions(Class clazz) {
        BaseOptions baseOptions = (BaseOptions)((Object)kitClass2Options.get(clazz));
        if (baseOptions == null) {
            AllOptionsFolder.getDefault().loadMIMEOption(clazz, false);
            baseOptions = (BaseOptions)((Object)kitClass2Options.get(clazz));
        }
        return baseOptions;
    }

    private void attachSettingsFileListener(FileObject fileObject) {
        String string = BaseKit.getKit(this.getKitClass()).getContentType();
        if (string == null) {
            return;
        }
        FileObject fileObject2 = TopManager.getDefault().getRepository().getDefaultFileSystem().findResource("Editors/" + string + "/" + "Settings.settings");
        if (fileObject2 != null && NbClassPath.toFile((FileObject)fileObject2) != null) {
            try {
                NbClassPath.toFile((FileObject)fileObject2).delete();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        fileObject.addFileChangeListener((FileChangeListener)new FileChangeAdapter(){

            private void delete(FileObject fileObject) {
                File file;
                if (fileObject.getNameExt().equals("Settings.settings") && (file = NbClassPath.toFile((FileObject)fileObject)) != null) {
                    file.delete();
                }
            }

            public void fileDataCreated(FileEvent fileEvent) {
                if (fileEvent == null) {
                    return;
                }
                this.delete(fileEvent.getFile());
            }

            public void fileChanged(FileEvent fileEvent) {
                if (fileEvent == null) {
                    return;
                }
                this.delete(fileEvent.getFile());
            }
        });
    }

    protected MIMEOptionFolder getMIMEFolder() {
        BaseKit baseKit = BaseKit.getKit(this.getKitClass());
        String string = baseKit.getContentType();
        if (string == null) {
            return null;
        }
        BaseOptions baseOptions = this;
        synchronized (baseOptions) {
            Object object;
            Object object2;
            FileObject fileObject;
            if (this.settingsFolder != null) {
                MIMEOptionFolder mIMEOptionFolder = this.settingsFolder;
                return mIMEOptionFolder;
            }
            FileObject fileObject2 = TopManager.getDefault().getRepository().getDefaultFileSystem().findResource("Editors/" + string);
            if (fileObject2 == null && (fileObject = TopManager.getDefault().getRepository().getDefaultFileSystem().findResource("Editors")) != null) {
                try {
                    object2 = new StringTokenizer(string, "/");
                    while (((StringTokenizer)object2).hasMoreElements()) {
                        object = ((StringTokenizer)object2).nextToken();
                        fileObject = fileObject.getFileObject((String)object) == null ? fileObject.createFolder((String)object) : fileObject.getFileObject((String)object);
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                fileObject2 = TopManager.getDefault().getRepository().getDefaultFileSystem().findResource("Editors/" + string);
            }
            if (fileObject2 != null) {
                try {
                    fileObject = DataObject.find((FileObject)fileObject2);
                    object2 = (DataFolder)fileObject.getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = BaseOptions.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder);
                    if (object2 != null) {
                        this.attachSettingsFileListener(fileObject2);
                        this.settingsFolder = new MIMEOptionFolder((DataFolder)object2, this);
                        object = this.settingsFolder;
                        return object;
                    }
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    dataObjectNotFoundException.printStackTrace();
                }
            }
            fileObject = null;
            return fileObject;
        }
    }

    public synchronized MIMEOptionNode getMimeNode() {
        if (this.mimeNode == null) {
            this.createMIMENode(this.getTypeName());
        }
        return this.mimeNode;
    }

    private void createMIMENode(String string) {
        if (string.equals(BASE)) {
            return;
        }
        try {
            this.mimeNode = new MIMEOptionNode(this);
        }
        catch (IntrospectionException introspectionException) {
            introspectionException.printStackTrace();
        }
    }

    protected void updateSettingsMap(Class clazz, Map map) {
        super.updateSettingsMap(clazz, map);
        if (clazz == this.getKitClass()) {
            map.put(INDENT_ENGINE_PROP, new Settings.Evaluator(){

                public Object getValue(Class clazz, String string) {
                    return BaseOptions.this.getIndentEngine();
                }
            });
            map.put("formatter", new Settings.Evaluator(){

                public Object getValue(Class clazz, String string) {
                    IndentEngine indentEngine = BaseOptions.this.getIndentEngine();
                    return indentEngine != null ? (indentEngine instanceof FormatterIndentEngine ? ((FormatterIndentEngine)indentEngine).getFormatter() : new IndentEngineFormatter(BaseOptions.this.getKitClass(), indentEngine)) : null;
                }
            });
            if (this.coloringMapInitializer != null) {
                this.coloringMapInitializer.updateSettingsMap(clazz, map);
            }
        }
        if (clazz == (class$org$netbeans$editor$BaseKit == null ? (class$org$netbeans$editor$BaseKit = BaseOptions.class$("org.netbeans.editor.BaseKit")) : class$org$netbeans$editor$BaseKit) && this.coloringMapInitializer != null) {
            this.coloringMapInitializer.updateSettingsMap(class$org$netbeans$editor$BaseKit == null ? (class$org$netbeans$editor$BaseKit = BaseOptions.class$("org.netbeans.editor.BaseKit")) : class$org$netbeans$editor$BaseKit, map);
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(HELP_ID);
    }

    public int getTabSize() {
        return this.getSettingInteger("tab-size");
    }

    public void setTabSize(int n) {
        if (n < 0) {
            NbEditorUtilities.invalidArgument("MSG_NegativeValue");
            return;
        }
        this.setSettingInteger("tab-size", n, TAB_SIZE_PROP);
    }

    public void setExpandTabs(boolean bl) {
        this.setSettingBoolean("expand-tabs", bl, EXPAND_TABS_PROP);
    }

    public void setSpacesPerTab(int n) {
        if (n > 0) {
            this.setSettingInteger("spaces-per-tab", n, SPACES_PER_TAB_PROP);
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public Map getDefaultAbbrevMap() {
        this.loadDefaultAbbreviations();
        return this.defaultAbbrevsMap;
    }

    private void loadDefaultAbbreviations() {
        if (this.defaultAbbrevsMap != null) {
            return;
        }
        MIMEOptionFolder mIMEOptionFolder = this.getMIMEFolder();
        if (mIMEOptionFolder == null) {
            return;
        }
        MIMEOptionFolder mIMEOptionFolder2 = mIMEOptionFolder.getFolder("Defaults");
        if (mIMEOptionFolder2 == null) {
            return;
        }
        MIMEOptionFile mIMEOptionFile = mIMEOptionFolder2.getFile(class$org$netbeans$modules$editor$options$AbbrevsMIMEProcessor == null ? (class$org$netbeans$modules$editor$options$AbbrevsMIMEProcessor = BaseOptions.class$("org.netbeans.modules.editor.options.AbbrevsMIMEProcessor")) : class$org$netbeans$modules$editor$options$AbbrevsMIMEProcessor, false);
        if (mIMEOptionFile != null && !mIMEOptionFile.isLoaded()) {
            mIMEOptionFile.loadSettings(false);
            this.defaultAbbrevsMap = new HashMap(mIMEOptionFile.getAllProperties());
        }
    }

    public Map getAbbrevMap() {
        this.loadDefaultAbbreviations();
        this.loadSettings(class$org$netbeans$modules$editor$options$AbbrevsMIMEProcessor == null ? (class$org$netbeans$modules$editor$options$AbbrevsMIMEProcessor = BaseOptions.class$("org.netbeans.modules.editor.options.AbbrevsMIMEProcessor")) : class$org$netbeans$modules$editor$options$AbbrevsMIMEProcessor);
        return new HashMap((Map)super.getSettingValue("abbrev-map"));
    }

    public void setAbbrevMap(Map map, boolean bl) {
        Map map2 = null;
        if (bl) {
            this.loadDefaultAbbreviations();
            map2 = OptionUtilities.getMapDiff(this.getAbbrevMap(), map, true);
            if (map2.size() > 0) {
                this.updateSettings(class$org$netbeans$modules$editor$options$AbbrevsMIMEProcessor == null ? (class$org$netbeans$modules$editor$options$AbbrevsMIMEProcessor = BaseOptions.class$("org.netbeans.modules.editor.options.AbbrevsMIMEProcessor")) : class$org$netbeans$modules$editor$options$AbbrevsMIMEProcessor, map2);
            }
        }
        super.setSettingValue("abbrev-map", map, ABBREV_MAP_PROP);
    }

    public void setAbbrevMap(Map map) {
        this.setAbbrevMap(map, true);
    }

    public String getCaretTypeInsertMode() {
        return (String)this.getSettingValue("caret-type-insert-mode");
    }

    public void setCaretTypeInsertMode(String string) {
        this.setSettingValue("caret-type-insert-mode", string, CARET_TYPE_INSERT_MODE_PROP);
    }

    public String getCaretTypeOverwriteMode() {
        return (String)this.getSettingValue("caret-type-overwrite-mode");
    }

    public void setCaretTypeOverwriteMode(String string) {
        this.setSettingValue("caret-type-overwrite-mode", string, CARET_TYPE_OVERWRITE_MODE_PROP);
    }

    public boolean getCaretItalicInsertMode() {
        return this.getSettingBoolean("caret-italic-insert-mode");
    }

    public void setCaretItalicInsertMode(boolean bl) {
        this.setSettingBoolean("caret-italic-insert-mode", bl, CARET_ITALIC_INSERT_MODE_PROP);
    }

    public boolean getCaretItalicOverwriteMode() {
        return this.getSettingBoolean("caret-italic-overwrite-mode");
    }

    public void setCaretItalicOverwriteMode(boolean bl) {
        this.setSettingBoolean("caret-italic-overwrite-mode", bl, CARET_ITALIC_OVERWRITE_MODE_PROP);
    }

    public Color getCaretColorInsertMode() {
        this.loadSettings(class$org$netbeans$modules$editor$options$FontsColorsMIMEProcessor == null ? (class$org$netbeans$modules$editor$options$FontsColorsMIMEProcessor = BaseOptions.class$("org.netbeans.modules.editor.options.FontsColorsMIMEProcessor")) : class$org$netbeans$modules$editor$options$FontsColorsMIMEProcessor);
        return (Color)super.getSettingValue("caret-color-insert-mode");
    }

    public void setCaretColorInsertMode(Color color) {
        this.setCaretColorInsertMode(color, true);
    }

    public void setCaretColorInsertMode(Color color, boolean bl) {
        if (bl && !this.getCaretColorInsertMode().equals(color) && color != null) {
            HashMap<String, Color> hashMap = new HashMap<String, Color>();
            hashMap.put("caret-color-insert-mode", color);
            if (hashMap != null) {
                this.updateSettings(class$org$netbeans$modules$editor$options$FontsColorsMIMEProcessor == null ? (class$org$netbeans$modules$editor$options$FontsColorsMIMEProcessor = BaseOptions.class$("org.netbeans.modules.editor.options.FontsColorsMIMEProcessor")) : class$org$netbeans$modules$editor$options$FontsColorsMIMEProcessor, hashMap);
            }
        }
        super.setSettingValue("caret-color-insert-mode", color, CARET_COLOR_INSERT_MODE_PROP);
    }

    public Color getCaretColorOverwriteMode() {
        this.loadSettings(class$org$netbeans$modules$editor$options$FontsColorsMIMEProcessor == null ? (class$org$netbeans$modules$editor$options$FontsColorsMIMEProcessor = BaseOptions.class$("org.netbeans.modules.editor.options.FontsColorsMIMEProcessor")) : class$org$netbeans$modules$editor$options$FontsColorsMIMEProcessor);
        return (Color)super.getSettingValue("caret-color-overwrite-mode");
    }

    public void setCaretColorOverwriteMode(Color color) {
        this.setCaretColorOverwriteMode(color, true);
    }

    public void setCaretColorOverwriteMode(Color color, boolean bl) {
        if (bl && !this.getCaretColorOverwriteMode().equals(color) && color != null) {
            HashMap<String, Color> hashMap = new HashMap<String, Color>();
            hashMap.put("caret-color-overwrite-mode", color);
            if (hashMap != null) {
                this.updateSettings(class$org$netbeans$modules$editor$options$FontsColorsMIMEProcessor == null ? (class$org$netbeans$modules$editor$options$FontsColorsMIMEProcessor = BaseOptions.class$("org.netbeans.modules.editor.options.FontsColorsMIMEProcessor")) : class$org$netbeans$modules$editor$options$FontsColorsMIMEProcessor, hashMap);
            }
        }
        super.setSettingValue("caret-color-overwrite-mode", color, CARET_COLOR_OVERWRITE_MODE_PROP);
    }

    public int getCaretBlinkRate() {
        return this.getSettingInteger("caret-blink-rate");
    }

    public void setCaretBlinkRate(int n) {
        if (n < 0) {
            NbEditorUtilities.invalidArgument("MSG_NegativeValue");
            return;
        }
        this.setSettingInteger("caret-blink-rate", n, CARET_BLINK_RATE_PROP);
    }

    public boolean getLineNumberVisible() {
        return this.getSettingBoolean("line-number-visible");
    }

    public void setLineNumberVisible(boolean bl) {
        this.setSettingBoolean("line-number-visible", bl, LINE_NUMBER_VISIBLE_PROP);
    }

    public Insets getScrollJumpInsets() {
        return (Insets)this.getSettingValue("scroll-jump-insets");
    }

    public void setScrollJumpInsets(Insets insets) {
        this.setSettingValue("scroll-jump-insets", insets, SCROLL_JUMP_INSETS_PROP);
    }

    public Insets getScrollFindInsets() {
        return (Insets)this.getSettingValue("scroll-find-insets");
    }

    public void setScrollFindInsets(Insets insets) {
        this.setSettingValue("scroll-find-insets", insets, SCROLL_FIND_INSETS_PROP);
    }

    public Map getDefaultKeyBindingsMap() {
        this.loadDefaultKeyBindings();
        return this.defaultKeyBindingsMap;
    }

    private void loadDefaultKeyBindings() {
        MIMEOptionFolder mIMEOptionFolder;
        Object object;
        if (this.defaultKeyBindingsMap != null) {
            return;
        }
        if (BASE.equals(this.getTypeName())) {
            object = AllOptionsFolder.getDefault().getMIMEFolder();
            if (object == null) {
                return;
            }
            mIMEOptionFolder = ((MIMEOptionFolder)object).getFolder("Defaults");
        } else {
            AllOptionsFolder.getDefault().loadDefaultKeyBindings();
            object = this.getMIMEFolder();
            if (object == null) {
                return;
            }
            mIMEOptionFolder = ((MIMEOptionFolder)object).getFolder("Defaults");
        }
        if (mIMEOptionFolder == null) {
            return;
        }
        object = mIMEOptionFolder.getFile(class$org$netbeans$modules$editor$options$KeyBindingsMIMEProcessor == null ? (class$org$netbeans$modules$editor$options$KeyBindingsMIMEProcessor = BaseOptions.class$("org.netbeans.modules.editor.options.KeyBindingsMIMEProcessor")) : class$org$netbeans$modules$editor$options$KeyBindingsMIMEProcessor, false);
        if (object != null && !((MIMEOptionFile)object).isLoaded()) {
            ((MIMEOptionFile)object).loadSettings(false);
            this.defaultKeyBindingsMap = new HashMap(((MIMEOptionFile)object).getAllProperties());
        }
    }

    private List getKBList() {
        this.loadDefaultKeyBindings();
        this.loadSettings(class$org$netbeans$modules$editor$options$KeyBindingsMIMEProcessor == null ? (class$org$netbeans$modules$editor$options$KeyBindingsMIMEProcessor = BaseOptions.class$("org.netbeans.modules.editor.options.KeyBindingsMIMEProcessor")) : class$org$netbeans$modules$editor$options$KeyBindingsMIMEProcessor);
        Class clazz = this.getKitClass();
        Settings.KitAndValue[] kitAndValueArray = this.getSettingValueHierarchy("key-bindings");
        List<MultiKeyBinding> list = null;
        int n = 0;
        while (n < kitAndValueArray.length) {
            if (kitAndValueArray[n].kitClass == clazz) {
                list = (List)kitAndValueArray[n].value;
            }
            ++n;
        }
        if (list == null) {
            list = new ArrayList();
        }
        int n2 = list.size();
        int n3 = 0;
        while (n3 < n2) {
            Object e = list.get(n3);
            if (!(e instanceof MultiKeyBinding) && e != null) {
                JTextComponent.KeyBinding keyBinding = (JTextComponent.KeyBinding)e;
                list.set(n3, new MultiKeyBinding(keyBinding.key, keyBinding.actionName));
            }
            ++n3;
        }
        return new ArrayList(list);
    }

    public List getKeyBindingList() {
        ArrayList<String> arrayList = new ArrayList<String>(this.getKBList());
        arrayList.add(0, this.getKitClass().getName());
        return arrayList;
    }

    public void setKeyBindingList(List list) {
        this.setKeyBindingList(list, true);
    }

    public void setKeyBindingsDiffMap(Map map) {
        if (map != null && map.size() > 0) {
            this.updateSettings(class$org$netbeans$modules$editor$options$KeyBindingsMIMEProcessor == null ? (class$org$netbeans$modules$editor$options$KeyBindingsMIMEProcessor = BaseOptions.class$("org.netbeans.modules.editor.options.KeyBindingsMIMEProcessor")) : class$org$netbeans$modules$editor$options$KeyBindingsMIMEProcessor, map);
        }
    }

    public void setKeyBindingList(List list, boolean bl) {
        if (list.size() > 0 && (list.get(0) instanceof Class || list.get(0) instanceof String)) {
            list.remove(0);
        }
        Map map = null;
        if (bl) {
            this.loadDefaultKeyBindings();
            List list2 = this.getKeyBindingList();
            if (list2.size() > 0 && (list2.get(0) instanceof Class || list2.get(0) instanceof String)) {
                list2.remove(0);
            }
            if ((map = OptionUtilities.getMapDiff(OptionUtilities.makeKeyBindingsMap(list2), OptionUtilities.makeKeyBindingsMap(list), true)).size() > 0) {
                this.updateSettings(class$org$netbeans$modules$editor$options$KeyBindingsMIMEProcessor == null ? (class$org$netbeans$modules$editor$options$KeyBindingsMIMEProcessor = BaseOptions.class$("org.netbeans.modules.editor.options.KeyBindingsMIMEProcessor")) : class$org$netbeans$modules$editor$options$KeyBindingsMIMEProcessor, map);
            }
        }
        super.setSettingValue("key-bindings", list, KEY_BINDING_LIST_PROP);
    }

    public Map getColoringMap() {
        this.loadSettings(class$org$netbeans$modules$editor$options$FontsColorsMIMEProcessor == null ? (class$org$netbeans$modules$editor$options$FontsColorsMIMEProcessor = BaseOptions.class$("org.netbeans.modules.editor.options.FontsColorsMIMEProcessor")) : class$org$netbeans$modules$editor$options$FontsColorsMIMEProcessor);
        HashMap<Object, String> hashMap = new HashMap<Object, String>(SettingsUtil.getColoringMap(this.getKitClass(), false, true));
        hashMap.put(null, this.getKitClass().getName());
        return hashMap;
    }

    public void setColoringMap(Map map) {
        this.setColoringMap(map, true);
    }

    public void setColoringMap(Map map, boolean bl) {
        Map map2 = null;
        if (map != null) {
            if (this.inReadExternal) {
                map = UpgradeOptions.patchColorings(this.getKitClass(), map);
            }
            if (bl && (map2 = OptionUtilities.getMapDiff(this.getColoringMap(), map, false)).size() > 0) {
                this.updateSettings(class$org$netbeans$modules$editor$options$FontsColorsMIMEProcessor == null ? (class$org$netbeans$modules$editor$options$FontsColorsMIMEProcessor = BaseOptions.class$("org.netbeans.modules.editor.options.FontsColorsMIMEProcessor")) : class$org$netbeans$modules$editor$options$FontsColorsMIMEProcessor, map2);
            }
            map.remove(null);
            SettingsUtil.setColoringMap(this.getKitClass(), map, false);
            this.coloringMapInitializer = SettingsUtil.getColoringMapInitializer(this.getKitClass(), map, false, this.getTypeName() + "-coloring-map-initializer");
            this.firePropertyChange(COLORING_MAP_PROP, null, null);
        }
    }

    public int getFontSize() {
        Coloring coloring = SettingsUtil.getColoring(this.getKitClass(), "default", false);
        return coloring != null ? coloring.getFont().getSize() : SettingsDefaults.defaultFont.getSize();
    }

    public void setFontSize(int n) {
        if (n < 0) {
            NbEditorUtilities.invalidArgument("MSG_NegativeValue");
            return;
        }
        int n2 = this.getFontSize();
        Map map = SettingsUtil.getColoringMap(this.getKitClass(), false, true);
        if (map != null) {
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Coloring coloring;
                Font font;
                Map.Entry entry = iterator.next();
                Object v = entry.getValue();
                if (!(v instanceof Coloring) || (font = (coloring = (Coloring)v).getFont()) == null || font.getSize() == n) continue;
                font = font.deriveFont((float)n);
                Coloring coloring2 = new Coloring(font, coloring.getFontMode(), coloring.getForeColor(), coloring.getBackColor());
                entry.setValue(coloring2);
            }
            this.setColoringMap(map);
            this.firePropertyChange(FONT_SIZE_PROP, null, null);
        }
    }

    public float getLineHeightCorrection() {
        return ((Float)this.getSettingValue("line-height-correction")).floatValue();
    }

    public void setLineHeightCorrection(float f) {
        if (f <= 0.0f) {
            NbEditorUtilities.invalidArgument("MSG_OutOfRange");
            return;
        }
        this.setSettingValue("line-height-correction", new Float(f), LINE_HEIGHT_CORRECTION_PROP);
    }

    public Map getDefaultMacrosMap() {
        this.loadDefaultMacros();
        return this.defaultMacrosMap;
    }

    private void loadDefaultMacros() {
        if (this.defaultMacrosMap != null) {
            return;
        }
        MIMEOptionFolder mIMEOptionFolder = this.getMIMEFolder();
        if (mIMEOptionFolder == null) {
            return;
        }
        MIMEOptionFolder mIMEOptionFolder2 = mIMEOptionFolder.getFolder("Defaults");
        if (mIMEOptionFolder2 == null) {
            return;
        }
        MIMEOptionFile mIMEOptionFile = mIMEOptionFolder2.getFile(class$org$netbeans$modules$editor$options$MacrosMIMEProcessor == null ? (class$org$netbeans$modules$editor$options$MacrosMIMEProcessor = BaseOptions.class$("org.netbeans.modules.editor.options.MacrosMIMEProcessor")) : class$org$netbeans$modules$editor$options$MacrosMIMEProcessor, false);
        if (mIMEOptionFile != null && !mIMEOptionFile.isLoaded()) {
            mIMEOptionFile.loadSettings(false);
            this.defaultMacrosMap = new HashMap(mIMEOptionFile.getAllProperties());
        }
    }

    private void processMacroKeyBindings(Map map, List list) {
        ArrayList<MultiKeyBinding> arrayList = new ArrayList<MultiKeyBinding>();
        ArrayList<MultiKeyBinding> arrayList2 = new ArrayList<MultiKeyBinding>();
        List list2 = this.getKBList();
        Iterator iterator = map.keySet().iterator();
        block0: while (iterator.hasNext()) {
            MultiKeyBinding multiKeyBinding;
            int n;
            String string = (String)iterator.next();
            if (!(map.get(string) instanceof String)) continue;
            String string2 = (String)map.get(string);
            String string3 = new String("macro-" + string);
            if (string2.length() != 0) {
                n = 0;
                while (n < list.size()) {
                    if (list.get(n) instanceof MultiKeyBinding) {
                        multiKeyBinding = (MultiKeyBinding)list.get(n);
                        if (string3.equals(multiKeyBinding.actionName)) {
                            arrayList2.add(multiKeyBinding);
                            continue block0;
                        }
                    }
                    ++n;
                }
                continue;
            }
            n = 0;
            while (n < list2.size()) {
                if (list2.get(n) instanceof MultiKeyBinding) {
                    multiKeyBinding = (MultiKeyBinding)list2.get(n);
                    if (string3.equals(multiKeyBinding.actionName)) {
                        arrayList.add(multiKeyBinding);
                        continue block0;
                    }
                }
                ++n;
            }
        }
        if (arrayList.size() > 0 || arrayList2.size() > 0) {
            list2.removeAll(arrayList);
            list2.addAll(arrayList2);
            this.setKeyBindingsDiffMap(OptionUtilities.getMapDiff(OptionUtilities.makeKeyBindingsMap(this.getKBList()), OptionUtilities.makeKeyBindingsMap(list2), true));
            Settings.setValue(this.getKitClass(), "key-bindings", list2);
        }
    }

    public Map getMacroMap() {
        this.loadDefaultMacros();
        this.loadSettings(class$org$netbeans$modules$editor$options$MacrosMIMEProcessor == null ? (class$org$netbeans$modules$editor$options$MacrosMIMEProcessor = BaseOptions.class$("org.netbeans.modules.editor.options.MacrosMIMEProcessor")) : class$org$netbeans$modules$editor$options$MacrosMIMEProcessor);
        HashMap<Object, List> hashMap = new HashMap<Object, List>((Map)super.getSettingValue("macro-map"));
        hashMap.put(null, this.getKBList());
        return hashMap;
    }

    public void setMacroDiffMap(Map map) {
        if (map != null && map.size() > 0) {
            this.updateSettings(class$org$netbeans$modules$editor$options$MacrosMIMEProcessor == null ? (class$org$netbeans$modules$editor$options$MacrosMIMEProcessor = BaseOptions.class$("org.netbeans.modules.editor.options.MacrosMIMEProcessor")) : class$org$netbeans$modules$editor$options$MacrosMIMEProcessor, map);
        }
    }

    public void setMacroMap(Map map, boolean bl) {
        Map map2 = null;
        ArrayList arrayList = new ArrayList();
        if (map.containsKey(null)) {
            arrayList.addAll((List)map.get(null));
            map.remove(null);
        }
        if (bl) {
            this.loadDefaultMacros();
            map2 = OptionUtilities.getMapDiff(this.getMacroMap(), map, true);
            if (map2.containsKey(null)) {
                map2.remove(null);
            }
            if (map2.size() > 0) {
                this.processMacroKeyBindings(map2, arrayList);
                this.updateSettings(class$org$netbeans$modules$editor$options$MacrosMIMEProcessor == null ? (class$org$netbeans$modules$editor$options$MacrosMIMEProcessor = BaseOptions.class$("org.netbeans.modules.editor.options.MacrosMIMEProcessor")) : class$org$netbeans$modules$editor$options$MacrosMIMEProcessor, map2);
            }
        }
        super.setSettingValue("macro-map", map);
    }

    public void setMacroMap(Map map) {
        this.setMacroMap(map, true);
    }

    public Insets getMargin() {
        return (Insets)this.getSettingValue(MARGIN_PROP);
    }

    public void setMargin(Insets insets) {
        this.setSettingValue(MARGIN_PROP, insets, MARGIN_PROP);
    }

    public Insets getLineNumberMargin() {
        return (Insets)this.getSettingValue("line-number-margin");
    }

    public void setLineNumberMargin(Insets insets) {
        this.setSettingValue("line-number-margin", insets, LINE_NUMBER_MARGIN_PROP);
    }

    public Dimension getLineNumberMargin2() {
        Insets insets = (Insets)this.getSettingValue("line-number-margin");
        return new Dimension(insets.left, insets.right);
    }

    public void setLineNumberMargin2(Dimension dimension) {
        this.setLineNumberMargin(new Insets(0, dimension.width, 0, dimension.height));
    }

    public boolean getStatusBarVisible() {
        return this.getSettingBoolean("status-bar-visible");
    }

    public void setStatusBarVisible(boolean bl) {
        this.setSettingBoolean("status-bar-visible", bl, STATUS_BAR_VISIBLE_PROP);
    }

    public int getStatusBarCaretDelay() {
        return this.getSettingInteger("status-bar-caret-delay");
    }

    public void setStatusBarCaretDelay(int n) {
        if (n < 0) {
            NbEditorUtilities.invalidArgument("MSG_NegativeValue");
            return;
        }
        this.setSettingInteger("status-bar-caret-delay", n, STATUS_BAR_CARET_DELAY_PROP);
    }

    public boolean getFindHighlightSearch() {
        return this.getSettingBoolean("find-highlight-search");
    }

    public void setFindHighlightSearch(boolean bl) {
        this.setSettingBoolean("find-highlight-search", bl, FIND_HIGHLIGHT_SEARCH_PROP);
    }

    public boolean getFindIncSearch() {
        return this.getSettingBoolean("find-inc-search");
    }

    public void setFindIncSearch(boolean bl) {
        this.setSettingBoolean("find-inc-search", bl, FIND_INC_SEARCH_PROP);
    }

    public int getFindIncSearchDelay() {
        return this.getSettingInteger("find-inc-search-delay");
    }

    public void setFindIncSearchDelay(int n) {
        if (n < 0) {
            NbEditorUtilities.invalidArgument("MSG_NegativeValue");
            return;
        }
        this.setSettingInteger("find-inc-search-delay", n, FIND_INC_SEARCH_DELAY_PROP);
    }

    public boolean getFindWrapSearch() {
        return this.getSettingBoolean("find-wrap-search");
    }

    public void setFindWrapSearch(boolean bl) {
        this.setSettingBoolean("find-wrap-search", bl, FIND_WRAP_SEARCH_PROP);
    }

    public boolean getFindSmartCase() {
        return this.getSettingBoolean("find-smart-case");
    }

    public void setFindSmartCase(boolean bl) {
        this.setSettingBoolean("find-smart-case", bl, FIND_SMART_CASE_PROP);
    }

    public Map getFindHistory() {
        return new HashMap((Map)this.getSettingValue("find-history"));
    }

    public void setFindHistory(Map map) {
        this.setSettingValue("find-history", map, FIND_HISTORY_PROP);
    }

    public int getFindHistorySize() {
        return this.getSettingInteger("find-history-size");
    }

    public void setFindHistorySize(int n) {
        this.setSettingInteger("find-history-size", n, FIND_HISTORY_SIZE_PROP);
    }

    public Color getTextLimitLineColor() {
        this.loadSettings(class$org$netbeans$modules$editor$options$FontsColorsMIMEProcessor == null ? (class$org$netbeans$modules$editor$options$FontsColorsMIMEProcessor = BaseOptions.class$("org.netbeans.modules.editor.options.FontsColorsMIMEProcessor")) : class$org$netbeans$modules$editor$options$FontsColorsMIMEProcessor);
        return (Color)super.getSettingValue("text-limit-line-color");
    }

    public void setTextLimitLineColor(Color color) {
        this.setTextLimitLineColor(color, true);
    }

    public void setTextLimitLineColor(Color color, boolean bl) {
        if (bl && !this.getTextLimitLineColor().equals(color) && color != null) {
            HashMap<String, Color> hashMap = new HashMap<String, Color>();
            hashMap.put("text-limit-line-color", color);
            if (hashMap != null) {
                this.updateSettings(class$org$netbeans$modules$editor$options$FontsColorsMIMEProcessor == null ? (class$org$netbeans$modules$editor$options$FontsColorsMIMEProcessor = BaseOptions.class$("org.netbeans.modules.editor.options.FontsColorsMIMEProcessor")) : class$org$netbeans$modules$editor$options$FontsColorsMIMEProcessor, hashMap);
            }
        }
        super.setSettingValue("text-limit-line-color", color, TEXT_LIMIT_LINE_COLOR_PROP);
    }

    public int getTextLimitWidth() {
        return this.getSettingInteger("text-limit-width");
    }

    public void setTextLimitWidth(int n) {
        if (n <= 0) {
            NbEditorUtilities.invalidArgument("MSG_OutOfRange");
            return;
        }
        this.setSettingInteger("text-limit-width", n, TEXT_LIMIT_WIDTH_PROP);
    }

    public boolean getTextLimitLineVisible() {
        return this.getSettingBoolean("text-limit-line-visible");
    }

    public void setTextLimitLineVisible(boolean bl) {
        this.setSettingBoolean("text-limit-line-visible", bl, TEXT_LIMIT_LINE_VISIBLE_PROP);
    }

    public boolean getHighlightMatchingBracket() {
        return this.getSettingBoolean("highlight-match-brace");
    }

    public void setHighlightMatchingBracket(boolean bl) {
        this.setSettingBoolean("highlight-match-brace", bl, HIGHLIGHT_MATCHING_BRACKET_PROP);
    }

    public boolean getHighlightCaretRow() {
        return this.getSettingBoolean("highlight-caret-row");
    }

    public void setHighlightCaretRow(boolean bl) {
        this.setSettingBoolean("highlight-caret-row", bl, HIGHLIGHT_CARET_ROW_PROP);
    }

    public boolean isToolbarVisible() {
        return this.getSettingBoolean(TOOLBAR_VISIBLE_PROP);
    }

    public void setToolbarVisible(boolean bl) {
        this.setSettingBoolean(TOOLBAR_VISIBLE_PROP, bl, TOOLBAR_VISIBLE_PROP);
    }

    public void initPopupMenuItems() {
        MultiPropertyFolder multiPropertyFolder;
        MIMEOptionFolder mIMEOptionFolder;
        if (!BASE.equals(this.getTypeName()) && (mIMEOptionFolder = this.getMIMEFolder()) != null && (multiPropertyFolder = mIMEOptionFolder.getMPFolder("Popup", false)) != null) {
            DataFolder dataFolder = multiPropertyFolder.getDataFolder();
            ArrayList arrayList = new ArrayList();
            Enumeration enumeration = dataFolder.getPrimaryFile().getAttributes();
            while (enumeration.hasMoreElements()) {
                arrayList.add(enumeration.nextElement());
            }
            if (multiPropertyFolder.getProperties().size() != 0 || arrayList.size() != 0) {
                HashSet hashSet = new HashSet(OptionUtilities.getGlobalPopupMenuItems());
                hashSet.addAll(multiPropertyFolder.getProperties());
                HashSet hashSet2 = new HashSet(OptionUtilities.getGlobalPopupAttribs());
                hashSet2.addAll(arrayList);
                List list = OptionUtilities.arrangeMergedPopup(hashSet, hashSet2);
                super.setSettingValue("popup-menu-action-name-list", list);
                return;
            }
        }
    }

    public IndentEngine getIndentEngine() {
        Object object;
        MIMEOptionFolder mIMEOptionFolder;
        if (this.inReadExternal) {
            return this.readExternalIndentEngine;
        }
        if (!BASE.equals(this.getTypeName())) {
            Map map;
            Object v;
            this.loadSettings(class$org$netbeans$modules$editor$options$PropertiesMIMEProcessor == null ? (class$org$netbeans$modules$editor$options$PropertiesMIMEProcessor = BaseOptions.class$("org.netbeans.modules.editor.options.PropertiesMIMEProcessor")) : class$org$netbeans$modules$editor$options$PropertiesMIMEProcessor);
            mIMEOptionFolder = this.getMIMEFolder();
            if (mIMEOptionFolder != null && (object = mIMEOptionFolder.getFile(class$org$netbeans$modules$editor$options$PropertiesMIMEProcessor == null ? (class$org$netbeans$modules$editor$options$PropertiesMIMEProcessor = BaseOptions.class$("org.netbeans.modules.editor.options.PropertiesMIMEProcessor")) : class$org$netbeans$modules$editor$options$PropertiesMIMEProcessor, false)) != null && (v = (map = ((MIMEOptionFile)object).getAllProperties()).get(INDENT_ENGINE_PROP)) instanceof String) {
                Object object2 = null;
                String string = (String)v;
                if (string.equals(NO_INDENT_ENGINE)) {
                    return IndentEngine.getDefault();
                }
                Lookup.Template template = new Lookup.Template(null, string, null);
                Lookup.Item item = Lookup.getDefault().lookupItem(template);
                if (item != null && (object2 = item.getInstance()) instanceof IndentEngine) {
                    return (IndentEngine)object2;
                }
            }
        }
        if ((object = this.getProperty(INDENT_ENGINE_PROP)) instanceof ServiceType.Handle) {
            mIMEOptionFolder = (IndentEngine)((ServiceType.Handle)object).getServiceType();
            if (mIMEOptionFolder != null) {
                this.setIndentEngine((IndentEngine)mIMEOptionFolder);
                return mIMEOptionFolder;
            }
        } else if (object instanceof IndentEngine) {
            this.setIndentEngine((IndentEngine)object);
            return (IndentEngine)object;
        }
        if ((mIMEOptionFolder = this.findDefaultIndentEngine()) != null) {
            this.setIndentEngine((IndentEngine)mIMEOptionFolder);
        }
        return mIMEOptionFolder;
    }

    public void setIndentEngine(IndentEngine indentEngine) {
        if (!this.inReadExternal) {
            Object object;
            String string = null;
            if (indentEngine != null) {
                object = new Lookup.Template(null, null, (Object)indentEngine);
                Lookup.Item item = Lookup.getDefault().lookupItem((Lookup.Template)object);
                if (item != null) {
                    string = item.getId();
                }
            }
            if (!BASE.equals(this.getTypeName())) {
                object = new HashMap();
                if (string == null) {
                    string = NO_INDENT_ENGINE;
                }
                object.put(INDENT_ENGINE_PROP, string);
                this.updateSettings(class$org$netbeans$modules$editor$options$PropertiesMIMEProcessor == null ? (class$org$netbeans$modules$editor$options$PropertiesMIMEProcessor = BaseOptions.class$("org.netbeans.modules.editor.options.PropertiesMIMEProcessor")) : class$org$netbeans$modules$editor$options$PropertiesMIMEProcessor, (Map)object, false);
            }
            this.refreshIndentEngineSettings();
        }
    }

    private void refreshIndentEngineSettings() {
        RequestProcessor.postRequest((Runnable)new Runnable(){

            public void run() {
                Settings.touchValue(BaseOptions.this.getKitClass(), BaseOptions.INDENT_ENGINE_PROP);
                Settings.touchValue(BaseOptions.this.getKitClass(), "formatter");
            }
        });
    }

    protected Class getDefaultIndentEngineClass() {
        return class$org$netbeans$modules$editor$SimpleIndentEngine == null ? (class$org$netbeans$modules$editor$SimpleIndentEngine = BaseOptions.class$("org.netbeans.modules.editor.SimpleIndentEngine")) : class$org$netbeans$modules$editor$SimpleIndentEngine;
    }

    private IndentEngine findDefaultIndentEngine() {
        ServiceType.Registry registry;
        Enumeration enumeration;
        if (this.getDefaultIndentEngineClass() != null && (enumeration = (registry = TopManager.getDefault().getServices()).services(this.getDefaultIndentEngineClass())).hasMoreElements()) {
            return (IndentEngine)enumeration.nextElement();
        }
        return null;
    }

    public void setOptionsVersion(int n) {
        int n2 = this.optionsVersion;
        this.optionsVersion = n;
        if (n != n2) {
            this.firePropertyChange(OPTIONS_VERSION_PROP, new Integer(n2), new Integer(n));
        }
    }

    public int getOptionsVersion() {
        return this.optionsVersion;
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.readExternalIndentEngine = this.getIndentEngine();
        this.inReadExternal = true;
        this.optionsVersion = 0;
        try {
            try {
                super.readExternal(objectInput);
            }
            catch (OptionalDataException optionalDataException) {
                Object var4_3 = null;
                this.refreshIndentEngineSettings();
                if (this.optionsVersion < 21) {
                    this.upgradeOptions(this.optionsVersion, 21);
                }
                this.optionsVersion = 21;
                this.inReadExternal = false;
                this.readExternalIndentEngine = null;
            }
            Object var4_2 = null;
            this.refreshIndentEngineSettings();
            if (this.optionsVersion < 21) {
                this.upgradeOptions(this.optionsVersion, 21);
            }
            this.optionsVersion = 21;
            this.inReadExternal = false;
            this.readExternalIndentEngine = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.refreshIndentEngineSettings();
            if (this.optionsVersion < 21) {
                this.upgradeOptions(this.optionsVersion, 21);
            }
            this.optionsVersion = 21;
            this.inReadExternal = false;
            this.readExternalIndentEngine = null;
            throw throwable;
        }
    }

    protected void upgradeOptions(int n, int n2) {
        UpgradeOptions.upgradeOptions(this, n, n2);
    }

    private void loadSettings(Class clazz) {
        MIMEOptionFile mIMEOptionFile;
        if (BASE.equals(this.getTypeName())) {
            MIMEOptionFolder mIMEOptionFolder = AllOptionsFolder.getDefault().getMIMEFolder();
            if (mIMEOptionFolder == null) {
                return;
            }
            mIMEOptionFile = mIMEOptionFolder.getFile(clazz, false);
        } else {
            MIMEOptionFolder mIMEOptionFolder = this.getMIMEFolder();
            if (mIMEOptionFolder == null) {
                return;
            }
            mIMEOptionFile = mIMEOptionFolder.getFile(clazz, false);
        }
        if (mIMEOptionFile != null && !mIMEOptionFile.isLoaded()) {
            mIMEOptionFile.loadSettings();
        }
    }

    private void updateSettings(Class clazz, Map map) {
        this.updateSettings(clazz, map, true);
    }

    private void updateSettings(Class clazz, Map map, boolean bl) {
        MIMEOptionFile mIMEOptionFile;
        MIMEOptionFolder mIMEOptionFolder;
        if (BASE.equals(this.getTypeName())) {
            mIMEOptionFolder = AllOptionsFolder.getDefault().getMIMEFolder();
            if (mIMEOptionFolder == null) {
                return;
            }
            mIMEOptionFile = mIMEOptionFolder.getFile(clazz, true);
        } else {
            mIMEOptionFolder = this.getMIMEFolder();
            if (mIMEOptionFolder == null) {
                return;
            }
            mIMEOptionFile = mIMEOptionFolder.getFile(clazz, true);
        }
        final Map map2 = map;
        final MIMEOptionFile mIMEOptionFile2 = mIMEOptionFile;
        if (mIMEOptionFile2 != null) {
            if (bl) {
                RequestProcessor.postRequest((Runnable)new Runnable(){

                    public void run() {
                        mIMEOptionFile2.updateSettings(map2);
                    }
                });
            } else {
                mIMEOptionFile2.updateSettings(map2);
            }
        } else {
            System.err.println("!!!!!!!!!!!!!!!!!!!!!!!!" + clazz.toString() + " type file haven't been found in folder:" + mIMEOptionFolder.getDataFolder());
        }
    }

    public void setSettingValue(String string, Object object) {
        this.setSettingValue(string, object, string);
    }

    private boolean isTheSame(String string, Object object) {
        if (string == null || string.equals(INDENT_ENGINE_PROP) || string.equals("formatter")) {
            return true;
        }
        Object object2 = this.getSettingValue(string);
        return object2 == null && object == null || object2 != null && object2.equals(object);
    }

    public void setSettingValue(String string, Object object, String string2) {
        if (!this.isTheSame(string, object)) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put(string, object);
            this.updateSettings(class$org$netbeans$modules$editor$options$PropertiesMIMEProcessor == null ? (class$org$netbeans$modules$editor$options$PropertiesMIMEProcessor = BaseOptions.class$("org.netbeans.modules.editor.options.PropertiesMIMEProcessor")) : class$org$netbeans$modules$editor$options$PropertiesMIMEProcessor, hashMap);
        }
        super.setSettingValue(string, object, string2);
    }

    public Object getSettingValue(String string) {
        this.loadSettings(class$org$netbeans$modules$editor$options$PropertiesMIMEProcessor == null ? (class$org$netbeans$modules$editor$options$PropertiesMIMEProcessor = BaseOptions.class$("org.netbeans.modules.editor.options.PropertiesMIMEProcessor")) : class$org$netbeans$modules$editor$options$PropertiesMIMEProcessor);
        return super.getSettingValue(string);
    }

    protected final void setSettingBoolean(String string, boolean bl, String string2) {
        this.setSettingValue(string, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    protected final void setSettingInteger(String string, int n, String string2) {
        this.setSettingValue(string, new Integer(n));
    }

    protected void loadXMLSettings() {
        this.getKeyBindingList();
        this.getAbbrevMap();
        this.getMacroMap();
        this.loadSettings(class$org$netbeans$modules$editor$options$FontsColorsMIMEProcessor == null ? (class$org$netbeans$modules$editor$options$FontsColorsMIMEProcessor = BaseOptions.class$("org.netbeans.modules.editor.options.FontsColorsMIMEProcessor")) : class$org$netbeans$modules$editor$options$FontsColorsMIMEProcessor);
        this.loadSettings(class$org$netbeans$modules$editor$options$PropertiesMIMEProcessor == null ? (class$org$netbeans$modules$editor$options$PropertiesMIMEProcessor = BaseOptions.class$("org.netbeans.modules.editor.options.PropertiesMIMEProcessor")) : class$org$netbeans$modules$editor$options$PropertiesMIMEProcessor);
    }

    public void writeExternal() throws IOException {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

