/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.SoftReference;
import java.util.AbstractCollection;
import java.util.HashSet;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.netbeans.modules.properties.FindPanel;
import org.netbeans.modules.properties.PropertiesTableCellEditor;
import org.netbeans.modules.properties.PropertiesTableModel;
import org.netbeans.modules.properties.TableViewSettingsFactory;
import org.openide.DialogDescriptor;
import org.openide.TopManager;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListener;
import org.openide.util.actions.ActionPerformer;
import org.openide.util.actions.SystemAction;

public class FindPerformer
implements ActionPerformer {
    private JTable table;
    private String findString;
    private int[] searchValues;
    private boolean highlightSearch = true;
    private boolean matchCaseSearch = false;
    private boolean backwardSearch = false;
    private boolean wrapSearch = true;
    private boolean rowSearch = true;
    private final ActionListener findNextActionListener;
    private final ActionListener findPreviousActionListener;
    private final ActionListener toggleHighlightListener;
    private final PropertyChangeListener settingsListener;
    private HashSet history = new HashSet();
    private TableViewSettingsFactory.TableViewSettings settings;
    private static SoftReference softRef;
    private static JDialog findDialog;
    public static final String TABLE_SEARCH_RESULT = "table.search.result";
    static /* synthetic */ Class class$org$netbeans$modules$properties$FindPerformer;

    private FindPerformer(JTable jTable) {
        this.findNextActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (FindPerformer.this.searchValues != null) {
                    1 var2_2 = this;
                    synchronized (var2_2) {
                        FindPerformer.this.backwardSearch = false;
                        FindPerformer.this.performSearch();
                    }
                }
            }
        };
        this.findPreviousActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (FindPerformer.this.searchValues != null) {
                    2 var2_2 = this;
                    synchronized (var2_2) {
                        FindPerformer.this.backwardSearch = true;
                        FindPerformer.this.performSearch();
                    }
                }
            }
        };
        this.toggleHighlightListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FindPerformer.this.highlightSearch = !FindPerformer.this.highlightSearch;
                FindPerformer.this.table.repaint();
            }
        };
        this.table = jTable;
        this.settingsListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                FindPerformer.this.registerKeyStrokes();
            }
        };
        this.settings = TableViewSettingsFactory.getTableViewSettings();
        this.settings.addPropertyChangeListener(WeakListener.propertyChange((PropertyChangeListener)this.settingsListener, (Object)this.settings));
        this.registerKeyStrokes();
    }

    public static FindPerformer getFindPerformer(JTable jTable) {
        Object object;
        if (softRef != null && (object = softRef.get()) != null) {
            FindPerformer findPerformer = (FindPerformer)object;
            if (!findPerformer.validateTable(jTable)) {
                findPerformer.resetTable(jTable);
                findPerformer.registerKeyStrokes();
            }
            return findPerformer;
        }
        object = new FindPerformer(jTable);
        softRef = new SoftReference(object);
        return object;
    }

    private void resetTable(JTable jTable) {
        this.table = jTable;
    }

    private boolean validateTable(JTable jTable) {
        return this.table != null && this.table.equals(jTable);
    }

    private synchronized void registerKeyStrokes() {
        KeyStroke[] keyStrokeArray = this.settings.getKeyStrokesFindNext();
        int n = 0;
        while (n < keyStrokeArray.length) {
            this.table.registerKeyboardAction(this.findNextActionListener, keyStrokeArray[n], 2);
            ++n;
        }
        keyStrokeArray = this.settings.getKeyStrokesFindPrevious();
        int n2 = 0;
        while (n2 < keyStrokeArray.length) {
            this.table.registerKeyboardAction(this.findPreviousActionListener, keyStrokeArray[n2], 2);
            ++n2;
        }
        keyStrokeArray = this.settings.getKeyStrokesToggleHighlight();
        int n3 = 0;
        while (n3 < keyStrokeArray.length) {
            this.table.registerKeyboardAction(this.toggleHighlightListener, keyStrokeArray[n3], 2);
            ++n3;
        }
    }

    public String getFindString() {
        return this.findString;
    }

    public boolean isHighlightSearch() {
        return this.highlightSearch;
    }

    public void performAction(SystemAction systemAction) {
        if (findDialog == null) {
            this.createFindDialog();
        } else {
            ((Component)findDialog).setVisible(true);
            findDialog.requestFocus();
        }
    }

    private void createFindDialog() {
        final JDialog[] jDialogArray = new JDialog[1];
        final FindPanel findPanel = new FindPanel();
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)findPanel, NbBundle.getBundle((Class)(class$org$netbeans$modules$properties$FindPerformer == null ? (class$org$netbeans$modules$properties$FindPerformer = FindPerformer.class$("org.netbeans.modules.properties.FindPerformer")) : class$org$netbeans$modules$properties$FindPerformer)).getString("LBL_Title"), false, (Object[])new JButton[0], null, 0, null, null);
        jDialogArray[0] = (JDialog)TopManager.getDefault().createDialog(dialogDescriptor);
        findDialog = jDialogArray[0];
        jDialogArray[0].getRootPane().setDefaultButton(findPanel.getButtons()[0]);
        findPanel.getButtons()[0].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FindPerformer.this.findString = ((JTextField)findPanel.getComboBox().getEditor().getEditorComponent()).getText();
                FindPerformer.this.highlightSearch = findPanel.getHighlightCheck().isSelected();
                FindPerformer.this.matchCaseSearch = findPanel.getMatchCaseCheck().isSelected();
                FindPerformer.this.backwardSearch = findPanel.getBackwardCheck().isSelected();
                FindPerformer.this.wrapSearch = findPanel.getWrapCheck().isSelected();
                FindPerformer.this.rowSearch = findPanel.getRowCheck().isSelected();
                ((Component)jDialogArray[0]).setVisible(false);
                jDialogArray[0].dispose();
                findDialog = null;
                if (FindPerformer.this.findString != null && !FindPerformer.this.findString.trim().equals("")) {
                    FindPerformer.this.history.add(FindPerformer.this.findString.intern());
                    FindPerformer.this.performSearch();
                }
                FindPerformer.this.table.repaint();
            }
        });
        findPanel.getButtons()[1].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((Component)jDialogArray[0]).setVisible(false);
                jDialogArray[0].dispose();
                findDialog = null;
            }
        });
        findPanel.getHighlightCheck().setSelected(this.highlightSearch);
        findPanel.getMatchCaseCheck().setSelected(this.matchCaseSearch);
        findPanel.getBackwardCheck().setSelected(this.backwardSearch);
        findPanel.getWrapCheck().setSelected(this.wrapSearch);
        findPanel.getRowCheck().setSelected(this.rowSearch);
        findPanel.getComboBox().setModel(new DefaultComboBoxModel<Object>(((AbstractCollection)this.history).toArray()));
        if (this.findString != null) {
            findPanel.getComboBox().setSelectedItem(this.findString);
        }
        findPanel.getComboBox().requestFocus();
        ((Component)jDialogArray[0]).setVisible(true);
    }

    public void closeFindDialog() {
        if (findDialog != null) {
            JDialog jDialog = findDialog;
            synchronized (jDialog) {
                ((Component)findDialog).setVisible(false);
                findDialog.dispose();
                findDialog = null;
            }
        }
    }

    private void prepareSearch() {
        int n = this.table.getSelectedRow();
        int n2 = this.table.getSelectedColumn();
        if (this.searchValues != null && n == this.searchValues[0] && n2 == this.searchValues[1]) {
            return;
        }
        if (n != -1 || n2 != -1) {
            int n3;
            int n4 = n3 = ((JTextField)((PropertiesTableCellEditor)this.table.getCellEditor(n, n2)).getComponent()).getCaretPosition();
            this.searchValues = new int[]{n, n2, n4, n3};
        } else if (this.backwardSearch) {
            int n5;
            int n6 = this.table.getRowCount() - 1;
            int n7 = this.table.getColumnCount() - 1;
            int n8 = n5 = ((PropertiesTableModel.StringPair)this.table.getValueAt(n6, n7)).getValue().length() - 1;
            this.searchValues = new int[]{n6, n7, n8, n5};
        } else {
            this.searchValues = new int[]{0, 0, 0, 0};
        }
    }

    private synchronized void performSearch() {
        this.prepareSearch();
        RequestProcessor.postRequest((Runnable)new Runnable(){

            public void run() {
                boolean bl = false;
                do {
                    int[] nArray = FindPerformer.this.search(FindPerformer.this.searchValues[0], FindPerformer.this.searchValues[1], FindPerformer.this.backwardSearch ? FindPerformer.this.searchValues[2] - 1 : FindPerformer.this.searchValues[3]);
                    if (FindPerformer.this.wrapSearch && !bl && nArray == null) {
                        if (FindPerformer.this.backwardSearch) {
                            int n = FindPerformer.this.table.getRowCount() - 1;
                            int n2 = FindPerformer.this.table.getColumnCount() - 1;
                            FindPerformer.access$002(FindPerformer.this, new int[]{n, n2, ((PropertiesTableModel.StringPair)FindPerformer.this.table.getValueAt(n, n2)).getValue().length() - 1, 0});
                        } else {
                            FindPerformer.access$002(FindPerformer.this, new int[]{0, 0, 0, 0});
                        }
                        bl = true;
                        continue;
                    }
                    if (nArray != null) {
                        FindPerformer.access$002(FindPerformer.this, nArray);
                        SwingUtilities.invokeLater(new Runnable(this, nArray){
                            private final /* synthetic */ int[] val$result;
                            private final /* synthetic */ 7 this$1;
                            {
                                this.this$1 = var1_1;
                                this.val$result = nArray;
                            }

                            public void run() {
                                Rectangle rectangle;
                                if (FindPerformer.access$400(7.access$1300(this.this$1)).getAutoscrolls() && (rectangle = FindPerformer.access$400(7.access$1300(this.this$1)).getCellRect(this.val$result[0], this.val$result[1], false)) != null) {
                                    FindPerformer.access$400(7.access$1300(this.this$1)).scrollRectToVisible(rectangle);
                                }
                                FindPerformer.access$400(7.access$1300(this.this$1)).getColumnModel().getSelectionModel().setSelectionInterval(this.val$result[1], this.val$result[1]);
                                FindPerformer.access$400(7.access$1300(this.this$1)).getSelectionModel().setSelectionInterval(this.val$result[0], this.val$result[0]);
                                FindPerformer.access$400(7.access$1300(this.this$1)).editCellAt(this.val$result[0], this.val$result[1]);
                            }
                        });
                    }
                    FindPerformer.access$002(FindPerformer.this, nArray);
                    bl = false;
                } while (bl);
            }

            static /* synthetic */ FindPerformer access$1300(7 var0) {
                return var0.FindPerformer.this;
            }
        });
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private int[] search(int n, int n2, int n3) {
        boolean bl;
        boolean bl2 = true;
        int n4 = this.rowSearch ? n : n2;
        boolean bl3 = true;
        do {
            if (!bl3 || (bl3 = false) || !true) {
                boolean bl4;
                int n5 = this.rowSearch ? n2 : n;
                boolean bl5 = true;
                do {
                    if (!bl5 || (bl5 = false) || !true) {
                        int n6;
                        int n7 = this.rowSearch ? n4 : n5;
                        String string = ((PropertiesTableModel.StringPair)this.table.getValueAt(n7, n6 = this.rowSearch ? n5 : n4)).toString();
                        if (string != null && string.length() >= this.findString.length()) {
                            int n8;
                            if (!bl2) {
                                int n9 = n3 = this.backwardSearch ? string.length() - this.findString.length() : 0;
                            }
                            if ((n8 = this.containsFindString(string, n3)) >= 0) {
                                this.table.putClientProperty(TABLE_SEARCH_RESULT, new int[]{n7, n6, n8, n8 + this.findString.length()});
                                return new int[]{n7, n6, n8, n8 + this.findString.length()};
                            }
                            if (bl2) {
                                bl2 = false;
                            }
                        }
                        int n10 = n5 = this.backwardSearch ? n5 - 1 : n5 + 1;
                    }
                    if (this.backwardSearch) {
                        if (n5 >= 0) {
                            bl4 = true;
                            continue;
                        }
                        bl4 = false;
                        continue;
                    }
                    bl4 = n5 < (this.rowSearch ? this.table.getColumnCount() : this.table.getRowCount());
                } while (bl4);
                if (this.rowSearch) {
                    n2 = this.backwardSearch ? this.table.getColumnCount() - 1 : 0;
                } else {
                    n = this.backwardSearch ? this.table.getRowCount() - 1 : 0;
                }
                int n11 = n4 = this.backwardSearch ? n4 - 1 : n4 + 1;
            }
            if (this.backwardSearch) {
                if (n4 < 0) return null;
                bl = true;
                continue;
            }
            if (n4 >= (this.rowSearch ? this.table.getRowCount() : this.table.getColumnCount())) return null;
            bl = true;
        } while (bl);
        return null;
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private int containsFindString(String string, int n) {
        boolean bl;
        if (n < 0) return -1;
        if (n >= string.length()) {
            return -1;
        }
        int n2 = n;
        boolean bl2 = true;
        do {
            if (!bl2 || (bl2 = false) || !true) {
                if (this.findString.regionMatches(!this.matchCaseSearch, 0, string, n2, this.findString.length())) {
                    return n2;
                }
                int n3 = n2 = this.backwardSearch ? n2 - 1 : n2 + 1;
            }
            if (this.backwardSearch) {
                if (n2 < 0) return -1;
                bl = true;
                continue;
            }
            if (n2 >= string.length() - this.findString.length() + 1) return -1;
            bl = true;
        } while (bl);
        return -1;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ int[] access$002(FindPerformer findPerformer, int[] nArray) {
        findPerformer.searchValues = nArray;
        return nArray;
    }
}

