/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.TreeSet;
import org.netbeans.modules.properties.Element;
import org.netbeans.modules.properties.KeyComparator;
import org.netbeans.modules.properties.KeyNode;
import org.netbeans.modules.properties.PresentableFileEntry;
import org.netbeans.modules.properties.PropertiesDataObject;
import org.netbeans.modules.properties.PropertiesEditorSupport;
import org.netbeans.modules.properties.PropertiesLocaleNode;
import org.netbeans.modules.properties.PropertiesStructure;
import org.netbeans.modules.properties.PropertyBundleEvent;
import org.netbeans.modules.properties.PropertyBundleListener;
import org.netbeans.modules.properties.StructHandler;
import org.netbeans.modules.properties.Util;
import org.netbeans.modules.properties.WeakListenerPropertyBundle;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.Children;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class PropertiesFileEntry
extends PresentableFileEntry
implements CookieSet.Factory {
    private String basicName;
    private transient StructHandler propStruct;
    private transient PropertiesEditorSupport editorSupport;
    static final long serialVersionUID = -3882240297814143015L;
    static /* synthetic */ Class class$org$netbeans$modules$properties$PropertiesEditorSupport;
    static /* synthetic */ Class class$org$netbeans$modules$properties$PropertiesOpen;
    static /* synthetic */ Class class$org$netbeans$modules$properties$PropertiesDataLoader;
    static /* synthetic */ Class class$org$netbeans$modules$properties$PropertiesFileEntry;

    PropertiesFileEntry(MultiDataObject multiDataObject, FileObject fileObject) {
        super(multiDataObject, fileObject);
        FileObject fileObject2 = this.getDataObject().getPrimaryFile();
        this.basicName = fileObject2 == null ? this.getFile().getName() : fileObject2.getName();
        this.getCookieSet().add(class$org$netbeans$modules$properties$PropertiesEditorSupport == null ? (class$org$netbeans$modules$properties$PropertiesEditorSupport = PropertiesFileEntry.class$("org.netbeans.modules.properties.PropertiesEditorSupport")) : class$org$netbeans$modules$properties$PropertiesEditorSupport, (CookieSet.Factory)this);
    }

    public FileObject copy(FileObject fileObject, String string) throws IOException {
        String string2 = ((PropertiesDataObject)this.getDataObject()).getPasteSuffix();
        if (string2 == null) {
            return super.copy(fileObject, string);
        }
        FileObject fileObject2 = this.getFile();
        String string3 = this.getDataObject().getPrimaryFile().getName();
        String string4 = string3 + string2 + Util.getLocalePartOfFileName((MultiDataObject.Entry)this);
        return fileObject2.copy(fileObject, string4, fileObject2.getExt());
    }

    public void delete() throws IOException {
        this.getHandler().stopParsing();
        try {
            super.delete();
            Object var2_1 = null;
            this.getHandler().allowParsing();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.getHandler().allowParsing();
            throw throwable;
        }
    }

    public FileObject move(FileObject fileObject, String string) throws IOException {
        FileObject fileObject2;
        String string2 = ((PropertiesDataObject)this.getDataObject()).getPasteSuffix();
        if (string2 == null) {
            return super.move(fileObject, string);
        }
        FileObject fileObject3 = this.getFile();
        FileLock fileLock = this.takeLock();
        try {
            String string3 = this.getDataObject().getPrimaryFile().getName();
            String string4 = string3 + string2 + Util.getLocalePartOfFileName((MultiDataObject.Entry)this);
            fileObject2 = fileObject3.move(fileLock, fileObject, string4, fileObject3.getExt());
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            fileLock.releaseLock();
            throw throwable;
        }
        fileLock.releaseLock();
        return fileObject2;
    }

    public Node.Cookie createCookie(Class clazz) {
        if (clazz.isAssignableFrom(class$org$netbeans$modules$properties$PropertiesEditorSupport == null ? (class$org$netbeans$modules$properties$PropertiesEditorSupport = PropertiesFileEntry.class$("org.netbeans.modules.properties.PropertiesEditorSupport")) : class$org$netbeans$modules$properties$PropertiesEditorSupport)) {
            return this.getPropertiesEditor();
        }
        return null;
    }

    protected Node createNodeDelegate() {
        return new PropertiesLocaleNode(this);
    }

    public Children getChildren() {
        return new PropKeysChildren();
    }

    public StructHandler getHandler() {
        if (this.propStruct == null) {
            this.propStruct = new StructHandler(this);
        }
        return this.propStruct;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    protected PropertiesEditorSupport getPropertiesEditor() {
        this.getDataObject().getCookie(class$org$netbeans$modules$properties$PropertiesOpen == null ? (class$org$netbeans$modules$properties$PropertiesOpen = PropertiesFileEntry.class$("org.netbeans.modules.properties.PropertiesOpen")) : class$org$netbeans$modules$properties$PropertiesOpen);
        if (this.editorSupport == null) {
            PropertiesFileEntry propertiesFileEntry = this;
            synchronized (propertiesFileEntry) {
                if (this.editorSupport == null) {
                    this.editorSupport = new PropertiesEditorSupport(this);
                }
            }
        }
        return this.editorSupport;
    }

    public FileObject rename(String string) throws IOException {
        if (!this.getFile().getName().startsWith(this.basicName)) {
            throw new IllegalStateException("Resource Bundles: error in Properties loader/rename.");
        }
        FileObject fileObject = super.rename(string + this.getFile().getName().substring(this.basicName.length()));
        this.basicName = string;
        return fileObject;
    }

    public FileObject renameEntry(String string) throws IOException {
        if (!this.getFile().getName().startsWith(this.basicName)) {
            throw new IllegalStateException("Resource Bundles: error in Properties loader / rename");
        }
        if (this.basicName.equals(this.getFile().getName())) {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getBundle((Class)(class$org$netbeans$modules$properties$PropertiesDataLoader == null ? (class$org$netbeans$modules$properties$PropertiesDataLoader = PropertiesFileEntry.class$("org.netbeans.modules.properties.PropertiesDataLoader")) : class$org$netbeans$modules$properties$PropertiesDataLoader)).getString("MSG_AttemptToRenamePrimaryFile"), 0);
            TopManager.getDefault().notify((NotifyDescriptor)message);
            return this.getFile();
        }
        FileObject fileObject = super.rename(string);
        ((PropertiesDataObject)this.getDataObject()).getBundleStructure().oneFileChanged(this.getHandler());
        return fileObject;
    }

    public FileObject createFromTemplate(FileObject fileObject, String string) throws IOException {
        String string2;
        ResourceBundle resourceBundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$properties$PropertiesFileEntry == null ? (class$org$netbeans$modules$properties$PropertiesFileEntry = PropertiesFileEntry.class$("org.netbeans.modules.properties.PropertiesFileEntry")) : class$org$netbeans$modules$properties$PropertiesFileEntry));
        if (!this.getFile().getName().startsWith(this.basicName)) {
            throw new IllegalStateException("Resource Bundles: error in Properties createFromTemplate");
        }
        String string3 = this.getFile().getName().substring(this.basicName.length());
        String string4 = string + string3;
        FileObject fileObject2 = fileObject.getFileObject(string4, string2 = this.getFile().getExt());
        if (fileObject2 == null) {
            return super.createFromTemplate(fileObject, string4);
        }
        String string5 = resourceBundle.getString("OPT_leave_alone");
        String string6 = resourceBundle.getString("OPT_concatenate");
        String string7 = resourceBundle.getString("OPT_overwrite");
        String string8 = resourceBundle.getString("LBL_ask_how_to_template");
        String string9 = MessageFormat.format(resourceBundle.getString("MSG_ask_how_to_template"), string4);
        NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)string9, string8, -1, 3, new Object[]{string6, string5, string7}, (Object)string6);
        Object object = TopManager.getDefault().notify(notifyDescriptor);
        if (string5.equals(object) || NotifyDescriptor.CLOSED_OPTION.equals(object)) {
            return fileObject2;
        }
        if (string6.equals(object)) {
            byte[] byArray;
            int n;
            OutputStream outputStream;
            InputStream inputStream;
            byte[] byArray2 = new byte[4096];
            FileLock fileLock = fileObject2.lock();
            try {
                inputStream = fileObject2.getInputStream();
                try {
                    outputStream = new ByteArrayOutputStream((int)fileObject2.getSize());
                    try {
                        while ((n = inputStream.read(byArray2)) != -1) {
                            ((ByteArrayOutputStream)outputStream).write(byArray2, 0, n);
                        }
                        Object var22_20 = null;
                        byArray = ((ByteArrayOutputStream)outputStream).toByteArray();
                    }
                    catch (Throwable throwable) {
                        Object var22_21 = null;
                        byte[] byArray3 = ((ByteArrayOutputStream)outputStream).toByteArray();
                        ((ByteArrayOutputStream)outputStream).close();
                        throw throwable;
                    }
                    ((ByteArrayOutputStream)outputStream).close();
                    Object var24_27 = null;
                }
                catch (Throwable throwable) {
                    Object var24_28 = null;
                    inputStream.close();
                    throw throwable;
                }
                inputStream.close();
                fileObject2.delete(fileLock);
                Object var26_30 = null;
            }
            catch (Throwable throwable) {
                Object var26_31 = null;
                fileLock.releaseLock();
                throw throwable;
            }
            fileLock.releaseLock();
            inputStream = fileObject.createData(string4, string2);
            fileLock = inputStream.lock();
            try {
                outputStream = inputStream.getOutputStream(fileLock);
                try {
                    outputStream.write(byArray);
                    InputStream inputStream2 = this.getFile().getInputStream();
                    try {
                        while ((n = inputStream2.read(byArray2)) != -1) {
                            outputStream.write(byArray2, 0, n);
                        }
                        Object var28_33 = null;
                    }
                    catch (Throwable throwable) {
                        Object var28_34 = null;
                        inputStream2.close();
                        throw throwable;
                    }
                    inputStream2.close();
                    Object var30_36 = null;
                }
                catch (Throwable throwable) {
                    Object var30_37 = null;
                    outputStream.close();
                    throw throwable;
                }
                outputStream.close();
                Object var32_39 = null;
            }
            catch (Throwable throwable) {
                Object var32_40 = null;
                fileLock.releaseLock();
                throw throwable;
            }
            fileLock.releaseLock();
            return inputStream;
        }
        if (string7.equals(object)) {
            FileLock fileLock = fileObject2.lock();
            try {
                fileObject2.delete(fileLock);
                Object var34_42 = null;
            }
            catch (Throwable throwable) {
                Object var34_43 = null;
                fileLock.releaseLock();
                throw throwable;
            }
            fileLock.releaseLock();
            return super.createFromTemplate(fileObject, string4);
        }
        throw new IOException("unrecognized result option: " + object);
    }

    public boolean isDeleteAllowed() {
        return !this.getFile().isReadOnly() && !this.basicName.equals(this.getFile().getName());
    }

    public boolean isCopyAllowed() {
        return true;
    }

    public boolean isMoveAllowed() {
        return !this.getFile().isReadOnly() && this.getDataObject().getPrimaryEntry() != this;
    }

    public boolean isRenameAllowed() {
        return !this.getFile().isReadOnly();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("propfiles.creating");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class PropKeysChildren
    extends Children.Keys {
        private PropertyBundleListener bundleListener = null;

        PropKeysChildren() {
        }

        private void mySetKeys() {
            TreeSet<String> treeSet = new TreeSet<String>(new KeyComparator());
            PropertiesStructure propertiesStructure = PropertiesFileEntry.this.getHandler().getStructure();
            if (propertiesStructure != null) {
                Iterator iterator = propertiesStructure.allItems();
                while (iterator.hasNext()) {
                    Element.ItemElem itemElem = (Element.ItemElem)iterator.next();
                    if (itemElem == null || itemElem.getKey() == null) continue;
                    treeSet.add(itemElem.getKey());
                }
            }
            this.setKeys(treeSet);
        }

        protected void addNotify() {
            this.mySetKeys();
            this.bundleListener = new PropertyBundleListener(this){
                private final /* synthetic */ PropKeysChildren this$1;
                {
                    this.this$1 = propKeysChildren;
                }

                public void bundleChanged(PropertyBundleEvent propertyBundleEvent) {
                    int n = propertyBundleEvent.getChangeType();
                    if (n == 1 || n == 2) {
                        PropKeysChildren.access$000(this.this$1);
                    } else if (n == 3 && propertyBundleEvent.getEntryName().equals(PropKeysChildren.access$100(this.this$1).getFile().getName())) {
                        PropKeysChildren.access$000(this.this$1);
                    } else if (n == 4 && propertyBundleEvent.getItemName() != null && propertyBundleEvent.getEntryName().equals(PropKeysChildren.access$100(this.this$1).getFile().getName())) {
                        PropKeysChildren.access$201(this.this$1, propertyBundleEvent.getItemName());
                    }
                }
            };
            ((PropertiesDataObject)PropertiesFileEntry.this.getDataObject()).getBundleStructure().addPropertyBundleListener(new WeakListenerPropertyBundle(this.bundleListener));
        }

        protected void removeNotify() {
            this.setKeys(new ArrayList());
        }

        protected Node[] createNodes(Object object) {
            String string = (String)object;
            return new Node[]{new KeyNode(PropertiesFileEntry.this.getHandler().getStructure(), string)};
        }

        static /* synthetic */ void access$000(PropKeysChildren propKeysChildren) {
            propKeysChildren.mySetKeys();
        }

        static /* synthetic */ PropertiesFileEntry access$100(PropKeysChildren propKeysChildren) {
            return propKeysChildren.PropertiesFileEntry.this;
        }

        static /* synthetic */ void access$201(PropKeysChildren propKeysChildren, Object object) {
            super.refreshKey(object);
        }
    }
}

