/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

public class UtilConvert {
    public static final String keyValueSeparators = "=: \t\r\n\f";
    public static final String strictKeyValueSeparators = "=:";
    private static final String specialSaveChars = "=:\t\r\n\f#!";
    public static final String whiteSpaceChars = " \t\r\n\f";
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static Hashtable load(InputStream inputStream) throws IOException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "8859_1"));
        String string;
        while ((string = bufferedReader.readLine()) != null) {
            int n;
            int n2;
            char c;
            if (string.length() <= 0 || (c = string.charAt(0)) == '#' || c == '!') continue;
            while (UtilConvert.continueLine(string)) {
                String string2 = bufferedReader.readLine();
                if (string2 == null) {
                    string2 = new String("");
                }
                String string3 = string.substring(0, string.length() - 1);
                n2 = 0;
                n2 = 0;
                while (n2 < string2.length()) {
                    if (whiteSpaceChars.indexOf(string2.charAt(n2)) == -1) break;
                    ++n2;
                }
                string2 = string2.substring(n2, string2.length());
                string = new String(string3 + string2);
            }
            int n3 = string.length();
            int n4 = 0;
            while (n4 < n3) {
                if (whiteSpaceChars.indexOf(string.charAt(n4)) == -1) break;
                ++n4;
            }
            n2 = n4;
            while (n2 < n3) {
                n = string.charAt(n2);
                if (n == 92) {
                    ++n2;
                } else if (keyValueSeparators.indexOf(n) != -1) break;
                ++n2;
            }
            n = n2 + 1;
            while (n < n3) {
                if (whiteSpaceChars.indexOf(string.charAt(n)) == -1) break;
                ++n;
            }
            if (n < n3 && strictKeyValueSeparators.indexOf(string.charAt(n)) != -1) {
                ++n;
            }
            while (n < n3) {
                if (whiteSpaceChars.indexOf(string.charAt(n)) == -1) break;
                ++n;
            }
            String string4 = string.substring(n4, n2);
            String string5 = n2 < n3 ? string.substring(n, n3) : "";
            string4 = UtilConvert.loadConvert(string4);
            string5 = UtilConvert.loadConvert(string5);
            hashtable.put(string4, string5);
        }
        return hashtable;
    }

    private static boolean continueLine(String string) {
        int n = 0;
        int n2 = string.length() - 1;
        while (n2 >= 0 && string.charAt(n2--) == '\\') {
            ++n;
        }
        return n % 2 == 1;
    }

    public static boolean continueLine(StringBuffer stringBuffer) {
        int n = 0;
        int n2 = stringBuffer.length() - 1;
        while (n2 >= 0 && stringBuffer.charAt(n2--) == '\\') {
            ++n;
        }
        return n % 2 == 1;
    }

    public static String loadConvert(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            int n3;
            if ((n3 = string.charAt(n2++)) == 92) {
                if ((n3 = string.charAt(n2++)) == 117) {
                    int n4 = 0;
                    int n5 = 0;
                    while (n5 < 4) {
                        n3 = string.charAt(n2++);
                        switch (n3) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                n4 = (n4 << 4) + n3 - 48;
                                break;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                n4 = (n4 << 4) + 10 + n3 - 97;
                                break;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                n4 = (n4 << 4) + 10 + n3 - 65;
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                        ++n5;
                    }
                    stringBuffer.append((char)n4);
                    continue;
                }
                if (n3 == 116) {
                    n3 = 9;
                } else if (n3 == 114) {
                    n3 = 13;
                } else if (n3 == 110) {
                    n3 = 10;
                } else if (n3 == 102) {
                    n3 = 12;
                }
                stringBuffer.append((char)n3);
                continue;
            }
            stringBuffer.append((char)n3);
        }
        return stringBuffer.toString();
    }

    public static String saveConvert(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n * 2);
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2++);
            switch (c) {
                case '\\': {
                    stringBuffer.append('\\');
                    stringBuffer.append('\\');
                    break;
                }
                case '\t': {
                    stringBuffer.append('\\');
                    stringBuffer.append('t');
                    break;
                }
                case '\n': {
                    stringBuffer.append('\\');
                    stringBuffer.append('n');
                    break;
                }
                case '\r': {
                    stringBuffer.append('\\');
                    stringBuffer.append('r');
                    break;
                }
                case '\f': {
                    stringBuffer.append('\\');
                    stringBuffer.append('f');
                    break;
                }
                default: {
                    if (c < '\u0014' || c > '\u007f') {
                        stringBuffer.append('\\');
                        stringBuffer.append('u');
                        stringBuffer.append(UtilConvert.toHex(c >> 12 & 0xF));
                        stringBuffer.append(UtilConvert.toHex(c >> 8 & 0xF));
                        stringBuffer.append(UtilConvert.toHex(c >> 4 & 0xF));
                        stringBuffer.append(UtilConvert.toHex(c >> 0 & 0xF));
                        break;
                    }
                    if (specialSaveChars.indexOf(c) != -1) {
                        stringBuffer.append('\\');
                    }
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static String escapePropertiesSpecialChars(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if ((c == ' ' || c == '=' || c == ':') && (n == 0 || n > 0 && string.charAt(n - 1) != '\\')) {
                stringBuffer.append('\\');
            }
            if (n == string.length() - 1 && c == '\\' && n > 0 && string.charAt(n - 1) != '\\') {
                stringBuffer.append('\\');
            }
            stringBuffer.append(c);
            ++n;
        }
        return stringBuffer.toString();
    }

    private static boolean onlySpaces(String string) {
        int n = 0;
        while (n < string.length()) {
            if (string.charAt(n) != ' ') {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static String escapeOutsideSpaces(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (string.charAt(n) == ' ') {
            stringBuffer.append('\\');
            stringBuffer.append(' ');
            if (n + 1 == string.length()) {
                return stringBuffer.toString();
            }
            ++n;
        }
        while (!UtilConvert.onlySpaces(string.substring(n))) {
            stringBuffer.append(string.charAt(n));
            if (n + 1 == string.length()) {
                return stringBuffer.toString();
            }
            ++n;
        }
        while (n < string.length()) {
            stringBuffer.append('\\');
            stringBuffer.append(' ');
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String escapeLineContinuationChar(String string) {
        if (string == null) {
            return null;
        }
        if (string.endsWith("\\") && string.length() > 1 && string.charAt(string.length() - 2) != '\\') {
            return new String(new StringBuffer(string).append('\\'));
        }
        return string;
    }

    public static String escapeJavaSpecialChars(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            switch (c) {
                case '\t': {
                    stringBuffer.append("\\t");
                    break;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    break;
                }
                case '\b': {
                    stringBuffer.append("\\b");
                    break;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    break;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String unicodesToChars(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            block13: {
                char c = string.charAt(n2);
                if (n2 + 5 < n) {
                    char c2 = string.charAt(n2 + 1);
                    try {
                        if (c == '\\' && c2 == 'u') {
                            int n3 = 0;
                            int n4 = 0;
                            while (n4 < 4) {
                                c2 = string.charAt(n2 + 1 + n4 + 1);
                                switch (c2) {
                                    case '0': 
                                    case '1': 
                                    case '2': 
                                    case '3': 
                                    case '4': 
                                    case '5': 
                                    case '6': 
                                    case '7': 
                                    case '8': 
                                    case '9': {
                                        n3 = (n3 << 4) + c2 - 48;
                                        break;
                                    }
                                    case 'a': 
                                    case 'b': 
                                    case 'c': 
                                    case 'd': 
                                    case 'e': 
                                    case 'f': {
                                        n3 = (n3 << 4) + 10 + c2 - 97;
                                        break;
                                    }
                                    case 'A': 
                                    case 'B': 
                                    case 'C': 
                                    case 'D': 
                                    case 'E': 
                                    case 'F': {
                                        n3 = (n3 << 4) + 10 + c2 - 65;
                                        break;
                                    }
                                    default: {
                                        throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                                    }
                                }
                                ++n4;
                            }
                            stringBuffer.append((char)n3);
                            n2 += 5;
                            break block13;
                        }
                        stringBuffer.append(c);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        stringBuffer.append(c);
                    }
                } else {
                    stringBuffer.append(c);
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String charsToUnicodes(String string) {
        return UtilConvert.charsToUnicodes(string, false);
    }

    public static String charsToUnicodes(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n * 2);
        int n2 = 0;
        while (n2 < n) {
            char c;
            if ((c = string.charAt(n2++)) < '\u0014' || c > '\u007f') {
                if (bl && Character.isWhitespace(c)) {
                    stringBuffer.append(c);
                    continue;
                }
                stringBuffer.append('\\');
                stringBuffer.append('u');
                stringBuffer.append(UtilConvert.toHex(c >> 12 & 0xF));
                stringBuffer.append(UtilConvert.toHex(c >> 8 & 0xF));
                stringBuffer.append(UtilConvert.toHex(c >> 4 & 0xF));
                stringBuffer.append(UtilConvert.toHex(c >> 0 & 0xF));
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static synchronized void store(OutputStream outputStream, String string, Hashtable hashtable) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, "8859_1"));
        if (string != null) {
            UtilConvert.writeln(bufferedWriter, "#" + string);
        }
        UtilConvert.writeln(bufferedWriter, "#" + new Date().toString());
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = (String)hashtable.get(string2);
            string2 = UtilConvert.saveConvert(string2);
            string3 = UtilConvert.saveConvert(string3);
            UtilConvert.writeln(bufferedWriter, string2 + "=" + string3);
        }
        bufferedWriter.flush();
    }

    private static void writeln(BufferedWriter bufferedWriter, String string) throws IOException {
        bufferedWriter.write(string);
        bufferedWriter.newLine();
    }

    private static char toHex(int n) {
        return hexDigit[n & 0xF];
    }
}

