/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.catalog.impl.oasis;

import java.io.IOException;
import java.net.URL;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.modules.xml.catalog.impl.oasis.CatalogHandler;
import org.netbeans.modules.xml.catalog.impl.oasis.Util;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.AttributeListImpl;

public class CatalogParser
implements DocumentHandler {
    private StringBuffer buffer;
    private CatalogHandler handler;
    private Stack context;

    public CatalogParser(CatalogHandler handler) {
        this.handler = handler;
        this.buffer = new StringBuffer(111);
        this.context = new Stack();
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void startElement(String name, AttributeList attrs) throws SAXException {
        this.dispatch(true);
        this.context.push(new Object[]{name, new AttributeListImpl(attrs)});
        if ("system".equals(name)) {
            this.handler.handle_system(attrs);
        } else if ("uri".equals(name)) {
            this.handler.handle_uri(attrs);
        } else if ("public".equals(name)) {
            this.handler.handle_public(attrs);
        } else if ("rewriteSystem".equals(name)) {
            this.handler.handle_rewriteSystem(attrs);
        } else if ("delegateSystem".equals(name)) {
            this.handler.handle_delegateSystem(attrs);
        } else if ("catalog".equals(name)) {
            this.handler.start_catalog(attrs);
        } else if ("rewriteURI".equals(name)) {
            this.handler.handle_rewriteURI(attrs);
        } else if ("delegatePublic".equals(name)) {
            this.handler.handle_delegatePublic(attrs);
        } else if ("nextCatalog".equals(name)) {
            this.handler.handle_nextCatalog(attrs);
        } else if ("group".equals(name)) {
            this.handler.start_group(attrs);
        } else if ("delegateURI".equals(name)) {
            this.handler.handle_delegateURI(attrs);
        }
    }

    public void endElement(String name) throws SAXException {
        this.dispatch(false);
        this.context.pop();
        if ("catalog".equals(name)) {
            this.handler.end_catalog();
        } else if ("group".equals(name)) {
            this.handler.end_group();
        }
    }

    public void characters(char[] chars, int start, int len) throws SAXException {
        this.buffer.append(chars, start, len);
    }

    public void ignorableWhitespace(char[] chars, int start, int len) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    private void dispatch(boolean fireOnlyIfMixed) throws SAXException {
        if (fireOnlyIfMixed && this.buffer.length() == 0) {
            return;
        }
        Object[] ctx = (Object[])this.context.peek();
        String here = (String)ctx[0];
        AttributeList attrs = (AttributeList)ctx[1];
        this.buffer.delete(0, this.buffer.length());
    }

    public void parse(InputSource input) throws SAXException, ParserConfigurationException, IOException {
        CatalogParser.parse(input, this);
    }

    public void parse(URL url) throws SAXException, ParserConfigurationException, IOException {
        CatalogParser.parse(new InputSource(url.toExternalForm()), this);
    }

    public static void parse(InputSource input, CatalogHandler handler) throws SAXException, ParserConfigurationException, IOException {
        CatalogParser.parse(input, new CatalogParser(handler));
    }

    public static void parse(URL url, CatalogHandler handler) throws SAXException, ParserConfigurationException, IOException {
        CatalogParser.parse(new InputSource(url.toExternalForm()), handler);
    }

    private static void parse(InputSource input, CatalogParser recognizer) throws SAXException, ParserConfigurationException, IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(true);
        factory.setNamespaceAware(false);
        Parser parser = factory.newSAXParser().getParser();
        parser.setDocumentHandler(recognizer);
        parser.setErrorHandler(recognizer.getDefaultErrorHandler());
        parser.parse(input);
    }

    private ErrorHandler getDefaultErrorHandler() {
        return new ErrorHandler(){

            public void error(SAXParseException ex) throws SAXException {
                if (CatalogParser.this.context.isEmpty() && Util.THIS.isLoggable()) {
                    Util.THIS.debug("Missing DOCTYPE.");
                }
                throw ex;
            }

            public void fatalError(SAXParseException ex) throws SAXException {
                throw ex;
            }

            public void warning(SAXParseException ex) throws SAXException {
            }
        };
    }
}

