/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.catalog.impl.sun;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.Customizer;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.MalformedURLException;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.xml.catalog.impl.sun.Catalog;
import org.netbeans.modules.xml.catalog.impl.sun.Util;

public class CatalogCustomizer
extends JPanel
implements Customizer {
    private static final long serialVersionUID = -1437233290256708364L;
    Catalog model = null;
    private JLabel locationLabel;
    private JTextField locationTextField;
    private JCheckBox preferCheckBox;
    private JButton selectButton;
    private JTextArea descTextArea;

    public CatalogCustomizer() {
        this.initComponents();
        this.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_CatalogCustomizer"));
        this.locationLabel.setDisplayedMnemonic(Util.THIS.getString("CatalogCustomizer.locationLabel.mne").charAt(0));
        this.locationTextField.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_locationTextField"));
        this.preferCheckBox.setMnemonic(Util.THIS.getString("MNE_preference").charAt(0));
        this.preferCheckBox.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_preference"));
        this.selectButton.setMnemonic(Util.THIS.getString("MNE_file").charAt(0));
        this.selectButton.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_file"));
    }

    private void initComponents() {
        this.locationLabel = new JLabel();
        this.locationTextField = new JTextField();
        this.selectButton = new JButton();
        this.preferCheckBox = new JCheckBox();
        this.descTextArea = new JTextArea();
        this.setLayout(new GridBagLayout());
        this.locationLabel.setForeground(Color.black);
        this.locationLabel.setText(Util.THIS.getString("CatalogCustomizer.locationLabel.text"));
        this.locationLabel.setLabelFor(this.locationTextField);
        this.add((Component)this.locationLabel, new GridBagConstraints());
        this.locationTextField.setColumns(20);
        this.locationTextField.setPreferredSize(new Dimension(220, 20));
        this.locationTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CatalogCustomizer.this.locationTextFieldActionPerformed(evt);
            }
        });
        this.locationTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                CatalogCustomizer.this.locationTextFieldFocusLost(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.add((Component)this.locationTextField, gridBagConstraints);
        this.selectButton.setText(ResourceBundle.getBundle("org/netbeans/modules/xml/catalog/impl/sun/Bundle").getString("PROP_choose_file"));
        this.selectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CatalogCustomizer.this.selectButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.add((Component)this.selectButton, gridBagConstraints);
        this.preferCheckBox.setText(ResourceBundle.getBundle("org/netbeans/modules/xml/catalog/impl/sun/Bundle").getString("LBL_preference"));
        this.preferCheckBox.setToolTipText(Util.THIS.getString("HINT_pp"));
        this.preferCheckBox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                CatalogCustomizer.this.preferCheckBoxStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        this.add((Component)this.preferCheckBox, gridBagConstraints);
        this.descTextArea.setEditable(false);
        this.descTextArea.setFont(UIManager.getFont("Label.font"));
        this.descTextArea.setForeground(new Color(102, 102, 153));
        this.descTextArea.setLineWrap(true);
        this.descTextArea.setText(Util.THIS.getString("DESC_catalog_fmts"));
        this.descTextArea.setWrapStyleWord(true);
        this.descTextArea.setDisabledTextColor(UIManager.getColor("Label.foreground"));
        this.descTextArea.setEnabled(false);
        this.descTextArea.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.descTextArea, gridBagConstraints);
    }

    private void selectButtonActionPerformed(ActionEvent evt) {
        File f = org.netbeans.modules.xml.catalog.lib.Util.selectCatalogFile("txt xml cat catalog");
        if (f == null) {
            return;
        }
        try {
            String location = f.toURL().toExternalForm();
            this.locationTextField.setText(location);
            this.model.setLocation(location);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    private void preferCheckBoxStateChanged(ChangeEvent evt) {
        if (this.model != null) {
            this.model.setPreferPublic(this.preferCheckBox.isSelected());
        }
    }

    private void locationTextFieldFocusLost(FocusEvent evt) {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("FocusLost-setting location: " + this.locationTextField.getText());
        }
        this.model.setLocation(this.locationTextField.getText());
    }

    private void locationTextFieldActionPerformed(ActionEvent evt) {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("ActionPerformed-setting location: " + this.locationTextField.getText());
        }
        this.model.setLocation(this.locationTextField.getText());
    }

    public void setObject(Object peer) {
        if (!(peer instanceof Catalog)) {
            throw new IllegalArgumentException("Catalog instance expected (" + peer.getClass() + ").");
        }
        this.model = (Catalog)peer;
        this.locationTextField.setText(this.model.getLocation());
        this.preferCheckBox.setSelected(this.model.isPreferPublic());
    }

    public void addPropertyChangeListener(PropertyChangeListener p1) {
    }

    public void removePropertyChangeListener(PropertyChangeListener p1) {
    }
}

