/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.catalog.settings;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.modules.xml.catalog.settings.Util;
import org.netbeans.modules.xml.catalog.spi.CatalogListener;
import org.netbeans.modules.xml.catalog.spi.CatalogReader;
import org.openide.ErrorManager;
import org.openide.TopManager;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.io.NbMarshalledObject;

public final class CatalogSettings
implements Externalizable {
    private static final long serialVersionUID = 7895789034L;
    public static final int VERSION_1 = 1;
    public static final String PROP_MOUNTED_CATALOGS = "catalogs";
    public static final String PROP_PRJ_INSTANCE = "cat-prj-in";
    private Set mountedCatalogs = new HashSet();
    private PropertyChangeSupport listeners = null;
    private final CatalogListener catalogListener = new CL();
    private static ErrorManager err = null;
    private static Lookup.Result result = null;
    private static CatalogSettings instance = null;
    static /* synthetic */ Class class$org$netbeans$modules$xml$catalog$settings$CatalogSettings;

    public CatalogSettings() {
        this.init();
    }

    private void init() {
        this.listeners = new PropertyChangeSupport(this);
    }

    public static synchronized CatalogSettings getDefault() {
        if (result == null) {
            result = Lookup.getDefault().lookup(new Lookup.Template(class$org$netbeans$modules$xml$catalog$settings$CatalogSettings == null ? (class$org$netbeans$modules$xml$catalog$settings$CatalogSettings = CatalogSettings.class$("org.netbeans.modules.xml.catalog.settings.CatalogSettings")) : class$org$netbeans$modules$xml$catalog$settings$CatalogSettings));
            result.addLookupListener(new LookupListener(){
                static /* synthetic */ Class class$org$netbeans$modules$xml$catalog$settings$CatalogSettings;

                public void resultChanged(LookupEvent e) {
                    CatalogSettings oldSettings = instance;
                    Class clazz = class$org$netbeans$modules$xml$catalog$settings$CatalogSettings == null ? (class$org$netbeans$modules$xml$catalog$settings$CatalogSettings = 1.class$("org.netbeans.modules.xml.catalog.settings.CatalogSettings")) : class$org$netbeans$modules$xml$catalog$settings$CatalogSettings;
                    synchronized (clazz) {
                        instance = (CatalogSettings)Lookup.getDefault().lookup(1.class$org$netbeans$modules$xml$catalog$settings$CatalogSettings == null ? (1.class$org$netbeans$modules$xml$catalog$settings$CatalogSettings = 1.class$("org.netbeans.modules.xml.catalog.settings.CatalogSettings")) : 1.class$org$netbeans$modules$xml$catalog$settings$CatalogSettings);
                    }
                    if (oldSettings != null) {
                        oldSettings.firePropertyChange(CatalogSettings.PROP_PRJ_INSTANCE, oldSettings, instance);
                    }
                }

                static /* synthetic */ Class class$(String x0) {
                    try {
                        return Class.forName(x0);
                    }
                    catch (ClassNotFoundException x1) {
                        throw new NoClassDefFoundError(x1.getMessage());
                    }
                }
            });
            instance = (CatalogSettings)result.allInstances().iterator().next();
        }
        return instance;
    }

    public final void addCatalog(CatalogReader provider) {
        CatalogSettings catalogSettings = this;
        synchronized (catalogSettings) {
            if (provider == null) {
                throw new IllegalArgumentException("null provider not permited");
            }
            this.mountedCatalogs.add(provider);
        }
        this.firePropertyChange(PROP_MOUNTED_CATALOGS, null, null);
        try {
            provider.addCatalogListener(this.catalogListener);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public final void removeCatalog(CatalogReader provider) {
        CatalogSettings catalogSettings = this;
        synchronized (catalogSettings) {
            this.mountedCatalogs.remove(provider);
        }
        this.firePropertyChange(PROP_MOUNTED_CATALOGS, null, null);
        try {
            provider.removeCatalogListener(this.catalogListener);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public final synchronized Iterator getCatalogs(Class[] providerClasses) {
        Iterator it = this.mountedCatalogs.iterator();
        if (providerClasses == null) {
            return it;
        }
        ArrayList list = new ArrayList();
        block0: while (it.hasNext()) {
            Object next = it.next();
            int i = 0;
            while (i < providerClasses.length) {
                if (!providerClasses[i].isAssignableFrom(next.getClass())) break block0;
                ++i;
            }
            list.add(next);
        }
        return ((AbstractList)list).iterator();
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.listeners.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.listeners.removePropertyChangeListener(l);
    }

    private void firePropertyChange(String name, Object oldValue, Object newValue) {
        this.listeners.firePropertyChange(name, oldValue, newValue);
    }

    public synchronized void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int version;
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("CatalogSettings.readExternal()");
        }
        if ((version = in.readInt()) != 1) {
            throw new StreamCorruptedException("Unsupported catalog externalization protocol version (" + version + ").");
        }
        int persistentCount = in.readInt();
        int i = 0;
        while (i < persistentCount) {
            String catalogClass = (String)in.readObject();
            NbMarshalledObject marshaled = (NbMarshalledObject)in.readObject();
            try {
                this.mountedCatalogs.add(marshaled.get());
            }
            catch (ClassNotFoundException ex) {
                this.emgr().annotate((Throwable)ex, Util.THIS.getString("EXC_deserialization_failed", catalogClass));
                this.emgr().notify(1, (Throwable)ex);
            }
            catch (IOException ex) {
                this.emgr().annotate((Throwable)ex, Util.THIS.getString("EXC_deserialization_failed", catalogClass));
                this.emgr().notify(1, (Throwable)ex);
            }
            catch (RuntimeException ex) {
                this.emgr().annotate((Throwable)ex, Util.THIS.getString("EXC_deserialization_failed", catalogClass));
                this.emgr().notify(1, (Throwable)ex);
            }
            ++i;
        }
    }

    public synchronized void writeExternal(ObjectOutput out) throws IOException {
        Object next;
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("CatalogSettings.writeExternal()");
        }
        out.writeInt(1);
        int persistentCount = 0;
        Iterator it = this.mountedCatalogs.iterator();
        while (it.hasNext()) {
            next = it.next();
            if (!(next instanceof Serializable)) continue;
            ++persistentCount;
        }
        it = this.mountedCatalogs.iterator();
        out.writeInt(persistentCount);
        while (it.hasNext()) {
            next = it.next();
            if (!(next instanceof Serializable)) continue;
            try {
                NbMarshalledObject marshaled = new NbMarshalledObject(next);
                out.writeObject(next.getClass().getName());
                out.writeObject(marshaled);
            }
            catch (IOException ex) {
                this.emgr().annotate((Throwable)ex, Util.THIS.getString("EXC_serialization_failed", next.getClass()));
                this.emgr().notify(1, (Throwable)ex);
            }
            catch (RuntimeException ex) {
                this.emgr().annotate((Throwable)ex, Util.THIS.getString("EXC_serialization_failed", next.getClass()));
                this.emgr().notify(1, (Throwable)ex);
            }
        }
    }

    private ErrorManager emgr() {
        if (err == null) {
            err = TopManager.getDefault().getErrorManager();
        }
        return err;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("CatalogSettings:");
        Iterator it = this.mountedCatalogs.iterator();
        while (it.hasNext()) {
            buf.append(", " + it.next());
        }
        return buf.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class CL
    implements CatalogListener {
        private CL() {
        }

        public void notifyRemoved(String publicID) {
        }

        public void notifyNew(String publicID) {
        }

        public void notifyUpdate(String publicID) {
        }

        public void notifyInvalidate() {
            CatalogSettings.this.firePropertyChange("settings changed!", null, CatalogSettings.this);
        }
    }
}

