/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javahelp;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.MissingResourceException;
import org.netbeans.modules.javahelp.Installer;
import org.openide.TopManager;
import org.openide.execution.NbfsStreamHandlerFactory;
import org.openide.util.NbBundle;

final class NbDocsStreamHandler
extends URLStreamHandler {
    private static Reference docsLoader;
    private static boolean addedTmSysLoaderListener;
    private static URL[] docsURLs;

    NbDocsStreamHandler() {
    }

    protected URLConnection openConnection(URL uRL) throws IOException {
        if (uRL.getProtocol().equals("nbdocs")) {
            return new NbDocsURLConnection(uRL);
        }
        throw new IOException("mismatched protocol");
    }

    private static ClassLoader getDocsLoader() {
        Reference reference = docsLoader;
        ClassLoader classLoader = reference != null ? (ClassLoader)reference.get() : null;
        if (classLoader == null) {
            classLoader = new URLClassLoader(NbDocsStreamHandler.getDocsURLs(), TopManager.getDefault().systemClassLoader());
            if (!addedTmSysLoaderListener) {
                TopManager.getDefault().addPropertyChangeListener(new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        if ("systemClassLoader".equals(propertyChangeEvent.getPropertyName())) {
                            docsLoader = null;
                        }
                    }
                });
                addedTmSysLoaderListener = true;
            }
            docsLoader = new WeakReference<ClassLoader>(classLoader);
        }
        return classLoader;
    }

    private static URL[] getDocsURLs() {
        if (docsURLs == null) {
            Object object;
            ArrayList<Object> arrayList = new ArrayList<Object>(2);
            String string = System.getProperty("netbeans.home");
            if (string != null) {
                try {
                    object = new File(string, "docs").getCanonicalFile().toURL();
                    if (!((URL)object).toString().endsWith("/")) {
                        object = new URL(((URL)object).toString() + "/");
                    }
                    arrayList.add(object);
                }
                catch (Exception exception) {
                    Installer.err.notify(16, (Throwable)exception);
                }
            }
            if ((object = System.getProperty("netbeans.user")) != null && !((String)object).equals(string)) {
                try {
                    URL uRL = new File((String)object, "docs").getCanonicalFile().toURL();
                    if (!uRL.toString().endsWith("/")) {
                        uRL = new URL(uRL.toString() + "/");
                    }
                    arrayList.add(uRL);
                }
                catch (Exception exception) {
                    Installer.err.notify(16, (Throwable)exception);
                }
            }
            Collections.reverse(arrayList);
            docsURLs = arrayList.toArray(new URL[arrayList.size()]);
        }
        return docsURLs;
    }

    static {
        Installer.err.log("Registering nbdocs: protocol");
        NbfsStreamHandlerFactory.getDefault().register("nbdocs", (URLStreamHandler)new NbDocsStreamHandler());
        docsLoader = null;
        addedTmSysLoaderListener = false;
        docsURLs = null;
    }

    private static final class NbDocsURLConnection
    extends URLConnection {
        private URLConnection real = null;
        private IOException exception = null;
        static /* synthetic */ Class class$org$netbeans$modules$javahelp$NbDocsStreamHandler;

        public NbDocsURLConnection(URL uRL) {
            super(uRL);
        }

        public synchronized void connect() throws IOException {
            if (this.exception != null) {
                IOException iOException = this.exception;
                this.exception = null;
                throw iOException;
            }
            if (!this.connected) {
                URL uRL;
                String string;
                String string2;
                int n;
                String string3 = this.url.getFile();
                if (string3.startsWith("/")) {
                    string3 = string3.substring(1);
                }
                if ((n = string3.lastIndexOf(46)) != -1) {
                    string2 = string3.substring(n + 1);
                    string = string3.substring(0, n).replace('/', '.');
                } else {
                    string2 = null;
                    string = string3.replace('/', '.');
                }
                try {
                    uRL = NbBundle.getLocalizedFile((String)string, (String)string2, (Locale)Locale.getDefault(), (ClassLoader)NbDocsStreamHandler.getDocsLoader());
                }
                catch (MissingResourceException missingResourceException) {
                    IOException iOException = new IOException("cannot connect to " + this.url);
                    Installer.err.annotate((Throwable)iOException, (Throwable)missingResourceException);
                    Installer.err.annotate((Throwable)iOException, NbBundle.getMessage((Class)(class$org$netbeans$modules$javahelp$NbDocsStreamHandler == null ? (class$org$netbeans$modules$javahelp$NbDocsStreamHandler = NbDocsURLConnection.class$("org.netbeans.modules.javahelp.NbDocsStreamHandler")) : class$org$netbeans$modules$javahelp$NbDocsStreamHandler), (String)"EXC_nbdocs_cannot_connect", (Object)this.url));
                    throw iOException;
                }
                this.real = uRL.openConnection();
                this.real.connect();
                this.connected = true;
            }
        }

        private void tryToConnect() {
            if (this.connected || this.exception != null) {
                return;
            }
            try {
                this.connect();
            }
            catch (IOException iOException) {
                this.exception = iOException;
            }
        }

        public String getHeaderField(int n) {
            this.tryToConnect();
            if (this.connected) {
                return this.real.getHeaderField(n);
            }
            return null;
        }

        public String getHeaderFieldKey(int n) {
            this.tryToConnect();
            if (this.connected) {
                return this.real.getHeaderFieldKey(n);
            }
            return null;
        }

        public String getHeaderField(String string) {
            this.tryToConnect();
            if (this.connected) {
                return this.real.getHeaderField(string);
            }
            return null;
        }

        public InputStream getInputStream() throws IOException {
            this.connect();
            return this.real.getInputStream();
        }

        public OutputStream getOutputStream() throws IOException {
            this.connect();
            return this.real.getOutputStream();
        }

        public String getContentType() {
            this.tryToConnect();
            if (this.connected) {
                return this.real.getContentType();
            }
            return "application/octet-stream";
        }

        public int getContentLength() {
            this.tryToConnect();
            if (this.connected) {
                return this.real.getContentLength();
            }
            return 0;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

