/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector.warp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.connector.warp.WarpConfigurationHandler;
import org.apache.catalina.connector.warp.WarpConnector;
import org.apache.catalina.connector.warp.WarpLogger;
import org.apache.catalina.connector.warp.WarpPacket;
import org.apache.catalina.connector.warp.WarpRequestHandler;

public class WarpConnection
implements LifecycleListener,
Runnable {
    private InputStream input = null;
    private OutputStream output = null;
    private boolean started = false;
    private Thread thread = null;
    private WarpLogger logger = new WarpLogger(this);
    private Socket socket = null;
    private WarpConnector connector = null;

    public WarpConnector getConnector() {
        return this.connector;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void lifecycleEvent(LifecycleEvent event) {
        if ("stop".equals(event.getType())) {
            this.stop();
        }
    }

    public void recv(WarpPacket packet) throws IOException {
        block2: {
            int l2;
            int l1;
            int t = this.input.read();
            if ((t | (l1 = this.input.read()) | (l2 = this.input.read())) == -1) {
                throw new IOException("Premature packet header end");
            }
            packet.reset();
            packet.setType(t & 0xFF);
            packet.size = (l1 & 0xFF) << 8 | l2 & 0xFF;
            if (packet.size <= 0) break block2;
            int off = 0;
            int ret = 0;
            do {
                if ((ret = this.input.read(packet.buffer, off, packet.size - off)) != -1) continue;
                throw new IOException("Premature packet payload end");
            } while ((off += ret) != packet.size);
        }
    }

    public void run() {
        WarpPacket packet = new WarpPacket();
        try {
            try {
                this.input = this.socket.getInputStream();
                this.output = this.socket.getOutputStream();
                if (!new WarpConfigurationHandler().handle(this, packet)) {
                    this.logger.log("Configuration handler returned false");
                    this.stop();
                }
                WarpRequestHandler requestHandler = new WarpRequestHandler();
                while (requestHandler.handle(this, packet)) {
                }
            }
            catch (IOException e) {
                this.logger.log("Exception on socket", e);
            }
            Object var3_4 = null;
            this.stop();
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.stop();
            throw throwable;
        }
    }

    public void send(WarpPacket packet) throws IOException {
        this.output.write(packet.getType() & 0xFF);
        this.output.write(packet.size >> 8 & 0xFF);
        this.output.write(packet.size & 0xFF);
        this.output.write(packet.buffer, 0, packet.size);
        this.output.flush();
        packet.reset();
    }

    public void setConnector(WarpConnector connector) {
        this.connector = connector;
        this.logger.setContainer(connector.getContainer());
    }

    public void setSocket(Socket socket) {
        this.socket = socket;
    }

    public void start() {
        WarpConnection warpConnection = this;
        synchronized (warpConnection) {
            this.started = true;
            this.thread = new Thread(this);
            this.thread.start();
        }
    }

    public void stop() {
        WarpConnection warpConnection = this;
        synchronized (warpConnection) {
            try {
                this.started = false;
                this.socket.close();
                this.getConnector().removeLifecycleListener(this);
            }
            catch (IOException e) {
                this.logger.log("Cannot close socket", e);
            }
        }
    }
}

