/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.schema2beans;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.modules.schema2beans.DocDefHandler;
import org.netbeans.modules.schema2beans.GenBeans;
import org.netbeans.modules.schema2beans.GeneralParser;
import org.netbeans.modules.schema2beans.Schema2BeansException;
import org.netbeans.modules.schema2beans.Schema2BeansNestedException;
import org.netbeans.modules.schema2beans.SchemaParser;
import org.netbeans.modules.schema2beans.SchemaRep;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLSchemaParser
extends GeneralParser
implements SchemaParser {
    private DocDefHandler handler;
    private boolean debug;
    private GenBeans.Config config = null;
    SchemaRep schema;

    public XMLSchemaParser(GenBeans.Config config, DocDefHandler docDefHandler) {
        this.config = config;
        this.filename = config.filename;
        this.schemaIn = config.fileIn;
        this.handler = docDefHandler;
        this.debug = config.getTraceParse();
    }

    public void process() throws IOException, Schema2BeansException {
        Object object;
        this.startupReader();
        try {
            try {
                object = DocumentBuilderFactory.newInstance();
                ((DocumentBuilderFactory)object).setNamespaceAware(true);
                ((DocumentBuilderFactory)object).setIgnoringComments(true);
                ((DocumentBuilderFactory)object).setIgnoringElementContentWhitespace(true);
                DocumentBuilder documentBuilder = ((DocumentBuilderFactory)object).newDocumentBuilder();
                Document document = documentBuilder.parse(new InputSource(this.reader));
                this.schema = new SchemaRep(document);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new Schema2BeansNestedException("Failed to parse", parserConfigurationException);
            }
            catch (SAXException sAXException) {
                throw new Schema2BeansNestedException("Failed to parse", sAXException);
            }
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.shutdownReader();
            throw throwable;
        }
        this.shutdownReader();
        if (this.debug) {
            object = new PrintWriter(System.out);
            this.schema.writeXMLSchemaStandalone((Writer)object);
            ((PrintWriter)object).flush();
        }
        this.schema.optimize();
        this.handler.startDocument(this.config.docroot);
        this.process(this.schema.getRootElement());
        this.handler.endDocument();
    }

    protected void process(SchemaRep.ElementExpr elementExpr) {
        if (elementExpr instanceof SchemaRep.Element) {
            this.processElement((SchemaRep.Element)elementExpr);
        } else if (elementExpr instanceof SchemaRep.ComplexType) {
            this.processComplexType((SchemaRep.ComplexType)elementExpr);
        } else if (elementExpr instanceof SchemaRep.SimpleType) {
            this.processSimpleType((SchemaRep.SimpleType)elementExpr);
        } else if (elementExpr instanceof SchemaRep.ContainsSubElements) {
            this.processContainsSubElements((SchemaRep.ContainsSubElements)elementExpr);
        } else {
            System.out.println("XMLSchemaPraser.process: Hit unknown ElementExpr: " + elementExpr);
        }
    }

    protected void processContainsSubElements(SchemaRep.ContainsSubElements containsSubElements) {
        Iterator iterator = containsSubElements.subElementsIterator();
        while (iterator.hasNext()) {
            SchemaRep.ElementExpr elementExpr = (SchemaRep.ElementExpr)iterator.next();
            this.process(elementExpr);
        }
    }

    protected void processElement(SchemaRep.Element element) {
        Object object;
        if (element.getRef() != null) {
            if (this.debug) {
                System.out.println("Skipping adding new element, because it's a reference to " + element.getRef());
            }
            return;
        }
        String string = element.getElementName();
        String string2 = element.getXMLSchemaType();
        SchemaRep.ElementExpr elementExpr = this.schema.getSchemaTypeDef(string2);
        if (this.debug) {
            System.out.println("Adding element " + string + " of type " + string2 + " schemaTypeDef=" + elementExpr);
        }
        this.handler.startElement(element.getFullContentName(), string, 2);
        int n = XMLSchemaParser.getInstanceValue(element.getMinOccurs(), element.getMaxOccurs());
        if (n != 32) {
            if (this.debug) {
                System.out.println("processElement: startGroupElements");
            }
            this.handler.startGroupElements();
        }
        boolean bl = false;
        if (elementExpr != null) {
            if (elementExpr instanceof SchemaRep.Element) {
                bl = true;
                this.addTopElements((SchemaRep.Element)elementExpr);
            } else if (elementExpr instanceof SchemaRep.ComplexType) {
                bl = this.addTopElements((SchemaRep.ComplexType)elementExpr);
            } else if (!(elementExpr instanceof SchemaRep.SimpleType)) {
                System.out.println("processElement: Unfamiliar schemaTypeDef: " + elementExpr);
            }
        }
        Iterator iterator = element.subElementsIterator();
        while (iterator.hasNext()) {
            object = (SchemaRep.ElementExpr)iterator.next();
            if (object instanceof SchemaRep.ComplexType) {
                bl = this.addTopElements((SchemaRep.ComplexType)object);
                continue;
            }
            if (object instanceof SchemaRep.SimpleType || object instanceof SchemaRep.Unique || object instanceof SchemaRep.Key || object instanceof SchemaRep.KeyRef || object instanceof SchemaRep.Annotation) continue;
            System.out.println("processElement: Unfamiliar subelement: " + object);
        }
        if (!bl) {
            object = element.getJavaType();
            if (this.debug) {
                System.out.println("We are a leaf node of type " + (String)object);
            }
            this.handler.javaType(element.getFullContentName(), element.getElementName(), (String)object);
            if (string2 == null) {
                this.handler.element("EMPTY", 32);
            } else {
                this.handler.element("#PCDATA", 32);
            }
        }
        if (n != 32) {
            this.handler.endGroupElements(n);
        }
        this.handler.endElement();
        if (elementExpr != null) {
            if (elementExpr instanceof SchemaRep.Element) {
                this.addTopAttributes(element, (SchemaRep.Element)elementExpr);
            } else if (elementExpr instanceof SchemaRep.ComplexType) {
                this.addTopAttributes(element, (SchemaRep.ComplexType)elementExpr);
            }
        }
        iterator = element.subElementsIterator();
        while (iterator.hasNext()) {
            object = (SchemaRep.ElementExpr)iterator.next();
            if (!(object instanceof SchemaRep.ComplexType)) continue;
            this.addTopAttributes(element, (SchemaRep.ComplexType)object);
        }
        this.processContainsSubElements(element);
    }

    protected boolean addTopElements(SchemaRep.ComplexType complexType) {
        boolean bl = false;
        Iterator iterator = complexType.subElementsIterator();
        while (iterator.hasNext()) {
            SchemaRep.ElementExpr elementExpr = (SchemaRep.ElementExpr)iterator.next();
            if (elementExpr instanceof SchemaRep.ModelGroup) {
                bl |= this.addTopElements((SchemaRep.ModelGroup)elementExpr);
                continue;
            }
            if (elementExpr instanceof SchemaRep.Attribute || elementExpr instanceof SchemaRep.AttributeGroup) continue;
            if (elementExpr instanceof SchemaRep.SimpleContent) {
                this.addTopElements((SchemaRep.SimpleContent)elementExpr);
                continue;
            }
            if (elementExpr instanceof SchemaRep.Annotation) continue;
            System.out.println("addTopElements.ComplexType: Unfamiliar subelement: " + elementExpr);
        }
        return bl;
    }

    protected boolean addTopElements(SchemaRep.ModelGroup modelGroup) {
        boolean bl = false;
        char c = ' ';
        if (modelGroup instanceof SchemaRep.Sequence) {
            c = ',';
        } else if (modelGroup instanceof SchemaRep.Choice) {
            c = '|';
        }
        int n = XMLSchemaParser.getInstanceValue(modelGroup.getMinOccurs(), modelGroup.getMaxOccurs());
        this.handler.startGroupElements();
        boolean bl2 = true;
        Iterator iterator = modelGroup.subElementsIterator();
        while (iterator.hasNext()) {
            if (bl2) {
                bl2 = false;
            } else {
                this.handler.character(c);
            }
            SchemaRep.ElementExpr elementExpr = (SchemaRep.ElementExpr)iterator.next();
            if (elementExpr instanceof SchemaRep.Element) {
                bl = true;
                this.addTopElements((SchemaRep.Element)elementExpr);
                continue;
            }
            if (elementExpr instanceof SchemaRep.ModelGroup) {
                bl |= this.addTopElements((SchemaRep.ModelGroup)elementExpr);
                continue;
            }
            System.out.println("Unfamiliar subelement: " + elementExpr);
        }
        this.handler.endGroupElements(n);
        return bl;
    }

    protected void addTopElements(SchemaRep.SimpleContent simpleContent) {
        Iterator iterator = simpleContent.subElementsIterator();
        while (iterator.hasNext()) {
            SchemaRep.ElementExpr elementExpr = (SchemaRep.ElementExpr)iterator.next();
            if (elementExpr instanceof SchemaRep.Extension) {
                SchemaRep.Extension extension = (SchemaRep.Extension)elementExpr;
                System.out.println("Found an extension of " + extension.getBase());
                continue;
            }
            if (elementExpr instanceof SchemaRep.Annotation) continue;
            System.out.println("addTopElements.SimpleContent: Unfamiliar subelement: " + elementExpr);
        }
    }

    protected void addTopElements(SchemaRep.Element element) {
        String string = element.getElementName();
        if (element.getRef() != null) {
            string = element.getRef();
        }
        if (string == null) {
            System.out.println("WARNING: elementName is null.");
        }
        if (this.debug) {
            System.out.println("addTopElements: name=" + string);
        }
        this.handler.element(element.getFullContentName(), string, XMLSchemaParser.getInstanceValue(element.getMinOccurs(), element.getMaxOccurs()));
    }

    protected void processComplexType(SchemaRep.ComplexType complexType) {
        String string = complexType.getTypeName();
        if (this.debug) {
            System.out.println("processComplexType: el=" + complexType);
        }
        if (string == null) {
            // empty if block
        }
        Iterator iterator = complexType.subElementsIterator();
        while (iterator.hasNext()) {
            SchemaRep.ElementExpr elementExpr = (SchemaRep.ElementExpr)iterator.next();
            if (elementExpr instanceof SchemaRep.ModelGroup) {
                this.processModelGroup((SchemaRep.ModelGroup)elementExpr);
                continue;
            }
            if (elementExpr instanceof SchemaRep.Attribute || elementExpr instanceof SchemaRep.AttributeGroup || elementExpr instanceof SchemaRep.SimpleContent || elementExpr instanceof SchemaRep.Annotation) continue;
            System.out.println("processComplexType: Unfamiliar subelement: " + elementExpr);
        }
    }

    protected void processModelGroup(SchemaRep.ModelGroup modelGroup) {
        Iterator iterator = modelGroup.subElementsIterator();
        while (iterator.hasNext()) {
            SchemaRep.ElementExpr elementExpr = (SchemaRep.ElementExpr)iterator.next();
            if (elementExpr instanceof SchemaRep.Element) {
                this.processElement((SchemaRep.Element)elementExpr);
                continue;
            }
            if (elementExpr instanceof SchemaRep.ModelGroup) {
                this.processModelGroup((SchemaRep.ModelGroup)elementExpr);
                continue;
            }
            System.out.println("processModelGroup: Unfamiliar subelement: " + elementExpr);
        }
    }

    protected void processSimpleType(SchemaRep.SimpleType simpleType) {
        System.out.println("processSimpleType: el=" + simpleType);
    }

    protected void addTopAttributes(SchemaRep.Element element, SchemaRep.Element element2) {
        Iterator iterator = element2.subElementsIterator();
        while (iterator.hasNext()) {
            SchemaRep.ElementExpr elementExpr = (SchemaRep.ElementExpr)iterator.next();
            if (elementExpr instanceof SchemaRep.Attribute) {
                this.addTopAttributes(element, (SchemaRep.Attribute)elementExpr);
                continue;
            }
            if (elementExpr instanceof SchemaRep.AttributeGroup) {
                this.addTopAttributes(element, (SchemaRep.AttributeGroup)elementExpr);
                continue;
            }
            if (!(elementExpr instanceof SchemaRep.ComplexType)) continue;
            this.addTopAttributes(element, (SchemaRep.ComplexType)elementExpr);
        }
    }

    protected void addTopAttributes(SchemaRep.Element element, SchemaRep.ComplexType complexType) {
        Iterator iterator = complexType.subElementsIterator();
        while (iterator.hasNext()) {
            SchemaRep.ElementExpr elementExpr = (SchemaRep.ElementExpr)iterator.next();
            if (elementExpr instanceof SchemaRep.Attribute) {
                this.addTopAttributes(element, (SchemaRep.Attribute)elementExpr);
                continue;
            }
            if (!(elementExpr instanceof SchemaRep.AttributeGroup)) continue;
            this.addTopAttributes(element, (SchemaRep.AttributeGroup)elementExpr);
        }
    }

    protected void addTopAttributes(SchemaRep.Element element, SchemaRep.Attribute attribute) {
        if (this.debug) {
            System.out.println("addTopAttribute to " + element + " attr=" + attribute);
        }
        String string = attribute.getAttributeName();
        if (attribute.getRef() != null) {
            this.addTopAttributes(element, this.schema.getAttribute(attribute.getRef()));
            return;
        }
        this.handler.startElement(element.getFullContentName(), element.getElementName(), 3);
        this.handler.element(attribute.getFullContentName(), string, 32);
        this.handler.element("CDATA", 32);
        if (attribute.getFixed() != null) {
            this.handler.element("#FIXED", 32);
            this.handler.element(attribute.getFullContentName(), attribute.getFixed(), 32);
        } else if (attribute.isRequired()) {
            this.handler.element("#REQUIRED", 32);
        } else {
            this.handler.element("#IMPLIED", 32);
        }
        this.handler.javaType(attribute.getFullContentName(), attribute.getAttributeName(), attribute.getType());
        this.handler.endElement();
    }

    protected void addTopAttributes(SchemaRep.Element element, SchemaRep.AttributeGroup attributeGroup) {
        SchemaRep.AttributeGroup attributeGroup2 = (SchemaRep.AttributeGroup)this.schema.getSchemaTypeDef(attributeGroup.getRef());
        if (this.debug) {
            System.out.println("addTopAttributes.AttributeGroup schemaTypeDef=" + attributeGroup2);
        }
        if (attributeGroup2 == null) {
            throw new IllegalStateException("attributeGroup ref has reference to unknown name: " + attributeGroup.getRef());
        }
        Iterator iterator = attributeGroup2.subElementsIterator();
        while (iterator.hasNext()) {
            SchemaRep.ElementExpr elementExpr = (SchemaRep.ElementExpr)iterator.next();
            if (elementExpr instanceof SchemaRep.Attribute) {
                this.addTopAttributes(element, (SchemaRep.Attribute)elementExpr);
                continue;
            }
            if (!(elementExpr instanceof SchemaRep.AttributeGroup)) continue;
            this.addTopAttributes(element, (SchemaRep.AttributeGroup)elementExpr);
        }
    }

    protected static int getInstanceValue(String string, String string2) {
        if (string == null) {
            string = "1";
        }
        if (string2 == null) {
            string2 = "1";
        }
        if (string.equals("0")) {
            if (string2.equals("1")) {
                return 16;
            }
            return 48;
        }
        if (string2.equals("1")) {
            return 32;
        }
        return 64;
    }
}

