/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tomcat.tomcat40.actions;

import java.io.IOException;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import org.netbeans.modules.tomcat.tomcat40.Tomcat40Installation;
import org.netbeans.modules.tomcat.tomcat40.serverconf.Context;
import org.netbeans.modules.tomcat.tomcat40.serverconf.Host;
import org.netbeans.modules.tomcat.tomcat40.serverconf.Server;
import org.netbeans.modules.tomcat.tomcat40.serverconf.Service;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;
import org.openide.windows.OutputWriter;

public class LogUtils {
    private static final String ACCESS_VALVE_CLASS = "org.apache.catalina.valves.AccessLogValve";
    private static final String DEFAULT_VALVE_PREFIX = "access_log.";
    private static final String DEFAULT_LOG_PREFIX = "catalina.";
    private static final String DEFAULT_LOG_SUFFIX = ".log";
    private static final String DEFAULT_LOG_DIR = "logs";
    private static final String LOG_FORMAT = "yyyy-MM-dd";
    static /* synthetic */ Class class$org$netbeans$modules$tomcat$tomcat40$actions$LogUtils;
    static /* synthetic */ Class class$org$openide$cookies$EditorCookie;

    public static void showContextLogFile(Tomcat40Installation tomcat40Installation, Context context) {
        String string;
        FileSystem fileSystem = tomcat40Installation.getBaseFileSystem();
        if (fileSystem == null) {
            return;
        }
        String string2 = context.getAttributeValue("Logger", "directory");
        if (string2 == null) {
            string2 = DEFAULT_LOG_DIR;
        }
        if ((string = context.getAttributeValue("Logger", "prefix")) == null) {
            String string3 = MessageFormat.format(NbBundle.getMessage((Class)(class$org$netbeans$modules$tomcat$tomcat40$actions$LogUtils == null ? (class$org$netbeans$modules$tomcat$tomcat40$actions$LogUtils = LogUtils.class$("org.netbeans.modules.tomcat.tomcat40.actions.LogUtils")) : class$org$netbeans$modules$tomcat$tomcat40$actions$LogUtils), (String)"MSG_contextLoggerNotDefined"), context.getAttributeValue("path"));
            TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string3, 2));
            return;
        }
        String string4 = context.getAttributeValue("Logger", "suffix");
        if (string4 == null) {
            string4 = DEFAULT_LOG_SUFFIX;
        }
        LogUtils.showLogFile(fileSystem, string2, string, string4, true);
    }

    public static void showHostLogFile(Tomcat40Installation tomcat40Installation, Host host) {
        String string;
        FileSystem fileSystem = tomcat40Installation.getBaseFileSystem();
        if (fileSystem == null) {
            return;
        }
        String string2 = host.getAttributeValue("Logger", "directory");
        if (string2 == null) {
            string2 = DEFAULT_LOG_DIR;
        }
        if ((string = host.getAttributeValue("Logger", "prefix")) == null) {
            String string3 = MessageFormat.format(NbBundle.getMessage((Class)(class$org$netbeans$modules$tomcat$tomcat40$actions$LogUtils == null ? (class$org$netbeans$modules$tomcat$tomcat40$actions$LogUtils = LogUtils.class$("org.netbeans.modules.tomcat.tomcat40.actions.LogUtils")) : class$org$netbeans$modules$tomcat$tomcat40$actions$LogUtils), (String)"MSG_hostLoggerNotDefined"), host.getAttributeValue("name"));
            TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string3, 2));
            return;
        }
        String string4 = host.getAttributeValue("Logger", "suffix");
        if (string4 == null) {
            string4 = DEFAULT_LOG_SUFFIX;
        }
        LogUtils.showLogFile(fileSystem, string2, string, string4, true);
    }

    public static void showAccessLogFile(Tomcat40Installation tomcat40Installation, Host host) {
        String string;
        String string2;
        FileSystem fileSystem = tomcat40Installation.getBaseFileSystem();
        if (fileSystem == null) {
            return;
        }
        int n = -1;
        int n2 = 0;
        while (n2 < host.sizeValve()) {
            if (ACCESS_VALVE_CLASS.equals(host.getAttributeValue("Valve", n2, "className"))) {
                n = n2;
                break;
            }
            ++n2;
        }
        if (n == -1) {
            String string3 = MessageFormat.format(NbBundle.getMessage((Class)(class$org$netbeans$modules$tomcat$tomcat40$actions$LogUtils == null ? (class$org$netbeans$modules$tomcat$tomcat40$actions$LogUtils = LogUtils.class$("org.netbeans.modules.tomcat.tomcat40.actions.LogUtils")) : class$org$netbeans$modules$tomcat$tomcat40$actions$LogUtils), (String)"MSG_accessLoggerNotDefined"), host.getAttributeValue("name"));
            TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string3, 2));
            return;
        }
        String string4 = host.getAttributeValue("Valve", n, "directory");
        if (string4 == null) {
            string4 = DEFAULT_LOG_DIR;
        }
        if ((string2 = host.getAttributeValue("Valve", n, "prefix")) == null) {
            string2 = DEFAULT_VALVE_PREFIX;
        }
        if ((string = host.getAttributeValue("Valve", n, "suffix")) == null) {
            string = DEFAULT_LOG_SUFFIX;
        }
        LogUtils.showLogFile(fileSystem, string4, string2, string, true);
    }

    public static void showServerLogFiles(Tomcat40Installation tomcat40Installation, Server server) {
        Object object;
        FileSystem fileSystem = tomcat40Installation.getBaseFileSystem();
        if (fileSystem == null) {
            return;
        }
        Service[] serviceArray = server.getService();
        if (serviceArray == null) {
            return;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < serviceArray.length) {
            object = serviceArray[n2].getEngine();
            if (object == null) {
                ++n;
            } else {
                boolean bl;
                String string;
                String string2;
                String string3 = object.getAttributeValue("Logger", "directory");
                if (string3 == null) {
                    string3 = DEFAULT_LOG_DIR;
                }
                if ((string2 = object.getAttributeValue("Logger", "prefix")) == null) {
                    string2 = DEFAULT_LOG_PREFIX;
                }
                if ((string = object.getAttributeValue("Logger", "suffix")) == null) {
                    string = DEFAULT_LOG_SUFFIX;
                }
                if (!(bl = LogUtils.showLogFile(fileSystem, string3, string2, string, false))) {
                    ++n;
                }
            }
            ++n2;
        }
        if (n == serviceArray.length) {
            object = MessageFormat.format(NbBundle.getMessage((Class)(class$org$netbeans$modules$tomcat$tomcat40$actions$LogUtils == null ? (class$org$netbeans$modules$tomcat$tomcat40$actions$LogUtils = LogUtils.class$("org.netbeans.modules.tomcat.tomcat40.actions.LogUtils")) : class$org$netbeans$modules$tomcat$tomcat40$actions$LogUtils), (String)"MSG_logFilesNotExist"), tomcat40Installation.getDisplayName());
            TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message(object, 2));
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean showLogFile(FileSystem fileSystem, String string, String string2, String string3, boolean bl) {
        void var10_17;
        Object object;
        String string4 = "";
        if (string3.startsWith(".")) {
            string4 = string3.substring(1);
        }
        String string5 = new SimpleDateFormat(LOG_FORMAT).format(new Date());
        FileObject fileObject = fileSystem.find(string, string2 + string5, string4);
        if (fileObject != null) {
            DataObject dataObject;
            boolean bl2 = false;
            if (string4.equals("txt")) {
                try {
                    dataObject = DataObject.find((FileObject)fileObject);
                    EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(class$org$openide$cookies$EditorCookie == null ? (class$org$openide$cookies$EditorCookie = LogUtils.class$("org.openide.cookies.EditorCookie")) : class$org$openide$cookies$EditorCookie);
                    if (editorCookie != null) {
                        editorCookie.open();
                        return true;
                    }
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    TopManager.getDefault().getErrorManager().notify((Throwable)dataObjectNotFoundException);
                }
            }
            if (bl2) return true;
            try {
                dataObject = TopManager.getDefault().getIO(fileObject.getName(), false);
                OutputWriter outputWriter = dataObject.getOut();
                InputStreamReader inputStreamReader = null;
                try {
                    int n;
                    inputStreamReader = new InputStreamReader(fileObject.getInputStream());
                    while ((n = inputStreamReader.read()) != -1) {
                        outputWriter.write(n);
                    }
                    Object var14_29 = null;
                    if (inputStreamReader == null) return true;
                }
                catch (Throwable throwable) {
                    Object var14_30 = null;
                    if (inputStreamReader == null) throw throwable;
                    inputStreamReader.close();
                    throw throwable;
                }
                inputStreamReader.close();
                return true;
            }
            catch (IOException iOException) {
                TopManager.getDefault().getErrorManager().notify((Throwable)iOException);
            }
            return true;
        }
        FileObject fileObject2 = fileSystem.find(string, null, null);
        Enumeration enumeration = fileObject2.getChildren(false);
        Object var10_16 = null;
        while (enumeration.hasMoreElements()) {
            FileObject fileObject3 = (FileObject)enumeration.nextElement();
            object = fileObject3.getName() + "." + fileObject3.getExt();
            if (!((String)object).startsWith(string2) || !((String)object).endsWith(string4)) continue;
            if (var10_17 == null) {
                FileObject fileObject4 = fileObject3;
                continue;
            }
            long l = fileObject3.lastModified().getTime();
            if (var10_17.lastModified().getTime() >= l) continue;
            FileObject fileObject5 = fileObject3;
        }
        if (var10_17 != null) {
            boolean bl3;
            boolean bl4 = false;
            if (string4.equals("txt")) {
                try {
                    object = DataObject.find((FileObject)var10_17);
                    EditorCookie editorCookie = (EditorCookie)object.getCookie(class$org$openide$cookies$EditorCookie == null ? (class$org$openide$cookies$EditorCookie = LogUtils.class$("org.openide.cookies.EditorCookie")) : class$org$openide$cookies$EditorCookie);
                    if (editorCookie != null) {
                        editorCookie.open();
                        return true;
                    }
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    TopManager.getDefault().getErrorManager().notify((Throwable)dataObjectNotFoundException);
                }
            }
            if (bl3) return true;
            try {
                object = TopManager.getDefault().getIO(var10_17.getName(), false);
                OutputWriter outputWriter = object.getOut();
                InputStreamReader inputStreamReader = null;
                try {
                    int n;
                    inputStreamReader = new InputStreamReader(var10_17.getInputStream());
                    while ((n = inputStreamReader.read()) != -1) {
                        outputWriter.write(n);
                    }
                    Object var17_37 = null;
                    if (inputStreamReader == null) return true;
                }
                catch (Throwable throwable) {
                    Object var17_38 = null;
                    if (inputStreamReader == null) throw throwable;
                    inputStreamReader.close();
                    throw throwable;
                }
                inputStreamReader.close();
                return true;
            }
            catch (IOException iOException) {
                TopManager.getDefault().getErrorManager().notify((Throwable)iOException);
            }
            return true;
        }
        if (!bl) return false;
        String string6 = MessageFormat.format(NbBundle.getMessage((Class)(class$org$netbeans$modules$tomcat$tomcat40$actions$LogUtils == null ? (class$org$netbeans$modules$tomcat$tomcat40$actions$LogUtils = LogUtils.class$("org.netbeans.modules.tomcat.tomcat40.actions.LogUtils")) : class$org$netbeans$modules$tomcat$tomcat40$actions$LogUtils), (String)"MSG_logFileNotExist"), string2 + LOG_FORMAT + "." + string4);
        TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string6, 2));
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

