/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.netbeans.modules.form.BeanSupport;
import org.netbeans.modules.form.FormAwareEditor;
import org.netbeans.modules.form.FormDesignValue;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.RADComponent;
import org.openide.explorer.propertysheet.editors.XMLPropertyEditor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ComponentChooserEditor
implements PropertyEditor,
FormAwareEditor,
XMLPropertyEditor {
    public static final int ALL_COMPONENTS = 0;
    public static final int VISUAL_COMPONENTS = 1;
    public static final int OTHER_COMPONENTS = 2;
    private static final String NULL_REF = "null";
    private static final String INVALID_REF = "default";
    private static String noneText = null;
    private static String invalidText = null;
    private FormModel formModel;
    private List components;
    private Class[] beanTypes = null;
    private int componentCategory = 0;
    private ComponentRef value;
    private Vector listeners;
    private static final String XML_COMPONENT = "ComponentRef";
    private static final String ATTR_NAME = "name";

    public ComponentChooserEditor() {
    }

    public ComponentChooserEditor(Class[] classArray) {
        this.beanTypes = classArray;
    }

    public void setValue(Object object) {
        if (object == null || object instanceof ComponentRef) {
            this.value = (ComponentRef)object;
        } else if (object instanceof RADComponent) {
            this.value = new ComponentRef((RADComponent)object);
        } else if (object instanceof String) {
            this.value = new ComponentRef((String)object);
        } else {
            return;
        }
        this.firePropertyChange();
    }

    public Object getValue() {
        if (this.value != null && INVALID_REF.equals(this.value.getDescription())) {
            return BeanSupport.NO_VALUE;
        }
        return this.value;
    }

    public String[] getTags() {
        List list = this.getComponents();
        int n = list.size() + 1;
        Object[] objectArray = new String[n];
        objectArray[0] = this.noneString();
        if (n > 1) {
            int n2 = 1;
            while (n2 < n) {
                objectArray[n2] = ((RADComponent)list.get(n2 - 1)).getName();
                ++n2;
            }
            Arrays.sort(objectArray, 1, n);
        }
        return objectArray;
    }

    public String getAsText() {
        if (this.value == null) {
            return this.noneString();
        }
        if (this.value.getComponent() == null) {
            return this.invalidString();
        }
        String string = this.value.getDescription();
        return NULL_REF.equals(string) ? this.noneString() : string;
    }

    public void setAsText(String string) {
        if (string == null || string.equals("") || string.equals(this.noneString())) {
            this.setValue(null);
        } else {
            this.setValue(string);
        }
    }

    public String getJavaInitializationString() {
        return this.value != null ? this.value.getJavaInitString() : null;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.listeners != null) {
            this.listeners.removeElement(propertyChangeListener);
        }
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
    }

    public Component getCustomEditor() {
        return null;
    }

    public boolean supportsCustomEditor() {
        return false;
    }

    public void setFormModel(FormModel formModel) {
        this.formModel = formModel;
    }

    public FormModel getFormModel() {
        return this.formModel;
    }

    public void setBeanTypes(Class[] classArray) {
        this.beanTypes = classArray;
    }

    public Class[] getBeanTypes() {
        return this.beanTypes;
    }

    public void setComponentCategory(int n) {
        this.componentCategory = n;
    }

    public int getComponentCategory() {
        return this.componentCategory;
    }

    public Node storeToXML(Document document) {
        String string = this.value != null ? (this.value.getComponent() != null ? this.value.getDescription() : INVALID_REF) : NULL_REF;
        Element element = document.createElement(XML_COMPONENT);
        element.setAttribute(ATTR_NAME, string);
        return element;
    }

    public void readFromXML(Node node) throws IOException {
        String string;
        Node node2;
        if (!XML_COMPONENT.equals(node.getNodeName())) {
            throw new IOException();
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null && (node2 = namedNodeMap.getNamedItem(ATTR_NAME)) != null && (string = node2.getNodeValue()) != null) {
            this.value = new ComponentRef(string);
        }
    }

    protected List getComponents() {
        if (this.components == null) {
            this.components = new ArrayList();
        } else {
            this.components.clear();
        }
        if (this.formModel != null) {
            RADComponent[] rADComponentArray;
            if (this.componentCategory == 1) {
                rADComponentArray = this.formModel.getVisualComponents();
            } else if (this.componentCategory == 2) {
                rADComponentArray = this.formModel.getOtherComponents(true);
            } else {
                List list = this.formModel.getMetaComponents();
                rADComponentArray = list.toArray(new RADComponent[list.size()]);
            }
            int n = 0;
            while (n < rADComponentArray.length) {
                if (this.acceptBean(rADComponentArray[n])) {
                    this.components.add(rADComponentArray[n]);
                }
                ++n;
            }
        }
        return this.components;
    }

    protected boolean acceptBean(RADComponent rADComponent) {
        if (this.beanTypes == null) {
            return true;
        }
        boolean bl = false;
        int n = 0;
        while (n < this.beanTypes.length && !bl) {
            bl = this.beanTypes[n].isAssignableFrom(rADComponent.getBeanClass());
            ++n;
        }
        return bl;
    }

    protected String noneString() {
        if (noneText == null) {
            noneText = FormUtils.getBundleString("CTL_NoComponent");
        }
        return noneText;
    }

    protected String invalidString() {
        if (invalidText == null) {
            invalidText = FormUtils.getBundleString("CTL_InvalidReference");
        }
        return invalidText;
    }

    protected final void firePropertyChange() {
        Vector vector;
        ComponentChooserEditor componentChooserEditor = this;
        synchronized (componentChooserEditor) {
            if (this.listeners == null) {
                return;
            }
            vector = (Vector)this.listeners.clone();
        }
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, null, null, null);
        int n = 0;
        while (n < vector.size()) {
            ((PropertyChangeListener)vector.elementAt(n)).propertyChange(propertyChangeEvent);
            ++n;
        }
    }

    private class ComponentRef
    implements RADComponent.ComponentReference,
    FormDesignValue {
        private String componentName;
        private RADComponent component;

        ComponentRef(String string) {
            this.componentName = string;
        }

        ComponentRef(RADComponent rADComponent) {
            this.componentName = rADComponent.getName();
            this.component = rADComponent;
        }

        public boolean equals(Object object) {
            return this == object || object instanceof RADComponent && object == this.component;
        }

        String getJavaInitString() {
            this.checkComponent();
            if (this.component != null) {
                if (this.component == this.component.getFormModel().getTopRADComponent()) {
                    return "this";
                }
            } else if (!ComponentChooserEditor.NULL_REF.equals(this.componentName)) {
                return null;
            }
            return this.componentName;
        }

        public RADComponent getComponent() {
            this.checkComponent();
            return this.component;
        }

        public String getDescription() {
            this.checkComponent();
            return this.componentName;
        }

        public Object getDesignValue() {
            this.checkComponent();
            return this.component != null ? this.component.getBeanInstance() : FormDesignValue.IGNORED_VALUE;
        }

        private void checkComponent() {
            if (this.component == null && !ComponentChooserEditor.NULL_REF.equals(this.componentName) && !ComponentChooserEditor.INVALID_REF.equals(this.componentName)) {
                List list = ComponentChooserEditor.this.getComponents();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    RADComponent rADComponent = (RADComponent)iterator.next();
                    if (!rADComponent.getName().equals(this.componentName)) continue;
                    if (rADComponent.isInModel()) {
                        this.component = rADComponent;
                    }
                    break;
                }
            } else if (this.component != null) {
                if (!this.component.isInModel()) {
                    this.component = null;
                } else {
                    this.componentName = this.component.getName();
                }
            }
        }
    }
}

