/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.netbeans.modules.form.ComponentContainer;
import org.netbeans.modules.form.FormDesigner;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormLoaderSettings;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.HandleLayer;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADVisualComponent;
import org.netbeans.modules.form.RADVisualContainer;
import org.netbeans.modules.form.layoutsupport.LayoutConstraints;
import org.netbeans.modules.form.layoutsupport.LayoutSupportManager;

class ComponentDragger {
    private FormDesigner formDesigner;
    private HandleLayer handleLayer;
    private RADVisualComponent[] selectedComponents;
    private Point hotspot;
    private Point mousePosition;
    private int resizeType;
    private RADVisualContainer targetMetaContainer;
    private boolean fixedTarget;
    private Container targetContainer;
    private Container targetContainerDel;
    private static FormLoaderSettings formSettings = FormEditor.getFormSettings();

    ComponentDragger(FormDesigner formDesigner, HandleLayer handleLayer, RADVisualComponent[] rADVisualComponentArray, Point point, RADVisualContainer rADVisualContainer) {
        this.formDesigner = formDesigner;
        this.handleLayer = handleLayer;
        this.selectedComponents = rADVisualComponentArray;
        this.hotspot = point;
        this.mousePosition = point;
        this.resizeType = 0;
        if (rADVisualContainer != null) {
            this.targetMetaContainer = rADVisualContainer;
            this.fixedTarget = true;
        }
    }

    ComponentDragger(FormDesigner formDesigner, HandleLayer handleLayer, RADVisualComponent[] rADVisualComponentArray, Point point, int n) {
        this.formDesigner = formDesigner;
        this.handleLayer = handleLayer;
        this.selectedComponents = rADVisualComponentArray;
        this.hotspot = point;
        this.mousePosition = point;
        this.resizeType = n;
    }

    void drag(Point point) {
        this.mousePosition = point;
    }

    void paintDragFeedback(Graphics2D graphics2D) {
        Stroke stroke = graphics2D.getStroke();
        BasicStroke basicStroke = new BasicStroke(2.0f, 2, 0, 10.0f, new float[]{1.0f, 4.0f}, 0.0f);
        graphics2D.setStroke(basicStroke);
        Color color = graphics2D.getColor();
        graphics2D.setColor(formSettings.getSelectionBorderColor());
        ArrayList arrayList = new ArrayList(this.selectedComponents.length);
        ArrayList arrayList2 = new ArrayList(this.selectedComponents.length);
        boolean bl = this.computeConstraints(this.mousePosition, arrayList, arrayList2);
        Point point = null;
        LayoutSupportManager layoutSupportManager = null;
        if (bl) {
            point = SwingUtilities.convertPoint(this.targetContainerDel, 0, 0, this.handleLayer);
            layoutSupportManager = this.targetMetaContainer.getLayoutSupport();
            if (this.resizeType == 0) {
                this.paintTargetContainerFeedback(graphics2D, this.targetContainerDel);
            }
        }
        int n = 0;
        while (n < this.selectedComponents.length) {
            RADVisualComponent rADVisualComponent = this.selectedComponents[n];
            boolean bl2 = false;
            if (bl) {
                Component component = (Component)this.formDesigner.getComponent(rADVisualComponent);
                LayoutConstraints layoutConstraints = (LayoutConstraints)arrayList.get(n);
                int n2 = (Integer)arrayList2.get(n);
                if (layoutConstraints != null || n2 >= 0) {
                    graphics2D.translate(point.x, point.y);
                    bl2 = layoutSupportManager.paintDragFeedback(this.targetContainer, this.targetContainerDel, component, layoutConstraints, n2, graphics2D);
                    graphics2D.translate(-point.x, -point.y);
                }
            }
            if (!bl2) {
                this.paintDragFeedback(graphics2D, rADVisualComponent);
            }
            ++n;
        }
        graphics2D.setColor(color);
        graphics2D.setStroke(stroke);
    }

    void dropComponents(Point point) {
        RADVisualComponent[] rADVisualComponentArray;
        RADVisualComponent[] rADVisualComponentArray2;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        RADVisualComponent[] rADVisualComponentArray3;
        int n6;
        ArrayList<LayoutConstraints> arrayList = null;
        ArrayList arrayList2 = null;
        if (this.targetMetaContainer != null ? !this.computeConstraints(point, arrayList = new ArrayList<LayoutConstraints>(this.selectedComponents.length), arrayList2 = new ArrayList(this.selectedComponents.length)) : this.handleLayer.mouseOnVisual(point)) {
            return;
        }
        FormModel formModel = this.formDesigner.getModel();
        LayoutSupportManager layoutSupportManager = null;
        RADVisualComponent[] rADVisualComponentArray4 = null;
        LayoutConstraints[] layoutConstraintsArray = null;
        ArrayList<Integer> arrayList3 = null;
        ArrayList<RADVisualComponent> arrayList4 = null;
        if (this.targetMetaContainer != null) {
            layoutSupportManager = this.targetMetaContainer.getLayoutSupport();
            rADVisualComponentArray4 = this.targetMetaContainer.getSubComponents();
            layoutConstraintsArray = new LayoutConstraints[rADVisualComponentArray4.length];
            this.adjustIndices(arrayList2);
            n6 = 0;
            while (n6 < this.selectedComponents.length) {
                if (this.selectedComponents[n6].getParentContainer() != this.targetMetaContainer) {
                    if (arrayList3 == null) {
                        arrayList3 = new ArrayList<Integer>(this.selectedComponents.length);
                    }
                    arrayList3.add(new Integer(n6));
                } else {
                    if (arrayList4 == null) {
                        arrayList4 = new ArrayList<RADVisualComponent>(this.selectedComponents.length);
                    }
                    arrayList4.add(this.selectedComponents[n6]);
                }
                ++n6;
            }
            if (arrayList3 != null && arrayList3.size() > 0) {
                int n7 = arrayList3.size();
                rADVisualComponentArray3 = new RADVisualComponent[n7];
                LayoutConstraints[] layoutConstraintsArray2 = new LayoutConstraints[n7];
                n5 = 0;
                while (n5 < n7) {
                    n4 = (Integer)arrayList3.get(n5);
                    rADVisualComponentArray3[n5] = this.selectedComponents[n4];
                    layoutConstraintsArray2[n5] = (LayoutConstraints)arrayList.get(n4);
                    ++n5;
                }
                n4 = (Integer)arrayList3.get(0);
                n3 = (Integer)arrayList2.get(n4);
                try {
                    layoutSupportManager.acceptNewComponents(rADVisualComponentArray3, layoutConstraintsArray2, n3);
                }
                catch (RuntimeException runtimeException) {
                    if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                        runtimeException.printStackTrace();
                    }
                    return;
                }
                int n8 = 0;
                while (n8 < n7) {
                    n2 = (Integer)arrayList3.get(n8);
                    arrayList.set(n2, layoutConstraintsArray2[n8]);
                    ++n8;
                }
                arrayList3.clear();
            }
        }
        n6 = this.selectedComponents.length + (rADVisualComponentArray4 != null ? rADVisualComponentArray4.length : 0);
        ArrayList<RADVisualComponent> arrayList5 = new ArrayList<RADVisualComponent>(n6);
        rADVisualComponentArray3 = new ArrayList(n6);
        int n9 = 0;
        n5 = 0;
        while (n5 < n6) {
            arrayList5.add(null);
            rADVisualComponentArray3.add(null);
            ++n5;
        }
        if (this.targetMetaContainer != null) {
            n4 = 0;
            while (n4 < this.selectedComponents.length) {
                n3 = (Integer)arrayList2.get(n4);
                if (n3 >= 0 && n3 < n6 && this.checkTarget(this.selectedComponents[n4])) {
                    while (arrayList5.get(n3) != null) {
                        if (++n3 != n6) continue;
                        n3 = 0;
                    }
                    arrayList5.set(n3, this.selectedComponents[n4]);
                }
                ++n4;
            }
            n3 = 0;
            while (n3 < rADVisualComponentArray4.length) {
                RADVisualComponent rADVisualComponent = rADVisualComponentArray4[n3];
                layoutConstraintsArray[n3] = layoutSupportManager.getConstraints(rADVisualComponent);
                n2 = arrayList5.indexOf(rADVisualComponent);
                if (n2 < 0) {
                    while (arrayList5.get(n9) != null) {
                        ++n9;
                    }
                    arrayList5.set(n9, rADVisualComponent);
                    rADVisualComponentArray3.set(n9, layoutConstraintsArray[n3]);
                }
                ++n3;
            }
        }
        n4 = 0;
        while (n4 < this.selectedComponents.length) {
            RADVisualComponent rADVisualComponent = this.selectedComponents[n4];
            int n10 = arrayList5.indexOf(rADVisualComponent);
            if (n10 >= 0) {
                rADVisualComponentArray3.set(n10, arrayList != null ? (Object)arrayList.get(n4) : null);
            } else if (this.checkTarget(rADVisualComponent)) {
                while (arrayList5.get(n9) != null) {
                    ++n9;
                }
                arrayList5.set(n9, rADVisualComponent);
                rADVisualComponentArray3.set(n9, arrayList != null ? (Object)arrayList.get(n4) : null);
            }
            ++n4;
        }
        int n11 = 0;
        while (n11 < n6) {
            RADVisualComponent rADVisualComponent = (RADVisualComponent)arrayList5.get(n11);
            if (rADVisualComponent != null) {
                RADVisualContainer rADVisualContainer = rADVisualComponent.getParentContainer();
                if (rADVisualContainer != this.targetMetaContainer) {
                    if (arrayList3 == null) {
                        arrayList3 = new ArrayList(this.selectedComponents.length);
                    }
                    arrayList3.add((Integer)((Object)rADVisualComponent));
                    formModel.removeComponentFromContainer(rADVisualComponent);
                }
            } else {
                arrayList5.remove(n11);
                rADVisualComponentArray3.remove(n11);
                --n11;
                --n6;
            }
            ++n11;
        }
        if (n6 == 0) {
            return;
        }
        boolean bl = formModel.isUndoRedoRecording();
        if (bl) {
            formModel.setUndoRedoRecording(false);
        }
        RADComponent[] rADComponentArray = new RADVisualComponent[n6];
        LayoutConstraints[] layoutConstraintsArray3 = new LayoutConstraints[n6];
        if (this.targetMetaContainer != null) {
            int n12 = 0;
            while (n12 < n6) {
                rADComponentArray[n12] = (RADVisualComponent)arrayList5.get(n12);
                layoutConstraintsArray3[n12] = (LayoutConstraints)rADVisualComponentArray3.get(n12);
                ++n12;
            }
            layoutSupportManager.removeAll();
            this.targetMetaContainer.initSubComponents(rADComponentArray);
            layoutSupportManager.addComponents((RADVisualComponent[])rADComponentArray, layoutConstraintsArray3, 0);
        } else {
            ComponentContainer componentContainer = formModel.getModelContainer();
            n = 0;
            while (n < n6) {
                rADComponentArray[n] = (RADVisualComponent)arrayList5.get(n);
                componentContainer.add(rADComponentArray[n]);
                ++n;
            }
        }
        if (arrayList3 != null) {
            n6 = arrayList3.size();
            rADVisualComponentArray2 = new RADVisualComponent[n6];
            n = 0;
            while (n < n6) {
                rADVisualComponentArray2[n] = (RADVisualComponent)arrayList3.get(n);
                formModel.fireComponentAdded(rADVisualComponentArray2[n], false);
                ++n;
            }
        } else {
            rADVisualComponentArray2 = new RADVisualComponent[]{};
            formModel.fireComponentsReordered(this.targetMetaContainer, new int[0]);
        }
        if (arrayList4 != null) {
            n6 = arrayList4.size();
            rADVisualComponentArray = new RADVisualComponent[n6];
            int n13 = 0;
            while (n13 < n6) {
                rADVisualComponentArray[n13] = (RADVisualComponent)arrayList4.get(n13);
                formModel.fireComponentLayoutChanged(rADVisualComponentArray[n13], null, null, null);
                ++n13;
            }
        } else {
            rADVisualComponentArray = new RADVisualComponent[]{};
        }
        if (bl) {
            DropUndoableEdit dropUndoableEdit = new DropUndoableEdit();
            dropUndoableEdit.formModel = formModel;
            dropUndoableEdit.targetContainer = this.targetMetaContainer;
            dropUndoableEdit.targetComponentsBeforeMove = rADVisualComponentArray4;
            dropUndoableEdit.targetConstraintsBeforeMove = layoutConstraintsArray;
            dropUndoableEdit.targetComponentsAfterMove = rADComponentArray;
            dropUndoableEdit.targetConstraintsAfterMove = layoutConstraintsArray3;
            dropUndoableEdit.componentsMovedFromOutside = rADVisualComponentArray2;
            dropUndoableEdit.componentsMovedWithinTarget = rADVisualComponentArray;
            formModel.addUndoableEdit(dropUndoableEdit);
        }
        if (bl) {
            formModel.setUndoRedoRecording(true);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ComponentDragger.this.formDesigner.setSelectedComponents(ComponentDragger.this.selectedComponents);
            }
        });
    }

    private boolean computeConstraints(Point point, List list, List list2) {
        if (this.selectedComponents == null || this.selectedComponents.length == 0) {
            return false;
        }
        if (!this.fixedTarget) {
            RADVisualContainer rADVisualContainer = this.targetMetaContainer = this.resizeType == 0 ? this.handleLayer.getMetaContainerAt(point) : this.selectedComponents[0].getParentContainer();
            if (this.targetMetaContainer == null) {
                return false;
            }
        }
        RADVisualContainer rADVisualContainer = null;
        block0: do {
            if (rADVisualContainer != null) {
                this.targetMetaContainer = rADVisualContainer;
                rADVisualContainer = null;
            }
            LayoutSupportManager layoutSupportManager = this.targetMetaContainer.getLayoutSupport();
            this.targetContainer = (Container)this.formDesigner.getComponent(this.targetMetaContainer);
            if (this.targetContainer == null) {
                return false;
            }
            this.targetContainerDel = this.targetMetaContainer.getContainerDelegate(this.targetContainer);
            if (this.targetContainerDel == null) {
                return false;
            }
            Point point2 = SwingUtilities.convertPoint(this.handleLayer, point, this.targetContainerDel);
            int n = 0;
            while (n < this.selectedComponents.length) {
                LayoutConstraints layoutConstraints = null;
                int n2 = -1;
                RADVisualComponent rADVisualComponent = this.selectedComponents[n];
                Component component = (Component)this.formDesigner.getComponent(rADVisualComponent);
                if (component != null) {
                    if (!this.checkTarget(rADVisualComponent)) {
                        rADVisualContainer = rADVisualComponent.getParentContainer();
                        list.clear();
                        list2.clear();
                        if (rADVisualContainer != null) continue block0;
                        return false;
                    }
                    if (this.resizeType == 0) {
                        Point point3 = SwingUtilities.convertPoint(this.handleLayer, this.hotspot, component);
                        n2 = layoutSupportManager.getNewIndex(this.targetContainer, this.targetContainerDel, component, rADVisualComponent.getComponentIndex(), point2, point3);
                        layoutConstraints = layoutSupportManager.getNewConstraints(this.targetContainer, this.targetContainerDel, component, rADVisualComponent.getComponentIndex(), point2, point3);
                    } else {
                        int n3 = 0;
                        int n4 = 0;
                        int n5 = 0;
                        int n6 = 0;
                        if ((this.resizeType & 2) != 0) {
                            n4 = point.y - this.hotspot.y;
                        } else if ((this.resizeType & 1) != 0) {
                            n3 = this.hotspot.y - point.y;
                        }
                        if ((this.resizeType & 8) != 0) {
                            n6 = point.x - this.hotspot.x;
                        } else if ((this.resizeType & 4) != 0) {
                            n5 = this.hotspot.x - point.x;
                        }
                        Insets insets = new Insets(n3, n5, n4, n6);
                        layoutConstraints = layoutSupportManager.getResizedConstraints(this.targetContainer, this.targetContainerDel, component, rADVisualComponent.getComponentIndex(), insets, point2);
                    }
                }
                list.add(layoutConstraints);
                list2.add(new Integer(n2));
                ++n;
            }
        } while (rADVisualContainer != null);
        return true;
    }

    private boolean checkTarget(RADVisualComponent rADVisualComponent) {
        if (!(rADVisualComponent instanceof RADVisualContainer)) {
            return true;
        }
        RADComponent rADComponent = this.targetMetaContainer;
        while (rADComponent != null) {
            if (rADComponent == rADVisualComponent) {
                return false;
            }
            rADComponent = rADComponent.getParentComponent();
        }
        return true;
    }

    private void adjustIndices(List list) {
        int n = -1;
        int n2 = 0;
        int n3 = 0;
        while (n3 < list.size()) {
            int n4 = (Integer)list.get(n3);
            if (n4 >= 0) {
                int n5;
                if (n4 == n) {
                    n5 = n2;
                } else {
                    n5 = 0;
                    RADVisualComponent[] rADVisualComponentArray = this.targetMetaContainer.getSubComponents();
                    int n6 = 0;
                    while (n6 < n4) {
                        RADVisualComponent rADVisualComponent = rADVisualComponentArray[n6];
                        boolean bl = false;
                        int n7 = 0;
                        while (n7 < this.selectedComponents.length) {
                            if (rADVisualComponent == this.selectedComponents[n7]) {
                                bl = true;
                                break;
                            }
                            ++n7;
                        }
                        if (bl) {
                            ++n5;
                        }
                        ++n6;
                    }
                    n = n4;
                    n2 = n5;
                }
                if (n5 != 0) {
                    list.set(n3, new Integer(n4 -= n5));
                }
            }
            ++n3;
        }
    }

    private void paintDragFeedback(Graphics2D graphics2D, RADVisualComponent rADVisualComponent) {
        Object object = this.formDesigner.getComponent(rADVisualComponent);
        if (!(object instanceof Component) || !((Component)object).isShowing()) {
            return;
        }
        Component component = (Component)object;
        Rectangle rectangle = component.getBounds();
        rectangle = SwingUtilities.convertRectangle(component.getParent(), rectangle, this.handleLayer);
        rectangle.translate(this.mousePosition.x - this.hotspot.x, this.mousePosition.y - this.hotspot.y);
        graphics2D.draw(new Rectangle2D.Double(rectangle.x, rectangle.y, rectangle.width, rectangle.height));
        if (rADVisualComponent instanceof RADVisualContainer) {
            RADVisualComponent[] rADVisualComponentArray = ((RADVisualContainer)rADVisualComponent).getSubComponents();
            int n = 0;
            while (n < rADVisualComponentArray.length) {
                this.paintDragFeedback(graphics2D, rADVisualComponentArray[n]);
                ++n;
            }
        }
    }

    private void paintTargetContainerFeedback(Graphics2D graphics2D, Container container) {
        Stroke stroke = graphics2D.getStroke();
        BasicStroke basicStroke = new BasicStroke(2.0f, 2, 0, 10.0f, new float[]{2.0f, 8.0f}, 0.0f);
        graphics2D.setStroke(basicStroke);
        Color color = graphics2D.getColor();
        graphics2D.setColor(formSettings.getDragBorderColor());
        Rectangle rectangle = new Rectangle(new Point(0, 0), container.getSize());
        rectangle = SwingUtilities.convertRectangle(container, rectangle, this.handleLayer);
        graphics2D.draw(new Rectangle2D.Double(rectangle.x, rectangle.y, rectangle.width, rectangle.height));
        graphics2D.setColor(color);
        graphics2D.setStroke(stroke);
    }

    private static class DropUndoableEdit
    extends AbstractUndoableEdit {
        FormModel formModel;
        RADVisualContainer targetContainer;
        RADVisualComponent[] targetComponentsBeforeMove;
        LayoutConstraints[] targetConstraintsBeforeMove;
        RADVisualComponent[] targetComponentsAfterMove;
        LayoutConstraints[] targetConstraintsAfterMove;
        RADVisualComponent[] componentsMovedFromOutside;
        RADVisualComponent[] componentsMovedWithinTarget;

        private DropUndoableEdit() {
        }

        public void undo() throws CannotUndoException {
            super.undo();
            boolean bl = this.formModel.isUndoRedoRecording();
            if (bl) {
                this.formModel.setUndoRedoRecording(false);
            }
            int n = 0;
            while (n < this.componentsMovedFromOutside.length) {
                this.formModel.removeComponentFromContainer(this.componentsMovedFromOutside[n]);
                ++n;
            }
            if (this.targetContainer != null) {
                LayoutSupportManager layoutSupportManager = this.targetContainer.getLayoutSupport();
                layoutSupportManager.removeAll();
                this.targetContainer.initSubComponents(this.targetComponentsBeforeMove);
                layoutSupportManager.addComponents(this.targetComponentsBeforeMove, this.targetConstraintsBeforeMove, 0);
                int n2 = 0;
                while (n2 < this.componentsMovedWithinTarget.length) {
                    this.formModel.fireComponentLayoutChanged(this.componentsMovedWithinTarget[n2], null, null, null);
                    ++n2;
                }
            }
            if (bl) {
                this.formModel.setUndoRedoRecording(true);
            }
        }

        public void redo() throws CannotRedoException {
            int n;
            Object object;
            super.redo();
            boolean bl = this.formModel.isUndoRedoRecording();
            if (bl) {
                this.formModel.setUndoRedoRecording(false);
            }
            if (this.targetContainer != null) {
                object = this.targetContainer.getLayoutSupport();
                ((LayoutSupportManager)object).removeAll();
                this.targetContainer.initSubComponents(this.targetComponentsAfterMove);
                ((LayoutSupportManager)object).addComponents(this.targetComponentsAfterMove, this.targetConstraintsAfterMove, 0);
            } else {
                object = this.formModel.getModelContainer();
                n = 0;
                while (n < this.targetComponentsAfterMove.length) {
                    object.add(this.targetComponentsAfterMove[n]);
                    ++n;
                }
            }
            int n2 = 0;
            while (n2 < this.componentsMovedFromOutside.length) {
                this.formModel.fireComponentAdded(this.componentsMovedFromOutside[n2], false);
                ++n2;
            }
            n = 0;
            while (n < this.componentsMovedWithinTarget.length) {
                this.formModel.fireComponentLayoutChanged(this.componentsMovedWithinTarget[n], null, null, null);
                ++n;
            }
            if (bl) {
                this.formModel.setUndoRedoRecording(true);
            }
        }

        public String getUndoPresentationName() {
            return "";
        }

        public String getRedoPresentationName() {
            return "";
        }
    }
}

