/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.form.ComponentContainer;
import org.netbeans.modules.form.ComponentInspector;
import org.netbeans.modules.form.FormDataObject;
import org.netbeans.modules.form.FormDesigner;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormModelEvent;
import org.netbeans.modules.form.FormModelListener;
import org.netbeans.modules.form.FormNode;
import org.netbeans.modules.form.FormRootNode;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.PersistenceException;
import org.netbeans.modules.form.PersistenceManager;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADComponentNode;
import org.netbeans.modules.form.RADVisualContainer;
import org.netbeans.modules.form.palette.CPManager;
import org.netbeans.modules.form.palette.PaletteTopComponent;
import org.netbeans.modules.java.JavaEditor;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.awt.UndoRedo;
import org.openide.cookies.SourceCookie;
import org.openide.loaders.DataObject;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.Node;
import org.openide.util.Task;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.Workspace;

public class FormEditorSupport
extends JavaEditor {
    static final String NO_WORKSPACE = "None";
    private static final int LOADING = 1;
    private static final int SAVING = 2;
    private FormModel formModel;
    private FormDataObject formDataObject;
    private FormRootNode formRootNode;
    private FormDesigner formDesigner;
    private ArrayList floatingWindows;
    private PersistenceManager persistenceManager;
    private ArrayList persistenceErrors;
    private boolean formLoaded = false;
    private boolean openOnEditing = false;
    private FormModelListener formListener;
    private static PropertyChangeListener workspacesListener;
    private static PropertyChangeListener settingsListener;
    private static PropertyChangeListener topcompsListener;
    private static PropertyChangeListener paletteListener;
    private UndoRedo.Manager editorUndoManager;
    private static Hashtable openForms;

    public FormEditorSupport(MultiDataObject.Entry entry, FormDataObject formDataObject) {
        super(entry);
        this.formDataObject = formDataObject;
    }

    public void openForm() {
        TopManager.getDefault().setStatusText(FormUtils.getFormattedBundleString("FMT_OpeningForm", new Object[]{this.formDataObject.getName()}));
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                try {
                    FormEditorSupport.this.loadFormData();
                }
                catch (PersistenceException persistenceException) {
                    FormEditorSupport.this.logPersistenceError(persistenceException, 0);
                }
                boolean bl = FormEditorSupport.this.formLoaded && FormEditorSupport.this.activateWorkspace();
                FormEditorSupport.this.superOpen();
                if (bl) {
                    FormEditorSupport.this.openGUI();
                }
                TopManager.getDefault().setStatusText("");
                FormEditorSupport.this.reportErrors(1);
            }
        });
    }

    public boolean loadForm() {
        if (this.formLoaded) {
            return true;
        }
        if (EventQueue.isDispatchThread()) {
            try {
                this.loadFormData();
            }
            catch (PersistenceException persistenceException) {
                this.logPersistenceError(persistenceException, 0);
            }
        } else {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    public void run() {
                        try {
                            FormEditorSupport.this.loadFormData();
                        }
                        catch (PersistenceException persistenceException) {
                            FormEditorSupport.this.logPersistenceError(persistenceException, 0);
                        }
                    }
                });
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return this.formLoaded;
    }

    public boolean isOpened() {
        return this.formLoaded;
    }

    public void saveDocument() throws IOException {
        IOException iOException = null;
        try {
            this.saveFormData();
            super.saveDocument();
        }
        catch (PersistenceException persistenceException) {
            Throwable throwable = persistenceException.getOriginalException();
            if (throwable instanceof IOException) {
                iOException = (IOException)throwable;
            }
            iOException = new IOException("Cannot save the form");
            ErrorManager.getDefault().annotate((Throwable)iOException, throwable != null ? throwable : persistenceException);
        }
        this.reportErrors(2);
        if (iOException != null) {
            throw iOException;
        }
    }

    protected void saveDocumentIfNecessary(boolean bl) throws IOException {
        IOException iOException = null;
        try {
            this.saveFormData();
            super.saveDocumentIfNecessary(bl);
        }
        catch (PersistenceException persistenceException) {
            Throwable throwable = persistenceException.getOriginalException();
            if (throwable instanceof IOException) {
                iOException = (IOException)throwable;
            }
            iOException = new IOException("Cannot save the form");
            ErrorManager.getDefault().annotate((Throwable)iOException, throwable != null ? throwable : persistenceException);
        }
        this.reportErrors(2);
        if (iOException != null) {
            throw iOException;
        }
    }

    public boolean saveForm() {
        try {
            this.saveFormData();
            return true;
        }
        catch (PersistenceException persistenceException) {
            this.logPersistenceError(persistenceException, 0);
            return false;
        }
    }

    public final FormDataObject getFormDataObject() {
        return this.formDataObject;
    }

    public final Node getFormRootNode() {
        return this.formRootNode;
    }

    public final FormModel getFormModel() {
        return this.formModel;
    }

    public Throwable[] getPersistenceErrors() {
        if (!this.anyPersistenceError()) {
            return new Throwable[0];
        }
        Throwable[] throwableArray = new Throwable[this.persistenceErrors.size()];
        this.persistenceErrors.toArray(throwableArray);
        return throwableArray;
    }

    public void reportErrors(int n) {
        if (!this.anyPersistenceError()) {
            return;
        }
        ErrorManager errorManager = ErrorManager.getDefault();
        boolean bl = n == 1 && this.formLoaded;
        boolean bl2 = false;
        Iterator iterator = ((AbstractList)this.persistenceErrors).iterator();
        while (iterator.hasNext()) {
            ErrorManager.Annotation[] annotationArray;
            Throwable throwable = (Throwable)iterator.next();
            if (throwable instanceof PersistenceException && (annotationArray = ((PersistenceException)throwable).getOriginalException()) != null) {
                throwable = annotationArray;
            }
            if (bl && !bl2) {
                annotationArray = errorManager.findAnnotations(throwable);
                int n2 = 0;
                if (annotationArray != null) {
                    int n3 = 0;
                    while (n3 < annotationArray.length) {
                        int n4 = annotationArray[n3].getSeverity();
                        if (n4 > n2) {
                            n2 = n4;
                        }
                        ++n3;
                    }
                } else {
                    n2 = 4096;
                }
                if (n2 > 16) {
                    bl2 = true;
                }
            }
            errorManager.notify(throwable);
        }
        if (bl && bl2) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    TopManager.getDefault().notify(new NotifyDescriptor((Object)FormUtils.getBundleString("MSG_FormLoadedWithErrors"), FormUtils.getBundleString("CTL_FormLoadedWithErrors"), -1, 2, new Object[]{NotifyDescriptor.OK_OPTION}, null));
                }
            });
        }
        this.resetPersistenceErrorLog();
    }

    public void registerFloatingWindow(Window window) {
        if (this.floatingWindows == null) {
            this.floatingWindows = new ArrayList();
        } else {
            ((AbstractCollection)this.floatingWindows).remove(window);
        }
        this.floatingWindows.add(window);
    }

    public void unregisterFloatingWindow(Window window) {
        if (this.floatingWindows != null) {
            ((AbstractCollection)this.floatingWindows).remove(window);
        }
    }

    FormDesigner getFormDesigner() {
        if (!this.formLoaded) {
            return null;
        }
        if (this.formDesigner == null) {
            this.formDesigner = new FormDesigner(this.formModel);
            if (this.formListener != null) {
                this.formModel.removeFormModelListener(this.formListener);
                this.formModel.addFormModelListener(this.formListener);
            }
        } else if (this.formDesigner.getModel() == null) {
            this.formDesigner.setModel(this.formModel);
        }
        return this.formDesigner;
    }

    void setFormDesigner(FormDesigner formDesigner) {
        this.formDesigner = formDesigner;
    }

    void markFormModified() {
        if (this.formLoaded && !this.formDataObject.isModified()) {
            super.notifyModified();
        }
    }

    void updateFormName(String string) {
        if (!this.formLoaded) {
            return;
        }
        this.formModel.setName(string);
        this.formModel.getFormDesigner().updateName(string);
        this.formRootNode.updateName(string);
        this.formModel.fireFormChanged();
    }

    void updateNodeChildren(ComponentContainer componentContainer) {
        FormNode formNode = componentContainer == null || componentContainer == this.formModel.getModelContainer() ? (this.formRootNode != null ? this.formRootNode.getOthersNode() : null) : (componentContainer instanceof RADComponent ? ((RADComponent)((Object)componentContainer)).getNodeReference() : null);
        if (formNode != null) {
            formNode.updateChildren();
        }
    }

    protected UndoRedo.Manager createUndoRedoManager() {
        this.editorUndoManager = super.createUndoRedoManager();
        return this.editorUndoManager;
    }

    void discardEditorUndoableEdits() {
        if (this.editorUndoManager != null) {
            this.editorUndoManager.discardAllEdits();
        }
    }

    UndoRedo.Manager getFormUndoRedoManager() {
        return this.formModel != null ? this.formModel.getUndoRedoManager() : null;
    }

    public static FormModel[] getOpenedForms() {
        Hashtable hashtable = openForms;
        synchronized (hashtable) {
            Object object;
            Collection collection = openForms.values();
            ArrayList<FormModel> arrayList = new ArrayList<FormModel>(collection.size());
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                object = (FormEditorSupport)((Object)iterator.next());
                if (!((FormEditorSupport)((Object)object)).formLoaded) continue;
                arrayList.add(((FormEditorSupport)((Object)object)).getFormModel());
            }
            object = new FormModel[arrayList.size()];
            arrayList.toArray((T[])object);
            Object object2 = object;
            return object2;
        }
    }

    public static FormDesigner getFormDesigner(FormModel formModel) {
        FormEditorSupport formEditorSupport = (FormEditorSupport)((Object)openForms.get(formModel));
        return formEditorSupport != null ? formEditorSupport.getFormDesigner() : null;
    }

    public static FormDataObject getFormDataObject(FormModel formModel) {
        FormEditorSupport formEditorSupport = (FormEditorSupport)((Object)openForms.get(formModel));
        return formEditorSupport != null ? formEditorSupport.getFormDataObject() : null;
    }

    public static FormEditorSupport getSupport(FormModel formModel) {
        return (FormEditorSupport)((Object)openForms.get(formModel));
    }

    private void superOpen() {
        super.open();
    }

    private void openForm(final boolean bl) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                try {
                    FormEditorSupport.this.loadFormData();
                }
                catch (PersistenceException persistenceException) {
                    FormEditorSupport.this.logPersistenceError(persistenceException, 0);
                }
                if (FormEditorSupport.this.formLoaded) {
                    boolean bl2 = bl && FormEditorSupport.this.activateWorkspace();
                    FormEditorSupport.this.superOpen();
                    if (bl2) {
                        FormEditorSupport.this.openGUI();
                    }
                }
                FormEditorSupport.this.reportErrors(1);
            }
        });
    }

    private void loadFormData() throws PersistenceException {
        if (this.formLoaded) {
            return;
        }
        this.resetPersistenceErrorLog();
        this.persistenceManager = this.recognizeForm(this.formDataObject);
        this.formModel = new FormModel();
        this.formModel.setName(this.formDataObject.getName());
        this.formModel.setReadOnly(this.formDataObject.isReadOnly());
        openForms.put(this.formModel, this);
        PersistenceManager persistenceManager = this.persistenceManager;
        synchronized (persistenceManager) {
            try {
                this.persistenceManager.loadForm(this.formDataObject, this.formModel, this.persistenceErrors);
            }
            catch (PersistenceException persistenceException) {
                this.persistenceManager = null;
                openForms.remove(this.formModel);
                this.formModel = null;
                throw persistenceException;
            }
        }
        this.formLoaded = true;
        this.formModel.fireFormLoaded();
        this.formRootNode = new FormRootNode(this.formModel);
        this.formRootNode.getChildren().getNodes();
        this.formDataObject.getNodeDelegate().getChildren().add(new Node[]{this.formRootNode});
        this.attachFormListener();
        FormEditorSupport.attachSettingsListener();
        FormEditorSupport.attachTopComponentsListener();
        FormEditorSupport.attachPaletteListener();
    }

    private PersistenceManager recognizeForm(FormDataObject formDataObject) throws PersistenceException {
        Object object;
        Object object2;
        Iterator iterator = PersistenceManager.getManagers();
        if (!iterator.hasNext()) {
            PersistenceException persistenceException = new PersistenceException("No persistence manager registered");
            ErrorManager.getDefault().annotate((Throwable)persistenceException, 65536, null, FormUtils.getBundleString("MSG_ERR_NoPersistenceManager"), null, null);
            throw persistenceException;
        }
        do {
            object = object2 = (PersistenceManager)iterator.next();
            synchronized (object) {
                try {
                    if (((PersistenceManager)object2).canLoadForm(formDataObject)) {
                        this.resetPersistenceErrorLog();
                        PersistenceManager persistenceManager = object2;
                        return persistenceManager;
                    }
                }
                catch (PersistenceException persistenceException) {
                    this.logPersistenceError(persistenceException);
                }
            }
        } while (iterator.hasNext());
        if (!this.anyPersistenceError()) {
            object2 = new PersistenceException("Form file format not recognized");
            ErrorManager.getDefault().annotate((Throwable)object2, 65536, null, FormUtils.getBundleString("MSG_ERR_NotRecognizedForm"), null, null);
        } else {
            object = null;
            int n = this.persistenceErrors.size();
            if (n == 1) {
                object2 = (PersistenceException)this.persistenceErrors.get(0);
                Throwable throwable = ((PersistenceException)object2).getOriginalException();
                object = throwable != null ? throwable : object2;
                n = 0;
            } else {
                object = object2 = new PersistenceException("Form file cannot be loaded");
            }
            ErrorManager.getDefault().annotate((Throwable)object, FormUtils.getBundleString("MSG_ERR_LoadingErrors"));
            int n2 = 0;
            while (n2 < n) {
                PersistenceException persistenceException = (PersistenceException)this.persistenceErrors.get(n2);
                Throwable throwable = persistenceException.getOriginalException();
                ErrorManager.getDefault().annotate((Throwable)object2, throwable != null ? throwable : persistenceException);
                ++n2;
            }
            this.resetPersistenceErrorLog();
        }
        throw object2;
    }

    private void logPersistenceError(Throwable throwable) {
        this.logPersistenceError(throwable, -1);
    }

    private void logPersistenceError(Throwable throwable, int n) {
        if (this.persistenceErrors == null) {
            this.persistenceErrors = new ArrayList();
        }
        if (n < 0) {
            this.persistenceErrors.add(throwable);
        } else {
            this.persistenceErrors.add(n, throwable);
        }
    }

    private void resetPersistenceErrorLog() {
        if (this.persistenceErrors != null) {
            this.persistenceErrors.clear();
        } else {
            this.persistenceErrors = new ArrayList();
        }
    }

    private boolean anyPersistenceError() {
        return this.persistenceErrors != null && !this.persistenceErrors.isEmpty();
    }

    private boolean activateWorkspace() {
        FormEditorSupport.attachWorkspacesListener();
        String string = TopManager.getDefault().getWindowManager().getCurrentWorkspace().getName();
        String string2 = FormEditor.getFormSettings().getWorkspace();
        if ("Editing".equals(string) || "Visual".equals(string) || string2.equals(NO_WORKSPACE) || string2.equals(string)) {
            Workspace workspace;
            this.openOnEditing = false;
            if (!string2.equals(string) && !string2.equals(NO_WORKSPACE) && (workspace = TopManager.getDefault().getWindowManager().findWorkspace(string2)) != null) {
                workspace.activate();
            }
            return true;
        }
        this.openOnEditing = true;
        return false;
    }

    private synchronized void openGUI() {
        FormDesigner formDesigner = this.getFormDesigner();
        if (formDesigner == null) {
            return;
        }
        formDesigner.initialize();
        formDesigner.open();
        ComponentInspector.getInstance().open();
        ComponentInspector.getInstance().focusForm(this, true);
        PaletteTopComponent.getInstance().open();
        formDesigner.requestFocus();
    }

    private void saveFormData() throws PersistenceException {
        if (this.formLoaded && !this.formDataObject.formFileReadOnly()) {
            this.formModel.fireFormToBeSaved();
            this.resetPersistenceErrorLog();
            PersistenceManager persistenceManager = this.persistenceManager;
            synchronized (persistenceManager) {
                this.persistenceManager.saveForm(this.formDataObject, this.formModel, this.persistenceErrors);
            }
        }
    }

    protected void notifyClosed() {
        super.notifyClosed();
        if (this.formLoaded) {
            this.closeForm();
        }
    }

    public void reloadForm() {
        if (this.canClose()) {
            this.reloadDocument();
        }
    }

    protected Task reloadDocumentTask() {
        boolean bl = this.formLoaded;
        if (this.formLoaded) {
            this.closeForm();
        }
        Task task = super.reloadDocumentTask();
        if (bl) {
            this.openForm(true);
        }
        return task;
    }

    private synchronized void closeForm() {
        Object object;
        this.formModel.fireFormToBeClosed();
        openForms.remove(this.formModel);
        this.formLoaded = false;
        if (this.formDataObject.isValid()) {
            this.formDataObject.getNodeDelegate().getChildren().remove(new Node[]{this.formRootNode});
        }
        this.detachFormListener();
        if (openForms.isEmpty()) {
            if (this.formDesigner != null) {
                this.formDesigner.setModel(null);
            }
            ComponentInspector.getInstance().focusForm(null, false);
            FormEditorSupport.detachWorkspacesListener();
            FormEditorSupport.detachSettingsListener();
            FormEditorSupport.detachTopComponentsListener();
            FormEditorSupport.detachPaletteListener();
            object = PaletteTopComponent.getInstance();
            object.setCloseOperation(0);
            object.close();
        } else {
            object = (FormEditorSupport)((Object)openForms.values().iterator().next());
            ComponentInspector.getInstance().focusForm((FormEditorSupport)((Object)object));
        }
        if (this.floatingWindows != null) {
            if (this.floatingWindows.size() > 0) {
                object = ((List)this.floatingWindows.clone()).iterator();
                while (object.hasNext()) {
                    Window window = (Window)object.next();
                    if (!window.isVisible()) continue;
                    ((Component)window).setVisible(false);
                }
            }
            this.floatingWindows = null;
        }
        if (this.formDesigner != null) {
            this.formDesigner.setCloseOperation(0);
            this.formDesigner.close();
            this.formDesigner = null;
        }
        this.formRootNode = null;
        this.formDesigner = null;
        this.persistenceManager = null;
        this.persistenceErrors = null;
        this.formModel = null;
    }

    void designerToBeClosed(Workspace workspace) {
        Mode mode;
        if (this.formDesigner == null) {
            return;
        }
        if (workspace == null) {
            workspace = TopManager.getDefault().getWindowManager().getCurrentWorkspace();
        }
        if ((mode = workspace.findMode((TopComponent)this.formDesigner)) != null && "Form".equals(mode.getName())) {
            TopComponent topComponent = null;
            TopComponent topComponent2 = null;
            TopComponent[] topComponentArray = mode.getTopComponents();
            int n = 0;
            while (n < topComponentArray.length) {
                TopComponent topComponent3 = topComponentArray[n];
                if (topComponent3.isOpened(workspace)) {
                    if (topComponent3 instanceof FormDesigner) {
                        if (topComponent3 != this.formDesigner) {
                            topComponent2 = null;
                            topComponent = null;
                            break;
                        }
                    } else if (topComponent3 instanceof ComponentInspector) {
                        topComponent = topComponent3;
                    } else if (topComponent3 instanceof PaletteTopComponent) {
                        topComponent2 = topComponent3;
                    }
                }
                ++n;
            }
            if (topComponent != null) {
                topComponent.setCloseOperation(1);
                topComponent.close(workspace);
            }
            if (topComponent2 != null) {
                topComponent2.setCloseOperation(1);
                topComponent2.close(workspace);
            }
        }
    }

    private void attachFormListener() {
        if (this.formListener != null || this.formDataObject.isReadOnly()) {
            return;
        }
        this.formListener = new FormModelListener(){

            public void formChanged(FormModelEvent[] formModelEventArray) {
                RADComponent[] rADComponentArray;
                boolean bl = false;
                HashSet<ComponentContainer> hashSet = formModelEventArray.length > 0 ? new HashSet<ComponentContainer>() : null;
                HashSet<RADComponent> hashSet2 = null;
                FormNode formNode = null;
                int n = 0;
                while (n < formModelEventArray.length) {
                    int n2;
                    rADComponentArray = formModelEventArray[n];
                    if (rADComponentArray.isModifying()) {
                        bl = true;
                    }
                    if ((n2 = rADComponentArray.getChangeType()) == 4 || n2 == 5 || n2 == 7 || n2 == 8 || n2 == 9) {
                        ComponentContainer componentContainer = rADComponentArray.getContainer();
                        if (hashSet == null || !hashSet.contains(componentContainer)) {
                            FormEditorSupport.this.updateNodeChildren(componentContainer);
                            if (hashSet != null) {
                                hashSet.add(componentContainer);
                            }
                        }
                        if (n2 == 8) {
                            FormNode formNode2 = componentContainer instanceof RADComponent ? ((RADComponent)((Object)componentContainer)).getNodeReference() : FormEditorSupport.this.formRootNode.getOthersNode();
                            if (!(formNode instanceof RADComponentNode)) {
                                if (formNode != FormEditorSupport.this.formRootNode) {
                                    formNode = formNode2;
                                }
                            } else if (formNode != formNode2) {
                                formNode = FormEditorSupport.this.formRootNode;
                            }
                        } else if (n2 == 4) {
                            formNode = ((RADVisualContainer)componentContainer).getLayoutNodeReference();
                        } else if (n2 == 7 && rADComponentArray.getComponent().isInModel()) {
                            if (hashSet2 == null) {
                                hashSet2 = new HashSet<RADComponent>();
                            }
                            hashSet2.add(rADComponentArray.getComponent());
                            hashSet2.remove(rADComponentArray.getContainer());
                        }
                    }
                    ++n;
                }
                if (FormEditorSupport.this.formDesigner != null) {
                    if (hashSet2 != null) {
                        rADComponentArray = new RADComponent[hashSet2.size()];
                        hashSet2.toArray(rADComponentArray);
                        FormEditorSupport.this.formDesigner.setSelectedComponents(rADComponentArray);
                    } else if (formNode != null) {
                        FormEditorSupport.this.formDesigner.setSelectedNode(formNode);
                    }
                }
                if (bl) {
                    FormEditorSupport.this.markFormModified();
                }
            }
        };
        this.formModel.addFormModelListener(this.formListener);
    }

    private void detachFormListener() {
        if (this.formListener != null) {
            this.formModel.removeFormModelListener(this.formListener);
            this.formListener = null;
        }
    }

    private static void attachWorkspacesListener() {
        if (workspacesListener != null) {
            return;
        }
        workspacesListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                TopComponent[] topComponentArray;
                if (!"currentWorkspace".equals(propertyChangeEvent.getPropertyName())) {
                    return;
                }
                Workspace workspace = TopManager.getDefault().getWindowManager().getCurrentWorkspace();
                if (workspace == null) {
                    return;
                }
                String string = workspace.getName();
                String string2 = FormEditor.getFormSettings().getWorkspace();
                if ("Editing".equals(string) || "Visual".equals(string) || string2.equals(FormEditorSupport.NO_WORKSPACE) || string2.equals(string)) {
                    boolean bl = false;
                    Collection collection = openForms.values();
                    topComponentArray = collection.iterator();
                    while (topComponentArray.hasNext()) {
                        FormEditorSupport formEditorSupport = (FormEditorSupport)((Object)topComponentArray.next());
                        if (!formEditorSupport.openOnEditing) continue;
                        formEditorSupport.openOnEditing = false;
                        formEditorSupport.openGUI();
                        bl = true;
                    }
                    if (bl) {
                        return;
                    }
                }
                if (string2.equals(string) && !string2.equals(FormEditorSupport.NO_WORKSPACE)) {
                    return;
                }
                Mode mode = workspace.findMode("Form");
                if (mode == null) {
                    return;
                }
                boolean bl = false;
                topComponentArray = mode.getTopComponents();
                int n = 0;
                while (n < topComponentArray.length) {
                    if (topComponentArray[n].isOpened(workspace)) {
                        bl = true;
                        break;
                    }
                    ++n;
                }
                if (bl) {
                    Collection collection = openForms.values();
                    Iterator iterator = collection.iterator();
                    while (iterator.hasNext()) {
                        FormEditorSupport formEditorSupport = (FormEditorSupport)((Object)iterator.next());
                        formEditorSupport.getFormDesigner().open(workspace);
                    }
                }
            }
        };
        TopManager.getDefault().getWindowManager().addPropertyChangeListener(workspacesListener);
    }

    private static void detachWorkspacesListener() {
        if (workspacesListener != null) {
            TopManager.getDefault().getWindowManager().removePropertyChangeListener(workspacesListener);
            workspacesListener = null;
        }
    }

    private static void attachSettingsListener() {
        if (settingsListener != null) {
            return;
        }
        settingsListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Enumeration enumeration = openForms.keys();
                while (enumeration.hasMoreElements()) {
                    FormModel formModel = (FormModel)enumeration.nextElement();
                    String string = propertyChangeEvent.getPropertyName();
                    if ("useIndentEngine".equals(string) || "generateOnSave".equals(string) || "variablesModifier".equals(string) || "variablesLocal".equals(string)) {
                        formModel.fireSyntheticPropertyChanged(null, string, propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
                        continue;
                    }
                    if (!"selectionBorderSize".equals(string) && !"selectionBorderColor".equals(string) && !"connectionBorderColor".equals(string) && !"formDesignerBackgroundColor".equals(string) && !"formDesignerBorderColor".equals(string)) continue;
                    formModel.getFormDesigner().updateVisualSettings();
                }
            }
        };
        FormEditor.getFormSettings().addPropertyChangeListener(settingsListener);
    }

    private static void detachSettingsListener() {
        if (settingsListener != null) {
            FormEditor.getFormSettings().removePropertyChangeListener(settingsListener);
            settingsListener = null;
        }
    }

    private static void attachTopComponentsListener() {
        if (topcompsListener != null) {
            return;
        }
        topcompsListener = new PropertyChangeListener(){
            static /* synthetic */ Class class$org$openide$cookies$SourceCookie;
            static /* synthetic */ Class class$org$openide$loaders$DataObject;

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("activated".equals(propertyChangeEvent.getPropertyName())) {
                    TopComponent topComponent = TopComponent.getRegistry().getActivated();
                    if (!(topComponent instanceof JavaEditor.JavaEditorComponent)) {
                        return;
                    }
                    Node[] nodeArray = topComponent.getActivatedNodes();
                    if (nodeArray == null || nodeArray.length != 1) {
                        return;
                    }
                    SourceCookie sourceCookie = (SourceCookie)nodeArray[0].getCookie(class$org$openide$cookies$SourceCookie == null ? (class$org$openide$cookies$SourceCookie = 8.class$("org.openide.cookies.SourceCookie")) : class$org$openide$cookies$SourceCookie);
                    if (sourceCookie == null) {
                        return;
                    }
                    DataObject dataObject = (DataObject)sourceCookie.getSource().getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = 8.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
                    if (dataObject == null) {
                        return;
                    }
                    FormEditorSupport formEditorSupport = ComponentInspector.getInstance().getFocusedForm();
                    Iterator iterator = openForms.values().iterator();
                    while (iterator.hasNext()) {
                        FormEditorSupport formEditorSupport2 = (FormEditorSupport)((Object)iterator.next());
                        if (formEditorSupport2.getFormDataObject() != dataObject) continue;
                        if (formEditorSupport2 == formEditorSupport) break;
                        formEditorSupport2.gotoForm();
                        ComponentInspector.getInstance().focusForm(formEditorSupport2);
                        break;
                    }
                }
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        };
        TopComponent.getRegistry().addPropertyChangeListener(topcompsListener);
    }

    private static void detachTopComponentsListener() {
        if (topcompsListener != null) {
            TopComponent.getRegistry().removePropertyChangeListener(topcompsListener);
            topcompsListener = null;
        }
    }

    private static void attachPaletteListener() {
        if (paletteListener != null) {
            return;
        }
        paletteListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("mode".equals(propertyChangeEvent.getPropertyName()) && new Integer(2).equals(propertyChangeEvent.getNewValue())) {
                    FormDesigner formDesigner = ComponentInspector.getInstance().getFocusedForm().getFormDesigner();
                    formDesigner.requestFocus();
                    formDesigner.componentActivated();
                }
            }
        };
        CPManager.getDefault().addPropertyChangeListener(paletteListener);
    }

    private static void detachPaletteListener() {
        if (paletteListener != null) {
            CPManager.getDefault().removePropertyChangeListener(paletteListener);
            paletteListener = null;
        }
    }

    public void gotoEditor() {
        super.open();
    }

    public void gotoForm() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                if (FormEditorSupport.this.formModel != null && FormEditorSupport.this.formModel.getFormDesigner().isOpened()) {
                    FormEditorSupport.this.formModel.getFormDesigner().requestVisible();
                }
            }
        });
    }

    static {
        openForms = new Hashtable();
    }
}

