/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;
import org.netbeans.modules.form.CodeGenerator;
import org.netbeans.modules.form.ComponentContainer;
import org.netbeans.modules.form.Event;
import org.netbeans.modules.form.EventHandler;
import org.netbeans.modules.form.EventSet;
import org.netbeans.modules.form.FormDataObject;
import org.netbeans.modules.form.FormDesigner;
import org.netbeans.modules.form.FormEditorSupport;
import org.netbeans.modules.form.FormEventHandlers;
import org.netbeans.modules.form.FormModelEvent;
import org.netbeans.modules.form.FormModelListener;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.JavaCodeGenerator;
import org.netbeans.modules.form.MetaComponentCreator;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADFormContainer;
import org.netbeans.modules.form.RADVisualComponent;
import org.netbeans.modules.form.RADVisualContainer;
import org.netbeans.modules.form.RADVisualFormContainer;
import org.netbeans.modules.form.codestructure.CodeStructure;
import org.netbeans.modules.form.layoutsupport.LayoutConstraints;
import org.netbeans.modules.form.layoutsupport.LayoutSupportDelegate;
import org.netbeans.modules.form.layoutsupport.LayoutSupportManager;
import org.openide.awt.UndoRedo;
import org.openide.util.Mutex;
import org.openide.util.MutexException;

public class FormModel {
    private RADComponent topRADComponent;
    private Class formBaseClass;
    private ArrayList otherComponents = new ArrayList(10);
    private ComponentContainer modelContainer;
    private String formName;
    private boolean readOnly = false;
    private boolean formLoaded = false;
    private UndoRedo.Manager undoRedoManager;
    private boolean undoRedoRecording = false;
    private CompoundEdit compoundEdit;
    private FormEventHandlers eventHandlers;
    private ArrayList listeners;
    private EventBroker eventBroker;
    private MetaComponentCreator metaCreator;
    private CodeStructure codeStructure = new CodeStructure(false);
    private CodeGenerator codeGenerator;
    private static int traceCount = 0;
    private static final boolean TRACE = false;
    static /* synthetic */ Class class$java$awt$Component;
    static /* synthetic */ Class class$java$lang$Object;

    FormModel() {
    }

    public void setFormBaseClass(Class clazz) throws Exception {
        if (this.formBaseClass != null) {
            throw new IllegalStateException("Form type already initialized.");
        }
        RADComponent rADComponent = (class$java$awt$Component == null ? (class$java$awt$Component = FormModel.class$("java.awt.Component")) : class$java$awt$Component).isAssignableFrom(clazz) ? (FormUtils.isContainer(clazz) ? new RADVisualFormContainer() : new RADVisualComponent()) : ((class$java$lang$Object == null ? (class$java$lang$Object = FormModel.class$("java.lang.Object")) : class$java$lang$Object) != clazz ? new RADFormContainer() : null);
        if (rADComponent != null) {
            this.topRADComponent = rADComponent;
            rADComponent.initialize(this);
            rADComponent.initInstance(clazz);
            rADComponent.setInModel(true);
        }
        this.formBaseClass = clazz;
    }

    public Class getFormBaseClass() {
        return this.formBaseClass;
    }

    void setName(String string) {
        this.formName = string;
    }

    void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    public final String getName() {
        return this.formName;
    }

    public final boolean isReadOnly() {
        return this.readOnly;
    }

    public final boolean isFormLoaded() {
        return this.formLoaded;
    }

    public final FormDesigner getFormDesigner() {
        return FormEditorSupport.getFormDesigner(this);
    }

    public final FormDataObject getFormDataObject() {
        return FormEditorSupport.getFormDataObject(this);
    }

    public ComponentContainer getModelContainer() {
        if (this.modelContainer == null) {
            this.modelContainer = new ModelContainer();
        }
        return this.modelContainer;
    }

    public final RADComponent getTopRADComponent() {
        return this.topRADComponent;
    }

    public RADComponent findRADComponent(String string) {
        Iterator iterator = this.getMetaComponents().iterator();
        while (iterator.hasNext()) {
            RADComponent rADComponent = (RADComponent)iterator.next();
            if (!string.equals(rADComponent.getName())) continue;
            return rADComponent;
        }
        return null;
    }

    public List getMetaComponents() {
        ArrayList arrayList = new ArrayList();
        FormModel.collectMetaComponents(this.getModelContainer(), arrayList);
        return arrayList;
    }

    public RADVisualComponent[] getVisualComponents() {
        ArrayList<RADComponent> arrayList = new ArrayList<RADComponent>();
        if (this.topRADComponent instanceof RADVisualComponent) {
            arrayList.add(this.topRADComponent);
        }
        if (this.topRADComponent instanceof RADVisualContainer) {
            FormModel.collectVisualMetaComponents((RADVisualContainer)this.topRADComponent, arrayList);
        }
        return arrayList.toArray(new RADVisualComponent[arrayList.size()]);
    }

    public RADComponent[] getOtherComponents(boolean bl) {
        ArrayList<RADComponent> arrayList = new ArrayList<RADComponent>();
        Iterator iterator = ((AbstractList)this.otherComponents).iterator();
        while (iterator.hasNext()) {
            RADComponent rADComponent = (RADComponent)iterator.next();
            arrayList.add(rADComponent);
            if (!bl || !(rADComponent instanceof ComponentContainer)) continue;
            FormModel.collectMetaComponents((ComponentContainer)((Object)rADComponent), arrayList);
        }
        return arrayList.toArray(new RADComponent[arrayList.size()]);
    }

    public RADComponent[] getNonVisualComponents() {
        return this.otherComponents.toArray(new RADComponent[this.otherComponents.size()]);
    }

    public FormEventHandlers getFormEventHandlers() {
        if (this.eventHandlers == null) {
            this.eventHandlers = new FormEventHandlers();
        }
        return this.eventHandlers;
    }

    private static void collectMetaComponents(ComponentContainer componentContainer, List list) {
        RADComponent[] rADComponentArray = componentContainer.getSubBeans();
        int n = 0;
        while (n < rADComponentArray.length) {
            RADComponent rADComponent = rADComponentArray[n];
            list.add(rADComponent);
            if (rADComponent instanceof ComponentContainer) {
                FormModel.collectMetaComponents((ComponentContainer)((Object)rADComponent), list);
            }
            ++n;
        }
    }

    private static void collectVisualMetaComponents(RADVisualContainer rADVisualContainer, List list) {
        RADVisualComponent[] rADVisualComponentArray = rADVisualContainer.getSubComponents();
        int n = 0;
        while (n < rADVisualComponentArray.length) {
            RADVisualComponent rADVisualComponent = rADVisualComponentArray[n];
            list.add(rADVisualComponent);
            if (rADVisualComponent instanceof RADVisualContainer) {
                FormModel.collectVisualMetaComponents((RADVisualContainer)rADVisualComponent, list);
            }
            ++n;
        }
    }

    public MetaComponentCreator getComponentCreator() {
        if (this.metaCreator == null) {
            this.metaCreator = new MetaComponentCreator(this);
        }
        return this.metaCreator;
    }

    public void addComponent(RADComponent rADComponent, ComponentContainer componentContainer) {
        boolean bl;
        if (componentContainer != null) {
            componentContainer.add(rADComponent);
        } else {
            rADComponent.setParentComponent(null);
            this.otherComponents.add(rADComponent);
        }
        boolean bl2 = bl = !rADComponent.isInModel();
        if (bl) {
            FormModel.setInModelRecursively(rADComponent, true);
        }
        this.fireComponentAdded(rADComponent, bl);
    }

    public void addVisualComponent(RADVisualComponent rADVisualComponent, RADVisualContainer rADVisualContainer, LayoutConstraints layoutConstraints) {
        boolean bl;
        LayoutSupportManager layoutSupportManager = rADVisualContainer.getLayoutSupport();
        RADVisualComponent[] rADVisualComponentArray = new RADVisualComponent[]{rADVisualComponent};
        LayoutConstraints[] layoutConstraintsArray = new LayoutConstraints[]{layoutConstraints};
        layoutSupportManager.acceptNewComponents(rADVisualComponentArray, layoutConstraintsArray, -1);
        rADVisualContainer.add(rADVisualComponent);
        layoutSupportManager.addComponents(rADVisualComponentArray, layoutConstraintsArray, -1);
        boolean bl2 = bl = !rADVisualComponent.isInModel();
        if (bl) {
            FormModel.setInModelRecursively(rADVisualComponent, true);
        }
        this.fireComponentAdded(rADVisualComponent, bl);
    }

    public void setContainerLayout(RADVisualContainer rADVisualContainer, LayoutSupportDelegate layoutSupportDelegate, LayoutManager layoutManager) throws Exception {
        LayoutSupportDelegate layoutSupportDelegate2 = rADVisualContainer.getLayoutSupport().getLayoutDelegate();
        rADVisualContainer.setLayoutSupportDelegate(layoutSupportDelegate, layoutManager);
        this.fireContainerLayoutExchanged(rADVisualContainer, layoutSupportDelegate2, layoutSupportDelegate);
    }

    public void removeComponentFromContainer(RADComponent rADComponent) {
        RADComponent rADComponent2 = rADComponent.getParentComponent();
        ComponentContainer componentContainer = rADComponent2 instanceof ComponentContainer ? (ComponentContainer)((Object)rADComponent2) : this.getModelContainer();
        int n = componentContainer.getIndexOf(rADComponent);
        componentContainer.remove(rADComponent);
        this.fireComponentRemoved(rADComponent, componentContainer, n, false, null, null);
    }

    public void removeComponent(RADComponent rADComponent) {
        RADComponent rADComponent2;
        if (this.eventHandlers != null) {
            this.removeEventHandlersRecursively(rADComponent);
        }
        ComponentContainer componentContainer = (rADComponent2 = rADComponent.getParentComponent()) instanceof ComponentContainer ? (ComponentContainer)((Object)rADComponent2) : this.getModelContainer();
        int n = componentContainer.getIndexOf(rADComponent);
        componentContainer.remove(rADComponent);
        Object object = null;
        Object object2 = null;
        boolean bl = this.codeStructure.isUndoRedoRecording();
        if (this.undoRedoRecording && !bl) {
            this.codeStructure.setUndoRedoRecording(true);
            object = this.codeStructure.markForUndo();
        }
        rADComponent.removeCodeExpression();
        rADComponent.setInModel(false);
        if (rADComponent instanceof ComponentContainer) {
            FormModel.releaseComponent(rADComponent);
        }
        if (this.undoRedoRecording && !bl) {
            object2 = this.codeStructure.markForUndo();
            if (object2.equals(object)) {
                object = null;
                object2 = null;
            }
            this.codeStructure.setUndoRedoRecording(false);
        }
        this.fireComponentRemoved(rADComponent, componentContainer, n, true, object, object2);
    }

    private void removeEventHandlersRecursively(RADComponent rADComponent) {
        int n;
        Object[] objectArray;
        if (rADComponent instanceof ComponentContainer) {
            objectArray = ((ComponentContainer)((Object)rADComponent)).getSubBeans();
            n = 0;
            while (n < objectArray.length) {
                this.removeEventHandlersRecursively((RADComponent)objectArray[n]);
                ++n;
            }
        }
        objectArray = rADComponent.getEventHandlers().getEventSets();
        n = 0;
        while (n < objectArray.length) {
            Event[] eventArray = ((EventSet)objectArray[n]).getEvents();
            int n2 = 0;
            while (n2 < eventArray.length) {
                if (eventArray[n2].getHandlers().size() > 0) {
                    this.eventHandlers.removeEventHandler(eventArray[n2]);
                }
                ++n2;
            }
            ++n;
        }
    }

    private static void releaseComponent(RADComponent rADComponent) {
        RADComponent[] rADComponentArray = ((ComponentContainer)((Object)rADComponent)).getSubBeans();
        int n = 0;
        int n2 = rADComponentArray.length;
        while (n < n2) {
            rADComponent = rADComponentArray[n];
            rADComponent.releaseCodeExpression();
            rADComponent.setInModel(false);
            if (rADComponent instanceof ComponentContainer) {
                FormModel.releaseComponent(rADComponent);
            }
            ++n;
        }
    }

    static void setInModelRecursively(RADComponent rADComponent, boolean bl) {
        rADComponent.setInModel(bl);
        if (rADComponent instanceof ComponentContainer) {
            RADComponent[] rADComponentArray = ((ComponentContainer)((Object)rADComponent)).getSubBeans();
            int n = 0;
            while (n < rADComponentArray.length) {
                FormModel.setInModelRecursively(rADComponentArray[n], bl);
                ++n;
            }
        }
    }

    public void setUndoRedoRecording(boolean bl) {
        FormModel.t("turning undo/redo recording " + (bl ? "on" : "off"));
        this.undoRedoRecording = bl;
    }

    public boolean isUndoRedoRecording() {
        return this.undoRedoRecording;
    }

    public boolean startCompoundEdit() {
        if (this.compoundEdit == null) {
            FormModel.t("starting compound edit");
            this.compoundEdit = new CompoundEdit();
            return true;
        }
        return false;
    }

    public CompoundEdit endCompoundEdit() {
        if (this.compoundEdit != null) {
            FormModel.t("ending compound edit");
            this.compoundEdit.end();
            if (this.undoRedoRecording && this.compoundEdit.isSignificant()) {
                this.getUndoRedoManager().undoableEditHappened(new UndoableEditEvent(this, this.compoundEdit));
            }
            CompoundEdit compoundEdit = this.compoundEdit;
            this.compoundEdit = null;
            return compoundEdit;
        }
        return null;
    }

    public boolean isCompoundEditInProgress() {
        return this.compoundEdit != null && this.compoundEdit.isInProgress();
    }

    public void addUndoableEdit(UndoableEdit undoableEdit) {
        FormModel.t("adding undoable edit");
        if (this.isCompoundEditInProgress()) {
            this.compoundEdit.addEdit(undoableEdit);
        } else {
            this.getUndoRedoManager().undoableEditHappened(new UndoableEditEvent(this, undoableEdit));
        }
    }

    UndoRedo.Manager getUndoRedoManager() {
        if (this.undoRedoManager == null) {
            this.undoRedoManager = new UndoRedoManager();
            this.undoRedoManager.setLimit(50);
        }
        return this.undoRedoManager;
    }

    public synchronized void addFormModelListener(FormModelListener formModelListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(formModelListener);
    }

    public synchronized void removeFormModelListener(FormModelListener formModelListener) {
        if (this.listeners != null) {
            ((AbstractCollection)this.listeners).remove(formModelListener);
        }
    }

    public void fireFormLoaded() {
        FormModel.t("firing form loaded");
        this.formLoaded = true;
        if (this.undoRedoManager != null) {
            this.undoRedoManager.discardAllEdits();
        }
        if (!this.readOnly && !Boolean.getBoolean("netbeans.form.no_undo")) {
            this.setUndoRedoRecording(true);
        }
        this.initializeCodeGenerator();
        this.fireEvents(new FormModelEvent[]{new FormModelEvent(this, 1)});
    }

    public void fireFormToBeSaved() {
        FormModel.t("firing form to be saved");
        this.fireEvents(new FormModelEvent[]{new FormModelEvent(this, 2)});
    }

    public void fireFormToBeClosed() {
        FormModel.t("firing form to be closed");
        if (this.undoRedoManager != null) {
            this.undoRedoManager.discardAllEdits();
        }
        this.fireEvents(new FormModelEvent[]{new FormModelEvent(this, 3)});
    }

    public FormModelEvent fireContainerLayoutExchanged(RADVisualContainer rADVisualContainer, LayoutSupportDelegate layoutSupportDelegate, LayoutSupportDelegate layoutSupportDelegate2) {
        FormModel.t("firing container layout exchange, container: " + (rADVisualContainer != null ? rADVisualContainer.getName() : "null"));
        FormModelEvent formModelEvent = new FormModelEvent(this, 4);
        formModelEvent.setLayout(rADVisualContainer, layoutSupportDelegate, layoutSupportDelegate2);
        this.sendEvent(formModelEvent);
        if (this.undoRedoRecording && rADVisualContainer != null && layoutSupportDelegate != layoutSupportDelegate2) {
            this.addUndoableEdit(formModelEvent.getUndoableEdit());
        }
        return formModelEvent;
    }

    public FormModelEvent fireContainerLayoutChanged(RADVisualContainer rADVisualContainer, String string, Object object, Object object2) {
        FormModel.t("firing container layout change, container: " + (rADVisualContainer != null ? rADVisualContainer.getName() : "null") + ", property: " + string);
        FormModelEvent formModelEvent = new FormModelEvent(this, 5);
        formModelEvent.setComponentAndContainer(rADVisualContainer, rADVisualContainer);
        formModelEvent.setProperty(string, object, object2);
        this.sendEvent(formModelEvent);
        if (this.undoRedoRecording && rADVisualContainer != null && string != null && object != object2) {
            this.addUndoableEdit(formModelEvent.getUndoableEdit());
        }
        return formModelEvent;
    }

    public FormModelEvent fireComponentLayoutChanged(RADVisualComponent rADVisualComponent, String string, Object object, Object object2) {
        FormModel.t("firing component layout change: " + (rADVisualComponent != null ? rADVisualComponent.getName() : "null"));
        FormModelEvent formModelEvent = new FormModelEvent(this, 6);
        formModelEvent.setComponentAndContainer(rADVisualComponent, null);
        formModelEvent.setProperty(string, object, object2);
        this.sendEvent(formModelEvent);
        if (this.undoRedoRecording && rADVisualComponent != null && string != null && object != object2) {
            this.addUndoableEdit(formModelEvent.getUndoableEdit());
        }
        return formModelEvent;
    }

    public FormModelEvent fireComponentAdded(RADComponent rADComponent, boolean bl) {
        FormModel.t("firing component added: " + (rADComponent != null ? rADComponent.getName() : "null"));
        FormModelEvent formModelEvent = new FormModelEvent(this, 7);
        formModelEvent.setAddData(rADComponent, null, bl);
        this.sendEvent(formModelEvent);
        if (this.undoRedoRecording && rADComponent != null) {
            this.addUndoableEdit(formModelEvent.getUndoableEdit());
        }
        return formModelEvent;
    }

    public FormModelEvent fireComponentRemoved(RADComponent rADComponent, ComponentContainer componentContainer, int n, boolean bl, Object object, Object object2) {
        FormModel.t("firing component removed: " + (rADComponent != null ? rADComponent.getName() : "null"));
        FormModelEvent formModelEvent = new FormModelEvent(this, 8);
        formModelEvent.setRemoveData(rADComponent, componentContainer, n, bl, object, object2);
        this.sendEvent(formModelEvent);
        if (this.undoRedoRecording && rADComponent != null && componentContainer != null) {
            this.addUndoableEdit(formModelEvent.getUndoableEdit());
        }
        return formModelEvent;
    }

    public FormModelEvent fireComponentsReordered(ComponentContainer componentContainer, int[] nArray) {
        FormModel.t("firing components reorder in container: " + (componentContainer instanceof RADComponent ? ((RADComponent)((Object)componentContainer)).getName() : "<top>"));
        FormModelEvent formModelEvent = new FormModelEvent(this, 9);
        formModelEvent.setComponentAndContainer(null, componentContainer);
        formModelEvent.setReordering(nArray);
        this.sendEvent(formModelEvent);
        if (this.undoRedoRecording && componentContainer != null) {
            this.addUndoableEdit(formModelEvent.getUndoableEdit());
        }
        return formModelEvent;
    }

    public FormModelEvent fireComponentPropertyChanged(RADComponent rADComponent, String string, Object object, Object object2) {
        FormModel.t("firing component property change, component: " + (rADComponent != null ? rADComponent.getName() : "<null component>") + ", property: " + string);
        FormModelEvent formModelEvent = new FormModelEvent(this, 10);
        formModelEvent.setComponentAndContainer(rADComponent, null);
        formModelEvent.setProperty(string, object, object2);
        this.sendEvent(formModelEvent);
        if (this.undoRedoRecording && rADComponent != null && string != null && object != object2) {
            this.addUndoableEdit(formModelEvent.getUndoableEdit());
        }
        return formModelEvent;
    }

    public FormModelEvent fireSyntheticPropertyChanged(RADComponent rADComponent, String string, Object object, Object object2) {
        FormModel.t("firing synthetic property change, component: " + (rADComponent != null ? rADComponent.getName() : "null") + ", property: " + string);
        FormModelEvent formModelEvent = new FormModelEvent(this, 11);
        formModelEvent.setComponentAndContainer(rADComponent, null);
        formModelEvent.setProperty(string, object, object2);
        this.sendEvent(formModelEvent);
        if (this.undoRedoRecording && rADComponent != null && string != null && object != object2) {
            this.addUndoableEdit(formModelEvent.getUndoableEdit());
        }
        return formModelEvent;
    }

    public FormModelEvent fireEventHandlerAdded(Event event, EventHandler eventHandler, String string, boolean bl) {
        FormModel.t("event handler added: " + eventHandler.getName());
        FormModelEvent formModelEvent = new FormModelEvent(this, 12);
        formModelEvent.setEvent(event, eventHandler, string, bl);
        this.sendEvent(formModelEvent);
        if (this.undoRedoRecording && event != null && eventHandler != null) {
            this.addUndoableEdit(formModelEvent.getUndoableEdit());
        }
        return formModelEvent;
    }

    public FormModelEvent fireEventHandlerRemoved(Event event, EventHandler eventHandler, boolean bl) {
        FormModel.t("firing event handler removed: " + eventHandler.getName());
        FormModelEvent formModelEvent = new FormModelEvent(this, 13);
        formModelEvent.setEvent(event, eventHandler, null, bl);
        this.sendEvent(formModelEvent);
        if (this.undoRedoRecording && event != null && eventHandler != null) {
            this.addUndoableEdit(formModelEvent.getUndoableEdit());
        }
        return formModelEvent;
    }

    public FormModelEvent fireEventHandlerRenamed(EventHandler eventHandler, String string) {
        FormModel.t("event handler renamed: " + eventHandler.getName());
        FormModelEvent formModelEvent = new FormModelEvent(this, 14);
        formModelEvent.setEvent(eventHandler, string);
        this.sendEvent(formModelEvent);
        if (this.undoRedoRecording && eventHandler != null && string != null) {
            this.addUndoableEdit(formModelEvent.getUndoableEdit());
        }
        return formModelEvent;
    }

    public FormModelEvent fireFormChanged() {
        FormModel.t("firing form change");
        FormModelEvent formModelEvent = new FormModelEvent(this, 15);
        this.sendEvent(formModelEvent);
        return formModelEvent;
    }

    public void fireEvents(FormModelEvent[] formModelEventArray) {
        ArrayList arrayList;
        FormModel formModel = this;
        synchronized (formModel) {
            if (this.listeners == null) {
                return;
            }
            arrayList = (ArrayList)this.listeners.clone();
        }
        int n = 0;
        while (n < arrayList.size()) {
            FormModelListener formModelListener = (FormModelListener)arrayList.get(n);
            formModelListener.formChanged(formModelEventArray);
            ++n;
        }
    }

    void sendEvent(FormModelEvent formModelEvent) {
        EventBroker eventBroker = this.getEventBroker();
        if (eventBroker != null) {
            eventBroker.sendEvent(formModelEvent);
        } else {
            FormModel.t("no event broker, firing event directly: " + formModelEvent.getChangeType());
            this.fireEvents(new FormModelEvent[]{formModelEvent});
        }
    }

    EventBroker getEventBroker() {
        if (this.eventBroker == null && this.isFormLoaded()) {
            this.eventBroker = new EventBroker();
        }
        return this.eventBroker;
    }

    CodeStructure getCodeStructure() {
        return this.codeStructure;
    }

    CodeGenerator getCodeGenerator() {
        if (this.codeGenerator == null) {
            this.codeGenerator = new JavaCodeGenerator();
        }
        return this.codeGenerator;
    }

    void initializeCodeGenerator() {
        this.getCodeGenerator().initialize(this);
    }

    static void t(String string) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    final class ModelContainer
    implements ComponentContainer {
        ModelContainer() {
        }

        public RADComponent[] getSubBeans() {
            int n = FormModel.this.otherComponents.size();
            if (FormModel.this.topRADComponent != null) {
                ++n;
            }
            RADComponent[] rADComponentArray = new RADComponent[n];
            FormModel.this.otherComponents.toArray(rADComponentArray);
            if (FormModel.this.topRADComponent != null) {
                rADComponentArray[n - 1] = FormModel.this.topRADComponent;
            }
            return rADComponentArray;
        }

        public void initSubComponents(RADComponent[] rADComponentArray) {
            FormModel.this.otherComponents.clear();
            int n = 0;
            while (n < rADComponentArray.length) {
                if (rADComponentArray[n] != FormModel.this.topRADComponent) {
                    FormModel.this.otherComponents.add(rADComponentArray[n]);
                }
                ++n;
            }
        }

        public void reorderSubComponents(int[] nArray) {
            RADComponent[] rADComponentArray = new RADComponent[FormModel.this.otherComponents.size()];
            int n = 0;
            while (n < nArray.length) {
                rADComponentArray[nArray[n]] = (RADComponent)FormModel.this.otherComponents.get(n);
                ++n;
            }
            FormModel.this.otherComponents.clear();
            FormModel.this.otherComponents.addAll(Arrays.asList(rADComponentArray));
        }

        public void add(RADComponent rADComponent) {
            rADComponent.setParentComponent(null);
            FormModel.this.otherComponents.add(rADComponent);
        }

        public void remove(RADComponent rADComponent) {
            if (((AbstractCollection)FormModel.this.otherComponents).remove(rADComponent)) {
                rADComponent.setParentComponent(null);
            }
        }

        public int getIndexOf(RADComponent rADComponent) {
            int n = FormModel.this.otherComponents.indexOf(rADComponent);
            if (n < 0 && rADComponent == FormModel.this.topRADComponent) {
                n = FormModel.this.otherComponents.size();
            }
            return n;
        }
    }

    private class EventBroker
    implements Runnable {
        private List eventsList;
        private boolean compoundUndoStarted;

        private EventBroker() {
        }

        public void sendEvent(FormModelEvent formModelEvent) {
            if (!this.placeEvent(formModelEvent)) {
                FormModel.t("firing event directly from event broker: " + formModelEvent.getChangeType());
                FormModel.this.fireEvents(new FormModelEvent[]{formModelEvent});
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private synchronized boolean placeEvent(FormModelEvent formModelEvent) {
            if (this.eventsList == null) {
                if (!formModelEvent.isModifying() || !EventQueue.isDispatchThread()) return false;
                this.eventsList = new ArrayList();
                this.eventsList.add(formModelEvent);
                boolean bl = this.compoundUndoStarted = FormModel.this.isUndoRedoRecording() && FormModel.this.startCompoundEdit();
                if (this.compoundUndoStarted) {
                    FormModel.t("compound undoable edit started from event broker");
                }
                EventQueue.invokeLater(this);
                return true;
            } else {
                this.eventsList.add(formModelEvent);
            }
            return true;
        }

        private synchronized List pickUpEvents() {
            List list = this.eventsList;
            this.eventsList = null;
            if (this.compoundUndoStarted) {
                this.compoundUndoStarted = false;
                FormModel.this.endCompoundEdit();
            }
            return list;
        }

        public void run() {
            List list = this.pickUpEvents();
            if (list != null && !list.isEmpty()) {
                FormModelEvent[] formModelEventArray = new FormModelEvent[list.size()];
                list.toArray(formModelEventArray);
                FormModel.t("firing event batch of " + list.size() + " events from event broker");
                FormModel.this.fireEvents(formModelEventArray);
            }
        }
    }

    static class UndoRedoManager
    extends UndoRedo.Manager {
        private Mutex.ExceptionAction runUndo = new Mutex.ExceptionAction(){

            public Object run() throws Exception {
                this.superUndo();
                return null;
            }
        };
        private Mutex.ExceptionAction runRedo = new Mutex.ExceptionAction(this){
            private final /* synthetic */ UndoRedoManager this$0;
            {
                this.this$0 = undoRedoManager;
            }

            public Object run() throws Exception {
                this.this$0.superRedo();
                return null;
            }
        };

        UndoRedoManager() {
        }

        public void superUndo() throws CannotUndoException {
            super.undo();
        }

        public void superRedo() throws CannotRedoException {
            super.redo();
        }

        public void undo() throws CannotUndoException {
            if (EventQueue.isDispatchThread()) {
                this.superUndo();
            } else {
                try {
                    Mutex.EVENT.readAccess(this.runUndo);
                }
                catch (MutexException mutexException) {
                    Exception exception = mutexException.getException();
                    if (exception instanceof CannotUndoException) {
                        throw (CannotUndoException)exception;
                    }
                    exception.printStackTrace();
                }
            }
        }

        public void redo() throws CannotRedoException {
            if (EventQueue.isDispatchThread()) {
                this.superRedo();
            } else {
                try {
                    Mutex.EVENT.readAccess(this.runRedo);
                }
                catch (MutexException mutexException) {
                    Exception exception = mutexException.getException();
                    if (exception instanceof CannotRedoException) {
                        throw (CannotRedoException)exception;
                    }
                    exception.printStackTrace();
                }
            }
        }
    }
}

