/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.netbeans.modules.form.ComponentContainer;
import org.netbeans.modules.form.Event;
import org.netbeans.modules.form.EventHandler;
import org.netbeans.modules.form.FormEventHandlers;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADProperty;
import org.netbeans.modules.form.RADVisualComponent;
import org.netbeans.modules.form.RADVisualContainer;
import org.netbeans.modules.form.layoutsupport.LayoutConstraints;
import org.netbeans.modules.form.layoutsupport.LayoutSupportDelegate;
import org.netbeans.modules.form.layoutsupport.LayoutSupportManager;
import org.openide.nodes.Node;

public class FormModelEvent
extends EventObject {
    public static final int FORM_LOADED = 1;
    public static final int FORM_TO_BE_SAVED = 2;
    public static final int FORM_TO_BE_CLOSED = 3;
    public static final int CONTAINER_LAYOUT_EXCHANGED = 4;
    public static final int CONTAINER_LAYOUT_CHANGED = 5;
    public static final int COMPONENT_LAYOUT_CHANGED = 6;
    public static final int COMPONENT_ADDED = 7;
    public static final int COMPONENT_REMOVED = 8;
    public static final int COMPONENTS_REORDERED = 9;
    public static final int COMPONENT_PROPERTY_CHANGED = 10;
    public static final int SYNTHETIC_PROPERTY_CHANGED = 11;
    public static final int EVENT_HANDLER_ADDED = 12;
    public static final int EVENT_HANDLER_REMOVED = 13;
    public static final int EVENT_HANDLER_RENAMED = 14;
    public static final int OTHER_CHANGE = 15;
    private boolean createdDeleted;
    private RADComponent component;
    private ComponentContainer container;
    private LayoutConstraints constraints;
    private int componentIndex = -1;
    private int[] reordering;
    private Object codeUndoRedoStart;
    private Object codeUndoRedoEnd;
    private String propertyName;
    private Object oldPropertyValue;
    private Object newPropertyValue;
    private Event componentEvent;
    private int changeType;
    private UndoableEdit undoableEdit;
    private FormModelEvent additionalEvent;
    private static List interestList;

    FormModelEvent(FormModel formModel, int n) {
        super(formModel);
        this.changeType = n;
        FormModelEvent.informInterestedEvents(this);
    }

    void setProperty(String string, Object object, Object object2) {
        this.propertyName = string;
        this.oldPropertyValue = object;
        this.newPropertyValue = object2;
    }

    void setComponentAndContainer(RADComponent rADComponent, ComponentContainer componentContainer) {
        this.component = rADComponent;
        this.container = componentContainer != null ? componentContainer : FormModelEvent.deriveContainer(rADComponent);
    }

    void setLayout(RADVisualContainer rADVisualContainer, LayoutSupportDelegate layoutSupportDelegate, LayoutSupportDelegate layoutSupportDelegate2) {
        this.component = rADVisualContainer;
        this.container = rADVisualContainer;
        this.oldPropertyValue = layoutSupportDelegate;
        this.newPropertyValue = layoutSupportDelegate2;
    }

    void setReordering(int[] nArray) {
        this.reordering = nArray;
    }

    void setAddData(RADComponent rADComponent, ComponentContainer componentContainer, boolean bl) {
        this.setComponentAndContainer(rADComponent, componentContainer);
        this.createdDeleted = bl;
        if (this.component instanceof RADVisualComponent && this.container instanceof RADVisualContainer) {
            this.componentIndex = this.container.getIndexOf(this.component);
            if (this.componentIndex >= 0) {
                LayoutSupportManager layoutSupportManager = ((RADVisualContainer)this.container).getLayoutSupport();
                this.constraints = layoutSupportManager.getConstraints(this.componentIndex);
            }
        }
    }

    void setRemoveData(RADComponent rADComponent, ComponentContainer componentContainer, int n, boolean bl, Object object, Object object2) {
        this.component = rADComponent;
        this.container = componentContainer;
        this.componentIndex = n;
        this.codeUndoRedoStart = object;
        this.codeUndoRedoEnd = object2;
        this.createdDeleted = bl;
        if (rADComponent instanceof RADVisualComponent && componentContainer instanceof RADVisualContainer) {
            LayoutSupportManager layoutSupportManager = ((RADVisualContainer)componentContainer).getLayoutSupport();
            this.constraints = layoutSupportManager.getStoredConstraints((RADVisualComponent)rADComponent);
        }
    }

    void setEvent(Event event, EventHandler eventHandler, String string, boolean bl) {
        if (event != null) {
            this.component = event.getComponent();
        }
        this.componentEvent = event;
        this.propertyName = eventHandler.getName();
        this.newPropertyValue = string;
        this.createdDeleted = bl;
    }

    void setEvent(EventHandler eventHandler, String string) {
        this.propertyName = eventHandler.getName();
        this.oldPropertyValue = string;
        this.newPropertyValue = eventHandler.getName();
    }

    void setChangeType(int n) {
        this.changeType = n;
    }

    private static ComponentContainer deriveContainer(RADComponent rADComponent) {
        if (rADComponent == null) {
            return null;
        }
        if (rADComponent.getParentComponent() instanceof ComponentContainer) {
            return (ComponentContainer)((Object)rADComponent.getParentComponent());
        }
        if (rADComponent.getParentComponent() == null) {
            return rADComponent.getFormModel().getModelContainer();
        }
        return null;
    }

    public final FormModel getFormModel() {
        return (FormModel)this.getSource();
    }

    public final int getChangeType() {
        return this.changeType;
    }

    public final boolean isModifying() {
        return this.changeType != 1 && this.changeType != 2 && this.changeType != 3 && (this.changeType != 12 || this.componentEvent != null);
    }

    public final boolean getCreatedDeleted() {
        return this.createdDeleted;
    }

    public final ComponentContainer getContainer() {
        return this.container;
    }

    public final RADComponent getComponent() {
        return this.component;
    }

    public final LayoutConstraints getComponentLayoutConstraints() {
        return this.constraints;
    }

    public final int getComponentIndex() {
        return this.componentIndex;
    }

    public final String getPropertyName() {
        return this.propertyName;
    }

    public final RADProperty getComponentProperty() {
        if (this.component == null || this.propertyName == null) {
            return null;
        }
        FormProperty formProperty = this.component.getPropertyByName(this.propertyName);
        return formProperty instanceof RADProperty ? (RADProperty)formProperty : null;
    }

    public final Object getOldPropertyValue() {
        return this.oldPropertyValue;
    }

    public final Object getNewPropertyValue() {
        return this.newPropertyValue;
    }

    public final LayoutSupportDelegate getOldLayoutSupport() {
        return (LayoutSupportDelegate)this.oldPropertyValue;
    }

    public final LayoutSupportDelegate getNewLayoutSupport() {
        return (LayoutSupportDelegate)this.newPropertyValue;
    }

    public final int[] getReordering() {
        return this.reordering;
    }

    public final Event getComponentEvent() {
        return this.componentEvent;
    }

    public final EventHandler getEventHandler() {
        return this.getFormModel().getFormEventHandlers().getEventHandler(this.propertyName);
    }

    public final String getEventHandlerName() {
        return this.propertyName;
    }

    public final String getOldEventHandlerName() {
        return (String)this.oldPropertyValue;
    }

    public final String getNewEventHandlerName() {
        return (String)this.newPropertyValue;
    }

    public final String getNewEventHandlerContent() {
        return this.changeType == 12 || this.changeType == 13 ? (String)this.newPropertyValue : null;
    }

    public final String getOldEventHandlerContent() {
        if (this.changeType == 12 || this.changeType == 13) {
            if (this.additionalEvent != null) {
                if (this.additionalEvent.changeType == 13 || this.additionalEvent.changeType == 12) {
                    this.oldPropertyValue = this.additionalEvent.oldPropertyValue;
                }
                this.additionalEvent = null;
            }
            return (String)this.oldPropertyValue;
        }
        return null;
    }

    public final void setOldEventHandlerContent(String string) {
        if (this.changeType == 12 || this.changeType == 13) {
            this.oldPropertyValue = string;
        }
    }

    UndoableEdit getUndoableEdit() {
        if (this.undoableEdit == null) {
            this.undoableEdit = new FormUndoableEdit();
        }
        return this.undoableEdit;
    }

    private static void addToInterestList(FormModelEvent formModelEvent) {
        if (interestList == null) {
            interestList = new ArrayList();
        } else {
            interestList.remove(formModelEvent);
        }
        interestList.add(formModelEvent);
    }

    private static void removeFromInterestList(FormModelEvent formModelEvent) {
        if (interestList != null) {
            interestList.remove(formModelEvent);
        }
    }

    private static void informInterestedEvents(FormModelEvent formModelEvent) {
        if (interestList != null) {
            Iterator iterator = interestList.iterator();
            while (iterator.hasNext()) {
                ((FormModelEvent)iterator.next()).newEventCreated(formModelEvent);
            }
        }
    }

    private void newEventCreated(FormModelEvent formModelEvent) {
        this.additionalEvent = formModelEvent;
    }

    private class FormUndoableEdit
    extends AbstractUndoableEdit {
        private FormUndoableEdit() {
        }

        public void undo() throws CannotUndoException {
            super.undo();
            boolean bl = FormModelEvent.this.getFormModel().isUndoRedoRecording();
            if (bl) {
                FormModelEvent.this.getFormModel().setUndoRedoRecording(false);
            }
            switch (FormModelEvent.this.changeType) {
                case 4: {
                    FormModel.t("UNDO: container layout change");
                    this.undoContainerLayoutExchange();
                    break;
                }
                case 5: {
                    FormModel.t("UNDO: container layout property change");
                    this.undoContainerLayoutChange();
                    break;
                }
                case 6: {
                    FormModel.t("UNDO: component layout constraints change");
                    this.undoComponentLayoutChange();
                    break;
                }
                case 9: {
                    FormModel.t("UNDO: components reorder");
                    this.undoComponentsReorder();
                    break;
                }
                case 7: {
                    FormModel.t("UNDO: component addition");
                    this.undoComponentAddition();
                    break;
                }
                case 8: {
                    FormModel.t("UNDO: component removal");
                    this.undoComponentRemoval();
                    break;
                }
                case 10: {
                    FormModel.t("UNDO: component property change");
                    this.undoComponentPropertyChange();
                    break;
                }
                case 11: {
                    FormModel.t("UNDO: synthetic property change");
                    this.undoSyntheticPropertyChange();
                    break;
                }
                case 12: {
                    FormModel.t("UNDO: event handler addition");
                    this.undoEventHandlerAddition();
                    break;
                }
                case 13: {
                    FormModel.t("UNDO: event handler removal");
                    this.undoEventHandlerRemoval();
                    break;
                }
                case 14: {
                    FormModel.t("UNDO: event handler renaming");
                    this.undoEventHandlerRenaming();
                    break;
                }
                default: {
                    FormModel.t("UNDO: " + FormModelEvent.this.changeType);
                }
            }
            if (bl) {
                FormModelEvent.this.getFormModel().setUndoRedoRecording(true);
            }
        }

        public void redo() throws CannotRedoException {
            super.redo();
            boolean bl = FormModelEvent.this.getFormModel().isUndoRedoRecording();
            if (bl) {
                FormModelEvent.this.getFormModel().setUndoRedoRecording(false);
            }
            switch (FormModelEvent.this.changeType) {
                case 4: {
                    FormModel.t("REDO: container layout change");
                    this.redoContainerLayoutExchange();
                    break;
                }
                case 5: {
                    FormModel.t("REDO: container layout property change");
                    this.redoContainerLayoutChange();
                    break;
                }
                case 6: {
                    FormModel.t("REDO: component layout constraints change");
                    this.redoComponentLayoutChange();
                    break;
                }
                case 9: {
                    FormModel.t("REDO: components reorder");
                    this.redoComponentsReorder();
                    break;
                }
                case 7: {
                    FormModel.t("REDO: component addition");
                    this.redoComponentAddition();
                    break;
                }
                case 8: {
                    FormModel.t("REDO: component removal");
                    this.redoComponentRemoval();
                    break;
                }
                case 10: {
                    FormModel.t("REDO: component property change");
                    this.redoComponentPropertyChange();
                    break;
                }
                case 11: {
                    FormModel.t("REDO: synthetic property change");
                    this.redoSyntheticPropertyChange();
                    break;
                }
                case 12: {
                    FormModel.t("REDO: event handler addition");
                    this.redoEventHandlerAddition();
                    break;
                }
                case 13: {
                    FormModel.t("REDO: event handler removal");
                    this.redoEventHandlerRemoval();
                    break;
                }
                case 14: {
                    FormModel.t("REDO: event handler renaming");
                    this.redoEventHandlerRenaming();
                    break;
                }
                default: {
                    FormModel.t("REDO: " + FormModelEvent.this.changeType);
                }
            }
            if (bl) {
                FormModelEvent.this.getFormModel().setUndoRedoRecording(true);
            }
        }

        public String getUndoPresentationName() {
            return "";
        }

        public String getRedoPresentationName() {
            return "";
        }

        public void die() {
            if (FormModelEvent.this.codeUndoRedoStart != null && FormModelEvent.this.codeUndoRedoEnd != null) {
                FormModelEvent.this.getFormModel().getCodeStructure().releaseUndoableChanges(FormModelEvent.this.codeUndoRedoStart, FormModelEvent.this.codeUndoRedoEnd);
            }
        }

        private void undoContainerLayoutExchange() {
            try {
                FormModelEvent.this.getFormModel().setContainerLayout((RADVisualContainer)FormModelEvent.this.getContainer(), FormModelEvent.this.getOldLayoutSupport(), null);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        private void redoContainerLayoutExchange() {
            try {
                FormModelEvent.this.getFormModel().setContainerLayout((RADVisualContainer)FormModelEvent.this.getContainer(), FormModelEvent.this.getNewLayoutSupport(), null);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        private void undoContainerLayoutChange() {
            Node.Property property;
            LayoutSupportManager layoutSupportManager;
            LayoutSupportManager layoutSupportManager2 = layoutSupportManager = FormModelEvent.this.getComponent() instanceof RADVisualContainer ? ((RADVisualContainer)FormModelEvent.this.getComponent()).getLayoutSupport() : null;
            if (layoutSupportManager != null && (property = layoutSupportManager.getLayoutProperty(FormModelEvent.this.getPropertyName())) != null) {
                try {
                    property.setValue(FormModelEvent.this.getOldPropertyValue());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        private void redoContainerLayoutChange() {
            Node.Property property;
            LayoutSupportManager layoutSupportManager;
            LayoutSupportManager layoutSupportManager2 = layoutSupportManager = FormModelEvent.this.getComponent() instanceof RADVisualContainer ? ((RADVisualContainer)FormModelEvent.this.getComponent()).getLayoutSupport() : null;
            if (layoutSupportManager != null && (property = layoutSupportManager.getLayoutProperty(FormModelEvent.this.getPropertyName())) != null) {
                try {
                    property.setValue(FormModelEvent.this.getNewPropertyValue());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        private void undoComponentLayoutChange() {
            if (FormModelEvent.this.getComponent() instanceof RADVisualComponent) {
                ((RADVisualComponent)FormModelEvent.this.getComponent()).getConstraintsProperties();
                FormProperty formProperty = FormModelEvent.this.getComponent().getPropertyByName(FormModelEvent.this.getPropertyName());
                if (formProperty != null) {
                    try {
                        formProperty.setValue(FormModelEvent.this.getOldPropertyValue());
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }

        private void redoComponentLayoutChange() {
            if (FormModelEvent.this.getComponent() instanceof RADVisualComponent) {
                ((RADVisualComponent)FormModelEvent.this.getComponent()).getConstraintsProperties();
                FormProperty formProperty = FormModelEvent.this.getComponent().getPropertyByName(FormModelEvent.this.getPropertyName());
                if (formProperty != null) {
                    try {
                        formProperty.setValue(FormModelEvent.this.getNewPropertyValue());
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }

        private void undoComponentAddition() {
            this.redoComponentRemoval();
        }

        private void redoComponentAddition() {
            this.undoComponentRemoval();
        }

        private void undoComponentRemoval() {
            if (FormModelEvent.this.codeUndoRedoStart != null && !FormModelEvent.this.getFormModel().getCodeStructure().undoToMark(FormModelEvent.this.codeUndoRedoStart)) {
                return;
            }
            RADComponent[] rADComponentArray = FormModelEvent.this.getContainer().getSubBeans();
            RADComponent[] rADComponentArray2 = new RADComponent[rADComponentArray.length + 1];
            if (FormModelEvent.this.componentIndex < 0) {
                FormModelEvent.this.componentIndex = rADComponentArray.length;
            }
            int n = 0;
            int n2 = 0;
            while (n2 < rADComponentArray2.length) {
                if (n == FormModelEvent.this.componentIndex) {
                    rADComponentArray2[n2] = FormModelEvent.this.getComponent();
                    if (n == rADComponentArray.length) break;
                    ++n2;
                }
                rADComponentArray2[n2] = rADComponentArray[n];
                ++n;
                ++n2;
            }
            FormModelEvent.this.getContainer().initSubComponents(rADComponentArray2);
            if (FormModelEvent.this.getContainer() instanceof RADVisualContainer && FormModelEvent.this.getComponent() instanceof RADVisualComponent) {
                LayoutSupportManager layoutSupportManager = ((RADVisualContainer)FormModelEvent.this.getContainer()).getLayoutSupport();
                layoutSupportManager.addComponents(new RADVisualComponent[]{(RADVisualComponent)FormModelEvent.this.getComponent()}, new LayoutConstraints[]{FormModelEvent.this.getComponentLayoutConstraints()}, FormModelEvent.this.componentIndex);
            }
            if (FormModelEvent.this.getCreatedDeleted()) {
                FormModel.setInModelRecursively(FormModelEvent.this.getComponent(), true);
            }
            FormModelEvent.this.getFormModel().fireComponentAdded(FormModelEvent.this.getComponent(), FormModelEvent.this.getCreatedDeleted());
        }

        private void redoComponentRemoval() {
            if (FormModelEvent.this.getCreatedDeleted()) {
                FormModelEvent.this.getFormModel().removeComponent(FormModelEvent.this.getComponent());
            } else {
                FormModelEvent.this.getFormModel().removeComponentFromContainer(FormModelEvent.this.getComponent());
            }
            if (FormModelEvent.this.codeUndoRedoEnd != null) {
                FormModelEvent.this.getFormModel().getCodeStructure().redoToMark(FormModelEvent.this.codeUndoRedoEnd);
            }
        }

        private void undoComponentsReorder() {
            if (FormModelEvent.this.getContainer() != null && FormModelEvent.this.reordering != null) {
                int[] nArray = new int[FormModelEvent.this.reordering.length];
                int n = 0;
                while (n < FormModelEvent.this.reordering.length) {
                    nArray[((FormModelEvent)FormModelEvent.this).reordering[n]] = n;
                    ++n;
                }
                FormModelEvent.this.getContainer().reorderSubComponents(nArray);
                FormModelEvent.this.getFormModel().fireComponentsReordered(FormModelEvent.this.getContainer(), nArray);
            }
        }

        private void redoComponentsReorder() {
            if (FormModelEvent.this.getContainer() != null && FormModelEvent.this.reordering != null) {
                FormModelEvent.this.getContainer().reorderSubComponents(FormModelEvent.this.reordering);
                FormModelEvent.this.getFormModel().fireComponentsReordered(FormModelEvent.this.getContainer(), FormModelEvent.this.reordering);
            }
        }

        private void undoComponentPropertyChange() {
            FormProperty formProperty = FormModelEvent.this.getComponent().getPropertyByName(FormModelEvent.this.getPropertyName());
            if (formProperty != null) {
                try {
                    formProperty.setValue(FormModelEvent.this.getOldPropertyValue());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        private void redoComponentPropertyChange() {
            FormProperty formProperty = FormModelEvent.this.getComponent().getPropertyByName(FormModelEvent.this.getPropertyName());
            if (formProperty != null) {
                try {
                    formProperty.setValue(FormModelEvent.this.getNewPropertyValue());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        private void undoSyntheticPropertyChange() {
            block6: {
                String string;
                block4: {
                    block5: {
                        string = FormModelEvent.this.getPropertyName();
                        if (!string.startsWith("$$$_")) break block4;
                        if (!string.startsWith("$$$_preCode_")) break block5;
                        FormProperty formProperty = FormModelEvent.this.getComponent().getPropertyByName(string.substring("$$$_preCode_".length()));
                        formProperty.setPreCode((String)FormModelEvent.this.getOldPropertyValue());
                        break block6;
                    }
                    if (!string.startsWith("$$$_postCode_")) break block6;
                    FormProperty formProperty = FormModelEvent.this.getComponent().getPropertyByName(string.substring("$$$_postCode_".length()));
                    formProperty.setPostCode((String)FormModelEvent.this.getOldPropertyValue());
                    break block6;
                }
                Node.Property[] propertyArray = FormModelEvent.this.getComponent().getSyntheticProperties();
                int n = 0;
                while (n < propertyArray.length) {
                    if (propertyArray[n].getName().equals(string)) {
                        try {
                            propertyArray[n].setValue(FormModelEvent.this.getOldPropertyValue());
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        break;
                    }
                    ++n;
                }
            }
        }

        private void redoSyntheticPropertyChange() {
            block6: {
                String string;
                block4: {
                    block5: {
                        string = FormModelEvent.this.getPropertyName();
                        if (!string.startsWith("$$$_")) break block4;
                        if (!string.startsWith("$$$_preCode_")) break block5;
                        FormProperty formProperty = FormModelEvent.this.getComponent().getPropertyByName(string.substring("$$$_preCode_".length()));
                        formProperty.setPreCode((String)FormModelEvent.this.getNewPropertyValue());
                        break block6;
                    }
                    if (!string.startsWith("$$$_postCode_")) break block6;
                    FormProperty formProperty = FormModelEvent.this.getComponent().getPropertyByName(string.substring("$$$_postCode_".length()));
                    formProperty.setPostCode((String)FormModelEvent.this.getNewPropertyValue());
                    break block6;
                }
                Node.Property[] propertyArray = FormModelEvent.this.getComponent().getSyntheticProperties();
                int n = 0;
                while (n < propertyArray.length) {
                    if (propertyArray[n].getName().equals(string)) {
                        try {
                            propertyArray[n].setValue(FormModelEvent.this.getNewPropertyValue());
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        break;
                    }
                    ++n;
                }
            }
        }

        private void undoEventHandlerAddition() {
            if (FormModelEvent.this.getComponentEvent() == null) {
                return;
            }
            FormModelEvent.addToInterestList(FormModelEvent.this);
            FormModelEvent.this.getFormModel().getFormEventHandlers().removeEventHandler(FormModelEvent.this.getComponentEvent(), FormModelEvent.this.getEventHandlerName());
            FormModelEvent.removeFromInterestList(FormModelEvent.this);
            FormModelEvent.this.getComponent().getNodeReference().firePropertyChangeHelper("__EVENT__" + FormModelEvent.this.getComponentEvent().getName(), null, null);
        }

        private void redoEventHandlerAddition() {
            if (FormModelEvent.this.getComponentEvent() == null) {
                return;
            }
            FormModelEvent.this.getFormModel().getFormEventHandlers().addEventHandler(FormModelEvent.this.getComponentEvent(), FormModelEvent.this.getEventHandlerName(), FormModelEvent.this.getOldEventHandlerContent());
            FormModelEvent.this.getComponent().getNodeReference().firePropertyChangeHelper("__EVENT__" + FormModelEvent.this.getComponentEvent().getName(), null, null);
        }

        private void undoEventHandlerRemoval() {
            if (FormModelEvent.this.getComponentEvent() == null) {
                return;
            }
            FormModelEvent.this.getFormModel().getFormEventHandlers().addEventHandler(FormModelEvent.this.getComponentEvent(), FormModelEvent.this.getEventHandlerName(), FormModelEvent.this.getOldEventHandlerContent());
            if (FormModelEvent.this.getComponent().getNodeReference() != null) {
                FormModelEvent.this.getComponent().getNodeReference().firePropertyChangeHelper("__EVENT__" + FormModelEvent.this.getComponentEvent().getName(), null, null);
            }
        }

        private void redoEventHandlerRemoval() {
            if (FormModelEvent.this.getComponentEvent() == null) {
                return;
            }
            FormModelEvent.addToInterestList(FormModelEvent.this);
            FormModelEvent.this.getFormModel().getFormEventHandlers().removeEventHandler(FormModelEvent.this.getComponentEvent(), FormModelEvent.this.getEventHandlerName());
            FormModelEvent.removeFromInterestList(FormModelEvent.this);
            FormModelEvent.this.getComponent().getNodeReference().firePropertyChangeHelper("__EVENT__" + FormModelEvent.this.getComponentEvent().getName(), null, null);
        }

        private void undoEventHandlerRenaming() {
            FormEventHandlers formEventHandlers = FormModelEvent.this.getFormModel().getFormEventHandlers();
            formEventHandlers.renameEventHandler(FormModelEvent.this.getNewEventHandlerName(), FormModelEvent.this.getOldEventHandlerName());
            Iterator iterator = formEventHandlers.getEventHandler(FormModelEvent.this.getOldEventHandlerName()).getAttachedEvents().iterator();
            while (iterator.hasNext()) {
                Event event = (Event)iterator.next();
                event.getComponent().getNodeReference().firePropertyChangeHelper("__EVENT__" + event.getName(), null, null);
            }
        }

        private void redoEventHandlerRenaming() {
            FormEventHandlers formEventHandlers = FormModelEvent.this.getFormModel().getFormEventHandlers();
            formEventHandlers.renameEventHandler(FormModelEvent.this.getOldEventHandlerName(), FormModelEvent.this.getNewEventHandlerName());
            Iterator iterator = formEventHandlers.getEventHandler(FormModelEvent.this.getNewEventHandlerName()).getAttachedEvents().iterator();
            while (iterator.hasNext()) {
                Event event = (Event)iterator.next();
                event.getComponent().getNodeReference().firePropertyChangeHelper("__EVENT__" + event.getName(), null, null);
            }
        }
    }
}

