/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.codestructure;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.netbeans.modules.form.codestructure.AbstractCodeStatement;
import org.netbeans.modules.form.codestructure.CodeExpression;
import org.netbeans.modules.form.codestructure.CodeExpressionOrigin;
import org.netbeans.modules.form.codestructure.CodeGroup;
import org.netbeans.modules.form.codestructure.CodeStatement;
import org.netbeans.modules.form.codestructure.CodeStructure;
import org.netbeans.modules.form.codestructure.CodeVariable;

class CodeSupport {
    private CodeSupport() {
    }

    static final class DefaultCodeGroup
    implements CodeGroup {
        private List statements = new ArrayList();

        DefaultCodeGroup() {
        }

        public void addStatement(CodeStatement codeStatement) {
            this.statements.add(codeStatement);
        }

        public void addStatement(int n, CodeStatement codeStatement) {
            this.statements.add(n, codeStatement);
        }

        public void addGroup(CodeGroup codeGroup) {
            this.statements.add(codeGroup);
        }

        public void addGroup(int n, CodeGroup codeGroup) {
            this.statements.add(n, codeGroup);
        }

        public CodeStatement getStatement(int n) {
            Object e = this.statements.get(n);
            if (e instanceof CodeStatement) {
                return (CodeStatement)e;
            }
            if (e instanceof CodeGroup) {
                return ((CodeGroup)e).getStatement(0);
            }
            return null;
        }

        public int indexOf(Object object) {
            return this.statements.indexOf(object);
        }

        public void remove(Object object) {
            this.statements.remove(object);
        }

        public void remove(int n) {
            this.statements.remove(n);
        }

        public void removeAll() {
            this.statements.clear();
        }

        public Iterator getStatementsIterator() {
            return new StatementsIterator();
        }

        class StatementsIterator
        implements Iterator {
            int index = 0;
            int count = DefaultCodeGroup.access$000(DefaultCodeGroup.this).size();
            Iterator subIter;

            StatementsIterator() {
            }

            public boolean hasNext() {
                if (this.subIter != null) {
                    if (this.subIter.hasNext()) {
                        return true;
                    }
                    this.subIter = null;
                    ++this.index;
                }
                while (this.index < this.count) {
                    Object e = DefaultCodeGroup.this.statements.get(this.index);
                    if (e instanceof CodeGroup) {
                        this.subIter = ((CodeGroup)e).getStatementsIterator();
                        if (this.subIter.hasNext()) {
                            return true;
                        }
                        this.subIter = null;
                    } else if (e instanceof CodeStatement) {
                        return true;
                    }
                    ++this.index;
                }
                return false;
            }

            public Object next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.subIter != null ? this.subIter.next() : DefaultCodeGroup.this.statements.get(this.index++);
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }

    static final class ValueOrigin
    implements CodeExpressionOrigin {
        private Class expressionType;
        private Object expressionValue;
        private String javaString;

        public ValueOrigin(Class clazz, Object object, String string) {
            this.expressionType = clazz;
            this.expressionValue = object;
            this.javaString = string;
        }

        public Class getType() {
            return this.expressionType;
        }

        public CodeExpression getParentExpression() {
            return null;
        }

        public Object getMetaObject() {
            return null;
        }

        public Object getValue() {
            return this.expressionValue;
        }

        public CodeExpression[] getCreationParameters() {
            return CodeStructure.EMPTY_PARAMS;
        }

        public String getJavaCodeString(String string, String[] stringArray) {
            return this.javaString;
        }
    }

    static final class FieldOrigin
    implements CodeExpressionOrigin {
        private CodeExpression parentExpression;
        private Field originField;

        public FieldOrigin(CodeExpression codeExpression, Field field) {
            this.parentExpression = codeExpression;
            this.originField = field;
        }

        public Class getType() {
            return this.originField.getType();
        }

        public CodeExpression getParentExpression() {
            return this.parentExpression;
        }

        public Object getMetaObject() {
            return this.originField;
        }

        public Object getValue() {
            return null;
        }

        public CodeExpression[] getCreationParameters() {
            return CodeStructure.EMPTY_PARAMS;
        }

        public String getJavaCodeString(String string, String[] stringArray) {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.parentExpression != null) {
                if (string != null && !string.equals("")) {
                    stringBuffer.append(string);
                    stringBuffer.append(".");
                }
            } else {
                stringBuffer.append(this.originField.getDeclaringClass().getName().replace('$', '.'));
                stringBuffer.append(".");
            }
            stringBuffer.append(this.originField.getName());
            return stringBuffer.toString();
        }
    }

    static final class MethodOrigin
    implements CodeExpressionOrigin {
        private CodeExpression parentExpression;
        private Method creationMethod;
        private CodeExpression[] parameters;

        public MethodOrigin(CodeExpression codeExpression, Method method, CodeExpression[] codeExpressionArray) {
            this.parentExpression = codeExpression;
            this.creationMethod = method;
            this.parameters = codeExpressionArray != null ? codeExpressionArray : CodeStructure.EMPTY_PARAMS;
        }

        public Class getType() {
            return this.creationMethod.getReturnType();
        }

        public CodeExpression getParentExpression() {
            return this.parentExpression;
        }

        public Object getMetaObject() {
            return this.creationMethod;
        }

        public Object getValue() {
            return null;
        }

        public CodeExpression[] getCreationParameters() {
            return this.parameters;
        }

        public String getJavaCodeString(String string, String[] stringArray) {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.parentExpression != null) {
                if (string != null && !string.equals("")) {
                    stringBuffer.append(string);
                    stringBuffer.append(".");
                }
            } else {
                stringBuffer.append(this.creationMethod.getDeclaringClass().getName().replace('$', '.'));
                stringBuffer.append(".");
            }
            stringBuffer.append(this.creationMethod.getName());
            stringBuffer.append("(");
            int n = 0;
            while (n < stringArray.length) {
                stringBuffer.append(stringArray[n]);
                if (n + 1 < this.parameters.length) {
                    stringBuffer.append(", ");
                }
                ++n;
            }
            stringBuffer.append(")");
            return stringBuffer.toString();
        }
    }

    static final class ConstructorOrigin
    implements CodeExpressionOrigin {
        private Constructor constructor;
        private CodeExpression[] parameters;

        public ConstructorOrigin(Constructor constructor, CodeExpression[] codeExpressionArray) {
            this.constructor = constructor;
            this.parameters = codeExpressionArray != null ? codeExpressionArray : CodeStructure.EMPTY_PARAMS;
        }

        public Class getType() {
            return this.constructor.getDeclaringClass();
        }

        public CodeExpression getParentExpression() {
            return null;
        }

        public Object getMetaObject() {
            return this.constructor;
        }

        public Object getValue() {
            Object[] objectArray = new Object[this.parameters.length];
            int n = 0;
            while (n < objectArray.length) {
                CodeExpressionOrigin codeExpressionOrigin = this.parameters[n].getOrigin();
                Object object = codeExpressionOrigin.getValue();
                Class clazz = codeExpressionOrigin.getType();
                if (object == null && clazz.isPrimitive()) {
                    return null;
                }
                objectArray[n] = object;
                ++n;
            }
            try {
                return this.constructor.newInstance(objectArray);
            }
            catch (Exception exception) {
                if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                    exception.printStackTrace();
                }
                return null;
            }
        }

        public CodeExpression[] getCreationParameters() {
            return this.parameters;
        }

        public String getJavaCodeString(String string, String[] stringArray) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("new ");
            stringBuffer.append(this.constructor.getName());
            stringBuffer.append("(");
            int n = 0;
            while (n < stringArray.length) {
                stringBuffer.append(stringArray[n]);
                if (n + 1 < this.parameters.length) {
                    stringBuffer.append(", ");
                }
                ++n;
            }
            stringBuffer.append(")");
            return stringBuffer.toString();
        }
    }

    static final class DeclareVariableStatement
    extends AbstractCodeStatement {
        private CodeVariable variable;

        public DeclareVariableStatement(CodeVariable codeVariable) {
            super(null);
            this.variable = codeVariable;
        }

        public Object getMetaObject() {
            return this.variable;
        }

        public CodeExpression[] getStatementParameters() {
            return CodeStructure.EMPTY_PARAMS;
        }

        public String getJavaCodeString(String string, String[] stringArray) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = this.variable.getType();
            if ((n & 0x3000) == 8192) {
                switch (n & 7) {
                    case 1: {
                        stringBuffer.append("public ");
                        break;
                    }
                    case 2: {
                        stringBuffer.append("private ");
                        break;
                    }
                    case 4: {
                        stringBuffer.append("protected ");
                    }
                }
                if ((n & 8) == 8) {
                    stringBuffer.append("static ");
                }
                if ((n & 0x10) == 16) {
                    stringBuffer.append("final ");
                }
                if ((n & 0x80) == 128) {
                    stringBuffer.append("transient ");
                }
                if ((n & 0x40) == 64) {
                    stringBuffer.append("volatile ");
                }
            } else if ((n & 0x10) == 16) {
                stringBuffer.append("final ");
            }
            stringBuffer.append(this.variable.getDeclaredType().getName().replace('$', '.'));
            stringBuffer.append(" ");
            stringBuffer.append(this.variable.getName());
            stringBuffer.append(";");
            return stringBuffer.toString();
        }
    }

    static final class AssignVariableStatement
    extends AbstractCodeStatement {
        private CodeVariable variable;

        public AssignVariableStatement(CodeVariable codeVariable, CodeExpression codeExpression) {
            super(codeExpression);
            this.variable = codeVariable;
        }

        public Object getMetaObject() {
            return this.parentExpression;
        }

        public CodeExpression[] getStatementParameters() {
            return this.parentExpression.getOrigin().getCreationParameters();
        }

        public String getJavaCodeString(String string, String[] stringArray) {
            int n;
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = this.variable.getType();
            if ((n2 & (n = 28672)) == 4096) {
                if ((n2 & 0x10) == 16) {
                    stringBuffer.append("final ");
                }
                stringBuffer.append(this.variable.getDeclaredType().getName().replace('$', '.'));
                stringBuffer.append(" ");
            }
            stringBuffer.append(this.variable.getName());
            stringBuffer.append(" = ");
            stringBuffer.append(this.parentExpression.getOrigin().getJavaCodeString(string, stringArray));
            stringBuffer.append(";");
            return stringBuffer.toString();
        }
    }

    static final class FieldStatement
    extends AbstractCodeStatement {
        private Field assignField;
        private CodeExpression[] parameters;

        public FieldStatement(CodeExpression codeExpression, Field field, CodeExpression codeExpression2) {
            super(codeExpression);
            this.assignField = field;
            this.parameters = new CodeExpression[]{codeExpression2};
        }

        public Object getMetaObject() {
            return this.assignField;
        }

        public CodeExpression[] getStatementParameters() {
            return this.parameters;
        }

        public String getJavaCodeString(String string, String[] stringArray) {
            StringBuffer stringBuffer = new StringBuffer();
            if (string != null && !string.equals("")) {
                stringBuffer.append(string);
                stringBuffer.append(".");
            }
            stringBuffer.append(this.assignField.getName());
            stringBuffer.append(" = ");
            stringBuffer.append(stringArray[0]);
            stringBuffer.append(";");
            return stringBuffer.toString();
        }
    }

    static final class MethodStatement
    extends AbstractCodeStatement {
        private Method performMethod;
        private CodeExpression[] parameters;

        public MethodStatement(CodeExpression codeExpression, Method method, CodeExpression[] codeExpressionArray) {
            super(codeExpression);
            this.performMethod = method;
            this.parameters = codeExpressionArray != null ? codeExpressionArray : CodeStructure.EMPTY_PARAMS;
        }

        public Object getMetaObject() {
            return this.performMethod;
        }

        public CodeExpression[] getStatementParameters() {
            return this.parameters;
        }

        public String getJavaCodeString(String string, String[] stringArray) {
            StringBuffer stringBuffer = new StringBuffer();
            if (string != null && !string.equals("")) {
                stringBuffer.append(string);
                stringBuffer.append(".");
            }
            stringBuffer.append(this.performMethod.getName());
            stringBuffer.append("(");
            int n = 0;
            while (n < stringArray.length) {
                stringBuffer.append(stringArray[n]);
                if (n + 1 < this.parameters.length) {
                    stringBuffer.append(", ");
                }
                ++n;
            }
            stringBuffer.append(");");
            return stringBuffer.toString();
        }
    }
}

