/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.fakepeer;

import java.awt.Button;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.peer.ButtonPeer;
import org.netbeans.modules.form.fakepeer.FakeComponentPeer;
import org.netbeans.modules.form.fakepeer.FakePeerUtils;

class FakeButtonPeer
extends FakeComponentPeer
implements ButtonPeer {
    private static final Insets MARGINS = new Insets(4, 8, 4, 8);

    FakeButtonPeer(Button button) {
        super(button);
    }

    Component createDelegate() {
        return new Delegate();
    }

    public void setLabel(String string) {
    }

    private class Delegate
    extends Component {
        Delegate() {
            this.setBackground(SystemColor.control);
            this.setForeground(SystemColor.controlText);
        }

        public void paint(Graphics graphics) {
            Button button = (Button)FakeButtonPeer.this._target;
            Dimension dimension = button.getSize();
            graphics.setColor(button.getBackground());
            FakePeerUtils.drawButton(graphics, 0, 0, dimension.width, dimension.height);
            String string = button.getLabel();
            if (string == null) {
                return;
            }
            graphics.setFont(button.getFont());
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n = fontMetrics.stringWidth(string);
            int n2 = fontMetrics.getHeight() - fontMetrics.getDescent();
            int n3 = (dimension.width - n) / 2;
            int n4 = (dimension.height - n2) / 2 + n2 - 2;
            if (button.isEnabled()) {
                graphics.setColor(button.getForeground());
            } else {
                graphics.setColor(SystemColor.controlLtHighlight);
                graphics.drawString(string, n3 + 1, n4 + 1);
                graphics.setColor(SystemColor.controlShadow);
            }
            graphics.drawString(string, n3, n4);
        }

        public Dimension getMinimumSize() {
            String string = ((Button)FakeButtonPeer.this._target).getLabel();
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int n = fontMetrics.stringWidth(string);
            int n2 = fontMetrics.getHeight();
            return new Dimension(n + MARGINS.left + MARGINS.right, n2 + MARGINS.top + MARGINS.bottom);
        }
    }
}

