/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.palette;

import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.netbeans.modules.form.palette.CPManager;
import org.netbeans.modules.form.palette.PaletteItemNode;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.awt.JPopupMenuPlus;
import org.openide.nodes.Index;
import org.openide.nodes.Node;
import org.openide.util.datatransfer.ExClipboard;

class ItemPopupMenu
extends JPopupMenuPlus {
    private Node itemNode;
    static /* synthetic */ Class class$org$openide$nodes$Index;

    public ItemPopupMenu(Node node) {
        this.itemNode = node;
        Node node2 = this.itemNode.getParentNode();
        ResourceBundle resourceBundle = CPManager.getBundle();
        JMenuItem jMenuItem = new JMenuItem(resourceBundle.getString("CTL_MoveLeft"));
        jMenuItem.setEnabled(!this.itemFirstOrLast(true));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ItemPopupMenu.this.moveLeft();
            }
        });
        ((JPopupMenu)((Object)this)).add(jMenuItem);
        jMenuItem = new JMenuItem(resourceBundle.getString("CTL_MoveRight"));
        jMenuItem.setEnabled(!this.itemFirstOrLast(false));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ItemPopupMenu.this.moveRight();
            }
        });
        ((JPopupMenu)((Object)this)).add(jMenuItem);
        ((JPopupMenu)((Object)this)).addSeparator();
        jMenuItem = new JMenuItem(resourceBundle.getString("CTL_Cut"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ItemPopupMenu.this.cutNode();
            }
        });
        ((JPopupMenu)((Object)this)).add(jMenuItem);
        jMenuItem = new JMenuItem(resourceBundle.getString("CTL_Copy"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ItemPopupMenu.this.copyNode();
            }
        });
        ((JPopupMenu)((Object)this)).add(jMenuItem);
        ((JPopupMenu)((Object)this)).addSeparator();
        jMenuItem = new JMenuItem(resourceBundle.getString("CTL_Delete"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ItemPopupMenu.this.deleteNode();
            }
        });
        ((JPopupMenu)((Object)this)).add(jMenuItem);
    }

    private void moveLeft() {
        Node node = this.itemNode.getParentNode();
        if (node == null) {
            return;
        }
        Index index = (Index)node.getCookie(class$org$openide$nodes$Index == null ? (class$org$openide$nodes$Index = ItemPopupMenu.class$("org.openide.nodes.Index")) : class$org$openide$nodes$Index);
        if (index == null) {
            return;
        }
        int n = index.indexOf(this.itemNode);
        if (index != null && index.indexOf(this.itemNode) > 0) {
            index.moveUp(n);
        }
    }

    private void moveRight() {
        Node node = this.itemNode.getParentNode();
        if (node == null) {
            return;
        }
        Index index = (Index)node.getCookie(class$org$openide$nodes$Index == null ? (class$org$openide$nodes$Index = ItemPopupMenu.class$("org.openide.nodes.Index")) : class$org$openide$nodes$Index);
        if (index == null) {
            return;
        }
        int n = index.indexOf(this.itemNode);
        if (n >= 0 && n + 1 < index.getNodesCount()) {
            index.moveDown(n);
        }
    }

    private void cutNode() {
        try {
            Transferable transferable = this.itemNode.clipboardCut();
            if (transferable != null) {
                ExClipboard exClipboard = TopManager.getDefault().getClipboard();
                exClipboard.setContents(transferable, new StringSelection(""));
            }
        }
        catch (IOException iOException) {
            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                iOException.printStackTrace();
            }
            TopManager.getDefault().getErrorManager().notify((Throwable)iOException);
        }
    }

    private void copyNode() {
        try {
            Transferable transferable = this.itemNode.clipboardCopy();
            if (transferable != null) {
                ExClipboard exClipboard = TopManager.getDefault().getClipboard();
                exClipboard.setContents(transferable, new StringSelection(""));
            }
        }
        catch (IOException iOException) {
            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                iOException.printStackTrace();
            }
            TopManager.getDefault().getErrorManager().notify((Throwable)iOException);
        }
    }

    private void deleteNode() {
        String string = MessageFormat.format(CPManager.getBundle().getString("FMT_ConfirmBeanDelete"), this.itemNode.getDisplayName());
        NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)string, CPManager.getBundle().getString("CTL_ConfirmBeanTitle"), 0);
        if (NotifyDescriptor.YES_OPTION.equals(TopManager.getDefault().notify((NotifyDescriptor)confirmation))) {
            try {
                this.itemNode.destroy();
            }
            catch (IOException iOException) {
                if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                    iOException.printStackTrace();
                }
                TopManager.getDefault().getErrorManager().notify((Throwable)iOException);
            }
        }
    }

    private boolean itemFirstOrLast(boolean bl) {
        Node node = this.itemNode.getParentNode();
        if (node == null) {
            return true;
        }
        boolean bl2 = true;
        Node[] nodeArray = node.getChildren().getNodes();
        int n = 0;
        while (n < nodeArray.length) {
            Node node2 = nodeArray[n];
            if (node2 != this.itemNode) {
                if (bl2 ? bl && node2 instanceof PaletteItemNode && ((PaletteItemNode)node2).getItemClass() != null : node2 instanceof PaletteItemNode && ((PaletteItemNode)node2).getItemClass() != null) {
                    return false;
                }
            } else {
                if (bl) {
                    return true;
                }
                bl2 = false;
            }
            ++n;
        }
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

