/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Hashtable;

public class FormLayout
implements LayoutManager {
    public static final String LEFT = "Left";
    public static final String RIGHT = "Right";
    public static final String CENTER = "Center";
    public static final String FILL = "Fill";
    private int _hgap;
    private int _vgap;
    private Hashtable _constraints = new Hashtable();

    public FormLayout() {
        this(0, 0);
    }

    public FormLayout(int n, int n2) {
        this._hgap = n;
        this._vgap = n2;
    }

    public void setHgap(int n) {
        this._hgap = n;
    }

    public int getHgap() {
        return this._hgap;
    }

    public void setVgap(int n) {
        this._vgap = n;
    }

    public int getVgap() {
        return this._vgap;
    }

    public void addLayoutComponent(String string, Component component) {
        if (string == null) {
            string = LEFT;
        }
        this._constraints.put(component, string);
    }

    public void removeLayoutComponent(Component component) {
        this._constraints.remove(component);
    }

    public Dimension preferredLayoutSize(Container container) {
        Dimension dimension = new Dimension();
        Object object = container.getTreeLock();
        synchronized (object) {
            Component[] componentArray = container.getComponents();
            Insets insets = container.getInsets();
            int n = 0;
            int n2 = 0;
            Dimension dimension2 = new Dimension();
            int n3 = componentArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Dimension dimension3 = componentArray[n4].getPreferredSize();
                Dimension dimension4 = n4 >= n3 - 1 ? dimension2 : componentArray[n4 + 1].getPreferredSize();
                dimension.height += Math.max(dimension3.height, dimension4.height);
                n = Math.max(n, dimension3.width);
                n2 = Math.max(n2, dimension4.width);
                if (n4 < n3 - 2) {
                    dimension.height += this._vgap;
                }
                n4 += 2;
            }
            dimension.width += insets.left + insets.right + this._hgap + n + n2;
            dimension.height += insets.top + insets.bottom;
        }
        return dimension;
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Component[] componentArray = container.getComponents();
            int n = componentArray.length;
            Insets insets = container.getInsets();
            Dimension dimension = container.getSize();
            Dimension dimension2 = new Dimension();
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                n2 = Math.max(n2, componentArray[n3].getPreferredSize().width);
                n3 += 2;
            }
            n2 += insets.left;
            int n4 = insets.top;
            int n5 = 0;
            while (n5 < n) {
                Dimension dimension3;
                Component component;
                Component component2 = componentArray[n5];
                Dimension dimension4 = component2.getPreferredSize();
                if (n5 < componentArray.length - 1) {
                    component = componentArray[n5 + 1];
                    dimension3 = component.getPreferredSize();
                } else {
                    component = null;
                    dimension3 = dimension2;
                }
                int n6 = Math.max(dimension4.height, dimension3.height);
                this.setComponentBounds(component2, insets.left, n4, n2 - insets.left, n6);
                if (component != null) {
                    this.setComponentBounds(component, n2 + this._hgap, n4, dimension.width - (n2 + this._hgap + insets.right), n6);
                }
                n4 += n6 + this._vgap;
                n5 += 2;
            }
        }
    }

    private void setComponentBounds(Component component, int n, int n2, int n3, int n4) {
        String string = (String)this._constraints.get(component);
        Dimension dimension = new Dimension(component.getPreferredSize());
        dimension.width = Math.min(dimension.width, n3);
        dimension.height = Math.min(dimension.height, n4);
        if (LEFT.equals(string)) {
            n3 = dimension.width;
        } else if (RIGHT.equals(string)) {
            n = n3 - dimension.width;
            n3 = dimension.width;
        } else if (CENTER.equals(string)) {
            n += (n3 - dimension.width) / 2;
            n3 = dimension.width;
        }
        component.setBounds(n, n2 + (n4 - dimension.height) / 2, n3, dimension.height);
    }
}

