/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.extbrowser;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.netbeans.modules.extbrowser.ExtBrowserImpl;
import org.netbeans.modules.extbrowser.NbDdeBrowserImpl;
import org.netbeans.modules.extbrowser.UnixBrowserImpl;
import org.netbeans.modules.extbrowser.WinWebBrowser;
import org.openide.awt.HtmlBrowser;
import org.openide.execution.NbProcessDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class ExtWebBrowser
implements HtmlBrowser.Factory,
Serializable {
    private static final long serialVersionUID = -3021027901671504127L;
    public static final String PROP_DESCRIPTION = "description";
    public static final String PROP_BROWSER_EXECUTABLE = "browserExecutable";
    public static final String PROP_START_IF_NOT_RUNNING = "startIfNotRunning";
    private String executable;
    private NbProcessDescriptor browserExecutable;
    private boolean startIfNotRunning = true;
    protected transient PropertyChangeSupport pcs;
    static /* synthetic */ Class class$org$netbeans$modules$extbrowser$ExtWebBrowser;

    public ExtWebBrowser() {
        this.init();
    }

    private void init() {
        this.pcs = new PropertyChangeSupport(this);
    }

    public String getDescription() {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$extbrowser$ExtWebBrowser == null ? (class$org$netbeans$modules$extbrowser$ExtWebBrowser = ExtWebBrowser.class$("org.netbeans.modules.extbrowser.ExtWebBrowser")) : class$org$netbeans$modules$extbrowser$ExtWebBrowser), (String)"CTL_ExternalBrowser");
    }

    public NbProcessDescriptor getBrowserExecutable() {
        if (this.browserExecutable == null || "".equals(this.browserExecutable.getProcessName())) {
            return this.defaultBrowserExecutable();
        }
        return this.browserExecutable;
    }

    public void setBrowserExecutable(NbProcessDescriptor nbProcessDescriptor) {
        NbProcessDescriptor nbProcessDescriptor2 = this.browserExecutable;
        this.browserExecutable = nbProcessDescriptor;
        this.pcs.firePropertyChange(PROP_BROWSER_EXECUTABLE, nbProcessDescriptor2, nbProcessDescriptor);
    }

    public boolean isStartWhenNotRunning() {
        return true;
    }

    public void setStartWhenNotRunning(boolean bl) {
        if (bl != this.startIfNotRunning) {
            this.startIfNotRunning = bl;
            this.pcs.firePropertyChange(PROP_START_IF_NOT_RUNNING, !this.startIfNotRunning, this.startIfNotRunning);
        }
    }

    protected NbProcessDescriptor defaultBrowserExecutable() {
        return new NbProcessDescriptor("netscape", "");
    }

    public HtmlBrowser.Impl createHtmlBrowserImpl() {
        ExtBrowserImpl extBrowserImpl = null;
        if (Utilities.isUnix()) {
            extBrowserImpl = new UnixBrowserImpl(this);
        } else if (Utilities.isWindows()) {
            extBrowserImpl = new NbDdeBrowserImpl(new WinWebBrowser());
        }
        return extBrowserImpl;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.executable != null) {
            if (this.executable.charAt(0) == '\"') {
                int n = this.executable.indexOf(34, 1);
                this.executable = n > 0 ? this.executable.substring(1, n) : this.executable.substring(1);
            }
            this.browserExecutable = new NbProcessDescriptor(this.executable, "");
            this.executable = null;
        }
        this.init();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

