/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ajp.tomcat4;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.AccessControlException;
import java.util.Stack;
import java.util.Vector;
import org.apache.ajp.tomcat4.Ajp13Logger;
import org.apache.ajp.tomcat4.Ajp13Processor;
import org.apache.ajp.tomcat4.Ajp13Request;
import org.apache.ajp.tomcat4.Ajp13Response;
import org.apache.catalina.Connector;
import org.apache.catalina.Container;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.Service;
import org.apache.catalina.net.DefaultServerSocketFactory;
import org.apache.catalina.net.ServerSocketFactory;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;

public final class Ajp13Connector
implements Connector,
Lifecycle,
Runnable {
    private int acceptCount = 10;
    private String address = null;
    private int bufferSize = 2048;
    protected Container container = null;
    private Vector created = new Vector();
    private int curProcessors = 0;
    private int debug = 0;
    private ServerSocketFactory factory = null;
    private static final String info = "org.apache.catalina.connector.ajp.Ajp13Connector/1.0";
    private int redirectPort = -1;
    private boolean enableLookups = false;
    protected LifecycleSupport lifecycle = new LifecycleSupport((Lifecycle)this);
    protected int minProcessors = 5;
    private int maxProcessors = 20;
    private int connectionTimeout = -1;
    private int port = 8009;
    private Stack processors = new Stack();
    private String scheme = "http";
    private boolean secure = false;
    private ServerSocket serverSocket = null;
    private StringManager sm = StringManager.getManager((String)"org.apache.ajp.tomcat4");
    private boolean started = false;
    private boolean stopped = false;
    private Thread thread = null;
    private ThreadGroup threadGroup = null;
    private String threadName = null;
    private DebugThread debugThread = null;
    private Object threadSync = new Object();
    private Ajp13Logger logger = new Ajp13Logger();
    private Service service = null;
    private String secret = null;
    private boolean tomcatAuthentication = true;

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Ajp13Processor createProcessor() {
        Stack stack = this.processors;
        synchronized (stack) {
            if (this.processors.size() > 0) {
                return (Ajp13Processor)this.processors.pop();
            }
            if (this.maxProcessors <= 0) return null;
            if (this.curProcessors >= this.maxProcessors) return null;
            return this.newProcessor();
        }
    }

    public Request createRequest() {
        Ajp13Request request = new Ajp13Request(this);
        request.setConnector(this);
        return request;
    }

    public Response createResponse() {
        Ajp13Response response = new Ajp13Response();
        response.setConnector(this);
        return response;
    }

    public LifecycleListener[] findLifecycleListeners() {
        return null;
    }

    public int getAcceptCount() {
        return this.acceptCount;
    }

    public String getAddress() {
        return this.address;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public Container getContainer() {
        return this.container;
    }

    public int getCurProcessors() {
        return this.curProcessors;
    }

    public int getDebug() {
        return this.debug;
    }

    public boolean getEnableLookups() {
        return this.enableLookups;
    }

    public ServerSocketFactory getFactory() {
        if (this.factory == null) {
            Ajp13Connector ajp13Connector = this;
            synchronized (ajp13Connector) {
                this.factory = new DefaultServerSocketFactory();
            }
        }
        return this.factory;
    }

    public String getInfo() {
        return info;
    }

    public int getMaxProcessors() {
        return this.maxProcessors;
    }

    public int getMinProcessors() {
        return this.minProcessors;
    }

    public int getPort() {
        return this.port;
    }

    public int getRedirectPort() {
        return this.redirectPort;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getSecret() {
        return this.secret;
    }

    public boolean getSecure() {
        return this.secure;
    }

    public Service getService() {
        return this.service;
    }

    public boolean getTomcatAuthentication() {
        return this.tomcatAuthentication;
    }

    public void initialize() throws LifecycleException {
    }

    public boolean isAvailable() {
        return this.started;
    }

    private Ajp13Processor newProcessor() {
        Ajp13Processor processor;
        if ((processor = new Ajp13Processor(this, this.curProcessors++, this.threadGroup)) instanceof Lifecycle) {
            try {
                processor.start();
            }
            catch (LifecycleException e) {
                this.logger.log("newProcessor", e);
                return null;
            }
        }
        this.created.addElement(processor);
        return processor;
    }

    private ServerSocket open() throws IOException {
        ServerSocketFactory factory = this.getFactory();
        if (this.address == null) {
            this.logger.log(this.sm.getString("ajp13Connector.allAddresses"));
            try {
                return factory.createSocket(this.port, this.acceptCount);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }
        try {
            InetAddress is = InetAddress.getByName(this.address);
            this.logger.log(this.sm.getString("ajp13Connector.anAddress", (Object)this.address));
            return factory.createSocket(this.port, this.acceptCount, is);
        }
        catch (Exception exception) {
            try {
                this.logger.log(this.sm.getString("ajp13Connector.noAddress", (Object)this.address));
                return factory.createSocket(this.port, this.acceptCount);
            }
            catch (Exception e1) {
                e1.printStackTrace();
                return null;
            }
        }
    }

    void recycle(Ajp13Processor processor) {
        Stack stack = this.processors;
        synchronized (stack) {
            if (this.debug > 0) {
                this.logger.log("added processor to available processors, available=" + this.processors.size());
            }
            this.processors.push(processor);
        }
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public void run() {
        Object socket;
        while (!this.stopped) {
            Ajp13Processor processor;
            block22: {
                socket = null;
                try {
                    if (this.debug > 0) {
                        this.logger.log("accepting socket...");
                    }
                    socket = this.serverSocket.accept();
                    if (this.debug > 0) {
                        this.logger.log("accepted socket, assigning to processor.");
                    }
                    ((Socket)socket).setSoLinger(true, 100);
                    ((Socket)socket).setKeepAlive(true);
                    if (this.connectionTimeout < 0) break block22;
                    ((Socket)socket).setSoTimeout(this.connectionTimeout);
                }
                catch (AccessControlException ace) {
                    this.logger.log("socket accept security exception: " + ace.getMessage());
                    continue;
                }
                catch (IOException e) {
                    if (this.started && !this.stopped) {
                        this.logger.log("accept: ", e);
                    }
                    try {
                        if (this.serverSocket != null) {
                            this.serverSocket.close();
                        }
                        if (this.stopped) {
                            if (this.debug <= 0) break;
                            this.logger.log("run():  stopped, so breaking");
                            break;
                        }
                        if (this.debug > 0) {
                            this.logger.log("run():  not stopped, so reopening server socket");
                        }
                        this.serverSocket = this.open();
                        continue;
                    }
                    catch (IOException ex) {
                        this.logger.log("socket reopen: ", ex);
                        break;
                    }
                }
            }
            if (this.debug > 0) {
                Stack e = this.processors;
                synchronized (e) {
                    this.logger.log("about to create a processor, available=" + this.processors.size() + ", created=" + this.created.size() + ", maxProcessors=" + this.maxProcessors);
                }
            }
            if ((processor = this.createProcessor()) == null) {
                try {
                    this.logger.log(this.sm.getString("ajp13Connector.noProcessor"));
                    ((Socket)socket).close();
                }
                catch (IOException iOException) {}
                continue;
            }
            processor.assign((Socket)socket);
        }
        socket = this.threadSync;
        synchronized (socket) {
            this.threadSync.notifyAll();
        }
    }

    public void setAcceptCount(int count) {
        this.acceptCount = count;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setContainer(Container container) {
        this.container = container;
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    public void setEnableLookups(boolean enableLookups) {
        this.enableLookups = enableLookups;
    }

    public void setFactory(ServerSocketFactory factory) {
        this.factory = factory;
    }

    public void setMaxProcessors(int maxProcessors) {
        this.maxProcessors = maxProcessors;
    }

    public void setMinProcessors(int minProcessors) {
        this.minProcessors = minProcessors;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setRedirectPort(int redirectPort) {
        this.redirectPort = redirectPort;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public void setSecret(String s) {
        this.secret = s;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public void setService(Service service) {
        this.service = service;
    }

    public void setTomcatAuthentication(boolean tomcatAuthentication) {
        this.tomcatAuthentication = tomcatAuthentication;
    }

    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(this.sm.getString("ajp13Connector.alreadyStarted"));
        }
        if (this.debug > 0) {
            this.debugThread = new DebugThread();
            this.debugThread.setDaemon(true);
            this.debugThread.start();
        }
        this.threadName = "Ajp13Connector[" + this.port + "]";
        this.threadGroup = new ThreadGroup(this.threadName);
        this.threadGroup.setDaemon(true);
        this.logger.setConnector(this);
        this.logger.setName(this.threadName);
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        try {
            this.serverSocket = this.open();
        }
        catch (IOException e) {
            throw new LifecycleException(String.valueOf(this.threadName) + ".open", (Throwable)e);
        }
        this.threadStart();
        while (this.curProcessors < this.minProcessors) {
            if (this.maxProcessors > 0 && this.curProcessors >= this.maxProcessors) break;
            Ajp13Processor processor = this.newProcessor();
            this.recycle(processor);
        }
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(this.sm.getString("ajp13Connector.notStarted"));
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        int i = this.created.size() - 1;
        while (i >= 0) {
            Ajp13Processor processor = (Ajp13Processor)this.created.elementAt(i);
            if (processor instanceof Lifecycle) {
                try {
                    processor.stop();
                }
                catch (LifecycleException e) {
                    this.logger.log("Ajp13Connector.stop", e);
                }
            }
            --i;
        }
        this.threadStop();
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException iOException) {}
            this.serverSocket = null;
        }
    }

    private void threadStart() {
        this.logger.log(this.sm.getString("ajp13Connector.starting"));
        this.thread = new Thread(this.threadGroup, this, this.threadName);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    private void threadStop() {
        this.logger.log(this.sm.getString("ajp13Connector.stopping"));
        this.stopped = true;
        Object object = this.threadSync;
        synchronized (object) {
            try {
                this.threadSync.wait(5000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.thread = null;
    }

    private class DebugThread
    extends Thread {
        DebugThread() {
        }

        public void run() {
            while (true) {
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
                Ajp13Connector.this.logger.log("active threads=" + Ajp13Connector.this.threadGroup.activeCount());
                System.out.println("===================================");
                System.out.println("Ajp13Connector active threads=" + Ajp13Connector.this.threadGroup.activeCount());
                Ajp13Connector.this.threadGroup.list();
                System.out.println("===================================");
            }
        }
    }
}

