/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.tree.children;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.netbeans.modules.xml.core.cookies.TreeEditorCookie;
import org.netbeans.modules.xml.tree.children.Util;
import org.netbeans.modules.xml.tree.nodes.AbstractDataNode;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.WeakListener;

public class DataObjectChildren
extends FilterNode.Children {
    private static final String ICON_DIR_BASE = "org/netbeans/modules/xml/tree/resources/";
    private static final String WAIT_ICON_BASE = "org/netbeans/modules/xml/tree/resources/waitNode";
    private static final Object WAIT_NODE_KEY = "org/netbeans/modules/xml/tree/resources/waitNode";
    private static final String ERROR_ICON_BASE = "org/netbeans/modules/xml/tree/resources/errorNode";
    private static final Object ERROR_NODE_KEY = "org/netbeans/modules/xml/tree/resources/errorNode";
    private AbstractNode[] waitNode = null;
    private AbstractNode[] errorNode = null;
    private final RootNodeListener rnListener;
    private PropertyChangeListener weakRNListener;
    private final TreeEditorListener teListener;
    private PropertyChangeListener weakTEListener;
    private final TreeEditorCookie editor;

    public DataObjectChildren(TreeEditorCookie editor) {
        super(null);
        this.editor = editor;
        this.teListener = new TreeEditorListener();
        this.rnListener = new RootNodeListener();
    }

    protected void finalize() {
        if (this.canDelegate()) {
            super.finalize();
        }
    }

    public Object clone() {
        return new DataObjectChildren(this.editor);
    }

    protected void addNotify() {
        this.updateOriginal();
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("\n+++ DataObjectChildren::addNotify: canDelegate = " + this.canDelegate());
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("+++                   ::addNotify: status " + this.editor.getStatus());
        }
        if (this.canDelegate()) {
            super.addNotify();
        } else {
            this.setKeys();
        }
        this.weakTEListener = WeakListener.propertyChange((PropertyChangeListener)this.teListener, (Object)this.editor);
        this.editor.addPropertyChangeListener(this.weakTEListener);
        Node rootNode = this.getNode();
        this.weakRNListener = WeakListener.propertyChange((PropertyChangeListener)this.rnListener, (Object)rootNode);
        rootNode.addPropertyChangeListener((PropertyChangeListener)this.rnListener);
        this.editor.prepareDocumentRoot();
    }

    protected void removeNotify() {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("\n+++ DataObjectChildren::removeNotify");
        }
        if (this.canDelegate()) {
            super.removeNotify();
            this.original = null;
        } else {
            this.setKeys(Collections.EMPTY_SET);
        }
        if (this.weakTEListener != null) {
            this.editor.removePropertyChangeListener(this.weakTEListener);
        }
        if (this.weakRNListener != null) {
            this.getNode().removePropertyChangeListener((PropertyChangeListener)this.rnListener);
        }
        this.errorNode = null;
        this.waitNode = null;
    }

    public Node findChild(String name) {
        if (this.canDelegate()) {
            return super.findChild(name);
        }
        if (this.errorNode != null && this.errorNode[0].getName().equals(name)) {
            return this.errorNode[0];
        }
        if (this.waitNode != null && this.waitNode[0].getName().equals(name)) {
            return this.waitNode[0];
        }
        return null;
    }

    protected Node[] createNodes(Object key) {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("\n+++ DataObjectChildren::createNodes: key = " + key);
        }
        Node[] nodes = null;
        if (this.canDelegate()) {
            nodes = super.createNodes(key);
        } else if (key == WAIT_NODE_KEY) {
            nodes = this.createWaitNode();
        } else if (key == ERROR_NODE_KEY) {
            nodes = this.createErrorNode();
        } else {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("+++                   ::createNodes: key = " + key);
            }
            nodes = new Node[]{};
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("+++                   ::createNodes: nodes = " + nodes);
        }
        return nodes;
    }

    public boolean add(Node[] arr) {
        if (this.canDelegate()) {
            return super.add(arr);
        }
        return false;
    }

    public boolean remove(Node[] arr) {
        if (this.canDelegate()) {
            return super.remove(arr);
        }
        return false;
    }

    protected void filterChildrenAdded(NodeMemberEvent ev) {
        if (this.canDelegate()) {
            super.filterChildrenAdded(ev);
        }
    }

    protected void filterChildrenRemoved(NodeMemberEvent ev) {
        if (this.canDelegate()) {
            super.filterChildrenRemoved(ev);
        }
    }

    protected void filterChildrenReordered(NodeReorderEvent ev) {
        if (this.canDelegate()) {
            super.filterChildrenReordered(ev);
        }
    }

    protected final void refreshKeys() {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("\n+++ DataObjectChildren::refreshKeys: isInitialized = " + this.isInitialized());
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("+++                   ::refreshKeys: status " + this.editor.getStatus());
        }
        this.updateOriginal();
        if (this.canDelegate()) {
            super.removeNotify();
            super.addNotify();
        } else {
            this.setKeys();
        }
    }

    private void setKeys() {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("\n+++ DataObjectChildren::setKeys");
        }
        this.setKeys(this.createKeys());
    }

    protected synchronized Collection createKeys() {
        LinkedList<Object> keys = new LinkedList<Object>();
        int status = this.editor.getStatus();
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("DataObjectChildren::createKeys: status " + status);
        }
        switch (status) {
            case 0: {
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("\tsetting null object list...");
                }
                keys.add(WAIT_NODE_KEY);
                break;
            }
            case 3: {
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("\tsetting null object list...");
                }
                keys.add(ERROR_NODE_KEY);
                break;
            }
            default: {
                if (!Util.THIS.isLoggable()) break;
                Util.THIS.debug("\nDataObjectChildren::createKeys: status = " + status);
            }
        }
        return keys;
    }

    private final Node[] createWaitNode() {
        if (this.waitNode == null) {
            this.waitNode = new AbstractNode[]{new AbstractNode(Children.LEAF)};
            this.waitNode[0].setName(Util.THIS.getString("PROP_Wait"));
            this.waitNode[0].setIconBase(WAIT_ICON_BASE);
        }
        return this.waitNode;
    }

    private final Node[] createErrorNode() {
        if (this.errorNode == null) {
            this.errorNode = new AbstractNode[]{new AbstractNode(Children.LEAF)};
            this.errorNode[0].setName(Util.THIS.getString("PROP_Error"));
            this.errorNode[0].setIconBase(ERROR_ICON_BASE);
        }
        return this.errorNode;
    }

    private Node getRootNode() {
        return ((AbstractDataNode)this.getNode()).getRootNode();
    }

    private boolean canDelegate() {
        return this.original != null;
    }

    private boolean updateOriginal() {
        Node oldOriginal = this.original;
        this.original = this.getRootNode();
        return oldOriginal != this.original;
    }

    private class RootNodeListener
    implements PropertyChangeListener {
        private RootNodeListener() {
        }

        public void propertyChange(PropertyChangeEvent pche) {
            String property = pche.getPropertyName();
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("DataObjectChildren::RootNodeListener propertyName = '" + property + "'");
            }
            if ("rootNode".equals(property)) {
                DataObjectChildren.this.refreshKeys();
            }
        }
    }

    private class TreeEditorListener
    implements PropertyChangeListener {
        private TreeEditorListener() {
        }

        public void propertyChange(PropertyChangeEvent pche) {
            String property = pche.getPropertyName();
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("DataObjectChildren::TreeEditorListener propertyName = '" + property + "'");
            }
            if ("status".equals(property)) {
                DataObjectChildren.this.refreshKeys();
            }
        }
    }
}

