/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.tree.children;

import java.beans.IntrospectionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import org.netbeans.modules.xml.tree.children.InstanceKey;
import org.netbeans.modules.xml.tree.children.Util;
import org.netbeans.modules.xml.tree.nodes.AbstractLayerNode;
import org.netbeans.modules.xml.tree.nodes.AbstractObjectNode;
import org.netbeans.modules.xml.tree.nodes.AbstractParentNode;
import org.netbeans.modules.xml.tree.nodes.AttlistDeclLayerNode;
import org.netbeans.modules.xml.tree.nodes.ElementAttributesNode;
import org.netbeans.modules.xml.tree.nodes.ElementDeclLayerNode;
import org.netbeans.modules.xml.tree.nodes.EntityDeclLayerNode;
import org.netbeans.modules.xml.tree.nodes.ExternalDTDNode;
import org.netbeans.modules.xml.tree.nodes.NodeFactory;
import org.netbeans.modules.xml.tree.nodes.NotationDeclLayerNode;
import org.netbeans.modules.xml.tree.settings.NodeViewType;
import org.netbeans.tax.TreeAttribute;
import org.netbeans.tax.TreeChild;
import org.netbeans.tax.TreeDocumentType;
import org.netbeans.tax.TreeElement;
import org.netbeans.tax.TreeNamedObjectMap;
import org.netbeans.tax.TreeNode;
import org.netbeans.tax.TreeObject;
import org.netbeans.tax.TreeObjectList;
import org.netbeans.tax.TreeParentNode;
import org.netbeans.tax.TreeText;
import org.netbeans.tax.traversal.TreeNodeFilter;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.WeakListener;

public class ObjectListChildren
extends Children.Keys {
    private final TreeObjectList objectList;
    private final Class[] groupTypes;
    private final boolean layer;
    private NodeViewType nodeViewType;
    private final ObjectListListener olListener;
    private final NodeViewTypeListener nvtListener;
    private PropertyChangeListener weakNVTListener;
    static /* synthetic */ Class class$org$netbeans$tax$TreeElementDecl;
    static /* synthetic */ Class class$org$netbeans$tax$TreeAttlistDecl;
    static /* synthetic */ Class class$org$netbeans$tax$TreeEntityDecl;
    static /* synthetic */ Class class$org$netbeans$tax$TreeNotationDecl;

    public ObjectListChildren(TreeObjectList objectList, Class[] groupTypes, boolean layer) {
        this.objectList = objectList;
        this.nodeViewType = null;
        this.groupTypes = groupTypes;
        this.layer = layer;
        this.olListener = new ObjectListListener();
        this.nvtListener = new NodeViewTypeListener();
    }

    public ObjectListChildren(TreeObjectList objectList, Class[] groupTypes) {
        this(objectList, groupTypes, false);
    }

    public ObjectListChildren(TreeObjectList objectList) {
        this(objectList, null);
    }

    protected void addNotify() {
        if (this.objectList != null) {
            this.objectList.addPropertyChangeListener((PropertyChangeListener)this.olListener);
        }
        this.setKeys();
    }

    protected void removeNotify() {
        this.setKeys(Collections.EMPTY_SET);
        if (this.objectList != null) {
            this.objectList.removePropertyChangeListener((PropertyChangeListener)this.olListener);
        }
        super.removeNotify();
    }

    protected final Node[] createNodes(Object key) {
        Node node = this.createNode(key);
        if (node == null) {
            return new Node[0];
        }
        return new Node[]{node};
    }

    private void setNodeViewTypeImpl(NodeViewType newNodeViewType) {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("@@@ ObjectListChildren::setNodeViewTypeImpl: this = " + (Object)((Object)this));
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("@@@                   ::setNodeViewTypeImpl: parent = " + this.getNode());
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("@@@                   ::setNodeViewTypeImpl: newNodeViewType = " + (Object)((Object)newNodeViewType));
        }
        if (newNodeViewType == null && Util.THIS.isLoggable()) {
            Util.THIS.debug("@@@                   ::setNodeViewTypeImpl: newNodeViewType == NULL", new RuntimeException());
        }
        if (this.nodeViewType != null && this.weakNVTListener != null) {
            this.nodeViewType.removePropertyChangeListener(this.weakNVTListener);
        }
        this.nodeViewType = newNodeViewType;
        this.weakNVTListener = WeakListener.propertyChange((PropertyChangeListener)this.nvtListener, (Object)((Object)this.nodeViewType));
        this.nodeViewType.addPropertyChangeListener(this.weakNVTListener);
    }

    public final void setNodeViewType(NodeViewType nodeViewType) {
        if (Util.equals((Object)this.nodeViewType, (Object)nodeViewType)) {
            return;
        }
        this.setNodeViewTypeImpl(nodeViewType);
        this.refreshKeys();
    }

    public final NodeViewType getNodeViewType() {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("$$$ ObjectListChildren::getNodeViewType: this = " + (Object)((Object)this));
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("$$$                   ::getNodeViewTypeImpl: parent = " + this.getNode());
        }
        if (this.nodeViewType == null) {
            Node parent = this.getNode();
            if (parent instanceof NodeViewType.Provider) {
                this.setNodeViewTypeImpl(((NodeViewType.Provider)parent).getNodeViewType());
            } else if (Util.THIS.isLoggable()) {
                Util.THIS.debug("$$$                   ::getNodeViewType: !!! parent is NOT instance of NodeViewType.Provider : " + parent);
            }
        }
        if (this.nodeViewType == null) {
            return new NodeViewType(NodeViewType.LINEAR_DATA);
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("$$$                   ::getNodeViewType: nodeViewType = " + (Object)((Object)this.nodeViewType));
        }
        return this.nodeViewType;
    }

    public TreeObjectList getObjectList() {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("ObjectListChildren::getObjectList: " + this.objectList);
        }
        return this.objectList;
    }

    protected final void refreshKeys() {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("ObjectListChildren::refreshKeys: isInitialized = " + this.isInitialized());
        }
        this.setKeys();
    }

    private void setKeys() {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("ObjectListChildren::setKeys");
        }
        this.setKeys(this.createKeys());
    }

    protected synchronized Collection createKeys() {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("\n\nObjectListChildren::createKeys: groupTypes = " + this.groupTypes);
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("                  ::createKeys: isGroupTypes = " + this.getNodeViewType().isGroupTypes());
        }
        LinkedList keys = new LinkedList();
        if (this.groupTypes != null && !this.layer && this.getNodeViewType().isGroupTypes()) {
            keys.addAll(this.createTypeKeys());
        } else {
            keys.addAll(this.createFilterKeys());
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("                  ::createKeys: keys = " + keys);
        }
        return keys;
    }

    private Collection createFilterKeys() {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("\nObjectListChildren::createFilterKeys");
        }
        LinkedList<InstanceKey> keys = new LinkedList<InstanceKey>();
        if (this.getObjectList() == null) {
            return keys;
        }
        Iterator it = !this.layer ? this.getObjectList().iterator() : this.getChildNodes(this.groupTypes[0]).iterator();
        TreeNodeFilter filter = this.getNodeViewType().getFilter();
        boolean showWS = this.getNodeViewType().isShowIgnorableWhitespaces();
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("                  ::createFilterKeys: showWS = " + showWS);
        }
        while (it.hasNext()) {
            TreeObject treeObj = (TreeObject)it.next();
            if (treeObj instanceof TreeNode && filter.acceptNode((TreeNode)treeObj) != 0 || !showWS && treeObj instanceof TreeText && ((TreeText)treeObj).onlyWhiteSpaces() || treeObj instanceof TreeAttribute && !((TreeAttribute)treeObj).isSpecified()) continue;
            keys.add(new InstanceKey(treeObj));
        }
        return keys;
    }

    private boolean hasChildNodes(Class type) {
        Iterator it = this.getObjectList().iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (!(obj instanceof TreeChild)) continue;
            TreeChild child = (TreeChild)obj;
            if (child.getClass().isAssignableFrom(type)) {
                return true;
            }
            if (!(child instanceof TreeParentNode) || !((TreeParentNode)child).hasChildNodes(type, true)) continue;
            return true;
        }
        return false;
    }

    private Collection getChildNodes(Class type) {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("\nObjectListChildren::getChildNodes: objectList = " + this.getObjectList());
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("                  ::getChildNodes:       type = " + type);
        }
        LinkedList<TreeChild> allChildNodes = new LinkedList<TreeChild>();
        Iterator it = this.getObjectList().iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("                  ::getChildNodes:       next_obj = " + obj);
            }
            if (!(obj instanceof TreeChild)) continue;
            TreeChild child = (TreeChild)obj;
            if (child.getClass().isAssignableFrom(type)) {
                allChildNodes.add(child);
                continue;
            }
            if (!(child instanceof TreeParentNode)) continue;
            Collection col = ((TreeParentNode)child).getChildNodes(type, true);
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("                  ::getChildNodes:       child is parent : " + col);
            }
            allChildNodes.addAll(col);
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("ObjectListChildren::getChildNodes: allChildNodes = " + allChildNodes);
        }
        return allChildNodes;
    }

    private Collection createTypeKeys() {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("\nObjectListChildren::createTypeKeys");
        }
        LinkedList<Class> keys = new LinkedList<Class>();
        int i = 0;
        while (i < this.groupTypes.length) {
            if (this.hasChildNodes(this.groupTypes[i])) {
                keys.add(this.groupTypes[i]);
            }
            ++i;
        }
        return keys;
    }

    protected Node createNode(Object key) {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("\n\nObjectListChildren::createNode: key = " + key);
        }
        Node node = null;
        if (key instanceof InstanceKey) {
            node = this.createFilterNode(((InstanceKey)key).getInstance());
        } else if (key instanceof Class) {
            node = this.createTypeNode((Class)key);
        }
        return node;
    }

    private Node createFilterNode(TreeObject treeObject) {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("\nObjectListChildren::createFilterNode: treeObject = " + treeObject);
        }
        AbstractObjectNode node = null;
        try {
            node = treeObject instanceof TreeObjectList ? this.createObjectListNode((TreeObjectList)treeObject) : NodeFactory.createObjectNode(treeObject);
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
        return node;
    }

    private Node createObjectListNode(TreeObjectList treeObjectList) throws IntrospectionException {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("ObjectListChildren::createObjectListNode: treeObjectList = " + treeObjectList);
        }
        AbstractParentNode node = null;
        TreeNode ownerNode = treeObjectList.getContentManager().getOwnerNode();
        if (ownerNode instanceof TreeElement && treeObjectList instanceof TreeNamedObjectMap) {
            node = new ElementAttributesNode((TreeNamedObjectMap)treeObjectList);
        } else if (ownerNode instanceof TreeDocumentType) {
            node = new ExternalDTDNode(treeObjectList);
        } else if (Util.THIS.isLoggable()) {
            Util.THIS.debug("\tMISSION IMPOSSIBLE -- createObjectListNode : what is it? : " + treeObjectList, new RuntimeException());
        }
        return node;
    }

    private Node createTypeNode(Class type) {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("\nObjectListChildren::createTypeNode: type = " + type);
        }
        TreeObjectList objectList = this.getObjectList();
        AbstractLayerNode node = null;
        try {
            if (type.isAssignableFrom(class$org$netbeans$tax$TreeElementDecl == null ? (class$org$netbeans$tax$TreeElementDecl = ObjectListChildren.class$("org.netbeans.tax.TreeElementDecl")) : class$org$netbeans$tax$TreeElementDecl)) {
                node = new ElementDeclLayerNode(objectList);
            } else if (type.isAssignableFrom(class$org$netbeans$tax$TreeAttlistDecl == null ? (class$org$netbeans$tax$TreeAttlistDecl = ObjectListChildren.class$("org.netbeans.tax.TreeAttlistDecl")) : class$org$netbeans$tax$TreeAttlistDecl)) {
                node = new AttlistDeclLayerNode(objectList);
            } else if (type.isAssignableFrom(class$org$netbeans$tax$TreeEntityDecl == null ? (class$org$netbeans$tax$TreeEntityDecl = ObjectListChildren.class$("org.netbeans.tax.TreeEntityDecl")) : class$org$netbeans$tax$TreeEntityDecl)) {
                node = new EntityDeclLayerNode(objectList);
            } else if (type.isAssignableFrom(class$org$netbeans$tax$TreeNotationDecl == null ? (class$org$netbeans$tax$TreeNotationDecl = ObjectListChildren.class$("org.netbeans.tax.TreeNotationDecl")) : class$org$netbeans$tax$TreeNotationDecl)) {
                node = new NotationDeclLayerNode(objectList);
            } else if (Util.THIS.isLoggable()) {
                Util.THIS.debug("\tMISSION IMPOSSIBLE: what is it? : " + type, new RuntimeException());
            }
        }
        catch (IntrospectionException ex) {
            // empty catch block
        }
        return node;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ObjectListListener
    implements PropertyChangeListener {
        private ObjectListListener() {
        }

        public void propertyChange(PropertyChangeEvent pche) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("\nObjectListChildren [ " + this + " ] ::ObjectListListener::propertyChange: propertyName = '" + pche.getPropertyName() + "'");
            }
            if ("contentInsert".equals(pche.getPropertyName()) || "contentRemove".equals(pche.getPropertyName()) || "contentOrder".equals(pche.getPropertyName())) {
                ObjectListChildren.this.refreshKeys();
            }
        }
    }

    private class NodeViewTypeListener
    implements PropertyChangeListener {
        private NodeViewTypeListener() {
        }

        public void propertyChange(PropertyChangeEvent pche) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("\nObjectListChildren [ " + this + " ] ::NodeViewTypeListener::propertyChange: propertyName = '" + pche.getPropertyName() + "'");
            }
            if ("groupTypes".equals(pche.getPropertyName()) || "showIgnorableWhitespaces".equals(pche.getPropertyName()) || "filter".equals(pche.getPropertyName())) {
                ObjectListChildren.this.refreshKeys();
            }
        }
    }
}

