/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.tree.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.netbeans.modules.xml.tree.editor.Util;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;

public class CustomizerView
extends JPanel
implements Externalizable {
    private static final long serialVersionUID = -2922109093973271414L;
    private transient Node[] selectedNodes;
    private transient ExplorerManager explorerManager;
    private transient PropertyIL iListener;
    private transient Component currentComponent;
    private transient JLabel textLabel;

    public CustomizerView() {
        this.setLayout(new BorderLayout());
        this.textLabel = new JLabel(Util.THIS.getString("PROP_viewNoNode"), 0);
        this.currentComponent = this.textLabel;
        this.selectedNodes = new Node[0];
        this.iListener = new PropertyIL();
        this.updateSelection();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    public void addNotify() {
        super.addNotify();
        this.explorerManager = ExplorerManager.find((Component)this);
        this.explorerManager.addPropertyChangeListener((PropertyChangeListener)this.iListener);
        this.selectedNodes = this.explorerManager.getSelectedNodes();
        this.updateSelection();
    }

    public void removeNotify() {
        super.removeNotify();
        this.explorerManager = ExplorerManager.find((Component)this);
        this.explorerManager.removePropertyChangeListener((PropertyChangeListener)this.iListener);
        this.explorerManager = null;
    }

    private void updateSelection() {
        this.remove(this.currentComponent);
        if (this.selectedNodes.length == 0) {
            this.textLabel.setText(Util.THIS.getString("PROP_viewNoNode"));
            this.textLabel.setName(Util.THIS.getString("PROP_viewInfo"));
            this.currentComponent = this.textLabel;
        } else if (this.selectedNodes.length > 1) {
            this.textLabel.setText(Util.THIS.getString("PROP_viewMultiple"));
            this.textLabel.setName(Util.THIS.getString("PROP_viewInfo"));
            this.currentComponent = this.textLabel;
        } else {
            Component customizer = this.selectedNodes[0].getCustomizer();
            if (customizer == null) {
                this.textLabel.setText(Util.THIS.getString("PROP_viewNoCustomizer"));
                this.textLabel.setName(Util.THIS.getString("PROP_viewInfo"));
                this.currentComponent = this.textLabel;
            } else {
                JPanel customizerPanel = new JPanel();
                customizerPanel.setLayout(new GridBagLayout());
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = 0;
                gbc.gridwidth = 0;
                gbc.gridheight = 0;
                gbc.fill = 1;
                gbc.insets = new Insets(0, 0, 11, 0);
                gbc.weightx = 1.0;
                gbc.weighty = 1.0;
                gbc.anchor = 18;
                customizerPanel.add(customizer, gbc);
                this.currentComponent = new JScrollPane(customizerPanel);
            }
        }
        this.add(this.currentComponent, "Center");
        this.validate();
        this.repaint();
    }

    static /* synthetic */ Node[] access$002(CustomizerView x0, Node[] x1) {
        x0.selectedNodes = x1;
        return x1;
    }

    class PropertyIL
    implements PropertyChangeListener {
        PropertyIL() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("selectedNodes".equals(evt.getPropertyName())) {
                if (CustomizerView.this.selectedNodes.equals(evt.getNewValue())) {
                    return;
                }
                CustomizerView.access$002(CustomizerView.this, (Node[])evt.getNewValue());
                CustomizerView.this.updateSelection();
            }
        }
    }
}

