/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.tree.lib;

import java.awt.Image;
import javax.swing.SwingUtilities;
import org.netbeans.tax.TreeException;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.util.Utilities;

public final class GuiUtil {
    public static Image getCutBadgeIcon() {
        return Utilities.loadImage((String)"org/netbeans/modules/xml/tree/resources/cutbadge.gif");
    }

    public static boolean confirmAction(String message) {
        NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)message, 0);
        Object option = TopManager.getDefault().notify((NotifyDescriptor)nd);
        return option == NotifyDescriptor.YES_OPTION;
    }

    public static void setStatusText(String text) {
        TopManager.getDefault().setStatusText(text);
    }

    public static void notifyException(Throwable exc) {
        GuiUtil.notifyException(null, exc);
    }

    public static void notifyException(String desc, Throwable ex) {
        ErrorManager err = ErrorManager.getDefault();
        if (desc != null) {
            err.annotate(ex, desc);
        }
        err.notify(4096, ex);
    }

    public static void notifyTreeException(TreeException exc) {
        GuiUtil.notifyWarning(exc.getMessage());
    }

    public static void notifyWarning(final String message) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)message, 2);
                TopManager.getDefault().notify((NotifyDescriptor)nd);
            }
        });
    }
}

