/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.tree.lib;

import java.beans.IntrospectionException;
import java.beans.beancontext.BeanContext;
import java.beans.beancontext.BeanContextMembershipEvent;
import java.beans.beancontext.BeanContextMembershipListener;
import java.beans.beancontext.BeanContextSupport;
import java.lang.ref.WeakReference;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import org.netbeans.modules.xml.tree.lib.OrderedBeanNode;
import org.openide.nodes.BeanChildren;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

public class OrderedBeanChildren
extends Children.Map {
    private static final BeanChildren.Factory DEFAULT_FACTORY = new OrderedBeanFactory();
    private BeanContext bean;
    private BeanChildren.Factory factory;
    private ContextL contextL;

    public OrderedBeanChildren(BeanContext bean) {
        this(bean, DEFAULT_FACTORY);
    }

    public OrderedBeanChildren(BeanContext bean, BeanChildren.Factory factory) {
        this.bean = bean;
        this.factory = factory;
    }

    private Map createMap(Object[] array) {
        TreeMap<Object, Node> map = new TreeMap<Object, Node>(new OrderComparator());
        int i = 0;
        while (i < array.length) {
            try {
                BeanContextSupport bcs;
                if (!(array[i] instanceof BeanContextSupport) || !this.bean.contains((bcs = (BeanContextSupport)array[i]).getBeanContextPeer())) {
                    map.put(array[i], this.factory.createNode(array[i]));
                }
            }
            catch (IntrospectionException ex) {
                // empty catch block
            }
            ++i;
        }
        return map;
    }

    protected Map initMap() {
        this.contextL = new ContextL(this);
        this.bean.addBeanContextMembershipListener(this.contextL);
        return this.createMap(this.bean.toArray());
    }

    protected void finalize() {
        if (this.contextL != null) {
            this.bean.removeBeanContextMembershipListener(this.contextL);
        }
    }

    private static final class ContextL
    implements BeanContextMembershipListener {
        private WeakReference ref;

        ContextL(OrderedBeanChildren bc) {
            this.ref = new WeakReference<OrderedBeanChildren>(bc);
        }

        public void childrenAdded(BeanContextMembershipEvent bcme) {
            OrderedBeanChildren bc = (OrderedBeanChildren)((Object)this.ref.get());
            if (bc != null) {
                // empty if block
            }
        }

        public void childrenRemoved(BeanContextMembershipEvent bcme) {
            OrderedBeanChildren bc = (OrderedBeanChildren)((Object)this.ref.get());
            if (bc != null) {
                // empty if block
            }
        }
    }

    private static class OrderedBeanFactory
    implements BeanChildren.Factory {
        private OrderedBeanFactory() {
        }

        public Node createNode(Object bean) throws IntrospectionException {
            return new OrderedBeanNode(bean);
        }
    }

    private class OrderComparator
    implements Comparator {
        private OrderComparator() {
        }

        public boolean equals(Object comp) {
            return comp == null ? false : comp instanceof OrderComparator;
        }

        public int compare(Object p1, Object p2) {
            try {
                return ((Comparable)p1).compareTo(p2);
            }
            catch (ClassCastException ex) {
                return -1;
            }
        }
    }
}

