/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.tree.lib;

import org.netbeans.modules.xml.tree.settings.TreeEditSettings;

public final class StringUtil {
    public static String printableValue(String value) {
        if (value == null) {
            return new String("");
        }
        int prefLen = TreeEditSettings.getDefault().getPrintableValueLength();
        int len = prefLen == 0 ? value.length() : Math.min(value.length(), prefLen);
        StringBuffer sb = new StringBuffer(2 * len);
        int i = 0;
        while (i < len) {
            char ch = value.charAt(i);
            if ('\r' == ch) {
                sb.append("\\r");
            } else if ('\n' == ch) {
                sb.append("\\n");
            } else if ('\t' == ch) {
                sb.append("\\t");
            } else if ('\b' == ch) {
                sb.append("\\b");
            } else if ('\f' == ch) {
                sb.append("\\f");
            } else {
                sb.append(ch);
            }
            ++i;
        }
        if (value.length() > len) {
            sb.append("...");
        }
        return sb.toString();
    }

    public static boolean isWS(char ch) {
        return ch == ' ' || ch == '\t' || ch == '\n' || ch == '\r';
    }

    public static int skipDelimited(String text, int pos, char del1, char del2, String nest) {
        char ch = text.charAt(pos);
        if (ch != del1) {
            return -1;
        }
        do {
            if (nest.indexOf(ch = text.charAt(++pos)) < 0) continue;
            pos = StringUtil.skipDelimited(text, pos, ch, ch, "");
            ch = text.charAt(pos);
        } while (ch != del2);
        return pos + 1;
    }

    public static int skipDelimited(String text, int pos, String del1, String del2) {
        if (text.startsWith(del1, pos)) {
            int match = text.indexOf(del2, pos + del1.length());
            if (match == -1) {
                return -1;
            }
            return match + del2.length();
        }
        return -1;
    }

    public static int skipWS(String text, int pos) {
        if (StringUtil.isWS(text.charAt(pos))) {
            return pos + 1;
        }
        return -1;
    }

    public static void main(String[] args) {
        String idtd = "   <!-- klfh -->  <!hjk \"fdsf\"  ''>]>";
        int pos = 0;
        int now = 0;
        int last = -1;
        System.err.println("SkipWs" + StringUtil.skipWS(" k", pos));
        System.err.println("SkipDelinitedchar" + StringUtil.skipDelimited("<  ' > '>", 0, '<', '>', "\"'"));
        System.err.println("SkipDelinitedchar" + StringUtil.skipDelimited("<!--  ' > '-->", 0, "<!--", "-->"));
        while (!idtd.substring(pos).startsWith("]>") && last != pos) {
            last = pos;
            now = 0;
            while (now != -1) {
                pos = now;
                now = StringUtil.skipWS(idtd, pos);
            }
            now = 0;
            while (now != -1) {
                pos = now;
                now = 0;
                while (now != -1) {
                    pos = now;
                    now = StringUtil.skipWS(idtd, pos);
                }
                now = StringUtil.skipDelimited(idtd, pos, "<!--", "-->");
            }
            now = 0;
            while (now != -1) {
                pos = now;
                now = StringUtil.skipDelimited(idtd, pos, '<', '>', "\"'");
            }
        }
    }
}

