/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.tree.nodes;

import java.awt.Component;
import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.beans.FeatureDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.List;
import org.netbeans.modules.xml.core.XMLDataObjectLook;
import org.netbeans.modules.xml.core.cookies.TreeDocumentCookie;
import org.netbeans.modules.xml.core.cookies.TreeEditorCookie;
import org.netbeans.modules.xml.tree.children.DataObjectChildren;
import org.netbeans.modules.xml.tree.nodes.AbstractRootNode;
import org.netbeans.modules.xml.tree.nodes.DataNodeCookie;
import org.netbeans.modules.xml.tree.nodes.TreeObjectNode;
import org.netbeans.modules.xml.tree.nodes.Util;
import org.netbeans.modules.xml.tree.settings.NodeViewType;
import org.netbeans.modules.xml.tree.settings.TreeEditSettings;
import org.netbeans.tax.TreeDocumentRoot;
import org.netbeans.tax.TreeException;
import org.netbeans.tax.TreeObject;
import org.openide.ServiceType;
import org.openide.TopManager;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.Utilities;
import org.openide.util.datatransfer.NewType;

public abstract class AbstractDataNode
extends DataNode
implements TreeObjectNode,
DataNodeCookie,
NodeViewType.Provider {
    public static final String PROP_ROOT_NODE = "rootNode";
    private static final String XML_STATUS = "status";
    private TreeDocumentCookie documentCookie;
    private int status;
    private Reference rootRef;
    public static final String NODE_VIEW_TYPE_ATTRIBUTE = "org.netbeans.modules.xml.tree.settings.NodeViewType";
    private NodeViewType nodeViewType;
    private InnerListener listener;
    static /* synthetic */ Class class$org$netbeans$modules$xml$core$cookies$TreeEditorCookie;
    static /* synthetic */ Class class$org$netbeans$modules$xml$core$cookies$TreeDocumentCookie;
    static /* synthetic */ Class class$java$lang$String;

    protected AbstractDataNode(XMLDataObjectLook dataObject) {
        super((DataObject)dataObject, (Children)new DataObjectChildren((TreeEditorCookie)dataObject.getCookie(class$org$netbeans$modules$xml$core$cookies$TreeEditorCookie == null ? (class$org$netbeans$modules$xml$core$cookies$TreeEditorCookie = AbstractDataNode.class$("org.netbeans.modules.xml.core.cookies.TreeEditorCookie")) : class$org$netbeans$modules$xml$core$cookies$TreeEditorCookie)));
        this.init(dataObject);
    }

    private void init(XMLDataObjectLook dataObject) {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("AbstractDataNode::init: status " + ((TreeEditorCookie)dataObject.getCookie(class$org$netbeans$modules$xml$core$cookies$TreeEditorCookie == null ? (class$org$netbeans$modules$xml$core$cookies$TreeEditorCookie = AbstractDataNode.class$("org.netbeans.modules.xml.core.cookies.TreeEditorCookie")) : class$org$netbeans$modules$xml$core$cookies$TreeEditorCookie)).getStatus());
        }
        this.documentCookie = null;
        this.status = -1;
        this.rootRef = null;
        this.listener = new InnerListener();
        TreeEditorCookie cake = (TreeEditorCookie)dataObject.getCookie(class$org$netbeans$modules$xml$core$cookies$TreeEditorCookie == null ? (class$org$netbeans$modules$xml$core$cookies$TreeEditorCookie = AbstractDataNode.class$("org.netbeans.modules.xml.core.cookies.TreeEditorCookie")) : class$org$netbeans$modules$xml$core$cookies$TreeEditorCookie);
        cake.addPropertyChangeListener((PropertyChangeListener)this.listener);
        this.updateIconBase();
        this.getCookieSet().add((Node.Cookie)this);
        this.updateShortDescription();
        this.initNodeViewType();
    }

    public final TreeObject getTreeObject() {
        try {
            return (TreeObject)this.getDocumentRoot();
        }
        catch (Exception e) {
            return null;
        }
    }

    public final XMLDataObjectLook getXMLDataObjectLook() {
        return (XMLDataObjectLook)this.getDataObject();
    }

    protected final TreeDocumentRoot getDocumentRoot() throws IOException, TreeException {
        AbstractRootNode rootNode = this.getRootNode();
        if (rootNode != null) {
            return (TreeDocumentRoot)rootNode.getTreeObject();
        }
        return null;
    }

    protected final DataObjectChildren getDataObjectChildren() {
        return (DataObjectChildren)this.getChildren();
    }

    private void updateShortDescription() {
        this.setShortDescription(this.createShortDescription());
    }

    private String createShortDescription() {
        StringBuffer sb = new StringBuffer();
        AbstractRootNode rootNode = this.getRootNode();
        if (rootNode != null) {
            sb.append(((FeatureDescriptor)((Object)rootNode)).getShortDescription());
        } else {
            sb.append(this.getNodeDescription());
            int status = ((TreeEditorCookie)this.getXMLDataObjectLook().getCookie(class$org$netbeans$modules$xml$core$cookies$TreeEditorCookie == null ? (class$org$netbeans$modules$xml$core$cookies$TreeEditorCookie = AbstractDataNode.class$("org.netbeans.modules.xml.core.cookies.TreeEditorCookie")) : class$org$netbeans$modules$xml$core$cookies$TreeEditorCookie)).getStatus();
            if (status == 0) {
                sb.append(' ').append(Util.THIS.getString("TEXT_PART_not_parsed_yet"));
            } else if (status == 3) {
                sb.append(' ').append(Util.THIS.getString("TEXT_PART_error"));
            }
        }
        return sb.toString();
    }

    protected abstract String getNodeDescription();

    public final Image getIcon(int type) {
        Image icon = super.getIcon(type);
        int status = ((TreeEditorCookie)this.getXMLDataObjectLook().getCookie(class$org$netbeans$modules$xml$core$cookies$TreeEditorCookie == null ? (class$org$netbeans$modules$xml$core$cookies$TreeEditorCookie = AbstractDataNode.class$("org.netbeans.modules.xml.core.cookies.TreeEditorCookie")) : class$org$netbeans$modules$xml$core$cookies$TreeEditorCookie)).getStatus();
        if (status == 3) {
            Image errorBadge = Utilities.loadImage((String)"org/netbeans/modules/xml/tree/resources/errorbadge.gif");
            icon = Utilities.mergeImages((Image)icon, (Image)errorBadge, (int)8, (int)8);
        }
        return icon;
    }

    public final Image getOpenedIcon(int type) {
        return this.getIcon(type);
    }

    protected final void updateIconBase() {
        this.fireIconChange();
        this.fireOpenedIconChange();
    }

    public final DataNode getDataNode() {
        String thisClassName = this.getClass().getName();
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("AbstractDataNode [ " + thisClassName + " ] ::getDataNode: this = " + this);
        }
        return this;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(this.getClass());
    }

    protected abstract AbstractRootNode createRootNode(TreeDocumentRoot var1);

    protected final void updateNode() {
        TreeDocumentCookie newDocumentCookie = (TreeDocumentCookie)this.getDataObject().getCookie(class$org$netbeans$modules$xml$core$cookies$TreeDocumentCookie == null ? (class$org$netbeans$modules$xml$core$cookies$TreeDocumentCookie = AbstractDataNode.class$("org.netbeans.modules.xml.core.cookies.TreeDocumentCookie")) : class$org$netbeans$modules$xml$core$cookies$TreeDocumentCookie);
        int newStatus = ((TreeEditorCookie)this.getDataObject().getCookie(class$org$netbeans$modules$xml$core$cookies$TreeEditorCookie == null ? (class$org$netbeans$modules$xml$core$cookies$TreeEditorCookie = AbstractDataNode.class$("org.netbeans.modules.xml.core.cookies.TreeEditorCookie")) : class$org$netbeans$modules$xml$core$cookies$TreeEditorCookie)).getStatus();
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("AbstractDataNode::updateNode: status " + newStatus);
            Util.THIS.debug("                ::updateNode:  OLD  documentCookie = " + this.documentCookie);
            Util.THIS.debug("                ::updateNode: *new* DocumentCookie = " + newDocumentCookie);
        }
        if (this.documentCookie != newDocumentCookie) {
            this.documentCookie = newDocumentCookie;
            if (this.documentCookie == null) {
                this.setRootNode(null);
            } else {
                this.setRootNode(this.createRootNode(this.documentCookie.getDocumentRoot()));
            }
        }
        if (this.status != newStatus) {
            this.status = newStatus;
            this.updateSheet();
            this.updateShortDescription();
            this.updateIconBase();
        }
    }

    public final AbstractRootNode getRootNode() {
        Object rootNode = this.rootRef == null ? null : this.rootRef.get();
        return rootNode;
    }

    protected final void setRootNode(AbstractRootNode newRootNode) {
        AbstractRootNode rootNode = this.getRootNode();
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("AbstractDataNode::setRootNode:  OLD  rootNode = " + rootNode);
            Util.THIS.debug("                ::setRootNode: *new* rootNode = " + newRootNode);
        }
        if (rootNode == newRootNode) {
            return;
        }
        AbstractRootNode oldRootNode = rootNode;
        this.rootRef = newRootNode != null ? new WeakReference<AbstractRootNode>(newRootNode) : null;
        if (oldRootNode != null) {
            oldRootNode.setDataNode(null);
        }
        if (newRootNode != null) {
            newRootNode.setDataNode(this);
        }
        if (oldRootNode != null) {
            oldRootNode.removePropertyChangeListener(this.listener);
        }
        if (newRootNode != null) {
            newRootNode.setNodeViewType(this.getNodeViewType());
            newRootNode.addPropertyChangeListener(this.listener);
        }
        this.firePropertyChange(PROP_ROOT_NODE, oldRootNode, newRootNode);
    }

    protected final void updateSheet() {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("--> AbstractDataNode.updateSheet");
        }
        this.setSheet(this.createSheet());
    }

    protected Sheet createSheet() {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("--> AbstractDataNode.createSheet");
        }
        Sheet sheet = super.createSheet();
        sheet.put(this.updatePropertiesSheetSet(sheet));
        sheet.put(this.createXMLSheetSet());
        Sheet.Set viewSet = this.createViewSheetSet();
        if (viewSet != null) {
            sheet.put(viewSet);
        }
        return sheet;
    }

    private Sheet.Set updatePropertiesSheetSet(Sheet sheet) {
        Sheet.Set propSet = sheet.get("properties");
        if (propSet == null) {
            propSet = Sheet.createPropertiesSet();
        }
        return propSet;
    }

    protected Sheet.Set createXMLSheetSet() {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("--> AbstractDataNode.createXMLSheetSet");
        }
        Sheet.Set xmlSet = new Sheet.Set();
        xmlSet.setName("__NAME__");
        AbstractRootNode rootNode = this.getRootNode();
        if (rootNode != null) {
            Node.PropertySet[] propertySets = rootNode.getPropertySets();
            int i = 0;
            while (i < propertySets.length) {
                if ("properties".equals(propertySets[i].getName())) {
                    xmlSet.put(propertySets[i].getProperties());
                    break;
                }
                ++i;
            }
        } else {
            int status = ((TreeEditorCookie)this.getXMLDataObjectLook().getCookie(class$org$netbeans$modules$xml$core$cookies$TreeEditorCookie == null ? (class$org$netbeans$modules$xml$core$cookies$TreeEditorCookie = AbstractDataNode.class$("org.netbeans.modules.xml.core.cookies.TreeEditorCookie")) : class$org$netbeans$modules$xml$core$cookies$TreeEditorCookie)).getStatus();
            switch (status) {
                case 0: {
                    xmlSet.put((Node.Property)new PropertySupport.ReadOnly(XML_STATUS, class$java$lang$String == null ? (class$java$lang$String = AbstractDataNode.class$("java.lang.String")) : class$java$lang$String, Util.THIS.getString("PROP_xmlStatus"), Util.THIS.getString("HINT_xmlStatus")){

                        public Object getValue() {
                            return Util.THIS.getString("MSG_not_parsed_yet");
                        }
                    });
                    break;
                }
                case 3: {
                    xmlSet.put((Node.Property)new PropertySupport.ReadOnly(XML_STATUS, class$java$lang$String == null ? (class$java$lang$String = AbstractDataNode.class$("java.lang.String")) : class$java$lang$String, Util.THIS.getString("PROP_xmlStatus"), Util.THIS.getString("HINT_xmlStatus")){

                        public Object getValue() {
                            return Util.THIS.getString("MSG_parsing_error");
                        }
                    });
                }
            }
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("<--                 .createXMLSheetSet: return = " + xmlSet);
        }
        return xmlSet;
    }

    protected Sheet.Set createViewSheetSet() {
        Sheet.Set viewSet = null;
        AbstractRootNode rootNode = this.getRootNode();
        if (rootNode != null) {
            viewSet = rootNode.getViewSheetSet();
        }
        return viewSet;
    }

    public final boolean hasCustomizer() {
        AbstractRootNode rootNode = this.getRootNode();
        if (rootNode != null) {
            return rootNode.hasCustomizer();
        }
        return false;
    }

    public final Component getCustomizer() {
        AbstractRootNode rootNode = this.getRootNode();
        if (rootNode != null) {
            return rootNode.getCustomizer();
        }
        return null;
    }

    public NodeViewType getNodeViewType() {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("AbstractDataNode::getNodeViewType: this = " + this);
        }
        if (this.nodeViewType != null && Util.THIS.isLoggable()) {
            Util.THIS.debug("                ::getNodeViewType: nodeViewType.name = " + this.nodeViewType.getName());
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("                ::getNodeViewType: nodeViewType = " + (Object)((Object)this.nodeViewType));
        }
        if (this.nodeViewType != null) {
            return this.nodeViewType;
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("                ::getNodeViewType: use DEFAULT value!");
        }
        return TreeEditSettings.getDefault().getDefaultNodeViewType();
    }

    public final void setNodeViewType(NodeViewType nodeViewType) {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("AbstractDataNode::setNodeViewType: this = " + this);
        }
        if (nodeViewType != null && Util.THIS.isLoggable()) {
            Util.THIS.debug("                ::setNodeViewType: NEW nodeViewType.name = " + nodeViewType.getName());
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("                ::setNodeViewType: NEW nodeViewType = " + (Object)((Object)nodeViewType));
        }
        if (this.nodeViewType == nodeViewType) {
            return;
        }
        NodeViewType oldNodeViewType = this.nodeViewType;
        this.nodeViewType = nodeViewType;
        if (oldNodeViewType != null && Util.THIS.isLoggable()) {
            Util.THIS.debug("                ::setNodeViewType: OLD nodeViewType.name = " + oldNodeViewType.getName());
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("                ::setNodeViewType: OLD nodeViewType = " + (Object)((Object)oldNodeViewType));
        }
        this.saveNodeViewType();
        this.firePropertyChange("nodeViewType", (Object)oldNodeViewType, (Object)this.nodeViewType);
    }

    private void updateNodeViewType() {
        AbstractRootNode rootNode = this.getRootNode();
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("AbstractDataNode::updateNodeViewType: this = " + this);
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("                ::updateNodeViewType: rootNode = " + rootNode);
        }
        if (rootNode != null) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("                ::updateNodeViewType: rawNodeViewType = " + (Object)((Object)rootNode.getRawNodeViewType()));
            }
            this.setNodeViewType(rootNode.getRawNodeViewType());
        }
    }

    private void initNodeViewType() {
        Object value = this.getDataObject().getPrimaryFile().getAttribute(NODE_VIEW_TYPE_ATTRIBUTE);
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("AbstractDataNode::initNodeViewType: this = " + this);
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("                ::initNodeViewType: value = " + value);
        }
        this.nodeViewType = value instanceof ServiceType.Handle ? (NodeViewType)((ServiceType.Handle)value).getServiceType() : NodeViewType.getValid((NodeViewType)((Object)value));
        if (this.nodeViewType != null && Util.THIS.isLoggable()) {
            Util.THIS.debug("                ::initNodeViewType: NEW nodeViewType.name = " + this.nodeViewType.getName());
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("                ::initNodeViewType: NEW nodeViewType = " + (Object)((Object)this.nodeViewType));
        }
    }

    private void saveNodeViewType() {
        if (this.nodeViewType != null && Util.THIS.isLoggable()) {
            Util.THIS.debug("AbstractDataNode::saveNodeViewType: nodeViewType.name = " + this.nodeViewType.getName());
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("AbstractDataNode::saveNodeViewType: nodeViewType = " + (Object)((Object)this.nodeViewType));
        }
        try {
            ServiceType.Handle value = null;
            if (this.nodeViewType != null) {
                value = new ServiceType.Handle((ServiceType)this.nodeViewType);
            }
            this.getDataObject().getPrimaryFile().setAttribute(NODE_VIEW_TYPE_ATTRIBUTE, (Object)value);
        }
        catch (IOException ioe) {
            TopManager.getDefault().getErrorManager().notify(1, (Throwable)ioe);
        }
    }

    public final NewType[] getNewTypes() {
        AbstractRootNode rootNode = this.getRootNode();
        if (rootNode == null) {
            return new NewType[0];
        }
        return rootNode.getNewTypes();
    }

    protected void createPasteTypes(Transferable t, List s) {
        AbstractRootNode rootNode = this.getRootNode();
        if (rootNode != null) {
            rootNode.createPasteTypes(t, s);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class InnerListener
    implements PropertyChangeListener {
        private InnerListener() {
        }

        public void propertyChange(PropertyChangeEvent pche) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("AbstractDataNode::InnerListener::propertyChange: propertyName = '" + pche.getPropertyName() + "'");
            }
            if (AbstractDataNode.XML_STATUS.equals(pche.getPropertyName())) {
                AbstractDataNode.this.updateNode();
            } else if ("nodeViewType".equals(pche.getPropertyName())) {
                AbstractDataNode.this.updateNodeViewType();
            }
        }

        public void childrenAdded(NodeMemberEvent ev) {
        }

        public void childrenRemoved(NodeMemberEvent ev) {
        }

        public void childrenReordered(NodeReorderEvent ev) {
        }

        public final void nodeDestroyed(NodeEvent ev) {
        }
    }
}

