/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.tree.nodes;

import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.beans.BeanInfo;
import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.LinkedList;
import org.netbeans.modules.xml.tree.lib.BeanUtil;
import org.netbeans.modules.xml.tree.lib.GuiUtil;
import org.netbeans.modules.xml.tree.lib.OrderedBeanNode;
import org.netbeans.modules.xml.tree.lib.StringUtil;
import org.netbeans.modules.xml.tree.nodes.DataNodeCookie;
import org.netbeans.modules.xml.tree.nodes.TreeObjectNode;
import org.netbeans.modules.xml.tree.nodes.Util;
import org.netbeans.tax.ReadOnlyException;
import org.netbeans.tax.TreeChild;
import org.netbeans.tax.TreeDocumentRoot;
import org.netbeans.tax.TreeException;
import org.netbeans.tax.TreeNode;
import org.netbeans.tax.TreeObject;
import org.netbeans.tax.TreeParentNode;
import org.netbeans.tax.io.XMLStringResult;
import org.openide.actions.TraceIntoAction;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.Utilities;
import org.openide.util.WeakListener;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.datatransfer.TransferListener;

abstract class AbstractObjectNode
extends OrderedBeanNode
implements TreeObjectNode,
DataNodeCookie {
    public static final XMLDataFlavor XML_NODE_COPY_FLAVOR = new XMLDataFlavor(class$org$netbeans$modules$xml$tree$nodes$AbstractObjectNode == null ? (class$org$netbeans$modules$xml$tree$nodes$AbstractObjectNode = AbstractObjectNode.class$("org.netbeans.modules.xml.tree.nodes.AbstractObjectNode")) : class$org$netbeans$modules$xml$tree$nodes$AbstractObjectNode, "XML_NODE_COPY_FLAVOR");
    public static final XMLDataFlavor XML_NODE_CUT_FLAVOR = new XMLDataFlavor(class$org$netbeans$modules$xml$tree$nodes$AbstractObjectNode == null ? (class$org$netbeans$modules$xml$tree$nodes$AbstractObjectNode = AbstractObjectNode.class$("org.netbeans.modules.xml.tree.nodes.AbstractObjectNode")) : class$org$netbeans$modules$xml$tree$nodes$AbstractObjectNode, "XML_NODE_CUT_FLAVOR");
    protected static final String ICON_DIR_BASE = "org/netbeans/modules/xml/tree/resources/";
    private static final String NODE_TYPE_PREFIX_SEPARATOR = " : ";
    private DataNode dataNode;
    private final TreeListener treeListener = new TreeListener();
    private final DataObjectListener doListener = new DataObjectListener();
    private Image mergeIcon;
    private short cutIconStack = 0;
    private SystemAction[] systemActions;
    static /* synthetic */ Class class$org$netbeans$modules$xml$tree$nodes$AbstractObjectNode;
    static /* synthetic */ Class class$org$openide$actions$CustomizeAction;
    static /* synthetic */ Class class$org$openide$actions$ReorderAction;
    static /* synthetic */ Class class$org$openide$actions$MoveUpAction;
    static /* synthetic */ Class class$org$openide$actions$MoveDownAction;
    static /* synthetic */ Class class$org$openide$actions$CutAction;
    static /* synthetic */ Class class$org$openide$actions$CopyAction;
    static /* synthetic */ Class class$org$openide$actions$PasteAction;
    static /* synthetic */ Class class$org$openide$actions$DeleteAction;
    static /* synthetic */ Class class$org$openide$actions$RenameAction;
    static /* synthetic */ Class class$org$openide$actions$NewAction;
    static /* synthetic */ Class class$org$openide$actions$PropertiesAction;
    static /* synthetic */ Class class$org$openide$actions$ToolsAction;
    static /* synthetic */ Class class$org$netbeans$modules$xml$tree$nodes$DataNodeCookie;
    static /* synthetic */ Class class$org$openide$cookies$SaveCookie;
    static /* synthetic */ Class class$org$openide$loaders$DataObject;

    protected AbstractObjectNode(TreeObject treeObject, Children children, String iconName) throws IntrospectionException {
        super(treeObject, children);
        this.init(treeObject);
        this.updateIconBase(iconName);
    }

    protected AbstractObjectNode(TreeObject treeObject, String iconName) throws IntrospectionException {
        this(treeObject, Children.LEAF, iconName);
    }

    private void init(TreeObject peer) {
        this.setSynchronizeName(false);
        peer.addPropertyChangeListener(WeakListener.propertyChange((PropertyChangeListener)this.treeListener, (Object)peer));
        this.updateNodeNames();
        if (this.hasCustomizer()) {
            this.setDefaultAction(SystemAction.get((Class)(class$org$openide$actions$CustomizeAction == null ? (class$org$openide$actions$CustomizeAction = AbstractObjectNode.class$("org.openide.actions.CustomizeAction")) : class$org$openide$actions$CustomizeAction)));
        }
    }

    public final TreeObject getTreeObject() {
        return (TreeObject)this.getBean();
    }

    protected boolean isReadOnly() {
        return this.getTreeObject().isReadOnly();
    }

    protected boolean canPaste() {
        return !this.isReadOnly();
    }

    protected boolean canChangeOrder() {
        return false;
    }

    protected boolean canMoveUpDown() {
        return false;
    }

    public boolean hasCustomizer() {
        return !this.isReadOnly();
    }

    protected abstract String getPresentableNamePropertyName();

    protected abstract void setPresentableNameProperty(String var1) throws TreeException;

    private void updatePresentableNameProperty() {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("AbstractObjectNode::updatePresentableNameProperty: this.getName = " + ((FeatureDescriptor)((Object)this)).getName());
        }
        try {
            this.setPresentableNameProperty(((FeatureDescriptor)((Object)this)).getName());
        }
        catch (TreeException exc) {
            this.updateNodeNames();
            GuiUtil.notifyTreeException(exc);
        }
    }

    private void updateNodeNames() {
        this.setNameImpl(this.createName());
        this.setDisplayName(this.createDisplayName());
        this.updateShortDescription();
    }

    private void updateShortDescription() {
        this.setShortDescription(this.createShortDescription());
    }

    protected String getNodeTypePrefix() {
        return null;
    }

    protected boolean checkName(String name) {
        return true;
    }

    private void setNameImpl(String name) {
        super.setName(name);
        this.updatePresentableNameProperty();
    }

    public final void setName(String name) {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("AbstractObjectNode::setName: '" + name + "'");
        }
        if (this.checkName(name)) {
            this.setNameImpl(name);
        }
    }

    protected abstract String createName();

    protected String createDisplayName() {
        return StringUtil.printableValue(this.createName());
    }

    protected final String createShortDescription() {
        StringBuffer sb = new StringBuffer();
        if (this.getNodeTypePrefix() != null) {
            sb.append(this.getNodeTypePrefix()).append(NODE_TYPE_PREFIX_SEPARATOR);
        }
        sb.append(this.createNodePreview());
        return sb.toString();
    }

    protected String createNodePreview() {
        return this.createDisplayName();
    }

    protected final void updateIconBase(String iconName) {
        this.setIconBase(ICON_DIR_BASE + iconName);
    }

    protected final void setMergeIcon(Image img) {
        this.mergeIcon = img;
        this.fireIconChange();
        this.fireOpenedIconChange();
    }

    public Image getIcon(int type) {
        Image img = super.getIcon(type);
        if (this.isReadOnly()) {
            Image roBadge = Utilities.loadImage((String)"org/netbeans/modules/xml/tree/resources/ro-badge.gif");
            img = Utilities.mergeImages((Image)img, (Image)roBadge, (int)16, (int)8);
        }
        if (this.mergeIcon == null) {
            return img;
        }
        return Utilities.mergeImages((Image)img, (Image)this.mergeIcon, (int)0, (int)0);
    }

    protected final void activateCutIcon() {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("AbstractObjectNode::activateCutIcon: cutIconStack = " + this.cutIconStack + " ++");
        }
        if (this.cutIconStack == 0) {
            this.setMergeIcon(GuiUtil.getCutBadgeIcon());
        }
        this.cutIconStack = (short)(this.cutIconStack + 1);
    }

    protected final void deactivateCutIcon() {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("AbstractObjectNode::DEactivateCutIcon: cutIconStack = " + this.cutIconStack + " --");
        }
        this.cutIconStack = (short)(this.cutIconStack - 1);
        if (this.cutIconStack == 0) {
            this.setMergeIcon(null);
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(this.getClass());
    }

    protected SystemAction[] createNodeSpecificActions() {
        return null;
    }

    protected final SystemAction[] createActions() {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("AbstractObjectNode::createActions: this = " + this);
        }
        if (this.systemActions == null) {
            LinkedList<Object> nodeActions = new LinkedList<Object>();
            boolean separator = false;
            SystemAction[] nodeSpecificActions = this.createNodeSpecificActions();
            if (nodeSpecificActions != null) {
                nodeActions.addAll(Arrays.asList(nodeSpecificActions));
                nodeActions.add(null);
            }
            if (this.canChangeOrder()) {
                nodeActions.add(SystemAction.get((Class)(class$org$openide$actions$ReorderAction == null ? (class$org$openide$actions$ReorderAction = AbstractObjectNode.class$("org.openide.actions.ReorderAction")) : class$org$openide$actions$ReorderAction)));
                separator = true;
            }
            if (this.canMoveUpDown()) {
                nodeActions.add(SystemAction.get((Class)(class$org$openide$actions$MoveUpAction == null ? (class$org$openide$actions$MoveUpAction = AbstractObjectNode.class$("org.openide.actions.MoveUpAction")) : class$org$openide$actions$MoveUpAction)));
                nodeActions.add(SystemAction.get((Class)(class$org$openide$actions$MoveDownAction == null ? (class$org$openide$actions$MoveDownAction = AbstractObjectNode.class$("org.openide.actions.MoveDownAction")) : class$org$openide$actions$MoveDownAction)));
                separator = true;
            }
            if (separator) {
                nodeActions.add(null);
                separator = false;
            }
            if (this.canCut()) {
                nodeActions.add(SystemAction.get((Class)(class$org$openide$actions$CutAction == null ? (class$org$openide$actions$CutAction = AbstractObjectNode.class$("org.openide.actions.CutAction")) : class$org$openide$actions$CutAction)));
                separator = true;
            }
            if (this.canCopy()) {
                nodeActions.add(SystemAction.get((Class)(class$org$openide$actions$CopyAction == null ? (class$org$openide$actions$CopyAction = AbstractObjectNode.class$("org.openide.actions.CopyAction")) : class$org$openide$actions$CopyAction)));
                separator = true;
            }
            if (!this.isLeaf() && this.canPaste()) {
                nodeActions.add(SystemAction.get((Class)(class$org$openide$actions$PasteAction == null ? (class$org$openide$actions$PasteAction = AbstractObjectNode.class$("org.openide.actions.PasteAction")) : class$org$openide$actions$PasteAction)));
                separator = true;
            }
            if (separator) {
                nodeActions.add(null);
                separator = false;
            }
            if (this.canDestroy()) {
                nodeActions.add(SystemAction.get((Class)(class$org$openide$actions$DeleteAction == null ? (class$org$openide$actions$DeleteAction = AbstractObjectNode.class$("org.openide.actions.DeleteAction")) : class$org$openide$actions$DeleteAction)));
                separator = true;
            }
            if (this.canRename()) {
                nodeActions.add(SystemAction.get((Class)(class$org$openide$actions$RenameAction == null ? (class$org$openide$actions$RenameAction = AbstractObjectNode.class$("org.openide.actions.RenameAction")) : class$org$openide$actions$RenameAction)));
                separator = true;
            }
            if (separator) {
                nodeActions.add(null);
                separator = false;
            }
            if (this.getNewTypes() != null && this.getNewTypes().length != 0) {
                nodeActions.add(SystemAction.get((Class)(class$org$openide$actions$NewAction == null ? (class$org$openide$actions$NewAction = AbstractObjectNode.class$("org.openide.actions.NewAction")) : class$org$openide$actions$NewAction)));
                nodeActions.add(null);
            }
            nodeActions.add(SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = AbstractObjectNode.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction)));
            if (Util.THIS.isLoggable()) {
                nodeActions.add(SystemAction.get((Class)(class$org$openide$actions$ToolsAction == null ? (class$org$openide$actions$ToolsAction = AbstractObjectNode.class$("org.openide.actions.ToolsAction")) : class$org$openide$actions$ToolsAction)));
                nodeActions.add(new TraceIntoAction(){
                    static /* synthetic */ Class class$java$beans$PropertyChangeListener;

                    public void performAction(Node[] activatedNodes) {
                        Object peer = AbstractObjectNode.super.getBean();
                        Util.THIS.debug("Dumping " + ((FeatureDescriptor)((Object)AbstractObjectNode.this)).getDisplayName() + " /" + ((FeatureDescriptor)((Object)AbstractObjectNode.this)).getName() + "/");
                        Util.THIS.debug("\tTree model listener " + AbstractObjectNode.this.treeListener);
                        Util.THIS.debug("\tThis node listener " + AbstractObjectNode.this.doListener);
                        Util.THIS.debug("\tRaw peer " + peer.getClass() + System.identityHashCode(peer));
                        Util.THIS.debug("\tString peer " + peer.toString());
                        if (peer instanceof TreeNode) {
                            TreeDocumentRoot parent = ((TreeNode)peer).getOwnerDocument();
                            if (parent == null) {
                                Util.THIS.debug("\tMISSING OWNER DOCUMENT!");
                                Util.THIS.debug("\tTraversing parents:");
                                TreeParentNode p = ((TreeChild)peer).getParentNode();
                                while (p != null) {
                                    Util.THIS.debug("\t\tRaw parent " + p.getClass() + System.identityHashCode(p));
                                    p = p.getParentNode();
                                }
                            } else {
                                Util.THIS.debug("\tRaw document " + parent.getClass() + System.identityHashCode(parent));
                                Util.THIS.debug("\tDocument listeners: " + ((TreeObject)parent).listListeners());
                            }
                            parent = ((TreeChild)peer).getParentNode();
                            if (parent == null) {
                                Util.THIS.debug("\tMISSING PARENT DOCUMENT!");
                            } else {
                                Util.THIS.debug("\tRaw parent " + parent.getClass() + System.identityHashCode(parent));
                                Util.THIS.debug("\tChildren: ");
                                int max = ((TreeParentNode)parent).getChildrenNumber();
                                int i = 0;
                                while (i < max) {
                                    TreeChild next = ((TreeParentNode)parent).item(i);
                                    Util.THIS.debug("\t\tRaw kid " + next.getClass() + System.identityHashCode(next));
                                    ++i;
                                }
                            }
                        }
                        Util.THIS.debug("\tPeer listeners: " + ((TreeObject)peer).listListeners());
                        try {
                            Class<?> clazz = peer.getClass();
                            Method method = clazz.getMethod("addPropertyChangeListener", class$java$beans$PropertyChangeListener == null ? (class$java$beans$PropertyChangeListener = 1.class$("java.beans.PropertyChangeListener")) : class$java$beans$PropertyChangeListener);
                            Util.THIS.debug("--> is 'addPropertyChangeListener' public: " + Modifier.isPublic(method.getModifiers()));
                        }
                        catch (Exception exc) {
                            Util.THIS.debug(exc);
                        }
                    }

                    public boolean enable(Node[] nodes) {
                        return true;
                    }

                    static /* synthetic */ Class class$(String x0) {
                        try {
                            return Class.forName(x0);
                        }
                        catch (ClassNotFoundException x1) {
                            throw new NoClassDefFoundError(x1.getMessage());
                        }
                    }
                });
            }
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("                  ::createActions: nodeActions = " + nodeActions);
            }
            this.systemActions = nodeActions.toArray(new SystemAction[0]);
        }
        return this.systemActions;
    }

    public final DataNode getDataNode() {
        String thisClassName = this.getClass().getName();
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("AbstractObjectNode [ " + thisClassName + " ] ::getDataNode: this = " + this);
        }
        if (this.dataNode != null) {
            return this.dataNode;
        }
        Node parent = this.getParentNode();
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("                    [ " + thisClassName + " ] ::getDataNode: parent = " + parent);
        }
        if (parent != null) {
            DataNodeCookie cake = (DataNodeCookie)parent.getCookie(class$org$netbeans$modules$xml$tree$nodes$DataNodeCookie == null ? (class$org$netbeans$modules$xml$tree$nodes$DataNodeCookie = AbstractObjectNode.class$("org.netbeans.modules.xml.tree.nodes.DataNodeCookie")) : class$org$netbeans$modules$xml$tree$nodes$DataNodeCookie);
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("                    [ " + thisClassName + " ] ::getDataNode: parent's DataNodeCookie = " + cake);
            }
            if (cake != null) {
                this.setDataNode(cake.getDataNode());
            }
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("                    [ " + thisClassName + " ] ::getDataNode: dataNode = " + this.dataNode);
        }
        return this.dataNode;
    }

    protected void setDataNode(DataNode dataNode) {
        this.dataNode = dataNode;
        this.addDataObjectListener();
    }

    private void addDataObjectListener() {
        if (this.dataNode != null) {
            DataObject dataObject = this.dataNode.getDataObject();
            dataObject.addPropertyChangeListener(WeakListener.propertyChange((PropertyChangeListener)this.doListener, (Object)dataObject));
        }
    }

    protected void superFireCookieChange() {
        super.fireCookieChange();
    }

    public final Node.Cookie getCookie(Class type) {
        DataNode node;
        if ((type == (class$org$openide$cookies$SaveCookie == null ? (class$org$openide$cookies$SaveCookie = AbstractObjectNode.class$("org.openide.cookies.SaveCookie")) : class$org$openide$cookies$SaveCookie) || (class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = AbstractObjectNode.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject) == type) && (node = this.getDataNode()) != null) {
            return node.getCookie(type);
        }
        if ((class$org$netbeans$modules$xml$tree$nodes$DataNodeCookie == null ? (class$org$netbeans$modules$xml$tree$nodes$DataNodeCookie = AbstractObjectNode.class$("org.netbeans.modules.xml.tree.nodes.DataNodeCookie")) : class$org$netbeans$modules$xml$tree$nodes$DataNodeCookie) == type) {
            return this;
        }
        return super.getCookie(type);
    }

    public boolean canDestroy() {
        boolean canDestroy;
        boolean bl = canDestroy = !this.isReadOnly();
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("AbstractObjectNode::canDestroy : " + canDestroy);
        }
        return canDestroy;
    }

    public void destroy() throws IOException {
        try {
            this.getTreeObject().removeFromContext();
        }
        catch (ReadOnlyException exc) {
            GuiUtil.notifyTreeException((TreeException)((Object)exc));
        }
    }

    public boolean canRename() {
        boolean canRename;
        boolean bl = canRename = !this.isReadOnly();
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("AbstractObjectNode::canRename : " + canRename);
        }
        return canRename;
    }

    protected void createProperties(Object bean, BeanInfo info) {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("AbstractObjectNode::createProperties: bean = " + bean);
        }
        if (bean instanceof TreeObject) {
            Node.Property[][] properties = BeanUtil.computeProperties((TreeObject)bean, info);
            Sheet sets = this.getSheet();
            Sheet.Set pset = Sheet.createPropertiesSet();
            pset.put(properties[0]);
            sets.put(pset);
            if (properties[1].length != 0) {
                Sheet.Set eset = Sheet.createExpertSet();
                eset.put(properties[1]);
                sets.put(eset);
            }
        } else {
            super.createProperties(bean, info);
        }
    }

    public boolean canCopy() {
        boolean canCopy = true;
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("AbstractObjectNode::canCopy : " + canCopy);
        }
        return canCopy;
    }

    public boolean canCut() {
        boolean canCut;
        boolean bl = canCut = !this.isReadOnly();
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("AbstractObjectNode::canCut : " + canCut);
        }
        return canCut;
    }

    public final Transferable clipboardCopy() throws IOException {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("AbstractObjectNode::clipboardCopy: flavor = " + XML_NODE_COPY_FLAVOR);
        }
        TreeObject clone = (TreeObject)this.getTreeObject().clone();
        ExTransferable transferable = ExTransferable.create((Transferable)new XMLTransferable(XML_NODE_COPY_FLAVOR, clone));
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("                  ::clipboardCopy: transferable [ " + System.identityHashCode(transferable) + " ] = " + transferable);
        }
        return transferable;
    }

    public final Transferable clipboardCut() throws IOException {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("AbstractObjectNode::clipboardCut:");
        }
        this.activateCutIcon();
        ExTransferable transferable = ExTransferable.create((Transferable)new XMLTransferable(XML_NODE_CUT_FLAVOR, this.getTreeObject()));
        transferable.addTransferListener(new TransferListener(){

            public void accepted(int action) {
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("AbstractObjectNode::clipboardCut::TransferListener::accepted: action = " + action);
                }
            }

            public void rejected() {
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("AbstractObjectNode::clipboardCut::TransferListener::rejected");
                }
            }

            public void ownershipLost() {
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("AbstractObjectNode::clipboardCut::TransferListener::ownershipLost");
                }
                AbstractObjectNode.this.deactivateCutIcon();
            }
        });
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("             ::clipboardCut: transferable [ " + System.identityHashCode(transferable) + " ] = " + transferable);
        }
        return transferable;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class DataObjectListener
    implements PropertyChangeListener {
        private DataObjectListener() {
        }

        public void propertyChange(PropertyChangeEvent pche) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("AbstractObjectNode::DataObjectListener::propertyChange: propertyName = '" + pche.getPropertyName() + "'");
            }
            if ("cookie".equals(pche.getPropertyName())) {
                AbstractObjectNode.this.superFireCookieChange();
            }
        }
    }

    private class TreeListener
    implements PropertyChangeListener {
        private TreeListener() {
        }

        public void propertyChange(PropertyChangeEvent pche) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("AbstractObjectNode::TreeListener::propertyChange: propertyName = '" + pche.getPropertyName() + "'");
            }
            if (pche.getPropertyName().equals(AbstractObjectNode.this.getPresentableNamePropertyName())) {
                AbstractObjectNode.this.updateNodeNames();
            } else if ("this".equals(pche.getPropertyName())) {
                AbstractObjectNode.this.updateShortDescription();
            }
        }
    }

    static class XMLTransferable
    implements Transferable {
        private TreeObject treeObject;
        private XMLDataFlavor xmlFlavor;

        public XMLTransferable(XMLDataFlavor flavor, TreeObject treeObject) {
            this.xmlFlavor = flavor;
            this.treeObject = treeObject;
        }

        public DataFlavor[] getTransferDataFlavors() {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("AbstractObjectNode::XMLTransferable::getTransferDataFlavors: xmlFlavor = " + this.xmlFlavor);
            }
            return new DataFlavor[]{this.xmlFlavor, DataFlavor.stringFlavor};
        }

        public boolean isDataFlavorSupported(DataFlavor flavor) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("AbstractObjectNode::XMLTransferable::isDataFlavorSupported: flavor = " + flavor);
            }
            if (DataFlavor.stringFlavor.equals(flavor)) {
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("AbstractObjectNode::XMLTransferable::isDataFlavorSupported: is stringFlavor");
                }
                return true;
            }
            if (this.xmlFlavor.equals((Object)flavor)) {
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("AbstractObjectNode::XMLTransferable::isDataFlavorSupported: is XMLDataFlavor");
                }
                return true;
            }
            return false;
        }

        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (this.isDataFlavorSupported(flavor)) {
                if (DataFlavor.stringFlavor == flavor) {
                    try {
                        if (this.treeObject instanceof TreeNode) {
                            return XMLStringResult.toString((TreeNode)((TreeNode)this.treeObject));
                        }
                        return "";
                    }
                    catch (Exception exc) {
                        GuiUtil.notifyException(exc);
                    }
                } else if (this.xmlFlavor == flavor) {
                    return this.treeObject;
                }
            }
            throw new UnsupportedFlavorException(flavor);
        }
    }

    public static class XMLDataFlavor
    extends DataFlavor {
        private static final long serialVersionUID = 2137534426987675449L;

        XMLDataFlavor(Class representationClass, String name) {
            super(representationClass, name);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof XMLDataFlavor)) {
                return false;
            }
            XMLDataFlavor xmlDF = (XMLDataFlavor)obj;
            return this.getHumanPresentableName().equals(xmlDF.getHumanPresentableName()) && super.equals(obj);
        }
    }
}

