/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.classfile;

import java.io.DataInputStream;
import java.io.IOException;
import org.netbeans.modules.classfile.CPUTF8Info;
import org.netbeans.modules.classfile.ConstantPool;

public final class LocalVariableTableEntry {
    int startPC;
    int length;
    String name;
    String description;
    int index;

    static LocalVariableTableEntry[] loadLocalVariableTable(DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        int n = dataInputStream.readUnsignedShort();
        LocalVariableTableEntry[] localVariableTableEntryArray = new LocalVariableTableEntry[n];
        int n2 = 0;
        while (n2 < n) {
            localVariableTableEntryArray[n2] = new LocalVariableTableEntry(dataInputStream, constantPool);
            ++n2;
        }
        return localVariableTableEntryArray;
    }

    LocalVariableTableEntry(DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        this.loadLocalVariableEntry(dataInputStream, constantPool);
    }

    private void loadLocalVariableEntry(DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        this.startPC = dataInputStream.readUnsignedShort();
        this.length = dataInputStream.readUnsignedShort();
        CPUTF8Info cPUTF8Info = (CPUTF8Info)constantPool.get(dataInputStream.readUnsignedShort());
        this.name = cPUTF8Info.getName();
        cPUTF8Info = (CPUTF8Info)constantPool.get(dataInputStream.readUnsignedShort());
        this.description = cPUTF8Info.getName();
        this.index = dataInputStream.readUnsignedShort();
    }

    public final int getStartPC() {
        return this.startPC;
    }

    public final int getLength() {
        return this.length;
    }

    public final String getName() {
        return this.name;
    }

    public final String getDescription() {
        return this.description;
    }

    public final int getIndex() {
        return this.index;
    }
}

