/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.util.ArrayList;
import org.apache.jasper.compiler.JspLineMapItem;

public class JspLineMap {
    private ArrayList lineMap = new ArrayList();
    private ArrayList fileMap = new ArrayList();

    public void add(JspLineMapItem lineMapItem) {
        this.lineMap.add(lineMapItem);
    }

    public int addFileName(String fileName) {
        int idx = this.fileMap.indexOf(fileName);
        if (idx >= 0) {
            return idx;
        }
        fileName = fileName.replace('\\', '/');
        this.fileMap.add(fileName);
        idx = this.fileMap.size() - 1;
        return idx;
    }

    public void clear() {
        this.lineMap.clear();
        this.fileMap.clear();
    }

    public JspLineMapItem get(int index) {
        return (JspLineMapItem)this.lineMap.get(index);
    }

    public String getFileName(int index) {
        return (String)this.fileMap.get(index);
    }

    public int size() {
        return this.lineMap.size();
    }

    public String toString() {
        StringBuffer out = new StringBuffer();
        out.append("JspLineMap Debugging:\n");
        out.append("lineMap: \n");
        int i = 0;
        while (i < this.lineMap.size()) {
            JspLineMapItem lineMapItem = (JspLineMapItem)this.lineMap.get(i);
            out.append("#" + i + ": ");
            out.append(lineMapItem.toString());
            ++i;
        }
        out.append("fileMap: \n");
        i = 0;
        while (i < this.fileMap.size()) {
            out.append("#" + i + ": " + this.fileMap.get(i) + "\n");
            ++i;
        }
        return out.toString();
    }
}

